/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.util.Arrays;
import java.util.NoSuchElementException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Hashing$;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.immutable.HashCollisionMapNode;
import scala.collection.immutable.MapNode;
import scala.collection.immutable.MapNode$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Node;
import scala.collection.immutable.Node$;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class BitmapIndexedMapNode<K, V>
extends MapNode<K, V> {
    private int dataMap;
    private int nodeMap;
    private Object[] content;
    private int[] originalHashes;
    private int size;
    private int cachedJavaKeySetHashCode;

    public int dataMap() {
        return this.dataMap;
    }

    public void dataMap_$eq(int x$1) {
        this.dataMap = x$1;
    }

    public int nodeMap() {
        return this.nodeMap;
    }

    public void nodeMap_$eq(int x$1) {
        this.nodeMap = x$1;
    }

    public Object[] content() {
        return this.content;
    }

    public void content_$eq(Object[] x$1) {
        this.content = x$1;
    }

    public int[] originalHashes() {
        return this.originalHashes;
    }

    public void originalHashes_$eq(int[] x$1) {
        this.originalHashes = x$1;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void size_$eq(int x$1) {
        this.size = x$1;
    }

    @Override
    public int cachedJavaKeySetHashCode() {
        return this.cachedJavaKeySetHashCode;
    }

    public void cachedJavaKeySetHashCode_$eq(int x$1) {
        this.cachedJavaKeySetHashCode = x$1;
    }

    @Override
    public K getKey(int index) {
        return (K)this.content()[2 * index];
    }

    @Override
    public V getValue(int index) {
        return (V)this.content()[2 * index + 1];
    }

    @Override
    public Tuple2<K, V> getPayload(int index) {
        return new Tuple2<Object, Object>(this.content()[2 * index], this.content()[2 * index + 1]);
    }

    @Override
    public int getHash(int index) {
        return this.originalHashes()[index];
    }

    @Override
    public MapNode<K, V> getNode(int index) {
        return (MapNode)this.content()[this.content().length - 1 - index];
    }

    @Override
    public V apply(K key, int originalHash, int keyHash, int shift) {
        int n = keyHash >>> shift & 0x1F;
        int n2 = 1 << n;
        if ((this.dataMap() & n2) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), n, n2);
            if (BoxesRunTime.equals(key, this.content()[2 * index])) {
                return (V)this.content()[2 * index + 1];
            }
            throw new NoSuchElementException(new StringBuilder(15).append("key not found: ").append(key).toString());
        }
        if ((this.nodeMap() & n2) != 0) {
            return ((MapNode)this.getNode(Node$.MODULE$.indexFrom(this.nodeMap(), n, n2))).apply(key, originalHash, keyHash, shift + 5);
        }
        throw new NoSuchElementException(new StringBuilder(15).append("key not found: ").append(key).toString());
    }

    @Override
    public Option<V> get(K key, int originalHash, int keyHash, int shift) {
        int n = keyHash >>> shift & 0x1F;
        int n2 = 1 << n;
        if ((this.dataMap() & n2) != 0) {
            Object object;
            int index = Node$.MODULE$.indexFrom(this.dataMap(), n, n2);
            Object object2 = object = this.content()[2 * index];
            object = null;
            Object key0 = object2;
            if (BoxesRunTime.equals(key, key0)) {
                return new Some<Object>(this.content()[2 * index + 1]);
            }
            return None$.MODULE$;
        }
        if ((this.nodeMap() & n2) != 0) {
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), n, n2);
            return ((MapNode)this.getNode(index)).get(key, originalHash, keyHash, shift + 5);
        }
        return None$.MODULE$;
    }

    @Override
    public <V1> V1 getOrElse(K key, int originalHash, int keyHash, int shift, Function0<V1> f) {
        int n = keyHash >>> shift & 0x1F;
        int n2 = 1 << n;
        if ((this.dataMap() & n2) != 0) {
            Object object;
            int index = Node$.MODULE$.indexFrom(this.dataMap(), n, n2);
            Object object2 = object = this.content()[2 * index];
            object = null;
            Object key0 = object2;
            if (BoxesRunTime.equals(key, key0)) {
                return (V1)this.content()[2 * index + 1];
            }
            return f.apply();
        }
        if ((this.nodeMap() & n2) != 0) {
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), n, n2);
            return ((MapNode)this.getNode(index)).getOrElse(key, originalHash, keyHash, shift + 5, f);
        }
        return f.apply();
    }

    @Override
    public boolean containsKey(K key, int originalHash, int keyHash, int shift) {
        int n = keyHash >>> shift & 0x1F;
        int n2 = 1 << n;
        if ((this.dataMap() & n2) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), n, n2);
            return this.originalHashes()[index] == originalHash && BoxesRunTime.equals(key, this.content()[2 * index]);
        }
        if ((this.nodeMap() & n2) != 0) {
            return ((MapNode)this.getNode(Node$.MODULE$.indexFrom(this.nodeMap(), n, n2))).containsKey(key, originalHash, keyHash, shift + 5);
        }
        return false;
    }

    @Override
    public <V1> BitmapIndexedMapNode<K, V1> updated(K key, V1 value, int originalHash, int keyHash, int shift, boolean replaceValue) {
        int n = keyHash >>> shift & 0x1F;
        int n2 = 1 << n;
        if ((this.dataMap() & n2) != 0) {
            Object object;
            Object object2;
            int index = Node$.MODULE$.indexFrom(this.dataMap(), n, n2);
            Object object3 = object2 = this.content()[2 * index];
            object2 = null;
            Object key0 = object3;
            int n3 = this.originalHashes()[index];
            if (n3 == originalHash && BoxesRunTime.equals(key0, key)) {
                if (replaceValue) {
                    Object object4;
                    Object object5 = object4 = this.content()[2 * index + 1];
                    object4 = null;
                    Object value0 = object5;
                    if (key0 == key && value0 == value) {
                        return this;
                    }
                    return this.copyAndSetValue(n2, key, value);
                }
                return this;
            }
            Object object6 = object = this.content()[2 * index + 1];
            object = null;
            Object value0 = object6;
            int key0Hash = Hashing$.MODULE$.improve(n3);
            MapNode<Object, Object> subNodeNew = this.mergeTwoKeyValPairs(key0, value0, n3, key0Hash, key, value, originalHash, keyHash, shift + 5);
            return this.copyAndMigrateFromInlineToNode(n2, key0Hash, subNodeNew);
        }
        if ((this.nodeMap() & n2) != 0) {
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), n, n2);
            Node subNode = this.getNode(index);
            MapNode<K, V1> subNodeNew = ((MapNode)subNode).updated(key, value, originalHash, keyHash, shift + 5, replaceValue);
            if (subNodeNew == subNode) {
                return this;
            }
            return this.copyAndSetNode(n2, (MapNode<K, V1>)subNode, subNodeNew);
        }
        return this.copyAndInsertValue(n2, key, originalHash, keyHash, value);
    }

    @Override
    public <V1> BitmapIndexedMapNode<K, V1> removed(K key, int originalHash, int keyHash, int shift) {
        int n = keyHash >>> shift & 0x1F;
        int n2 = 1 << n;
        if ((this.dataMap() & n2) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), n, n2);
            if (BoxesRunTime.equals(this.content()[2 * index], key)) {
                if (this.payloadArity() == 2 && this.nodeArity() == 0) {
                    int newDataMap;
                    int n3;
                    if (shift == 0) {
                        n3 = this.dataMap() ^ n2;
                    } else {
                        int maskFrom_shift = 0;
                        int n4 = keyHash >>> maskFrom_shift & 0x1F;
                        n3 = newDataMap = 1 << n4;
                    }
                    if (index == 0) {
                        Object[] objectArray = new Object[2];
                        int getKey_index = 1;
                        objectArray[0] = this.content()[2 * getKey_index];
                        int getValue_index = 1;
                        objectArray[1] = this.content()[2 * getValue_index + 1];
                        int getHash_index = 1;
                        return new BitmapIndexedMapNode<K, V>(newDataMap, 0, objectArray, new int[]{this.originalHashes()[1]}, 1, Hashing$.MODULE$.improve(this.originalHashes()[getHash_index]));
                    }
                    Object[] objectArray = new Object[2];
                    int getKey_index = 0;
                    objectArray[0] = this.content()[2 * getKey_index];
                    int getValue_index = 0;
                    objectArray[1] = this.content()[2 * getValue_index + 1];
                    int getHash_index = 0;
                    return new BitmapIndexedMapNode<K, V>(newDataMap, 0, objectArray, new int[]{this.originalHashes()[0]}, 1, Hashing$.MODULE$.improve(this.originalHashes()[getHash_index]));
                }
                return this.copyAndRemoveValue(n2, keyHash);
            }
            return this;
        }
        if ((this.nodeMap() & n2) != 0) {
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), n, n2);
            Node subNode = this.getNode(index);
            MapNode subNodeNew = ((MapNode)subNode).removed(key, originalHash, keyHash, shift + 5);
            if (subNodeNew == subNode) {
                return this;
            }
            int subNodeNewSize = subNodeNew.size();
            if (subNodeNewSize == 1) {
                if (this.size() == ((MapNode)subNode).size()) {
                    return (BitmapIndexedMapNode)subNodeNew;
                }
                return this.copyAndMigrateFromNodeToInline(n2, (MapNode<K, V1>)subNode, subNodeNew);
            }
            if (subNodeNewSize > 1) {
                return this.copyAndSetNode(n2, (MapNode<K, V1>)subNode, subNodeNew);
            }
            return this;
        }
        return this;
    }

    public <V1> MapNode<K, V1> mergeTwoKeyValPairs(K key0, V1 value0, int originalHash0, int keyHash0, K key1, V1 value1, int originalHash1, int keyHash1, int shift) {
        if (shift >= 32) {
            return new HashCollisionMapNode(originalHash0, keyHash0, Vector$.MODULE$.from((IterableOnce)ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[]{new Tuple2<K, V1>(key0, value0), new Tuple2<K, V1>(key1, value1)})));
        }
        int n = keyHash0 >>> shift & 0x1F;
        int n2 = keyHash1 >>> shift & 0x1F;
        int newCachedHash = keyHash0 + keyHash1;
        if (n != n2) {
            int dataMap = 1 << n | 1 << n2;
            if (n < n2) {
                return new BitmapIndexedMapNode<K, V>(dataMap, 0, new Object[]{key0, value0, key1, value1}, new int[]{originalHash0, originalHash1}, 2, newCachedHash);
            }
            return new BitmapIndexedMapNode<K, V>(dataMap, 0, new Object[]{key1, value1, key0, value0}, new int[]{originalHash1, originalHash0}, 2, newCachedHash);
        }
        int n3 = 1 << n;
        MapNode<K, V1> node = this.mergeTwoKeyValPairs(key0, value0, originalHash0, keyHash0, key1, value1, originalHash1, keyHash1, shift + 5);
        return new BitmapIndexedMapNode<K, V>(0, n3, new Object[]{node}, Array$.MODULE$.emptyIntArray(), node.size(), node.cachedJavaKeySetHashCode());
    }

    @Override
    public boolean hasNodes() {
        return this.nodeMap() != 0;
    }

    @Override
    public int nodeArity() {
        return Integer.bitCount(this.nodeMap());
    }

    @Override
    public boolean hasPayload() {
        return this.dataMap() != 0;
    }

    @Override
    public int payloadArity() {
        return Integer.bitCount(this.dataMap());
    }

    public int dataIndex(int bitpos) {
        return Integer.bitCount(this.dataMap() & bitpos - 1);
    }

    public int nodeIndex(int bitpos) {
        return Integer.bitCount(this.nodeMap() & bitpos - 1);
    }

    public <V1> BitmapIndexedMapNode<K, V1> copyAndSetValue(int bitpos, K newKey, V1 newValue) {
        int dataIx = this.dataIndex(bitpos);
        int idx = 2 * dataIx;
        Object[] src = this.content();
        Object[] dst = new Object[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        dst[idx + 1] = newValue;
        return new BitmapIndexedMapNode<K, V>(this.dataMap(), this.nodeMap(), dst, this.originalHashes(), this.size(), this.cachedJavaKeySetHashCode());
    }

    public <V1> BitmapIndexedMapNode<K, V1> copyAndSetNode(int bitpos, MapNode<K, V1> oldNode, MapNode<K, V1> newNode) {
        int idx = this.content().length - 1 - this.nodeIndex(bitpos);
        Object[] src = this.content();
        Object[] dst = new Object[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        dst[idx] = newNode;
        return new BitmapIndexedMapNode<K, V>(this.dataMap(), this.nodeMap(), dst, this.originalHashes(), this.size() - oldNode.size() + newNode.size(), this.cachedJavaKeySetHashCode() - oldNode.cachedJavaKeySetHashCode() + newNode.cachedJavaKeySetHashCode());
    }

    public <V1> BitmapIndexedMapNode<K, V1> copyAndInsertValue(int bitpos, K key, int originalHash, int keyHash, V1 value) {
        int dataIx = this.dataIndex(bitpos);
        int idx = 2 * dataIx;
        Object[] src = this.content();
        Object[] dst = new Object[src.length + 2];
        System.arraycopy(src, 0, dst, 0, idx);
        dst[idx] = key;
        dst[idx + 1] = value;
        System.arraycopy(src, idx, dst, idx + 2, src.length - idx);
        int[] dstHashes = this.insertElement(this.originalHashes(), dataIx, originalHash);
        return new BitmapIndexedMapNode<K, V>(this.dataMap() | bitpos, this.nodeMap(), dst, dstHashes, this.size() + 1, this.cachedJavaKeySetHashCode() + keyHash);
    }

    public BitmapIndexedMapNode<K, V> copyAndRemoveValue(int bitpos, int keyHash) {
        int dataIx = this.dataIndex(bitpos);
        int idx = 2 * dataIx;
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 2];
        System.arraycopy(src, 0, dst, 0, idx);
        System.arraycopy(src, idx + 2, dst, idx, src.length - idx - 2);
        int[] dstHashes = this.removeElement(this.originalHashes(), dataIx);
        return new BitmapIndexedMapNode<K, V>(this.dataMap() ^ bitpos, this.nodeMap(), dst, dstHashes, this.size() - 1, this.cachedJavaKeySetHashCode() - keyHash);
    }

    public <V1> BitmapIndexedMapNode<K, V> migrateFromInlineToNodeInPlace(int bitpos, int keyHash, MapNode<K, V1> node) {
        int dataIx = this.dataIndex(bitpos);
        int idxOld = 2 * dataIx;
        int idxNew = this.content().length - 2 - this.nodeIndex(bitpos);
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 2 + 1];
        System.arraycopy(src, 0, dst, 0, idxOld);
        System.arraycopy(src, idxOld + 2, dst, idxOld, idxNew - idxOld);
        dst[idxNew] = node;
        System.arraycopy(src, idxNew + 2, dst, idxNew + 1, src.length - idxNew - 2);
        int[] dstHashes = this.removeElement(this.originalHashes(), dataIx);
        this.dataMap_$eq(this.dataMap() ^ bitpos);
        this.nodeMap_$eq(this.nodeMap() | bitpos);
        this.content_$eq(dst);
        this.originalHashes_$eq(dstHashes);
        this.size_$eq(this.size() - 1 + node.size());
        this.cachedJavaKeySetHashCode_$eq(this.cachedJavaKeySetHashCode() - keyHash + node.cachedJavaKeySetHashCode());
        return this;
    }

    public <V1> BitmapIndexedMapNode<K, V1> copyAndMigrateFromInlineToNode(int bitpos, int keyHash, MapNode<K, V1> node) {
        int dataIx = this.dataIndex(bitpos);
        int idxOld = 2 * dataIx;
        int idxNew = this.content().length - 2 - this.nodeIndex(bitpos);
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 2 + 1];
        System.arraycopy(src, 0, dst, 0, idxOld);
        System.arraycopy(src, idxOld + 2, dst, idxOld, idxNew - idxOld);
        dst[idxNew] = node;
        System.arraycopy(src, idxNew + 2, dst, idxNew + 1, src.length - idxNew - 2);
        int[] dstHashes = this.removeElement(this.originalHashes(), dataIx);
        return new BitmapIndexedMapNode<K, V>(this.dataMap() ^ bitpos, this.nodeMap() | bitpos, dst, dstHashes, this.size() - 1 + node.size(), this.cachedJavaKeySetHashCode() - keyHash + node.cachedJavaKeySetHashCode());
    }

    public <V1> BitmapIndexedMapNode<K, V1> copyAndMigrateFromNodeToInline(int bitpos, MapNode<K, V1> oldNode, MapNode<K, V1> node) {
        int idxOld = this.content().length - 1 - this.nodeIndex(bitpos);
        int dataIxNew = this.dataIndex(bitpos);
        int idxNew = 2 * dataIxNew;
        K key = node.getKey(0);
        V1 value = node.getValue(0);
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 1 + 2];
        System.arraycopy(src, 0, dst, 0, idxNew);
        dst[idxNew] = key;
        dst[idxNew + 1] = value;
        System.arraycopy(src, idxNew, dst, idxNew + 2, idxOld - idxNew);
        System.arraycopy(src, idxOld + 1, dst, idxOld + 2, src.length - idxOld - 1);
        int hash = node.getHash(0);
        int[] dstHashes = this.insertElement(this.originalHashes(), dataIxNew, hash);
        return new BitmapIndexedMapNode<K, V>(this.dataMap() | bitpos, this.nodeMap() ^ bitpos, dst, dstHashes, this.size() - oldNode.size() + 1, this.cachedJavaKeySetHashCode() - oldNode.cachedJavaKeySetHashCode() + node.cachedJavaKeySetHashCode());
    }

    @Override
    public <U> void foreach(Function1<Tuple2<K, V>, U> f) {
        int iN = this.payloadArity();
        for (int i = 0; i < iN; ++i) {
            f.apply(this.getPayload(i));
        }
        int jN = this.nodeArity();
        for (int j = 0; j < jN; ++j) {
            ((MapNode)this.getNode(j)).foreach(f);
        }
    }

    @Override
    public <U> void foreachEntry(Function2<K, V, U> f) {
        int iN = this.payloadArity();
        for (int i = 0; i < iN; ++i) {
            f.apply(this.content()[2 * i], this.content()[2 * i + 1]);
        }
        int jN = this.nodeArity();
        for (int j = 0; j < jN; ++j) {
            ((MapNode)this.getNode(j)).foreachEntry(f);
        }
    }

    @Override
    public void foreachWithHash(Function3<K, V, Object, BoxedUnit> f) {
        int iN = this.payloadArity();
        for (int i = 0; i < iN; ++i) {
            f.apply(this.content()[2 * i], this.content()[2 * i + 1], this.originalHashes()[i]);
        }
        int jN = this.nodeArity();
        for (int j = 0; j < jN; ++j) {
            ((MapNode)this.getNode(j)).foreachWithHash(f);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        void deepContentEquality_length;
        void deepContentEquality_a2;
        if (!(that instanceof BitmapIndexedMapNode)) return false;
        BitmapIndexedMapNode bitmapIndexedMapNode = (BitmapIndexedMapNode)that;
        if (this == bitmapIndexedMapNode) return true;
        if (this.cachedJavaKeySetHashCode() != bitmapIndexedMapNode.cachedJavaKeySetHashCode()) return false;
        if (this.nodeMap() != bitmapIndexedMapNode.nodeMap()) return false;
        if (this.dataMap() != bitmapIndexedMapNode.dataMap()) return false;
        if (this.size() != bitmapIndexedMapNode.size()) return false;
        if (!Arrays.equals(this.originalHashes(), bitmapIndexedMapNode.originalHashes())) return false;
        int n = this.content().length;
        Object[] objectArray = bitmapIndexedMapNode.content();
        Object[] deepContentEquality_a1 = this.content();
        if (deepContentEquality_a1 == deepContentEquality_a2) {
            return true;
        }
        boolean deepContentEquality_isEqual = true;
        for (int deepContentEquality_i = 0; deepContentEquality_isEqual && deepContentEquality_i < deepContentEquality_length; ++deepContentEquality_i) {
            deepContentEquality_isEqual = BoxesRunTime.equals(deepContentEquality_a1[deepContentEquality_i], deepContentEquality_a2[deepContentEquality_i]);
        }
        boolean bl = deepContentEquality_isEqual;
        Object var4_5 = null;
        objectArray = null;
        if (!bl) return false;
        return true;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Trie nodes do not support hashing.");
    }

    @Override
    public BitmapIndexedMapNode<K, V> copy() {
        Object[] contentClone = (Object[])this.content().clone();
        int contentLength = contentClone.length;
        for (int i = Integer.bitCount(this.dataMap()) * 2; i < contentLength; ++i) {
            contentClone[i] = ((MapNode)contentClone[i]).copy();
        }
        return new BitmapIndexedMapNode<K, V>(this.dataMap(), this.nodeMap(), contentClone, (int[])this.originalHashes().clone(), this.size(), this.cachedJavaKeySetHashCode());
    }

    @Override
    public BitmapIndexedMapNode<K, V> filterImpl(Function1<Tuple2<K, V>, Object> pred, boolean flipped) {
        if (this.size() == 0) {
            return this;
        }
        if (this.size() == 1) {
            if (BoxesRunTime.unboxToBoolean(pred.apply(this.getPayload(0))) != flipped) {
                return this;
            }
            return MapNode$.MODULE$.empty();
        }
        if (this.nodeMap() == 0) {
            int minimumIndex = Integer.numberOfTrailingZeros(this.dataMap());
            int maximumIndex = 32 - Integer.numberOfLeadingZeros(this.dataMap());
            int newDataMap = 0;
            int newCachedHashCode = 0;
            int dataIndex = 0;
            for (int i = minimumIndex; i < maximumIndex; ++i) {
                int n = 1 << i;
                if ((n & this.dataMap()) == 0) continue;
                Tuple2<K, V> payload = this.getPayload(dataIndex);
                if (BoxesRunTime.unboxToBoolean(pred.apply(payload)) != flipped) {
                    newDataMap |= n;
                    newCachedHashCode += Hashing$.MODULE$.improve(this.originalHashes()[dataIndex]);
                }
                ++dataIndex;
            }
            if (newDataMap == 0) {
                return MapNode$.MODULE$.empty();
            }
            if (newDataMap == this.dataMap()) {
                return this;
            }
            int newSize = Integer.bitCount(newDataMap);
            Object[] newContent = new Object[newSize * 2];
            int[] newOriginalHashCodes = new int[newSize];
            int newMaximumIndex = 32 - Integer.numberOfLeadingZeros(newDataMap);
            int newDataIndex = 0;
            for (int j = Integer.numberOfTrailingZeros(newDataMap); j < newMaximumIndex; ++j) {
                int n = 1 << j;
                if ((n & newDataMap) == 0) continue;
                int n2 = Integer.bitCount(this.dataMap() & n - 1);
                newContent[newDataIndex * 2] = this.content()[n2 * 2];
                newContent[newDataIndex * 2 + 1] = this.content()[n2 * 2 + 1];
                newOriginalHashCodes[newDataIndex] = this.originalHashes()[n2];
                ++newDataIndex;
            }
            return new BitmapIndexedMapNode<K, V>(newDataMap, 0, newContent, newOriginalHashCodes, newSize, newCachedHashCode);
        }
        int allMap = this.dataMap() | this.nodeMap();
        int minimumIndex = Integer.numberOfTrailingZeros(allMap);
        int maximumIndex = 32 - Integer.numberOfLeadingZeros(allMap);
        int oldDataPassThrough = 0;
        int nodeMigrateToDataTargetMap = 0;
        AbstractBuffer nodesToMigrateToData = null;
        int nodesToPassThroughMap = 0;
        int mapOfNewNodes = 0;
        Object newNodes = null;
        int newDataMap = 0;
        int newNodeMap = 0;
        int newSize = 0;
        int newCachedHashCode = 0;
        int dataIndex = 0;
        int nodeIndex = 0;
        for (int i = minimumIndex; i < maximumIndex; ++i) {
            int n = 1 << i;
            if ((n & this.dataMap()) != 0) {
                Tuple2<K, V> payload = this.getPayload(dataIndex);
                if (BoxesRunTime.unboxToBoolean(pred.apply(payload)) != flipped) {
                    newDataMap |= n;
                    oldDataPassThrough |= n;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(this.originalHashes()[dataIndex]);
                }
                ++dataIndex;
                continue;
            }
            if ((n & this.nodeMap()) == 0) continue;
            Node oldSubNode = this.getNode(nodeIndex);
            MapNode<K, V> newSubNode = ((MapNode)oldSubNode).filterImpl(pred, flipped);
            newSize += newSubNode.size();
            newCachedHashCode += newSubNode.cachedJavaKeySetHashCode();
            if (newSubNode.size() > 1) {
                newNodeMap |= n;
                if (oldSubNode == newSubNode) {
                    nodesToPassThroughMap |= n;
                } else {
                    mapOfNewNodes |= n;
                    if (newNodes == null) {
                        newNodes = Queue$.MODULE$.empty();
                    }
                    ((AbstractBuffer)newNodes).$plus$eq(newSubNode);
                }
            } else if (newSubNode.size() == 1) {
                newDataMap |= n;
                nodeMigrateToDataTargetMap |= n;
                if (nodesToMigrateToData == null) {
                    nodesToMigrateToData = (Queue)IterableFactory.apply$(Queue$.MODULE$, Nil$.MODULE$);
                }
                nodesToMigrateToData.$plus$eq(newSubNode);
            }
            ++nodeIndex;
        }
        if (newSize == 0) {
            return MapNode$.MODULE$.empty();
        }
        if (newSize == this.size()) {
            return this;
        }
        int newDataSize = Integer.bitCount(newDataMap);
        int newContentSize = 2 * newDataSize + Integer.bitCount(newNodeMap);
        Object[] newContent = new Object[newContentSize];
        int[] newOriginalHashes = new int[newDataSize];
        int newAllMap = newDataMap | newNodeMap;
        int maxIndex = 32 - Integer.numberOfLeadingZeros(newAllMap);
        int oldDataIndex = 0;
        int oldNodeIndex = 0;
        int newDataIndex = 0;
        int newNodeIndex = 0;
        for (int i = minimumIndex; i < maxIndex; ++i) {
            int bitpos = Node$.MODULE$.bitposFrom(i);
            if ((bitpos & oldDataPassThrough) != 0) {
                newContent[newDataIndex * 2] = this.content()[2 * oldDataIndex];
                newContent[newDataIndex * 2 + 1] = this.content()[2 * oldDataIndex + 1];
                newOriginalHashes[newDataIndex] = this.originalHashes()[oldDataIndex];
                ++newDataIndex;
                ++oldDataIndex;
                continue;
            }
            if ((bitpos & nodesToPassThroughMap) != 0) {
                newContent[newContentSize - newNodeIndex - 1] = this.getNode(oldNodeIndex);
                ++newNodeIndex;
                ++oldNodeIndex;
                continue;
            }
            if ((bitpos & nodeMigrateToDataTargetMap) != 0) {
                MapNode node = (MapNode)((Queue)nodesToMigrateToData).dequeue();
                newContent[2 * newDataIndex] = node.getKey(0);
                newContent[2 * newDataIndex + 1] = node.getValue(0);
                newOriginalHashes[newDataIndex] = node.getHash(0);
                ++newDataIndex;
                ++oldNodeIndex;
                continue;
            }
            if ((bitpos & mapOfNewNodes) != 0) {
                newContent[newContentSize - newNodeIndex - 1] = ((Queue)newNodes).dequeue();
                ++newNodeIndex;
                ++oldNodeIndex;
                continue;
            }
            if ((bitpos & this.dataMap()) != 0) {
                ++oldDataIndex;
                continue;
            }
            if ((bitpos & this.nodeMap()) == 0) continue;
            ++oldNodeIndex;
        }
        return new BitmapIndexedMapNode<K, V>(newDataMap, newNodeMap, newContent, newOriginalHashes, newSize, newCachedHashCode);
    }

    public BitmapIndexedMapNode(int dataMap, int nodeMap, Object[] content, int[] originalHashes, int size, int cachedJavaKeySetHashCode) {
        this.dataMap = dataMap;
        this.nodeMap = nodeMap;
        this.content = content;
        this.originalHashes = originalHashes;
        this.size = size;
        this.cachedJavaKeySetHashCode = cachedJavaKeySetHashCode;
        Statics.releaseFence();
    }
}

