/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.math.BigDecimal;
import py4j.Protocol;
import py4j.StringUtil;

public class ReturnObject {
    private String name;
    private Object primitiveObject;
    private boolean isReference;
    private boolean isMap;
    private boolean isList;
    private boolean isNull;
    private boolean isError;
    private boolean isVoid;
    private boolean isArray;
    private boolean isIterator;
    private boolean isSet;
    private boolean isDecimal;
    private int size;
    private String commandPart;

    public static ReturnObject getArrayReturnObject(String name, int size) {
        ReturnObject rObject = new ReturnObject();
        rObject.name = name;
        rObject.size = size;
        rObject.isArray = true;
        rObject.commandPart = 't' + name;
        return rObject;
    }

    public static ReturnObject getDecimalReturnObject(Object object) {
        BigDecimal decimal = (BigDecimal)object;
        ReturnObject rObject = new ReturnObject();
        rObject.isDecimal = true;
        rObject.commandPart = 'D' + decimal.toPlainString();
        return rObject;
    }

    public static ReturnObject getErrorReferenceReturnObject(String name) {
        ReturnObject rObject = new ReturnObject();
        rObject.name = name;
        rObject.isError = true;
        StringBuilder builder = new StringBuilder();
        builder.append('x');
        builder.append('r');
        builder.append(name);
        rObject.commandPart = builder.toString();
        return rObject;
    }

    public static ReturnObject getErrorReturnObject(Throwable throwable) {
        ReturnObject rObject = new ReturnObject();
        rObject.isError = true;
        StringBuilder builder = new StringBuilder();
        builder.append('x');
        builder.append('s');
        builder.append(StringUtil.escape(Protocol.getThrowableAsString(throwable)));
        rObject.commandPart = builder.toString();
        return rObject;
    }

    public static ReturnObject getIteratorReturnObject(String name) {
        ReturnObject rObject = new ReturnObject();
        rObject.name = name;
        rObject.isIterator = true;
        rObject.commandPart = 'g' + name;
        return rObject;
    }

    public static ReturnObject getListReturnObject(String name, int size) {
        ReturnObject rObject = new ReturnObject();
        rObject.name = name;
        rObject.size = size;
        rObject.isList = true;
        rObject.commandPart = 'l' + name;
        return rObject;
    }

    public static ReturnObject getMapReturnObject(String name, int size) {
        ReturnObject rObject = new ReturnObject();
        rObject.name = name;
        rObject.size = size;
        rObject.isMap = true;
        rObject.commandPart = 'a' + name;
        return rObject;
    }

    public static ReturnObject getNullReturnObject() {
        ReturnObject rObject = new ReturnObject();
        rObject.isNull = true;
        rObject.commandPart = String.valueOf('n');
        return rObject;
    }

    public static ReturnObject getPrimitiveReturnObject(Object primitive) {
        ReturnObject rObject = new ReturnObject();
        rObject.primitiveObject = primitive;
        char primitiveType = Protocol.getPrimitiveType(primitive);
        rObject.commandPart = primitiveType == 's' ? primitiveType + StringUtil.escape(primitive.toString()) : (primitiveType == 'j' ? primitiveType + Protocol.encodeBytes((byte[])primitive) : primitiveType + primitive.toString());
        return rObject;
    }

    public static ReturnObject getReferenceReturnObject(String name) {
        ReturnObject rObject = new ReturnObject();
        rObject.name = name;
        rObject.isReference = true;
        rObject.commandPart = 'r' + name;
        return rObject;
    }

    public static ReturnObject getSetReturnObject(String name, int size) {
        ReturnObject rObject = new ReturnObject();
        rObject.name = name;
        rObject.size = size;
        rObject.isSet = true;
        rObject.commandPart = 'h' + name;
        return rObject;
    }

    public static ReturnObject getVoidReturnObject() {
        ReturnObject rObject = new ReturnObject();
        rObject.isVoid = true;
        rObject.commandPart = String.valueOf('v');
        return rObject;
    }

    private ReturnObject() {
    }

    public String getCommandPart() {
        return this.commandPart;
    }

    public String getName() {
        return this.name;
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean isReference() {
        return this.isReference;
    }
}

