# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: oracle/v1/genesis.proto, oracle/v1/oracle.proto, oracle/v1/query.proto, oracle/v1/tx.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import datetime
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ...cosmos.base import v1beta1 as __cosmos_base_v1_beta1__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class ResolveStatus(betterproto.Enum):
    """ResolveStatus encodes the status of an oracle request."""

    RESOLVE_STATUS_OPEN_UNSPECIFIED = 0
    """Open - the request is not yet resolved."""

    RESOLVE_STATUS_SUCCESS = 1
    """Success - the request has been resolved successfully with no errors."""

    RESOLVE_STATUS_FAILURE = 2
    """Failure - an error occured during the request's resolve call."""

    RESOLVE_STATUS_EXPIRED = 3
    """
    Expired - the request does not get enough reports from validator within the
    timeframe.
    """


@dataclass(eq=False, repr=False)
class DataSource(betterproto.Message):
    """
    DataSource is the data structure for storing data sources in the storage.
    """

    owner: str = betterproto.string_field(1)
    """Owner is an address of the account who own the data source"""

    name: str = betterproto.string_field(2)
    """Name is data source name used for display"""

    description: str = betterproto.string_field(3)
    """Description is data source description used for display"""

    filename: str = betterproto.string_field(4)
    """
    Filename is string of file name used as reference for locating data source
    file stored in bandchain nodes
    """

    treasury: str = betterproto.string_field(5)
    """
    Treasury is the account address who receive data source fee from requester.
    """

    fee: List["__cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(6)
    """
    Fee is the data source fee per ask_count that data provider will receive
    from requester.
    """


@dataclass(eq=False, repr=False)
class OracleScript(betterproto.Message):
    """
    OracleScript is the data structure for storing oracle scripts in the
    storage.
    """

    owner: str = betterproto.string_field(1)
    """Owner is an address of the account who own the oracle script"""

    name: str = betterproto.string_field(2)
    """Name is oracle script name used for display"""

    description: str = betterproto.string_field(3)
    """Description is oracle script description used for display"""

    filename: str = betterproto.string_field(4)
    """
    Filename is string of file name used as reference for locating compiled
    oracle script WASM file stored in bandchain nodes
    """

    schema: str = betterproto.string_field(5)
    """
    Schema is the schema of the oracle script input/output which is formatted
    in OBI format e.g. "{symbol:string,multiplier:u64}/{px:u64}"
    """

    source_code_url: str = betterproto.string_field(6)
    """
    SourceCodeURL is the URL of oracle script's source code. It is recommendded
    to store source code on IPFS and get its URL to preserve decentralization.
    """


@dataclass(eq=False, repr=False)
class RawRequest(betterproto.Message):
    """
    RawRequest is the data structure for storing raw requests in the storage.
    """

    external_id: int = betterproto.uint64_field(1)
    """ExternalID is an ID of the raw request"""

    data_source_id: int = betterproto.uint64_field(2)
    """
    DataSourceID is an ID of data source script that relates to the raw request
    """

    calldata: bytes = betterproto.bytes_field(3)
    """
    Calldata is the data used as argument params for executing data source
    script
    """


@dataclass(eq=False, repr=False)
class RawReport(betterproto.Message):
    """
    RawRequest is the data structure for storing raw reporter in the storage.
    """

    external_id: int = betterproto.uint64_field(1)
    """ExternalID is an ID of the raw request"""

    exit_code: int = betterproto.uint32_field(2)
    """
    ExitCode is status code provided by validators to specify error, if any.
    Exit code is usually filled by the exit code returned from execution of
    specified data source script. With code 0 means there is no error.
    """

    data: bytes = betterproto.bytes_field(3)
    """
    Data is raw result provided by validators. It is usually filled by the
    result from execution of specified data source script.
    """


@dataclass(eq=False, repr=False)
class Request(betterproto.Message):
    """Request is the data structure for storing requests in the storage."""

    oracle_script_id: int = betterproto.uint64_field(1)
    """OracleScriptID is ID of an oracle script"""

    calldata: bytes = betterproto.bytes_field(2)
    """Calldata is the data used as argument params for the oracle script"""

    requested_validators: List[str] = betterproto.string_field(3)
    """
    RequestedValidators is a list of validator addresses that are assigned for
    fulfilling the request
    """

    min_count: int = betterproto.uint64_field(4)
    """
    MinCount is minimum number of validators required for fulfilling the
    request
    """

    request_height: int = betterproto.int64_field(5)
    """RequestHeight is block height that the request has been created"""

    request_time: int = betterproto.int64_field(6)
    """
    RequestTime is timestamp of the chain's block which contains the request
    """

    client_id: str = betterproto.string_field(7)
    """
    ClientID is arbitrary id provided by requester. It is used by client-side
    for referencing the request
    """

    raw_requests: List["RawRequest"] = betterproto.message_field(8)
    """
    RawRequests is a list of raw requests specified by execution of oracle
    script
    """

    ibc_channel: "IbcChannel" = betterproto.message_field(9)
    """
    IBCChannel is an IBC channel info of the other chain, which contains a
    channel and a port to allow bandchain connect to that chain. This field
    allows other chain be able to request data from bandchain via IBC.
    """

    execute_gas: int = betterproto.uint64_field(10)
    """ExecuteGas is amount of gas to reserve for executing"""


@dataclass(eq=False, repr=False)
class Report(betterproto.Message):
    """Report is the data structure for storing reports in the storage."""

    validator: str = betterproto.string_field(1)
    """Validator is a validator address who submit the report"""

    in_before_resolve: bool = betterproto.bool_field(2)
    """
    InBeforeResolve indicates whether the report is submitted before the
    request resolved
    """

    raw_reports: List["RawReport"] = betterproto.message_field(3)
    """
    RawReports is list of raw reports provided by the validator. Each raw
    report has different external ID
    """


@dataclass(eq=False, repr=False)
class OracleRequestPacketData(betterproto.Message):
    """
    OracleRequestPacketData encodes an oracle request sent from other
    blockchains to BandChain.
    """

    client_id: str = betterproto.string_field(1)
    """
    ClientID is the unique identifier of this oracle request, as specified by
    the client. This same unique ID will be sent back to the requester with the
    oracle response.
    """

    oracle_script_id: int = betterproto.uint64_field(2)
    """
    OracleScriptID is the unique identifier of the oracle script to be
    executed.
    """

    calldata: bytes = betterproto.bytes_field(3)
    """
    Calldata is the OBI-encoded calldata bytes available for oracle executor to
    read.
    """

    ask_count: int = betterproto.uint64_field(4)
    """
    AskCount is the number of validators that are requested to respond to this
    oracle request. Higher value means more security, at a higher gas cost.
    """

    min_count: int = betterproto.uint64_field(5)
    """
    MinCount is the minimum number of validators necessary for the request to
    proceed to the execution phase. Higher value means more security, at the
    cost of liveness.
    """

    fee_limit: List["__cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(6)
    """
    FeeLimit is the maximum tokens that will be paid to all data source
    providers.
    """

    prepare_gas: int = betterproto.uint64_field(7)
    """PrepareGas is amount of gas to pay to prepare raw requests"""

    execute_gas: int = betterproto.uint64_field(8)
    """ExecuteGas is amount of gas to reserve for executing"""


@dataclass(eq=False, repr=False)
class OracleRequestPacketAcknowledgement(betterproto.Message):
    """
    OracleRequestPacketAcknowledgement encodes an oracle request
    acknowledgement send back to requester chain.
    """

    request_id: int = betterproto.uint64_field(1)
    """RequestID is BandChain's unique identifier for this oracle request."""


@dataclass(eq=False, repr=False)
class OracleResponsePacketData(betterproto.Message):
    """
    OracleResponsePacketData encodes an oracle response from BandChain to the
    requester.
    """

    client_id: str = betterproto.string_field(1)
    """
    ClientID is the unique identifier matched with that of the oracle request
    packet.
    """

    request_id: int = betterproto.uint64_field(2)
    """RequestID is BandChain's unique identifier for this oracle request."""

    ans_count: int = betterproto.uint64_field(3)
    """
    AnsCount is the number of validators among to the asked validators that
    actually responded to this oracle request prior to this oracle request
    being resolved.
    """

    request_time: int = betterproto.int64_field(4)
    """
    RequestTime is the UNIX epoch time at which the request was sent to
    BandChain.
    """

    resolve_time: int = betterproto.int64_field(5)
    """
    ResolveTime is the UNIX epoch time at which the request was resolved to the
    final result.
    """

    resolve_status: "ResolveStatus" = betterproto.enum_field(6)
    """
    ResolveStatus is the status of this oracle request, which can be OK,
    FAILURE, or EXPIRED.
    """

    result: bytes = betterproto.bytes_field(7)
    """
    Result is the final aggregated value encoded in OBI format. Only available
    if status if OK.
    """


@dataclass(eq=False, repr=False)
class Result(betterproto.Message):
    """Result encodes a result of request and store in chain"""

    client_id: str = betterproto.string_field(1)
    """
    ClientID is the unique identifier of this oracle request, as specified by
    the client. This same unique ID will be sent back to the requester with the
    oracle response.
    """

    oracle_script_id: int = betterproto.uint64_field(2)
    """
    OracleScriptID is the unique identifier of the oracle script to be
    executed.
    """

    calldata: bytes = betterproto.bytes_field(3)
    """
    Calldata is the calldata bytes available for oracle executor to read.
    """

    ask_count: int = betterproto.uint64_field(4)
    """
    AskCount is the number of validators that are requested to respond to this
    oracle request. Higher value means more security, at a higher gas cost.
    """

    min_count: int = betterproto.uint64_field(5)
    """
    MinCount is the minimum number of validators necessary for the request to
    proceed to the execution phase. Higher value means more security, at the
    cost of liveness.
    """

    request_id: int = betterproto.uint64_field(6)
    """RequestID is BandChain's unique identifier for this oracle request."""

    ans_count: int = betterproto.uint64_field(7)
    """
    AnsCount is the number of validators among to the asked validators that
    actually responded to this oracle request prior to this oracle request
    being resolved.
    """

    request_time: int = betterproto.int64_field(8)
    """
    RequestTime is the UNIX epoch time at which the request was sent to
    BandChain.
    """

    resolve_time: int = betterproto.int64_field(9)
    """
    ResolveTime is the UNIX epoch time at which the request was resolved to the
    final result.
    """

    resolve_status: "ResolveStatus" = betterproto.enum_field(10)
    """
    ResolveStatus is the status of this oracle request, which can be OK,
    FAILURE, or EXPIRED.
    """

    result: bytes = betterproto.bytes_field(11)
    """Result is the final aggregated value only available if status if OK."""


@dataclass(eq=False, repr=False)
class ValidatorStatus(betterproto.Message):
    """
    ValidatorStatus maintains whether a validator is an active oracle provider.
    """

    is_active: bool = betterproto.bool_field(1)
    """
    IsActive is a boolean indicating active status of validator. The validator
    will be deactivated when they are unable to send reports to fulfill oracle
    request before the request expired.
    """

    since: datetime = betterproto.message_field(2)
    """
    Since is a block timestamp when validator has been activated/deactivated
    """


@dataclass(eq=False, repr=False)
class ActiveValidator(betterproto.Message):
    """ActiveValidator is information of currently active validator"""

    address: str = betterproto.string_field(1)
    """Address is a validator address"""

    power: int = betterproto.uint64_field(2)
    """Power is an amount of token that the validator is holding"""


@dataclass(eq=False, repr=False)
class Params(betterproto.Message):
    """
    Params is the data structure that keeps the parameters of the oracle
    module.
    """

    max_raw_request_count: int = betterproto.uint64_field(1)
    """
    MaxRawRequestCount is the maximum number of data source raw requests a
    request can make.
    """

    max_ask_count: int = betterproto.uint64_field(2)
    """
    MaxAskCount is the maximum number of validators a request can target.
    """

    max_calldata_size: int = betterproto.uint64_field(3)
    """
    MaxCalldataSize is the maximum size limit of calldata (bytes) in a request.
    """

    max_report_data_size: int = betterproto.uint64_field(4)
    """
    MaxReportDataSize is the maximum size limit of report data (bytes) in a
    report.
    """

    expiration_block_count: int = betterproto.uint64_field(5)
    """
    ExpirationBlockCount is the number of blocks a request stays valid before
    it gets expired due to insufficient reports.
    """

    base_owasm_gas: int = betterproto.uint64_field(6)
    """
    BaseOwasmGas is the base amount of Cosmos-SDK gas charged for owasm
    execution.
    """

    per_validator_request_gas: int = betterproto.uint64_field(7)
    """
    PerValidatorRequestGas is the amount of Cosmos-SDK gas charged per
    requested validator.
    """

    sampling_try_count: int = betterproto.uint64_field(8)
    """
    SamplingTryCount the number of validator sampling tries to pick the highest
    voting power subset of validators to perform an oracle task.
    """

    oracle_reward_percentage: int = betterproto.uint64_field(9)
    """
    OracleRewardPercentage is the percentage of block rewards allocated to
    active oracle validators.
    """

    inactive_penalty_duration: int = betterproto.uint64_field(10)
    """
    InactivePenaltyDuration is the duration period where a validator cannot
    activate back after missing an oracle report.
    """

    ibc_request_enabled: bool = betterproto.bool_field(11)
    """
    IBCRequestEnabled is a flag indicating whether sending oracle request via
    IBC is allowed
    """


@dataclass(eq=False, repr=False)
class PendingResolveList(betterproto.Message):
    """
    PendingResolveList is a list of requests that are waiting to be resolved
    """

    request_ids: List[int] = betterproto.uint64_field(1)
    """RequestIDs is a list of request IDs that are waiting to be resolved"""


@dataclass(eq=False, repr=False)
class IbcChannel(betterproto.Message):
    """
    IBCChannel is information of IBC protocol to allow communicating with other
    chain
    """

    port_id: str = betterproto.string_field(1)
    """
    PortID is port ID used for sending response packet when request is
    resolved.
    """

    channel_id: str = betterproto.string_field(2)
    """
    ChannelID is channel ID used for sending response packet when request is
    resolved.
    """


@dataclass(eq=False, repr=False)
class RequestVerification(betterproto.Message):
    """
    RequestVerification is a message that is constructed and signed by a
    reporter to be used as a part of verification of oracle request.
    """

    chain_id: str = betterproto.string_field(1)
    """ChainID is the ID of targeted chain"""

    validator: str = betterproto.string_field(2)
    """Validator is an validator address"""

    request_id: int = betterproto.uint64_field(3)
    """RequestID is the targeted request ID"""

    external_id: int = betterproto.uint64_field(4)
    """ExternalID is the oracle's external ID of data source"""

    data_source_id: int = betterproto.uint64_field(5)
    """DataSourceID is the ID of data source"""


@dataclass(eq=False, repr=False)
class PriceResult(betterproto.Message):
    """PriceResult is a result from standard price reference"""

    symbol: str = betterproto.string_field(1)
    """
    Symbol is unit of data indicating what the data is. It is price currencies
    for this case.
    """

    multiplier: int = betterproto.uint64_field(2)
    """
    Multiplier is a number used for left-shifting value to eliminate decimal
    digits
    """

    px: int = betterproto.uint64_field(3)
    """
    Px is the actual data, which is rate number multiplied by the multiplier.
    """

    request_id: int = betterproto.uint64_field(4)
    """RequestID is oracle request ID that contains this price"""

    resolve_time: int = betterproto.int64_field(5)
    """
    ResolveTime is epoch timestamp indicating the time when the request had
    been resolved
    """


@dataclass(eq=False, repr=False)
class MsgRequestData(betterproto.Message):
    """MsgRequestData is a message for sending a data oracle request."""

    oracle_script_id: int = betterproto.uint64_field(1)
    """OracleScriptID is the identifier of the oracle script to be called."""

    calldata: bytes = betterproto.bytes_field(2)
    """Calldata is the OBI-encoded call parameters for the oracle script."""

    ask_count: int = betterproto.uint64_field(3)
    """AskCount is the number of validators to perform the oracle task."""

    min_count: int = betterproto.uint64_field(4)
    """
    MinCount is the minimum number of validators sufficient to resolve the
    oracle tasks.
    """

    client_id: str = betterproto.string_field(5)
    """
    ClientID is the client-provided unique identifier to track the request.
    """

    fee_limit: List["__cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(6)
    """
    FeeLimit is the maximum tokens that will be paid to all data source
    providers.
    """

    prepare_gas: int = betterproto.uint64_field(7)
    """PrepareGas is amount of gas to pay to prepare raw requests"""

    execute_gas: int = betterproto.uint64_field(8)
    """ExecuteGas is amount of gas to reserve for executing"""

    sender: str = betterproto.string_field(9)
    """Sender is an account address of message sender."""


@dataclass(eq=False, repr=False)
class MsgRequestDataResponse(betterproto.Message):
    """MsgRequestDataResponse is response data for MsgRequestData message"""

    pass


@dataclass(eq=False, repr=False)
class MsgReportData(betterproto.Message):
    """
    MsgReportData is a message for reporting to a data request by a validator.
    """

    request_id: int = betterproto.uint64_field(1)
    """RequestID is the identifier of the request to be reported to."""

    raw_reports: List["RawReport"] = betterproto.message_field(2)
    """
    RawReports is the list of report information provided by data sources
    identified by external ID
    """

    validator: str = betterproto.string_field(3)
    """Validator is the address of the validator that owns this report."""


@dataclass(eq=False, repr=False)
class MsgReportDataResponse(betterproto.Message):
    """MsgReportDataResponse is response data for MsgReportData message"""

    pass


@dataclass(eq=False, repr=False)
class MsgCreateDataSource(betterproto.Message):
    """MsgCreateDataSource is a message for creating a new data source."""

    name: str = betterproto.string_field(1)
    """Name is the name of this data source used for display (optional)."""

    description: str = betterproto.string_field(2)
    """
    Description is the description of this data source used for display
    (optional).
    """

    executable: bytes = betterproto.bytes_field(3)
    """
    Executable is the content of executable script or binary file to be run by
    validators upon execution.
    """

    fee: List["__cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(4)
    """
    Fee is the data source fee per ask_count that data provider will receive
    from requester.
    """

    treasury: str = betterproto.string_field(5)
    """
    Treasury is the account address who receive data source fee from requester.
    """

    owner: str = betterproto.string_field(6)
    """
    Owner is the account address who is allowed to make further changes to the
    data source.
    """

    sender: str = betterproto.string_field(7)
    """Sender is the signer of this message."""


@dataclass(eq=False, repr=False)
class MsgCreateDataSourceResponse(betterproto.Message):
    """
    MsgCreateDataSourceResponse is response data for MsgCreateDataSource
    message
    """

    pass


@dataclass(eq=False, repr=False)
class MsgEditDataSource(betterproto.Message):
    """MsgEditDataSource is a message for editing an existing data source."""

    data_source_id: int = betterproto.uint64_field(1)
    """
    DataSourceID is the unique identifier of the data source to be edited.
    """

    name: str = betterproto.string_field(2)
    """Name is the name of this data source used for display (optional)."""

    description: str = betterproto.string_field(3)
    """
    Description is the description of this data source used for display
    (optional).
    """

    executable: bytes = betterproto.bytes_field(4)
    """
    Executable is the executable script or binary to be run by validators upon
    execution.
    """

    fee: List["__cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(5)
    """
    Fee is the data source fee per ask_count that data provider will receive
    from requester.
    """

    treasury: str = betterproto.string_field(6)
    """Treasury is the address who receive data source fee from requester."""

    owner: str = betterproto.string_field(7)
    """
    Owner is the address who is allowed to make further changes to the data
    source.
    """

    sender: str = betterproto.string_field(8)
    """
    Sender is the signer of this message. Must be the current data source's
    owner.
    """


@dataclass(eq=False, repr=False)
class MsgEditDataSourceResponse(betterproto.Message):
    """
    MsgEditDataSourceResponse is response data for MsgEditDataSource message
    """

    pass


@dataclass(eq=False, repr=False)
class MsgCreateOracleScript(betterproto.Message):
    """MsgCreateOracleScript is a message for creating an oracle script."""

    name: str = betterproto.string_field(1)
    """Name is the name of this oracle script used for display (optional)."""

    description: str = betterproto.string_field(2)
    """
    Description is the description of this oracle script used for display
    (optional).
    """

    schema: str = betterproto.string_field(3)
    """Schema is the OBI schema of this oracle script (optional)."""

    source_code_url: str = betterproto.string_field(4)
    """
    SourceCodeURL is the absolute URI to the script's source code (optional).
    """

    code: bytes = betterproto.bytes_field(5)
    """
    Code is the oracle WebAssembly binary code. Can be raw of gzip compressed.
    """

    owner: str = betterproto.string_field(6)
    """
    Owner is the address who is allowed to make further changes to the oracle
    script.
    """

    sender: str = betterproto.string_field(7)
    """Sender is the signer of this message."""


@dataclass(eq=False, repr=False)
class MsgCreateOracleScriptResponse(betterproto.Message):
    """
    MsgCreateOracleScriptResponse is response data for MsgCreateOracleScript
    message
    """

    pass


@dataclass(eq=False, repr=False)
class MsgEditOracleScript(betterproto.Message):
    """
    MsgEditOracleScript is a message for editing an existing oracle script.
    """

    oracle_script_id: int = betterproto.uint64_field(1)
    """
    OracleScriptID is the unique identifier of the oracle script to be edited.
    """

    name: str = betterproto.string_field(2)
    """Name is the name of this oracle script used for display (optional)."""

    description: str = betterproto.string_field(3)
    """
    Description is the description of this oracle script used for display
    (optional).
    """

    schema: str = betterproto.string_field(4)
    """Schema is the OBI schema of this oracle script (optional)."""

    source_code_url: str = betterproto.string_field(5)
    """
    SourceCodeURL is the absolute URI to the script's source code (optional).
    """

    code: bytes = betterproto.bytes_field(6)
    """
    Code is the oracle WebAssembly binary code. Can be raw of gzip compressed.
    """

    owner: str = betterproto.string_field(7)
    """
    Owner is an account address who is allowed to make further changes to the
    oracle script.
    """

    sender: str = betterproto.string_field(8)
    """
    Sender is an account address who sign this message. Must be the current
    oracle script's owner.
    """


@dataclass(eq=False, repr=False)
class MsgEditOracleScriptResponse(betterproto.Message):
    """
    MsgEditOracleScriptResponse is response data for MsgEditOracleScript
    message
    """

    pass


@dataclass(eq=False, repr=False)
class MsgActivate(betterproto.Message):
    """
    MsgEditOracleScript is a message for activating a validator to become an
    oracle provider. However, the activation can be revoked once the validator
    is unable to provide data to fulfill requests
    """

    validator: str = betterproto.string_field(1)
    """
    Validator is the validator address who sign this message and request to be
    activated.
    """


@dataclass(eq=False, repr=False)
class MsgActivateResponse(betterproto.Message):
    """MsgActivateResponse is response data for MsgActivate message"""

    pass


@dataclass(eq=False, repr=False)
class QueryCountsRequest(betterproto.Message):
    """QueryCountsRequest is request type for the Query/Count RPC method."""

    pass


@dataclass(eq=False, repr=False)
class QueryCountsResponse(betterproto.Message):
    """QueryCountsResponse is response type for the Query/Count RPC method."""

    data_source_count: int = betterproto.uint64_field(1)
    """
    DataSourceCount is total number of data sources available on the chain
    """

    oracle_script_count: int = betterproto.uint64_field(2)
    """
    OracleScriptCount is total number of oracle scripts available on the chain
    """

    request_count: int = betterproto.uint64_field(3)
    """RequestCount is total number of requests submitted to the chain"""


@dataclass(eq=False, repr=False)
class QueryDataRequest(betterproto.Message):
    """QueryDataRequest is request type for the Query/Data RPC method."""

    data_hash: str = betterproto.string_field(1)
    """
    DataHash is SHA256 hash of the file's content, which can be data source or
    oracle script
    """


@dataclass(eq=False, repr=False)
class QueryDataResponse(betterproto.Message):
    """QueryDataResponse is response type for the Query/Data RPC method."""

    data: bytes = betterproto.bytes_field(1)
    """Data is file's content, which can be data source or oracle script"""


@dataclass(eq=False, repr=False)
class QueryDataSourceRequest(betterproto.Message):
    """
    QueryDataSourceRequest is request type for the Query/DataSource RPC method.
    """

    data_source_id: int = betterproto.uint64_field(1)
    """DataSourceID is ID of a data source script"""


@dataclass(eq=False, repr=False)
class QueryDataSourceResponse(betterproto.Message):
    """
    QueryDataSourceResponse is response type for the Query/DataSource RPC
    method.
    """

    data_source: "DataSource" = betterproto.message_field(1)
    """DataSource is summary information of a data source"""


@dataclass(eq=False, repr=False)
class QueryOracleScriptRequest(betterproto.Message):
    """
    QueryOracleScriptRequest is request type for the Query/OracleScript RPC
    method.
    """

    oracle_script_id: int = betterproto.uint64_field(1)
    """OracleScriptID is ID of an oracle script"""


@dataclass(eq=False, repr=False)
class QueryOracleScriptResponse(betterproto.Message):
    """
    QueryOracleScriptResponse is response type for the Query/OracleScript RPC
    method.
    """

    oracle_script: "OracleScript" = betterproto.message_field(1)
    """OracleScript is summary information of an oracle script"""


@dataclass(eq=False, repr=False)
class QueryRequestRequest(betterproto.Message):
    """
    QueryRequestRequest is request type for the Query/Request RPC method.
    """

    request_id: int = betterproto.uint64_field(1)
    """RequestID is ID of an oracle request"""


@dataclass(eq=False, repr=False)
class QueryRequestResponse(betterproto.Message):
    """
    QueryRequestResponse is response type for the Query/Request RPC method.
    """

    request: "Request" = betterproto.message_field(1)
    """Request is an oracle request"""

    reports: List["Report"] = betterproto.message_field(2)
    """
    Reports is list of result data as raw reports that are fulfilled by
    assigned validators
    """

    result: "Result" = betterproto.message_field(3)
    """Result is a final form of result data"""


@dataclass(eq=False, repr=False)
class QueryPendingRequestsRequest(betterproto.Message):
    """
    QueryPendingRequestRequest is request type for the Query/PendingRequests
    RPC method.
    """

    validator_address: str = betterproto.string_field(1)
    """ValidatorAddress is address of a validator"""


@dataclass(eq=False, repr=False)
class QueryPendingRequestsResponse(betterproto.Message):
    """
    QueryPendingRequestResponse is response type for the Query/PendingRequests
    RPC method.
    """

    request_ids: List[int] = betterproto.uint64_field(1)
    """
    RequestIDs is a list of pending request IDs assigned to the given validator
    """


@dataclass(eq=False, repr=False)
class QueryParamsRequest(betterproto.Message):
    """QueryParamsRequest is request type for the Query/Params RPC method."""

    pass


@dataclass(eq=False, repr=False)
class QueryParamsResponse(betterproto.Message):
    """
    QueryParamsResponse is response type for the Query/Params RPC method.
    """

    params: "Params" = betterproto.message_field(1)
    """pagination defines an optional pagination for the request."""


@dataclass(eq=False, repr=False)
class QueryValidatorRequest(betterproto.Message):
    """
    QueryValidatorRequest is request type for the Query/Validator RPC method.
    """

    validator_address: str = betterproto.string_field(1)
    """ValidatorAddress is address of a validator"""


@dataclass(eq=False, repr=False)
class QueryValidatorResponse(betterproto.Message):
    """
    QueryValidatorResponse is response type for the Query/Validator RPC method.
    """

    status: "ValidatorStatus" = betterproto.message_field(1)
    """Status is status of a validator e.g. active/inactive"""


@dataclass(eq=False, repr=False)
class QueryIsReporterRequest(betterproto.Message):
    """
    QueryIsReporterRequest is request type for the Query/Reporter RPC method.
    """

    validator_address: str = betterproto.string_field(1)
    """ValidatorAddress is a validator address"""

    reporter_address: str = betterproto.string_field(2)
    """ReporterAddress is a candidate account"""


@dataclass(eq=False, repr=False)
class QueryIsReporterResponse(betterproto.Message):
    """
    QueryIsReporterResponse is response type for the Query/Reporter RPC method.
    """

    is_reporter: bool = betterproto.bool_field(1)
    """IsReporter is true if this account has been granted by validator"""


@dataclass(eq=False, repr=False)
class QueryReportersRequest(betterproto.Message):
    """
    QueryReportersRequest is request type for the Query/Reporters RPC method.
    """

    validator_address: str = betterproto.string_field(1)
    """ValidatorAddress is a validator address"""


@dataclass(eq=False, repr=False)
class QueryReportersResponse(betterproto.Message):
    """
    QueryReportersResponse is response type for the Query/Reporters RPC method.
    """

    reporter: List[str] = betterproto.string_field(1)
    """Reporter is a list of account addresses of reporters"""


@dataclass(eq=False, repr=False)
class QueryActiveValidatorsRequest(betterproto.Message):
    """
    QueryActiveValidatorsRequest is request type for the Query/ActiveValidators
    RPC method.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryActiveValidatorsResponse(betterproto.Message):
    """
    QueryActiveValidatorsResponse is response type for the
    Query/ActiveValidators RPC method.
    """

    validators: List["ActiveValidator"] = betterproto.message_field(1)
    """Validators is a list of active validators"""


@dataclass(eq=False, repr=False)
class QueryRequestSearchRequest(betterproto.Message):
    """
    QueryRequestSearchRequest is request type for the Query/RequestSearch RPC
    method.
    """

    oracle_script_id: int = betterproto.uint64_field(1)
    """OracleScriptID is ID of an oracle script"""

    calldata: str = betterproto.string_field(2)
    """
    Calldata is OBI-encoded data in hex format as argument params for the
    oracle script
    """

    ask_count: int = betterproto.uint64_field(3)
    """AskCount is number of validators allowed for fulfilling the request"""

    min_count: int = betterproto.uint64_field(4)
    """MinCount is number of validators required for fulfilling the request"""


@dataclass(eq=False, repr=False)
class QueryRequestSearchResponse(betterproto.Message):
    """
    QueryRequestSearchResponse is response type for the Query/RequestSearch RPC
    method.
    """

    request: "QueryRequestResponse" = betterproto.message_field(1)
    """Request is details of an oracle request"""


@dataclass(eq=False, repr=False)
class QueryRequestPriceRequest(betterproto.Message):
    """
    QueryRequestPriceRequest is request type for the Query/RequestPrice RPC
    method.
    """

    symbols: List[str] = betterproto.string_field(1)
    """Symbol is unit of data indicating what the data is"""

    ask_count: int = betterproto.uint64_field(2)
    """AskCount is number of validators allowed for fulfilling the request"""

    min_count: int = betterproto.uint64_field(3)
    """MinCount is number of validators required for fulfilling the request"""


@dataclass(eq=False, repr=False)
class QueryRequestPriceResponse(betterproto.Message):
    """
    QueryRequestPriceResponse is response type for the Query/RequestPrice RPC
    method.
    """

    price_results: List["PriceResult"] = betterproto.message_field(1)
    """PriceResult is a list of price results for given symbols"""


@dataclass(eq=False, repr=False)
class QueryRequestVerificationRequest(betterproto.Message):
    """
    QueryRequestVerificationRequest is request type for the
    Query/RequestVerification RPC
    """

    chain_id: str = betterproto.string_field(1)
    """
    ChainID is the chain ID to identify which chain ID is used for the
    verification
    """

    validator: str = betterproto.string_field(2)
    """Validator is a validator address"""

    request_id: int = betterproto.uint64_field(3)
    """RequestID is oracle request ID"""

    external_id: int = betterproto.uint64_field(4)
    """ExternalID is an oracle's external ID"""

    data_source_id: int = betterproto.uint64_field(5)
    """DataSourceID is the ID of data source"""

    reporter: str = betterproto.string_field(6)
    """
    Reporter is an bech32-encoded public key of the reporter authorized by the
    validator
    """

    signature: bytes = betterproto.bytes_field(7)
    """
    Signature is a signature signed by the reporter using reporter's private
    key
    """

    max_delay: int = betterproto.uint64_field(8)
    """
    MaxDelay is a max number of RequestID delay acceptable in case of node
    delay
    """


@dataclass(eq=False, repr=False)
class QueryRequestVerificationResponse(betterproto.Message):
    """
    QueryRequestVerificationResponse is response type for the
    Query/RequestVerification RPC
    """

    chain_id: str = betterproto.string_field(1)
    """ChainID is the targeted chain ID"""

    validator: str = betterproto.string_field(2)
    """Validator is the targeted validator address"""

    request_id: int = betterproto.uint64_field(3)
    """RequestID is the ID of targeted request"""

    external_id: int = betterproto.uint64_field(4)
    """ExternalID is the ID of targeted oracle's external data source"""

    data_source_id: int = betterproto.uint64_field(5)
    """
    DataSourceID is the ID of a data source that relates to the targeted
    external ID
    """

    is_delay: bool = betterproto.bool_field(6)
    """
    IsDelay is a flag to tell that this request is not exist yet but in
    MaxDelay range
    """


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the oracle module's genesis state."""

    params: "Params" = betterproto.message_field(1)
    """Params defines all the paramaters of the module."""

    data_sources: List["DataSource"] = betterproto.message_field(2)
    """DataSources are data sources to be installed during genesis phase"""

    oracle_scripts: List["OracleScript"] = betterproto.message_field(3)
    """
    OracleScripts are list of oracle scripts to be installed during genesis
    phase
    """


class MsgStub(betterproto.ServiceStub):
    async def request_data(
        self,
        msg_request_data: "MsgRequestData",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgRequestDataResponse":
        return await self._unary_unary(
            "/oracle.v1.Msg/RequestData",
            msg_request_data,
            MsgRequestDataResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def report_data(
        self,
        msg_report_data: "MsgReportData",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgReportDataResponse":
        return await self._unary_unary(
            "/oracle.v1.Msg/ReportData",
            msg_report_data,
            MsgReportDataResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def create_data_source(
        self,
        msg_create_data_source: "MsgCreateDataSource",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgCreateDataSourceResponse":
        return await self._unary_unary(
            "/oracle.v1.Msg/CreateDataSource",
            msg_create_data_source,
            MsgCreateDataSourceResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def edit_data_source(
        self,
        msg_edit_data_source: "MsgEditDataSource",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgEditDataSourceResponse":
        return await self._unary_unary(
            "/oracle.v1.Msg/EditDataSource",
            msg_edit_data_source,
            MsgEditDataSourceResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def create_oracle_script(
        self,
        msg_create_oracle_script: "MsgCreateOracleScript",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgCreateOracleScriptResponse":
        return await self._unary_unary(
            "/oracle.v1.Msg/CreateOracleScript",
            msg_create_oracle_script,
            MsgCreateOracleScriptResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def edit_oracle_script(
        self,
        msg_edit_oracle_script: "MsgEditOracleScript",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgEditOracleScriptResponse":
        return await self._unary_unary(
            "/oracle.v1.Msg/EditOracleScript",
            msg_edit_oracle_script,
            MsgEditOracleScriptResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def activate(
        self,
        msg_activate: "MsgActivate",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgActivateResponse":
        return await self._unary_unary(
            "/oracle.v1.Msg/Activate",
            msg_activate,
            MsgActivateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class QueryStub(betterproto.ServiceStub):
    async def counts(
        self,
        query_counts_request: "QueryCountsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryCountsResponse":
        return await self._unary_unary(
            "/oracle.v1.Query/Counts",
            query_counts_request,
            QueryCountsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def data(
        self,
        query_data_request: "QueryDataRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryDataResponse":
        return await self._unary_unary(
            "/oracle.v1.Query/Data",
            query_data_request,
            QueryDataResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def data_source(
        self,
        query_data_source_request: "QueryDataSourceRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryDataSourceResponse":
        return await self._unary_unary(
            "/oracle.v1.Query/DataSource",
            query_data_source_request,
            QueryDataSourceResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def oracle_script(
        self,
        query_oracle_script_request: "QueryOracleScriptRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryOracleScriptResponse":
        return await self._unary_unary(
            "/oracle.v1.Query/OracleScript",
            query_oracle_script_request,
            QueryOracleScriptResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def request(
        self,
        query_request_request: "QueryRequestRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryRequestResponse":
        return await self._unary_unary(
            "/oracle.v1.Query/Request",
            query_request_request,
            QueryRequestResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def pending_requests(
        self,
        query_pending_requests_request: "QueryPendingRequestsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryPendingRequestsResponse":
        return await self._unary_unary(
            "/oracle.v1.Query/PendingRequests",
            query_pending_requests_request,
            QueryPendingRequestsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def validator(
        self,
        query_validator_request: "QueryValidatorRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryValidatorResponse":
        return await self._unary_unary(
            "/oracle.v1.Query/Validator",
            query_validator_request,
            QueryValidatorResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def is_reporter(
        self,
        query_is_reporter_request: "QueryIsReporterRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryIsReporterResponse":
        return await self._unary_unary(
            "/oracle.v1.Query/IsReporter",
            query_is_reporter_request,
            QueryIsReporterResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def reporters(
        self,
        query_reporters_request: "QueryReportersRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryReportersResponse":
        return await self._unary_unary(
            "/oracle.v1.Query/Reporters",
            query_reporters_request,
            QueryReportersResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def active_validators(
        self,
        query_active_validators_request: "QueryActiveValidatorsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryActiveValidatorsResponse":
        return await self._unary_unary(
            "/oracle.v1.Query/ActiveValidators",
            query_active_validators_request,
            QueryActiveValidatorsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def params(
        self,
        query_params_request: "QueryParamsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryParamsResponse":
        return await self._unary_unary(
            "/oracle.v1.Query/Params",
            query_params_request,
            QueryParamsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def request_search(
        self,
        query_request_search_request: "QueryRequestSearchRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryRequestSearchResponse":
        return await self._unary_unary(
            "/oracle.v1.Query/RequestSearch",
            query_request_search_request,
            QueryRequestSearchResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def request_price(
        self,
        query_request_price_request: "QueryRequestPriceRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryRequestPriceResponse":
        return await self._unary_unary(
            "/oracle.v1.Query/RequestPrice",
            query_request_price_request,
            QueryRequestPriceResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def request_verification(
        self,
        query_request_verification_request: "QueryRequestVerificationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryRequestVerificationResponse":
        return await self._unary_unary(
            "/oracle.v1.Query/RequestVerification",
            query_request_verification_request,
            QueryRequestVerificationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class MsgBase(ServiceBase):
    async def request_data(self, msg_request_data: "MsgRequestData") -> "MsgRequestDataResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def report_data(self, msg_report_data: "MsgReportData") -> "MsgReportDataResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_data_source(self, msg_create_data_source: "MsgCreateDataSource") -> "MsgCreateDataSourceResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def edit_data_source(self, msg_edit_data_source: "MsgEditDataSource") -> "MsgEditDataSourceResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_oracle_script(
        self, msg_create_oracle_script: "MsgCreateOracleScript"
    ) -> "MsgCreateOracleScriptResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def edit_oracle_script(self, msg_edit_oracle_script: "MsgEditOracleScript") -> "MsgEditOracleScriptResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def activate(self, msg_activate: "MsgActivate") -> "MsgActivateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_request_data(
        self, stream: "grpclib.server.Stream[MsgRequestData, MsgRequestDataResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.request_data(request)
        await stream.send_message(response)

    async def __rpc_report_data(self, stream: "grpclib.server.Stream[MsgReportData, MsgReportDataResponse]") -> None:
        request = await stream.recv_message()
        response = await self.report_data(request)
        await stream.send_message(response)

    async def __rpc_create_data_source(
        self,
        stream: "grpclib.server.Stream[MsgCreateDataSource, MsgCreateDataSourceResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.create_data_source(request)
        await stream.send_message(response)

    async def __rpc_edit_data_source(
        self,
        stream: "grpclib.server.Stream[MsgEditDataSource, MsgEditDataSourceResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.edit_data_source(request)
        await stream.send_message(response)

    async def __rpc_create_oracle_script(
        self,
        stream: "grpclib.server.Stream[MsgCreateOracleScript, MsgCreateOracleScriptResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.create_oracle_script(request)
        await stream.send_message(response)

    async def __rpc_edit_oracle_script(
        self,
        stream: "grpclib.server.Stream[MsgEditOracleScript, MsgEditOracleScriptResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.edit_oracle_script(request)
        await stream.send_message(response)

    async def __rpc_activate(self, stream: "grpclib.server.Stream[MsgActivate, MsgActivateResponse]") -> None:
        request = await stream.recv_message()
        response = await self.activate(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/oracle.v1.Msg/RequestData": grpclib.const.Handler(
                self.__rpc_request_data,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgRequestData,
                MsgRequestDataResponse,
            ),
            "/oracle.v1.Msg/ReportData": grpclib.const.Handler(
                self.__rpc_report_data,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgReportData,
                MsgReportDataResponse,
            ),
            "/oracle.v1.Msg/CreateDataSource": grpclib.const.Handler(
                self.__rpc_create_data_source,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgCreateDataSource,
                MsgCreateDataSourceResponse,
            ),
            "/oracle.v1.Msg/EditDataSource": grpclib.const.Handler(
                self.__rpc_edit_data_source,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgEditDataSource,
                MsgEditDataSourceResponse,
            ),
            "/oracle.v1.Msg/CreateOracleScript": grpclib.const.Handler(
                self.__rpc_create_oracle_script,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgCreateOracleScript,
                MsgCreateOracleScriptResponse,
            ),
            "/oracle.v1.Msg/EditOracleScript": grpclib.const.Handler(
                self.__rpc_edit_oracle_script,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgEditOracleScript,
                MsgEditOracleScriptResponse,
            ),
            "/oracle.v1.Msg/Activate": grpclib.const.Handler(
                self.__rpc_activate,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgActivate,
                MsgActivateResponse,
            ),
        }


class QueryBase(ServiceBase):
    async def counts(self, query_counts_request: "QueryCountsRequest") -> "QueryCountsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def data(self, query_data_request: "QueryDataRequest") -> "QueryDataResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def data_source(self, query_data_source_request: "QueryDataSourceRequest") -> "QueryDataSourceResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def oracle_script(
        self, query_oracle_script_request: "QueryOracleScriptRequest"
    ) -> "QueryOracleScriptResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def request(self, query_request_request: "QueryRequestRequest") -> "QueryRequestResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def pending_requests(
        self, query_pending_requests_request: "QueryPendingRequestsRequest"
    ) -> "QueryPendingRequestsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def validator(self, query_validator_request: "QueryValidatorRequest") -> "QueryValidatorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def is_reporter(self, query_is_reporter_request: "QueryIsReporterRequest") -> "QueryIsReporterResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def reporters(self, query_reporters_request: "QueryReportersRequest") -> "QueryReportersResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def active_validators(
        self, query_active_validators_request: "QueryActiveValidatorsRequest"
    ) -> "QueryActiveValidatorsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def params(self, query_params_request: "QueryParamsRequest") -> "QueryParamsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def request_search(
        self, query_request_search_request: "QueryRequestSearchRequest"
    ) -> "QueryRequestSearchResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def request_price(
        self, query_request_price_request: "QueryRequestPriceRequest"
    ) -> "QueryRequestPriceResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def request_verification(
        self, query_request_verification_request: "QueryRequestVerificationRequest"
    ) -> "QueryRequestVerificationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_counts(self, stream: "grpclib.server.Stream[QueryCountsRequest, QueryCountsResponse]") -> None:
        request = await stream.recv_message()
        response = await self.counts(request)
        await stream.send_message(response)

    async def __rpc_data(self, stream: "grpclib.server.Stream[QueryDataRequest, QueryDataResponse]") -> None:
        request = await stream.recv_message()
        response = await self.data(request)
        await stream.send_message(response)

    async def __rpc_data_source(
        self,
        stream: "grpclib.server.Stream[QueryDataSourceRequest, QueryDataSourceResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.data_source(request)
        await stream.send_message(response)

    async def __rpc_oracle_script(
        self,
        stream: "grpclib.server.Stream[QueryOracleScriptRequest, QueryOracleScriptResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.oracle_script(request)
        await stream.send_message(response)

    async def __rpc_request(self, stream: "grpclib.server.Stream[QueryRequestRequest, QueryRequestResponse]") -> None:
        request = await stream.recv_message()
        response = await self.request(request)
        await stream.send_message(response)

    async def __rpc_pending_requests(
        self,
        stream: "grpclib.server.Stream[QueryPendingRequestsRequest, QueryPendingRequestsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.pending_requests(request)
        await stream.send_message(response)

    async def __rpc_validator(
        self,
        stream: "grpclib.server.Stream[QueryValidatorRequest, QueryValidatorResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.validator(request)
        await stream.send_message(response)

    async def __rpc_is_reporter(
        self,
        stream: "grpclib.server.Stream[QueryIsReporterRequest, QueryIsReporterResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.is_reporter(request)
        await stream.send_message(response)

    async def __rpc_reporters(
        self,
        stream: "grpclib.server.Stream[QueryReportersRequest, QueryReportersResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.reporters(request)
        await stream.send_message(response)

    async def __rpc_active_validators(
        self,
        stream: "grpclib.server.Stream[QueryActiveValidatorsRequest, QueryActiveValidatorsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.active_validators(request)
        await stream.send_message(response)

    async def __rpc_params(self, stream: "grpclib.server.Stream[QueryParamsRequest, QueryParamsResponse]") -> None:
        request = await stream.recv_message()
        response = await self.params(request)
        await stream.send_message(response)

    async def __rpc_request_search(
        self,
        stream: "grpclib.server.Stream[QueryRequestSearchRequest, QueryRequestSearchResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.request_search(request)
        await stream.send_message(response)

    async def __rpc_request_price(
        self,
        stream: "grpclib.server.Stream[QueryRequestPriceRequest, QueryRequestPriceResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.request_price(request)
        await stream.send_message(response)

    async def __rpc_request_verification(
        self,
        stream: "grpclib.server.Stream[QueryRequestVerificationRequest, QueryRequestVerificationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.request_verification(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/oracle.v1.Query/Counts": grpclib.const.Handler(
                self.__rpc_counts,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryCountsRequest,
                QueryCountsResponse,
            ),
            "/oracle.v1.Query/Data": grpclib.const.Handler(
                self.__rpc_data,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDataRequest,
                QueryDataResponse,
            ),
            "/oracle.v1.Query/DataSource": grpclib.const.Handler(
                self.__rpc_data_source,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDataSourceRequest,
                QueryDataSourceResponse,
            ),
            "/oracle.v1.Query/OracleScript": grpclib.const.Handler(
                self.__rpc_oracle_script,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryOracleScriptRequest,
                QueryOracleScriptResponse,
            ),
            "/oracle.v1.Query/Request": grpclib.const.Handler(
                self.__rpc_request,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryRequestRequest,
                QueryRequestResponse,
            ),
            "/oracle.v1.Query/PendingRequests": grpclib.const.Handler(
                self.__rpc_pending_requests,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPendingRequestsRequest,
                QueryPendingRequestsResponse,
            ),
            "/oracle.v1.Query/Validator": grpclib.const.Handler(
                self.__rpc_validator,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryValidatorRequest,
                QueryValidatorResponse,
            ),
            "/oracle.v1.Query/IsReporter": grpclib.const.Handler(
                self.__rpc_is_reporter,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryIsReporterRequest,
                QueryIsReporterResponse,
            ),
            "/oracle.v1.Query/Reporters": grpclib.const.Handler(
                self.__rpc_reporters,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryReportersRequest,
                QueryReportersResponse,
            ),
            "/oracle.v1.Query/ActiveValidators": grpclib.const.Handler(
                self.__rpc_active_validators,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryActiveValidatorsRequest,
                QueryActiveValidatorsResponse,
            ),
            "/oracle.v1.Query/Params": grpclib.const.Handler(
                self.__rpc_params,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryParamsRequest,
                QueryParamsResponse,
            ),
            "/oracle.v1.Query/RequestSearch": grpclib.const.Handler(
                self.__rpc_request_search,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryRequestSearchRequest,
                QueryRequestSearchResponse,
            ),
            "/oracle.v1.Query/RequestPrice": grpclib.const.Handler(
                self.__rpc_request_price,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryRequestPriceRequest,
                QueryRequestPriceResponse,
            ),
            "/oracle.v1.Query/RequestVerification": grpclib.const.Handler(
                self.__rpc_request_verification,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryRequestVerificationRequest,
                QueryRequestVerificationResponse,
            ),
        }
