from Crypto.Cipher import AES
from Crypto.Random import new as Random
from hashlib import sha256
from base64 import b64encode,b64decode

class AESCipher:
  def __init__(self,data,key):
    self.block_size = 16
    self.data = data
    self.key = sha256(key.encode()).digest()[:32]
    self.pad = lambda s: s + (self.block_size - len(s) % self.block_size) * chr (self.block_size - len(s) % self.block_size)
    self.unpad = lambda s: s[:-ord(s[len(s) - 1:])]

  def encrypt(self):
    plain_text = self.pad(self.data)
    iv = Random().read(AES.block_size)
    cipher = AES.new(self.key,AES.MODE_OFB,iv)
    return b64encode(iv + cipher.encrypt(plain_text.encode())).decode()

  def decrypt(self):
    cipher_text = b64decode(self.data.encode())
    iv = cipher_text[:self.block_size]
    cipher = AES.new(self.key,AES.MODE_OFB,iv)
    return self.unpad(cipher.decrypt(cipher_text[self.block_size:])).decode()
