# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DataInputConfigurationProperties',
    'DataOutputConfigurationProperties',
    'InferenceSchedulerInputNameConfiguration',
    'InferenceSchedulerS3InputConfiguration',
    'InferenceSchedulerS3OutputConfiguration',
    'InferenceSchedulerTag',
]

@pulumi.output_type
class DataInputConfigurationProperties(dict):
    """
    Specifies configuration information for the input data for the inference scheduler, including delimiter, format, and dataset location.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3InputConfiguration":
            suggest = "s3_input_configuration"
        elif key == "inferenceInputNameConfiguration":
            suggest = "inference_input_name_configuration"
        elif key == "inputTimeZoneOffset":
            suggest = "input_time_zone_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataInputConfigurationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataInputConfigurationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataInputConfigurationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_input_configuration: 'outputs.InferenceSchedulerS3InputConfiguration',
                 inference_input_name_configuration: Optional['outputs.InferenceSchedulerInputNameConfiguration'] = None,
                 input_time_zone_offset: Optional[str] = None):
        """
        Specifies configuration information for the input data for the inference scheduler, including delimiter, format, and dataset location.
        :param str input_time_zone_offset: Indicates the difference between your time zone and Greenwich Mean Time (GMT).
        """
        pulumi.set(__self__, "s3_input_configuration", s3_input_configuration)
        if inference_input_name_configuration is not None:
            pulumi.set(__self__, "inference_input_name_configuration", inference_input_name_configuration)
        if input_time_zone_offset is not None:
            pulumi.set(__self__, "input_time_zone_offset", input_time_zone_offset)

    @property
    @pulumi.getter(name="s3InputConfiguration")
    def s3_input_configuration(self) -> 'outputs.InferenceSchedulerS3InputConfiguration':
        return pulumi.get(self, "s3_input_configuration")

    @property
    @pulumi.getter(name="inferenceInputNameConfiguration")
    def inference_input_name_configuration(self) -> Optional['outputs.InferenceSchedulerInputNameConfiguration']:
        return pulumi.get(self, "inference_input_name_configuration")

    @property
    @pulumi.getter(name="inputTimeZoneOffset")
    def input_time_zone_offset(self) -> Optional[str]:
        """
        Indicates the difference between your time zone and Greenwich Mean Time (GMT).
        """
        return pulumi.get(self, "input_time_zone_offset")


@pulumi.output_type
class DataOutputConfigurationProperties(dict):
    """
    Specifies configuration information for the output results for the inference scheduler, including the S3 location for the output.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3OutputConfiguration":
            suggest = "s3_output_configuration"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataOutputConfigurationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataOutputConfigurationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataOutputConfigurationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_output_configuration: 'outputs.InferenceSchedulerS3OutputConfiguration',
                 kms_key_id: Optional[str] = None):
        """
        Specifies configuration information for the output results for the inference scheduler, including the S3 location for the output.
        :param str kms_key_id: The ID number for the AWS KMS key used to encrypt the inference output.
        """
        pulumi.set(__self__, "s3_output_configuration", s3_output_configuration)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="s3OutputConfiguration")
    def s3_output_configuration(self) -> 'outputs.InferenceSchedulerS3OutputConfiguration':
        return pulumi.get(self, "s3_output_configuration")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The ID number for the AWS KMS key used to encrypt the inference output.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class InferenceSchedulerInputNameConfiguration(dict):
    """
    Specifies configuration information for the input data for the inference, including timestamp format and delimiter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentTimestampDelimiter":
            suggest = "component_timestamp_delimiter"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceSchedulerInputNameConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceSchedulerInputNameConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceSchedulerInputNameConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_timestamp_delimiter: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        Specifies configuration information for the input data for the inference, including timestamp format and delimiter.
        :param str component_timestamp_delimiter: Indicates the delimiter character used between items in the data.
        :param str timestamp_format: The format of the timestamp, whether Epoch time, or standard, with or without hyphens (-).
        """
        if component_timestamp_delimiter is not None:
            pulumi.set(__self__, "component_timestamp_delimiter", component_timestamp_delimiter)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="componentTimestampDelimiter")
    def component_timestamp_delimiter(self) -> Optional[str]:
        """
        Indicates the delimiter character used between items in the data.
        """
        return pulumi.get(self, "component_timestamp_delimiter")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The format of the timestamp, whether Epoch time, or standard, with or without hyphens (-).
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class InferenceSchedulerS3InputConfiguration(dict):
    """
    Specifies configuration information for the input data for the inference, including input data S3 location.
    """
    def __init__(__self__, *,
                 bucket: str,
                 prefix: Optional[str] = None):
        """
        Specifies configuration information for the input data for the inference, including input data S3 location.
        """
        pulumi.set(__self__, "bucket", bucket)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        return pulumi.get(self, "prefix")


@pulumi.output_type
class InferenceSchedulerS3OutputConfiguration(dict):
    """
    Specifies configuration information for the output results from the inference, including output S3 location.
    """
    def __init__(__self__, *,
                 bucket: str,
                 prefix: Optional[str] = None):
        """
        Specifies configuration information for the output results from the inference, including output S3 location.
        """
        pulumi.set(__self__, "bucket", bucket)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        return pulumi.get(self, "prefix")


@pulumi.output_type
class InferenceSchedulerTag(dict):
    """
    A tag is a key-value pair that can be added to a resource as metadata.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A tag is a key-value pair that can be added to a resource as metadata.
        :param str key: The key for the specified tag.
        :param str value: The value for the specified tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key for the specified tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the specified tag.
        """
        return pulumi.get(self, "value")


