# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AgentTagArgs',
    'LocationEFSEc2ConfigArgs',
    'LocationEFSTagArgs',
    'LocationFSxWindowsTagArgs',
    'LocationHDFSNameNodeArgs',
    'LocationHDFSQopConfigurationArgs',
    'LocationHDFSTagArgs',
    'LocationNFSMountOptionsArgs',
    'LocationNFSOnPremConfigArgs',
    'LocationNFSTagArgs',
    'LocationObjectStorageTagArgs',
    'LocationS3S3ConfigArgs',
    'LocationS3TagArgs',
    'LocationSMBMountOptionsArgs',
    'LocationSMBTagArgs',
    'TaskFilterRuleArgs',
    'TaskOptionsArgs',
    'TaskScheduleArgs',
    'TaskTagArgs',
]

@pulumi.input_type
class AgentTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        :param pulumi.Input[str] key: The key for an AWS resource tag.
        :param pulumi.Input[str] value: The value for an AWS resource tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key for an AWS resource tag.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for an AWS resource tag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class LocationEFSEc2ConfigArgs:
    def __init__(__self__, *,
                 security_group_arns: pulumi.Input[Sequence[pulumi.Input[str]]],
                 subnet_arn: pulumi.Input[str]):
        """
        The subnet and security group that DataSync uses to access target EFS file system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_arns: The Amazon Resource Names (ARNs) of the security groups that are configured for the Amazon EC2 resource.
        :param pulumi.Input[str] subnet_arn: The ARN of the subnet that DataSync uses to access the target EFS file system.
        """
        pulumi.set(__self__, "security_group_arns", security_group_arns)
        pulumi.set(__self__, "subnet_arn", subnet_arn)

    @property
    @pulumi.getter(name="securityGroupArns")
    def security_group_arns(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The Amazon Resource Names (ARNs) of the security groups that are configured for the Amazon EC2 resource.
        """
        return pulumi.get(self, "security_group_arns")

    @security_group_arns.setter
    def security_group_arns(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_group_arns", value)

    @property
    @pulumi.getter(name="subnetArn")
    def subnet_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the subnet that DataSync uses to access the target EFS file system.
        """
        return pulumi.get(self, "subnet_arn")

    @subnet_arn.setter
    def subnet_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_arn", value)


@pulumi.input_type
class LocationEFSTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        :param pulumi.Input[str] key: The key for an AWS resource tag.
        :param pulumi.Input[str] value: The value for an AWS resource tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key for an AWS resource tag.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for an AWS resource tag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class LocationFSxWindowsTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        :param pulumi.Input[str] key: The key for an AWS resource tag.
        :param pulumi.Input[str] value: The value for an AWS resource tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key for an AWS resource tag.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for an AWS resource tag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class LocationHDFSNameNodeArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[str],
                 port: pulumi.Input[int]):
        """
        HDFS Name Node IP and port information.
        :param pulumi.Input[str] hostname: The DNS name or IP address of the Name Node in the customer's on premises HDFS cluster.
        :param pulumi.Input[int] port: The port on which the Name Node is listening on for client requests.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[str]:
        """
        The DNS name or IP address of the Name Node in the customer's on premises HDFS cluster.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The port on which the Name Node is listening on for client requests.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class LocationHDFSQopConfigurationArgs:
    def __init__(__self__, *,
                 data_transfer_protection: Optional[pulumi.Input['LocationHDFSQopConfigurationDataTransferProtection']] = None,
                 rpc_protection: Optional[pulumi.Input['LocationHDFSQopConfigurationRpcProtection']] = None):
        """
        Configuration information for RPC Protection and Data Transfer Protection. These parameters can be set to AUTHENTICATION, INTEGRITY, or PRIVACY. The default value is PRIVACY.
        :param pulumi.Input['LocationHDFSQopConfigurationDataTransferProtection'] data_transfer_protection: Configuration for Data Transfer Protection.
        :param pulumi.Input['LocationHDFSQopConfigurationRpcProtection'] rpc_protection: Configuration for RPC Protection.
        """
        if data_transfer_protection is not None:
            pulumi.set(__self__, "data_transfer_protection", data_transfer_protection)
        if rpc_protection is not None:
            pulumi.set(__self__, "rpc_protection", rpc_protection)

    @property
    @pulumi.getter(name="dataTransferProtection")
    def data_transfer_protection(self) -> Optional[pulumi.Input['LocationHDFSQopConfigurationDataTransferProtection']]:
        """
        Configuration for Data Transfer Protection.
        """
        return pulumi.get(self, "data_transfer_protection")

    @data_transfer_protection.setter
    def data_transfer_protection(self, value: Optional[pulumi.Input['LocationHDFSQopConfigurationDataTransferProtection']]):
        pulumi.set(self, "data_transfer_protection", value)

    @property
    @pulumi.getter(name="rpcProtection")
    def rpc_protection(self) -> Optional[pulumi.Input['LocationHDFSQopConfigurationRpcProtection']]:
        """
        Configuration for RPC Protection.
        """
        return pulumi.get(self, "rpc_protection")

    @rpc_protection.setter
    def rpc_protection(self, value: Optional[pulumi.Input['LocationHDFSQopConfigurationRpcProtection']]):
        pulumi.set(self, "rpc_protection", value)


@pulumi.input_type
class LocationHDFSTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        :param pulumi.Input[str] key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param pulumi.Input[str] value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class LocationNFSMountOptionsArgs:
    def __init__(__self__, *,
                 version: Optional[pulumi.Input['LocationNFSMountOptionsVersion']] = None):
        """
        The NFS mount options that DataSync can use to mount your NFS share.
        :param pulumi.Input['LocationNFSMountOptionsVersion'] version: The specific NFS version that you want DataSync to use to mount your NFS share.
        """
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input['LocationNFSMountOptionsVersion']]:
        """
        The specific NFS version that you want DataSync to use to mount your NFS share.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input['LocationNFSMountOptionsVersion']]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class LocationNFSOnPremConfigArgs:
    def __init__(__self__, *,
                 agent_arns: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Contains a list of Amazon Resource Names (ARNs) of agents that are used to connect an NFS server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] agent_arns: ARN(s) of the agent(s) to use for an NFS location.
        """
        pulumi.set(__self__, "agent_arns", agent_arns)

    @property
    @pulumi.getter(name="agentArns")
    def agent_arns(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        ARN(s) of the agent(s) to use for an NFS location.
        """
        return pulumi.get(self, "agent_arns")

    @agent_arns.setter
    def agent_arns(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "agent_arns", value)


@pulumi.input_type
class LocationNFSTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        :param pulumi.Input[str] key: The key for an AWS resource tag.
        :param pulumi.Input[str] value: The value for an AWS resource tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key for an AWS resource tag.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for an AWS resource tag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class LocationObjectStorageTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        :param pulumi.Input[str] key: The key for an AWS resource tag.
        :param pulumi.Input[str] value: The value for an AWS resource tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key for an AWS resource tag.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for an AWS resource tag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class LocationS3S3ConfigArgs:
    def __init__(__self__, *,
                 bucket_access_role_arn: pulumi.Input[str]):
        """
        The Amazon Resource Name (ARN) of the AWS IAM role that is used to access an Amazon S3 bucket.
        :param pulumi.Input[str] bucket_access_role_arn: The ARN of the IAM role of the Amazon S3 bucket.
        """
        pulumi.set(__self__, "bucket_access_role_arn", bucket_access_role_arn)

    @property
    @pulumi.getter(name="bucketAccessRoleArn")
    def bucket_access_role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the IAM role of the Amazon S3 bucket.
        """
        return pulumi.get(self, "bucket_access_role_arn")

    @bucket_access_role_arn.setter
    def bucket_access_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_access_role_arn", value)


@pulumi.input_type
class LocationS3TagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        :param pulumi.Input[str] key: The key for an AWS resource tag.
        :param pulumi.Input[str] value: The value for an AWS resource tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key for an AWS resource tag.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for an AWS resource tag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class LocationSMBMountOptionsArgs:
    def __init__(__self__, *,
                 version: Optional[pulumi.Input['LocationSMBMountOptionsVersion']] = None):
        """
        The mount options used by DataSync to access the SMB server.
        :param pulumi.Input['LocationSMBMountOptionsVersion'] version: The specific SMB version that you want DataSync to use to mount your SMB share.
        """
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input['LocationSMBMountOptionsVersion']]:
        """
        The specific SMB version that you want DataSync to use to mount your SMB share.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input['LocationSMBMountOptionsVersion']]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class LocationSMBTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        :param pulumi.Input[str] key: The key for an AWS resource tag.
        :param pulumi.Input[str] value: The value for an AWS resource tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key for an AWS resource tag.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for an AWS resource tag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class TaskFilterRuleArgs:
    def __init__(__self__, *,
                 filter_type: Optional[pulumi.Input['TaskFilterRuleFilterType']] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Specifies which files folders and objects to include or exclude when transferring files from source to destination.
        :param pulumi.Input['TaskFilterRuleFilterType'] filter_type: The type of filter rule to apply. AWS DataSync only supports the SIMPLE_PATTERN rule type.
        :param pulumi.Input[str] value: A single filter string that consists of the patterns to include or exclude. The patterns are delimited by "|".
        """
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional[pulumi.Input['TaskFilterRuleFilterType']]:
        """
        The type of filter rule to apply. AWS DataSync only supports the SIMPLE_PATTERN rule type.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: Optional[pulumi.Input['TaskFilterRuleFilterType']]):
        pulumi.set(self, "filter_type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        A single filter string that consists of the patterns to include or exclude. The patterns are delimited by "|".
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class TaskOptionsArgs:
    def __init__(__self__, *,
                 atime: Optional[pulumi.Input['TaskOptionsAtime']] = None,
                 bytes_per_second: Optional[pulumi.Input[int]] = None,
                 gid: Optional[pulumi.Input['TaskOptionsGid']] = None,
                 log_level: Optional[pulumi.Input['TaskOptionsLogLevel']] = None,
                 mtime: Optional[pulumi.Input['TaskOptionsMtime']] = None,
                 overwrite_mode: Optional[pulumi.Input['TaskOptionsOverwriteMode']] = None,
                 posix_permissions: Optional[pulumi.Input['TaskOptionsPosixPermissions']] = None,
                 preserve_deleted_files: Optional[pulumi.Input['TaskOptionsPreserveDeletedFiles']] = None,
                 preserve_devices: Optional[pulumi.Input['TaskOptionsPreserveDevices']] = None,
                 security_descriptor_copy_flags: Optional[pulumi.Input['TaskOptionsSecurityDescriptorCopyFlags']] = None,
                 task_queueing: Optional[pulumi.Input['TaskOptionsTaskQueueing']] = None,
                 transfer_mode: Optional[pulumi.Input['TaskOptionsTransferMode']] = None,
                 uid: Optional[pulumi.Input['TaskOptionsUid']] = None,
                 verify_mode: Optional[pulumi.Input['TaskOptionsVerifyMode']] = None):
        """
        Represents the options that are available to control the behavior of a StartTaskExecution operation.
        :param pulumi.Input['TaskOptionsAtime'] atime: A file metadata value that shows the last time a file was accessed (that is, when the file was read or written to).
        :param pulumi.Input[int] bytes_per_second: A value that limits the bandwidth used by AWS DataSync.
        :param pulumi.Input['TaskOptionsGid'] gid: The group ID (GID) of the file's owners.
        :param pulumi.Input['TaskOptionsLogLevel'] log_level: A value that determines the types of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide.
        :param pulumi.Input['TaskOptionsMtime'] mtime: A value that indicates the last time that a file was modified (that is, a file was written to) before the PREPARING phase.
        :param pulumi.Input['TaskOptionsOverwriteMode'] overwrite_mode: A value that determines whether files at the destination should be overwritten or preserved when copying files.
        :param pulumi.Input['TaskOptionsPosixPermissions'] posix_permissions: A value that determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file.
        :param pulumi.Input['TaskOptionsPreserveDeletedFiles'] preserve_deleted_files: A value that specifies whether files in the destination that don't exist in the source file system should be preserved.
        :param pulumi.Input['TaskOptionsPreserveDevices'] preserve_devices: A value that determines whether AWS DataSync should preserve the metadata of block and character devices in the source file system, and recreate the files with that device name and metadata on the destination.
        :param pulumi.Input['TaskOptionsSecurityDescriptorCopyFlags'] security_descriptor_copy_flags: A value that determines which components of the SMB security descriptor are copied during transfer.
        :param pulumi.Input['TaskOptionsTaskQueueing'] task_queueing: A value that determines whether tasks should be queued before executing the tasks.
        :param pulumi.Input['TaskOptionsTransferMode'] transfer_mode: A value that determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location.
        :param pulumi.Input['TaskOptionsUid'] uid: The user ID (UID) of the file's owner.
        :param pulumi.Input['TaskOptionsVerifyMode'] verify_mode: A value that determines whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred.
        """
        if atime is not None:
            pulumi.set(__self__, "atime", atime)
        if bytes_per_second is not None:
            pulumi.set(__self__, "bytes_per_second", bytes_per_second)
        if gid is not None:
            pulumi.set(__self__, "gid", gid)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if mtime is not None:
            pulumi.set(__self__, "mtime", mtime)
        if overwrite_mode is not None:
            pulumi.set(__self__, "overwrite_mode", overwrite_mode)
        if posix_permissions is not None:
            pulumi.set(__self__, "posix_permissions", posix_permissions)
        if preserve_deleted_files is not None:
            pulumi.set(__self__, "preserve_deleted_files", preserve_deleted_files)
        if preserve_devices is not None:
            pulumi.set(__self__, "preserve_devices", preserve_devices)
        if security_descriptor_copy_flags is not None:
            pulumi.set(__self__, "security_descriptor_copy_flags", security_descriptor_copy_flags)
        if task_queueing is not None:
            pulumi.set(__self__, "task_queueing", task_queueing)
        if transfer_mode is not None:
            pulumi.set(__self__, "transfer_mode", transfer_mode)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if verify_mode is not None:
            pulumi.set(__self__, "verify_mode", verify_mode)

    @property
    @pulumi.getter
    def atime(self) -> Optional[pulumi.Input['TaskOptionsAtime']]:
        """
        A file metadata value that shows the last time a file was accessed (that is, when the file was read or written to).
        """
        return pulumi.get(self, "atime")

    @atime.setter
    def atime(self, value: Optional[pulumi.Input['TaskOptionsAtime']]):
        pulumi.set(self, "atime", value)

    @property
    @pulumi.getter(name="bytesPerSecond")
    def bytes_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        A value that limits the bandwidth used by AWS DataSync.
        """
        return pulumi.get(self, "bytes_per_second")

    @bytes_per_second.setter
    def bytes_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bytes_per_second", value)

    @property
    @pulumi.getter
    def gid(self) -> Optional[pulumi.Input['TaskOptionsGid']]:
        """
        The group ID (GID) of the file's owners.
        """
        return pulumi.get(self, "gid")

    @gid.setter
    def gid(self, value: Optional[pulumi.Input['TaskOptionsGid']]):
        pulumi.set(self, "gid", value)

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input['TaskOptionsLogLevel']]:
        """
        A value that determines the types of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide.
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input['TaskOptionsLogLevel']]):
        pulumi.set(self, "log_level", value)

    @property
    @pulumi.getter
    def mtime(self) -> Optional[pulumi.Input['TaskOptionsMtime']]:
        """
        A value that indicates the last time that a file was modified (that is, a file was written to) before the PREPARING phase.
        """
        return pulumi.get(self, "mtime")

    @mtime.setter
    def mtime(self, value: Optional[pulumi.Input['TaskOptionsMtime']]):
        pulumi.set(self, "mtime", value)

    @property
    @pulumi.getter(name="overwriteMode")
    def overwrite_mode(self) -> Optional[pulumi.Input['TaskOptionsOverwriteMode']]:
        """
        A value that determines whether files at the destination should be overwritten or preserved when copying files.
        """
        return pulumi.get(self, "overwrite_mode")

    @overwrite_mode.setter
    def overwrite_mode(self, value: Optional[pulumi.Input['TaskOptionsOverwriteMode']]):
        pulumi.set(self, "overwrite_mode", value)

    @property
    @pulumi.getter(name="posixPermissions")
    def posix_permissions(self) -> Optional[pulumi.Input['TaskOptionsPosixPermissions']]:
        """
        A value that determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file.
        """
        return pulumi.get(self, "posix_permissions")

    @posix_permissions.setter
    def posix_permissions(self, value: Optional[pulumi.Input['TaskOptionsPosixPermissions']]):
        pulumi.set(self, "posix_permissions", value)

    @property
    @pulumi.getter(name="preserveDeletedFiles")
    def preserve_deleted_files(self) -> Optional[pulumi.Input['TaskOptionsPreserveDeletedFiles']]:
        """
        A value that specifies whether files in the destination that don't exist in the source file system should be preserved.
        """
        return pulumi.get(self, "preserve_deleted_files")

    @preserve_deleted_files.setter
    def preserve_deleted_files(self, value: Optional[pulumi.Input['TaskOptionsPreserveDeletedFiles']]):
        pulumi.set(self, "preserve_deleted_files", value)

    @property
    @pulumi.getter(name="preserveDevices")
    def preserve_devices(self) -> Optional[pulumi.Input['TaskOptionsPreserveDevices']]:
        """
        A value that determines whether AWS DataSync should preserve the metadata of block and character devices in the source file system, and recreate the files with that device name and metadata on the destination.
        """
        return pulumi.get(self, "preserve_devices")

    @preserve_devices.setter
    def preserve_devices(self, value: Optional[pulumi.Input['TaskOptionsPreserveDevices']]):
        pulumi.set(self, "preserve_devices", value)

    @property
    @pulumi.getter(name="securityDescriptorCopyFlags")
    def security_descriptor_copy_flags(self) -> Optional[pulumi.Input['TaskOptionsSecurityDescriptorCopyFlags']]:
        """
        A value that determines which components of the SMB security descriptor are copied during transfer.
        """
        return pulumi.get(self, "security_descriptor_copy_flags")

    @security_descriptor_copy_flags.setter
    def security_descriptor_copy_flags(self, value: Optional[pulumi.Input['TaskOptionsSecurityDescriptorCopyFlags']]):
        pulumi.set(self, "security_descriptor_copy_flags", value)

    @property
    @pulumi.getter(name="taskQueueing")
    def task_queueing(self) -> Optional[pulumi.Input['TaskOptionsTaskQueueing']]:
        """
        A value that determines whether tasks should be queued before executing the tasks.
        """
        return pulumi.get(self, "task_queueing")

    @task_queueing.setter
    def task_queueing(self, value: Optional[pulumi.Input['TaskOptionsTaskQueueing']]):
        pulumi.set(self, "task_queueing", value)

    @property
    @pulumi.getter(name="transferMode")
    def transfer_mode(self) -> Optional[pulumi.Input['TaskOptionsTransferMode']]:
        """
        A value that determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location.
        """
        return pulumi.get(self, "transfer_mode")

    @transfer_mode.setter
    def transfer_mode(self, value: Optional[pulumi.Input['TaskOptionsTransferMode']]):
        pulumi.set(self, "transfer_mode", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input['TaskOptionsUid']]:
        """
        The user ID (UID) of the file's owner.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input['TaskOptionsUid']]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="verifyMode")
    def verify_mode(self) -> Optional[pulumi.Input['TaskOptionsVerifyMode']]:
        """
        A value that determines whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred.
        """
        return pulumi.get(self, "verify_mode")

    @verify_mode.setter
    def verify_mode(self, value: Optional[pulumi.Input['TaskOptionsVerifyMode']]):
        pulumi.set(self, "verify_mode", value)


@pulumi.input_type
class TaskScheduleArgs:
    def __init__(__self__, *,
                 schedule_expression: pulumi.Input[str]):
        """
        Specifies the schedule you want your task to use for repeated executions.
        :param pulumi.Input[str] schedule_expression: A cron expression that specifies when AWS DataSync initiates a scheduled transfer from a source to a destination location
        """
        pulumi.set(__self__, "schedule_expression", schedule_expression)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> pulumi.Input[str]:
        """
        A cron expression that specifies when AWS DataSync initiates a scheduled transfer from a source to a destination location
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "schedule_expression", value)


@pulumi.input_type
class TaskTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        :param pulumi.Input[str] key: The key for an AWS resource tag.
        :param pulumi.Input[str] value: The value for an AWS resource tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key for an AWS resource tag.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for an AWS resource tag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


