import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Schema for Module Fragment of type FreyrAIM::Spider::PostgreSQL::MODULE
 *
 * @schema CfnPostgreSqlModuleProps
 */
export interface CfnPostgreSqlModuleProps {
    /**
     * @schema CfnPostgreSqlModuleProps#Parameters
     */
    readonly parameters?: CfnPostgreSqlModulePropsParameters;
    /**
     * @schema CfnPostgreSqlModuleProps#Resources
     */
    readonly resources?: CfnPostgreSqlModulePropsResources;
}
/**
 * Converts an object of type 'CfnPostgreSqlModuleProps' to JSON representation.
 */
export declare function toJson_CfnPostgreSqlModuleProps(obj: CfnPostgreSqlModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnPostgreSqlModulePropsParameters
 */
export interface CfnPostgreSqlModulePropsParameters {
    /**
     * The environment name
     *
     * @schema CfnPostgreSqlModulePropsParameters#EnvName
     */
    readonly envName?: CfnPostgreSqlModulePropsParametersEnvName;
    /**
     * Username for database access
     *
     * @schema CfnPostgreSqlModulePropsParameters#DBUsername
     */
    readonly dbUsername?: CfnPostgreSqlModulePropsParametersDbUsername;
    /**
     * Password database access
     *
     * @schema CfnPostgreSqlModulePropsParameters#DBPassword
     */
    readonly dbPassword?: CfnPostgreSqlModulePropsParametersDbPassword;
    /**
     * The environment name
     *
     * @schema CfnPostgreSqlModulePropsParameters#Test
     */
    readonly test?: CfnPostgreSqlModulePropsParametersTest;
}
/**
 * Converts an object of type 'CfnPostgreSqlModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnPostgreSqlModulePropsParameters(obj: CfnPostgreSqlModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnPostgreSqlModulePropsResources
 */
export interface CfnPostgreSqlModulePropsResources {
    /**
     * @schema CfnPostgreSqlModulePropsResources#PostgreSQL
     */
    readonly postgreSql?: CfnPostgreSqlModulePropsResourcesPostgreSql;
}
/**
 * Converts an object of type 'CfnPostgreSqlModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnPostgreSqlModulePropsResources(obj: CfnPostgreSqlModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * The environment name
 *
 * @schema CfnPostgreSqlModulePropsParametersEnvName
 */
export interface CfnPostgreSqlModulePropsParametersEnvName {
    /**
     * @schema CfnPostgreSqlModulePropsParametersEnvName#Type
     */
    readonly type: string;
    /**
     * @schema CfnPostgreSqlModulePropsParametersEnvName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnPostgreSqlModulePropsParametersEnvName' to JSON representation.
 */
export declare function toJson_CfnPostgreSqlModulePropsParametersEnvName(obj: CfnPostgreSqlModulePropsParametersEnvName | undefined): Record<string, any> | undefined;
/**
 * Username for database access
 *
 * @schema CfnPostgreSqlModulePropsParametersDbUsername
 */
export interface CfnPostgreSqlModulePropsParametersDbUsername {
    /**
     * @schema CfnPostgreSqlModulePropsParametersDbUsername#Type
     */
    readonly type: string;
    /**
     * @schema CfnPostgreSqlModulePropsParametersDbUsername#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnPostgreSqlModulePropsParametersDbUsername' to JSON representation.
 */
export declare function toJson_CfnPostgreSqlModulePropsParametersDbUsername(obj: CfnPostgreSqlModulePropsParametersDbUsername | undefined): Record<string, any> | undefined;
/**
 * Password database access
 *
 * @schema CfnPostgreSqlModulePropsParametersDbPassword
 */
export interface CfnPostgreSqlModulePropsParametersDbPassword {
    /**
     * @schema CfnPostgreSqlModulePropsParametersDbPassword#Type
     */
    readonly type: string;
    /**
     * @schema CfnPostgreSqlModulePropsParametersDbPassword#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnPostgreSqlModulePropsParametersDbPassword' to JSON representation.
 */
export declare function toJson_CfnPostgreSqlModulePropsParametersDbPassword(obj: CfnPostgreSqlModulePropsParametersDbPassword | undefined): Record<string, any> | undefined;
/**
 * The environment name
 *
 * @schema CfnPostgreSqlModulePropsParametersTest
 */
export interface CfnPostgreSqlModulePropsParametersTest {
    /**
     * @schema CfnPostgreSqlModulePropsParametersTest#Type
     */
    readonly type: string;
    /**
     * @schema CfnPostgreSqlModulePropsParametersTest#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnPostgreSqlModulePropsParametersTest' to JSON representation.
 */
export declare function toJson_CfnPostgreSqlModulePropsParametersTest(obj: CfnPostgreSqlModulePropsParametersTest | undefined): Record<string, any> | undefined;
/**
 * @schema CfnPostgreSqlModulePropsResourcesPostgreSql
 */
export interface CfnPostgreSqlModulePropsResourcesPostgreSql {
    /**
     * @schema CfnPostgreSqlModulePropsResourcesPostgreSql#Type
     */
    readonly type?: string;
    /**
     * @schema CfnPostgreSqlModulePropsResourcesPostgreSql#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnPostgreSqlModulePropsResourcesPostgreSql' to JSON representation.
 */
export declare function toJson_CfnPostgreSqlModulePropsResourcesPostgreSql(obj: CfnPostgreSqlModulePropsResourcesPostgreSql | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `FreyrAIM::Spider::PostgreSQL::MODULE`
 *
 * @cloudformationResource FreyrAIM::Spider::PostgreSQL::MODULE
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnPostgreSqlModule extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "FreyrAIM::Spider::PostgreSQL::MODULE";
    /**
     * Resource props.
     */
    readonly props: CfnPostgreSqlModuleProps;
    /**
     * Create a new `FreyrAIM::Spider::PostgreSQL::MODULE`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnPostgreSqlModuleProps);
}
