# Generated by Django 2.1.4 on 2018-12-21 16:21

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('pyfb_endpoint', '0004_auto_20181219_1402'),
        ('pyfb_company', '0004_auto_20181210_1138'),
    ]

    operations = [
        migrations.CreateModel(
            name='Did',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('number', models.CharField(db_index=True, max_length=30, unique=True, verbose_name='DID number')),
                ('prov_max_channels', models.PositiveIntegerField(default=0, help_text='maximum simultaneous calls allowed for this did. 0 means no limit', verbose_name='provider channels')),
                ('provider_free', models.BooleanField(default=True, verbose_name='Free from provider')),
                ('cust_max_channels', models.PositiveIntegerField(blank=True, default=0, help_text='maximum simultaneous calls allowed for this did. 0 means no limit', null=True, verbose_name='customer channels')),
                ('customer_free', models.BooleanField(default=True, verbose_name='Free for customer')),
                ('insee_code', models.CharField(blank=True, help_text='Postal code, INSEE code ... for routing urgency number to the right urgency call center.', max_length=10, null=True, verbose_name='Special code for routing urgency numbers')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('customer', models.ForeignKey(blank=True, limit_choices_to={'enabled': True}, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='didcustomer', to='pyfb_company.Customer', verbose_name='Customer')),
                ('provider', models.ForeignKey(limit_choices_to={'enabled': True}, on_delete=django.db.models.deletion.CASCADE, related_name='didprovider', to='pyfb_company.Provider', verbose_name='Provider')),
            ],
            options={
                'verbose_name': 'DID',
                'verbose_name_plural': 'DIDs',
                'db_table': 'pyfb_did',
                'ordering': ('number',),
            },
        ),
        migrations.CreateModel(
            name='RoutesDid',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('order', models.IntegerField(default=1)),
                ('type', models.CharField(choices=[('s', 'SIP Trunk'), ('e', 'External number')], default='s', help_text='Routing type : sip trunk (s) orexternal number (e).', max_length=2, verbose_name='Route type')),
                ('number', models.CharField(blank=True, default='', max_length=30, null=True, verbose_name='destination number')),
                ('weight', models.PositiveIntegerField(default=0, verbose_name='weight')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('contract_did', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='pyfb_did.Did')),
                ('trunk', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='pyfb_endpoint.CustomerEndpoint')),
            ],
            options={
                'verbose_name': 'DID route',
                'verbose_name_plural': 'DID routes',
                'db_table': 'pyfb_did_routes',
                'ordering': ('contract_did',),
            },
        ),
        migrations.AlterUniqueTogether(
            name='routesdid',
            unique_together={('contract_did', 'order')},
        ),
    ]
