"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontToMediaStore = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
const aws_cdk_lib_1 = require("aws-cdk-lib");
class CloudFrontToMediaStore extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of CloudFrontToMediaStore class.
     * @param {Construct} scope - represents the scope for all the resources.
     * @param {string} id - this is a scope-unique id.
     * @param {CloudFrontToMediaStoreProps} props - user provided props for the construct
     * @since 1.76.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        let cloudFrontDistributionProps = props.cloudFrontDistributionProps;
        if (props.existingMediaStoreContainerObj) {
            this.mediaStoreContainer = props.existingMediaStoreContainerObj;
        }
        else {
            let mediaStoreProps;
            if (props.mediaStoreContainerProps) {
                mediaStoreProps = props.mediaStoreContainerProps;
            }
            else {
                this.cloudFrontOriginAccessIdentity = defaults.CloudFrontOriginAccessIdentity(this);
                mediaStoreProps = {
                    containerName: aws_cdk_lib_1.Aws.STACK_NAME,
                    policy: JSON.stringify({
                        Version: '2012-10-17',
                        Statement: [{
                                Sid: 'MediaStoreDefaultPolicy',
                                Effect: 'Allow',
                                Principal: '*',
                                Action: [
                                    'mediastore:GetObject',
                                    'mediastore:DescribeObject'
                                ],
                                Resource: `arn:${aws_cdk_lib_1.Aws.PARTITION}:mediastore:${aws_cdk_lib_1.Aws.REGION}:${aws_cdk_lib_1.Aws.ACCOUNT_ID}:container/${aws_cdk_lib_1.Aws.STACK_NAME}/*`,
                                Condition: {
                                    StringEquals: {
                                        'aws:UserAgent': this.cloudFrontOriginAccessIdentity.originAccessIdentityName
                                    },
                                    Bool: {
                                        'aws:SecureTransport': 'true'
                                    }
                                }
                            }]
                    })
                };
                const userAgentHeader = {
                    'User-Agent': this.cloudFrontOriginAccessIdentity.originAccessIdentityName
                };
                if (cloudFrontDistributionProps) {
                    cloudFrontDistributionProps.customHeaders = userAgentHeader;
                }
                else {
                    cloudFrontDistributionProps = {
                        customHeaders: userAgentHeader
                    };
                }
            }
            this.mediaStoreContainer = defaults.MediaStoreContainer(this, mediaStoreProps);
        }
        [this.cloudFrontWebDistribution, this.cloudFrontLoggingBucket, this.cloudFrontOriginRequestPolicy, this.cloudFrontFunction]
            = defaults.CloudFrontDistributionForMediaStore(this, this.mediaStoreContainer, cloudFrontDistributionProps, props.insertHttpSecurityHeaders, props.cloudFrontLoggingBucketProps, props.responseHeadersPolicyProps);
    }
}
exports.CloudFrontToMediaStore = CloudFrontToMediaStore;
_a = JSII_RTTI_SYMBOL_1;
CloudFrontToMediaStore[_a] = { fqn: "@aws-solutions-constructs/aws-cloudfront-mediastore.CloudFrontToMediaStore", version: "2.29.0" };
//# sourceMappingURL=data:application/json;base64,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