# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pysmartdatamodels']

package_data = \
{'': ['*'], 'pysmartdatamodels': ['model-assets/*']}

install_requires = \
['jsonref>=1.1.0,<2.0.0',
 'jsonschema>=4.17.3,<5.0.0',
 'pytz>=2022.7.1,<2023.0.0',
 'requests>=2.28.2,<3.0.0']

setup_kwargs = {
    'name': 'pysmartdatamodels',
    'version': '0.5.41',
    'description': 'Open-licensed and free data models to model your digital twins, share data in data spaces or develop smart applications',
    'long_description': '[![Smart Data Models](https://smartdatamodels.org/wp-content/uploads/2022/01/SmartDataModels_logo.png "Logo")](https://smartdatamodels.org)  \n\nSmart Data Models \n==================\n\nThe [Smart Data Models](https://smartdatamodels.org) is a program lead by [4 organizations](https://smartdatamodels.org/index.php/faqs/) with the collaboration of [more than 80](https://smartdatamodels.org/index.php/statistics/) and open to collaboration. It provides multisector agile standardized free and open-licensed data models based either on actual use cases or on adopted open standards.\nThe data models describe the entities and their attributes to be used in digital twins deployments, data spaces and other smart applications. The data models are grouped in subjects. Each subject is available at a unique repository at [https://smart-data-models.github.com](https://smart-data-models.github.com). Contributions to existing data models can be done there. New ones are drafted in the [incubated repository](https://github.com/smart-data-models/incubated/) once [filled this form](https://smartdatamodels.org/index.php/new-incubated-data-models/) for getting the permissions. [This manual](https://bit.ly/contribution_manual) helps you with the creation. There is a database of [contributors](https://smartdatamodels.org/index.php/contributors/) available. \n\nThis python package includes all the data models and several functions (listed below) to use them in your developments.\n\nEvery data model is open licensed and the list of its attributes and every attribute definition is included. Also, there is a function to check if a key values payload complies with a data model.  \n\nIf you want to be updated on this package you can join this [mailing list](https://smartdatamodels.org/index.php/developers-list/) (Announcements are sent only when something relevant happens). We love to hear from you at info@smartdatamodels.org\n\nThere are several online tools to manage and to create the data models, [generate examples](https://smartdatamodels.org/index.php/generate-a-ngsi-ld-keyvalues-payload-compliant-with-a-data-model/) or to adapt to [existing ontologies](https://smartdatamodels.org/index.php/generate-acontext-based-on-external-ontologies-iris/). See tools menu option at the [home site](https://smartdatamodels.org).\n\nCurrently, there are thirteen domains. \n#### [Smart Cities](https://github.com/smart-data-models/SmartCities)\n#### [Smart Agrifood](https://smartdatamodels.org/index.php/statistics/)\n#### [Smart Water](https://github.com/smart-data-models/SmartWater)\n#### [Smart Energy](https://github.com/smart-data-models/SmartEnergy)\n#### [Smart Environment](https://github.com/smart-data-models/SmartEnvironment)\n#### [Smart Robotics](https://github.com/smart-data-models/SmartRobotics)\n#### [Smart Sensoring](https://github.com/smart-data-models/Smart-Sensoring)\n#### [Cross sector](https://github.com/smart-data-models/CrossSector)\n#### [Smart Aeronautics](https://github.com/smart-data-models/SmartAeronautics)\n#### [Smart Destination](https://github.com/smart-data-models/SmartDestination)\n#### [Smart Health](https://github.com/smart-data-models/SmartHealth)\n#### [Smart Manufacturing](https://github.com/smart-data-models/SmartManufacturing)\n#### [Smart Logistics](https://github.com/smart-data-models/SmartLogistics)\n\n## Functions available include:\n\n1- Load all datamodels in a dict like the official list. Function load_all_datamodels()\n\n    Returns a dict with all data models with this object structure\n        - repoName: The name of the subject\n        - repoLink: the link to the repository of the subject\n        - dataModels: An array with all the datamodels of this subject\n        - domains: an array to the domains that this subject belongs to\n        Parameters:\n          None\n\n        Returns:\n           array of objects with the description of the subject\n        \n\n2- Load all attributes in a dict like the official export of attributes. Function load_all_attributes()\n \n    Returns an array of objects describing every attribute in the data models\n        - _id: identifier of the item\n        - property: the name of the attribute\n        - dataModel: the data model this attribute is present\n        - repoName: the subject this data model belongs to\n        - description: the description of the attribute\n        - typeNGSI: Whether it is a property, Geoproperty, or relationship\n        - modelTags: inherited from the data model tags\n        - license: link to the license for the data model\n        - schemaVersion: version of the data model\n        - type: data type\n        - model: when available the reference model for the attribute\n        - units: when available the recommended units for the attribute\n        - format: either date, or time, or date-time, or URI, etc the format of the attribute\n        Parameters:\n\n        Returns:\n           array of objects with the description of the subject\n\n3- List all data models. Function list_all_datamodels()\n\n        List the names of the entities defined in the data models.\n        Parameters:\n\n        Returns:\n        array of strings: data models\' names\n\n4- List all subjects. Function list_all_subjects()\n\n        List the names of the subjects (groups of data models). The subject\'s names define repositories with the name dataModel.subject at the root of the https://smart-data-models.github.com site\n          Parameters:\n\n      Returns:\n        array of strings: subjects\' names\n\n5- List the data models of a subject. Function datamodels_subject(subject)\n\n        List the names of the entities defined in the data models.\n        Parameters:\n          subject: name of the subject\n\n        Returns:\n         if subject is found\n           array of strings: data models\' names belonging to the subject\n         if subject is not found\n           False\n\n6- List description of an attribute. Function description_attribute(subject, datamodel, attribute)\n\n        List the description of an attribute belonging to a subject and data model.\n        Parameters:\n          subject: name of the subject\n          datamodel: name of the data model\n          attribute: name of the attribute\n\n        Returns:\n          if subject, datamodel and attribute are found\n            string: attribute\'s description\n          if any of the input parameters is not found\n            False\n\n7- List data-type of an attribute. Function datatype_attribute(subject, datamodel, attribute)\n\n    List the data type of an attribute belonging to a subject and data model.\n        Parameters:\n        subject: name of the subject\n        datamodel: name of the data model\n        attribute: name of the attribute\n\n        Returns:\n          if subject, datamodel and attribute are found\n            string: attribute\'s data type\n          if any of the input parameters is not found\n            False\n\n8- Give reference model for an attribute. Function model_attribute(subject, datamodel, attribute)\n\n        List the model of an attribute (when available) belonging to a subject and data model.\n          Parameters:\n            subject: name of the subject\n            datamodel: name of the data model\n            attribute: name of the attribute\n\n          Returns:\n            if subject, datamodel and attribute are found\n              string: attribute model\'s URL\n            if any of the input parameters is not found or there is not a model\n              False\n\n9- Give reference units for an attribute. Function attributes_datamodel(subject, datamodel)\n\n        List the recommended units of an attribute belonging to a subject and data model.\n          Parameters:\n            subject: name of the subject\n            datamodel: name of the data model\n            attribute: name of the attribute\n\n        Returns:\n          if subject, datamodel and attribute are found\n            string: acronym/text of the recommended units\n          if any of the input parameters is not found or there are not recommended units\n            False\n\n10- List the attributes of a data model. Function attributes_datamodel(subject, datamodel)\n\n        List the attributes of a data model (currently only first level ones) .\n          Parameters:\n          subject: name of the subject\n          datamodel: name of the data model\n\n          Returns:\n            if subject and datamodel  are found\n              array: attribute\'s names\n            if any of the input parameters is not found\n              False\n\n11- List the NGSI type (Property, Relationship or Geoproperty) of the attribute. Function ngsi_datatype_attribute(subject, datamodel, attribute)\n\n        List the NGSI data type of an attribute (Property, Relationship or Geoproperty) belonging to a subject and data model.\n          Parameters:\n            subject: name of the subject\n            datamodel: name of the data model\n            attribute: name of the attribute\n\n          Returns:\n            if subject, datamodel and attribute are found\n              string: NGSI data type\n            if any of the input parameters is not found\n              False\n\n12- Print a list of data models attributes separated by a separator. Function print_datamodel(subject, datamodel, separator, meta_attributes)\n\n        Validates a json schema defining a data model.\n        Parameters:\n          schema_url: url of the schema (public available). (i.e. raw version of a github repo https://raw.githubusercontent.com/smart-data-models/dataModel.Aeronautics/master/AircraftModel/schema.json\n\n\n        Returns:\n          object with four elements:\n        - documentationStatusofProperties: For each first level attribute lists if the attribute is documented and includes the description (when available). Also the NGSI type if is set and which one is described.\n        Example:\n            "dateCreated":\n                  {\n                  "x-ngsi": true,\n                  "x-ngsi_text": "ok to Property",\n                  "documented": true,\n                  "text": "This will usually be allocated by the storage platform.. Entity creation timestamp"\n                  },\n        - schemaDiagnose: It counts the attributes with right descriptions and those which don\'t.\n        - alreadyUsedProperties: It identifies attributes that have already been used in other data models and includes their definition\n        - availableProperties: Identifies those attributes which are not already included in any other data model\n\n13- Returns the link to the repository of a subject. Function subject_repolink(subject)\n\n        Print the different elements of the attributes of a data model separated by a given separator.\n        Parameters:\n          subject: name of the subject\n          datamodel: name of the data model\n          separator: string between the different elements printed\n          meta_attributes: list of different qualifiers of an attribute\n             property: the name of the attribute\n             type: the data type of the attribute (json schema basic types)\n             dataModel: the data model the attribute belongs to\n             repoName: the subject the attribute belongs to\n             description: the definition of the attribute\n             typeNGSI: the NGSI type, Property, Relationship or Geoproperty\n             modelTags: the tags assigned to the data model\n             format: For those attributes having it the format, i.e. date-time\n             units: For those attributes having it the recommended units, i.e. meters\n             model: For those attributes having it the reference model, i.e. https://schema.org/Number\n\n        Returns:\n          It prints a version of the attributes separated by the separator listing the meta_attributes specified\n          A variable with the same strings\n          if any of the input parameters is not found it returns false\n          \n14- Returns the links to the repositories of a data model name. Function datamodel_repolink(datamodel)\n\n        It returns the direct link to the repository of the subject if it is found and False if not .\n        Parameters:\n          subject: name of the subject\n\n        Returns:\n         if subject is found\n           url of the github repository. Example for subject User it returns \'https://github.com/smart-data-models/dataModel.User.git\'\n         if subject is not found\n           False\n\n15- Update the official data model list or the database of attributes from the source. Function update_data()\n\n        It returns an array with the direct links to the repositories where is located the data model if it is found and False if not found.\n        Parameters:\n          datamodel: name of the data model\n\n        Returns:\n         if data model is found\n           array of urls (even with one single result) to the github repository. Example for subject Activity it returns [\'https://github.com/smart-data-models/dataModel.User.git\']\n         if data model is not found\n           False\n\n## Pending features (glad to receive contributions to them)\n\nA.- Function to allow submission of improvements (i.e. missing recommended units or model) and comments to the different data models. Currently, you can do it searching for your data model here \n[https://smartdatamodels.org/index.php/list-of-data-models-3/](https://smartdatamodels.org/index.php/list-of-data-models-3/) going to the github repo and making your PR or raising your issues there.\n\nB.- Function to submit a new data model to an incubation repository. Currently, this is done manually [incubated repository](https://github.com/smart-data-models/incubated/tree/master). By filling this [form](https://smartdatamodels.org/index.php/new-incubated-data-models/) you are granted to contribute with new data models. For existing data models just see point C    \n\nif you want to suggest other functions / needs please let us know at info@smartdatamodels.org.\n\n### some example code\n\nfrom pysmartdatamodels import pysmartdatamodels as sdm\n\nsubject = "dataModel.Weather"\n\ndataModel = "WeatherForecast"\n\nattribute = "precipitation"\n\nprint(sdm.load_all_datamodels())\n\nprint(len(sdm.load_all_attributes()))   # there is more than 19.000 to get all listed\n\nprint(sdm.list_all_datamodels())\n\nprint(sdm.list_all_subjects())\n\nprint(sdm.datamodels_subject("dataModel.Weather"))\n\nprint(sdm.description_attribute(subject, dataModel, attribute))\n\nprint(sdm.datatype_attribute(subject, dataModel, attribute))\n\nprint(sdm.model_attribute(subject, dataModel, attribute))\n\nprint(sdm.units_attribute(subject, dataModel, attribute))\n\nprint(sdm.attributes_datamodel(subject, dataModel))\n\nprint(sdm.subject_repolink(subject))\n\nprint(sdm.datamodel_repolink(dataModel))\n\nprint(sdm.print_datamodel(subject, dataModel, ",", [\n        "property",\n        "type",\n        "dataModel",\n        "repoName",\n        "description",\n        "typeNGSI",\n        "modelTags",\n        "format",\n        "units",\n        "model",\n    ]))\n\nsdm.update_data()\n',
    'author': 'aabella',
    'author_email': 'alberto.abella@fiware.org',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
