# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['simple_ddl_parser', 'simple_ddl_parser.dialects', 'simple_ddl_parser.output']

package_data = \
{'': ['*']}

install_requires = \
['ply>=3.11,<4.0']

entry_points = \
{'console_scripts': ['sdp = simple_ddl_parser.cli:main']}

setup_kwargs = {
    'name': 'simple-ddl-parser',
    'version': '0.16.0',
    'description': 'Simple DDL Parser to parse SQL & dialects like HQL, TSQL, Oracle, etc ddl files to json/python dict with full information about columns: types, defaults, primary keys, etc.; sequences, alters, custom types & other entities from ddl.',
    'long_description': '\nSimple DDL Parser\n-----------------\n\n\n.. image:: https://img.shields.io/pypi/v/simple-ddl-parser\n   :target: https://img.shields.io/pypi/v/simple-ddl-parser\n   :alt: badge1\n \n.. image:: https://img.shields.io/pypi/l/simple-ddl-parser\n   :target: https://img.shields.io/pypi/l/simple-ddl-parser\n   :alt: badge2\n \n.. image:: https://img.shields.io/pypi/pyversions/simple-ddl-parser\n   :target: https://img.shields.io/pypi/pyversions/simple-ddl-parser\n   :alt: badge3\n \n.. image:: https://github.com/xnuinside/simple-ddl-parser/actions/workflows/main.yml/badge.svg\n   :target: https://github.com/xnuinside/simple-ddl-parser/actions/workflows/main.yml/badge.svg\n   :alt: workflow\n\n\nBuild with ply (lex & yacc in python). A lot of samples in \'tests/.\n\nIs it Stable?\n^^^^^^^^^^^^^\n\nYes, library already has about 3500+ usage per day - https://pypistats.org/packages/simple-ddl-parser.\n\nAs maintainer I guarantee that any backward incompatible changes will not be done in patch or minor version. Only additionals & new features.\n\nHowever, in process of adding support for new statements & features I see that output can be structured more optimal way and I hope to release version ``1.0.*`` with more struct output result. But, it will not be soon, first of all, I want to add support for so much statements as I can. So I don\'t think make sense to expect version 1.0.* before, for example, version ``0.26.0`` :)\n\nHow does it work?\n^^^^^^^^^^^^^^^^^\n\nParser tested on different DDLs for PostgreSQL & Hive. But idea to support as much as possible DDL dialects (Vertica, Oracle, Hive, MsSQL, etc.). You can check dialects sections after ``Supported Statements`` section to get more information that statements from dialects already supported by parser.\n**If you need some statement, that not supported by parser yet**\\ : please provide DDL example & information about that is it SQL dialect or DB.\n\nTypes that are used in your DB does not matter, so parser must also work successfuly to any DDL for SQL DB. Parser is NOT case sensitive, it did not expect that all queries will be in upper case or lower case. So you can write statements like this:\n\n.. code-block:: sql\n\n\n       Alter Table Persons ADD CONSTRAINT CHK_PersonAge CHECK (Age>=18 AND City=\'Sandnes\');\n\nIt will be parsed as is without errors.\n\nIf you have samples that cause an error - please open the issue (but don\'t forget to add ddl example), I will be glad to fix it.\n\nA lot of statements and output result you can find in tests on the github - https://github.com/xnuinside/simple-ddl-parser/tree/main/tests .\n\nHow to install\n^^^^^^^^^^^^^^\n\n.. code-block:: bash\n\n\n       pip install simple-ddl-parser\n\nHow to use\n----------\n\nExtract additional information from HQL (& other dialects)\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\nIn some dialects like HQL there is a lot of additional information about table like, fore example, is it external table, STORED AS, location & etc. This propertie will be always empty in \'classic\' SQL DB like PostgreSQL or MySQL and this is the reason, why by default this information are \'hidden\'.\nAlso some fields hidden in HQL, because they are simple not exists in HIVE, for example \'deferrable_initially\'\nTo get this \'hql\' specific details about table in output please use \'output_mode\' argument in run() method.\n\nexample:\n\n.. code-block:: python\n\n\n       ddl = """\n       CREATE TABLE IF NOT EXISTS default.salesorderdetail(\n           SalesOrderID int,\n           ProductID int,\n           OrderQty int,\n           LineTotal decimal\n           )\n       PARTITIONED BY (batch_id int, batch_id2 string, batch_32 some_type)\n       LOCATION \'s3://datalake/table_name/v1\'\n       ROW FORMAT DELIMITED\n           FIELDS TERMINATED BY \',\'\n           COLLECTION ITEMS TERMINATED BY \'\\002\'\n           MAP KEYS TERMINATED BY \'\\003\'\n       STORED AS TEXTFILE\n       """\n\n       result = DDLParser(ddl).run(output_mode="hql")\n       print(result)\n\nAnd you will get output with additional keys \'stored_as\', \'location\', \'external\', etc.\n\n.. code-block:: python\n\n\n       # additional keys examples\n     {\n       ...,\n       \'location\': "\'s3://datalake/table_name/v1\'",\n       \'map_keys_terminated_by\': "\'\\\\003\'",\n       \'partitioned_by\': [{\'name\': \'batch_id\', \'size\': None, \'type\': \'int\'},\n                           {\'name\': \'batch_id2\', \'size\': None, \'type\': \'string\'},\n                           {\'name\': \'batch_32\', \'size\': None, \'type\': \'some_type\'}],\n       \'primary_key\': [],\n       \'row_format\': \'DELIMITED\',\n       \'schema\': \'default\',\n       \'stored_as\': \'TEXTFILE\',\n       ... \n     }\n\nIf you run parser with command line add flag \'-o=hql\' or \'--output-mode=hql\' to get the same result.\n\nPossible output_modes: ["mssql", "mysql", "oracle", "hql", "sql"]\n\nFrom python code\n^^^^^^^^^^^^^^^^\n\n.. code-block:: python\n\n       from simple_ddl_parser import DDLParser\n\n\n       parse_results = DDLParser("""create table dev.data_sync_history(\n           data_sync_id bigint not null,\n           sync_count bigint not null,\n           sync_mark timestamp  not  null,\n           sync_start timestamp  not null,\n           sync_end timestamp  not null,\n           message varchar(2000) null,\n           primary key (data_sync_id, sync_start)\n       ); """).run()\n\n       print(parse_results)\n\nTo parse from file\n^^^^^^^^^^^^^^^^^^\n\n.. code-block:: python\n\n\n       from simple_ddl_parser import parse_from_file\n\n       result = parse_from_file(\'tests/sql/test_one_statement.sql\')\n       print(result)\n\nFrom command line\n^^^^^^^^^^^^^^^^^\n\nsimple-ddl-parser is installed to environment as command **sdp**\n\n.. code-block:: bash\n\n\n       sdp path_to_ddl_file\n\n       # for example:\n\n       sdp tests/sql/test_two_tables.sql\n\nYou will see the output in **schemas** folder in file with name **test_two_tables_schema.json**\n\nIf you want to have also output in console - use **-v** flag for verbose.\n\n.. code-block:: bash\n\n\n       sdp tests/sql/test_two_tables.sql -v\n\nIf you don\'t want to dump schema in file and just print result to the console, use **--no-dump** flag:\n\n.. code-block:: bash\n\n\n       sdp tests/sql/test_two_tables.sql --no-dump\n\nYou can provide target path where you want to dump result with argument **-t**\\ , **--targer**\\ :\n\n.. code-block:: bash\n\n\n       sdp tests/sql/test_two_tables.sql -t dump_results/\n\nMore details\n^^^^^^^^^^^^\n\n``DDLParser(ddl).run()``\n.run() method contains several arguments, that impact changing output result. As you can saw upper exists argument ``output_mode`` that allow you to set dialect and get more fields in output relative to chosen dialect, for example \'hql\'. Possible output_modes: ["mssql", "mysql", "oracle", "hql", "sql"]\n\nAlso in .run() method exists argument ``group_by_type`` (by default: False). By default output of parser looks like a List with Dicts where each dict == one entitiy from ddl (table, sequence, type, etc). And to understand that is current entity you need to check Dict like: if \'table_name\' in dict - this is a table, if \'type_name\' - this is a type & etc.\n\nTo make work little bit easy you can set group_by_type=True and you will get output already sorted by types, like:\n\n.. code-block:: python\n\n\n       { \n           \'tables\': [all_pasrsed_tables], \n           \'sequences\': [all_pasrsed_sequences], \n           \'types\': [all_pasrsed_types], \n           \'domains\': [all_pasrsed_domains],\n           ...\n       }\n\nFor example:\n\n.. code-block:: python\n\n\n       ddl = """\n       CREATE TYPE "schema--notification"."ContentType" AS\n           ENUM (\'TEXT\',\'MARKDOWN\',\'HTML\');\n           CREATE TABLE "schema--notification"."notification" (\n               content_type "schema--notification"."ContentType"\n           );\n       CREATE SEQUENCE dev.incremental_ids\n           INCREMENT 10\n           START 0\n           MINVALUE 0\n           MAXVALUE 9223372036854775807\n           CACHE 1;\n       """\n\n       result = DDLParser(ddl).run(group_by_type=True)\n\n       # result will be:\n\n       {\'sequences\': [{\'cache\': 1,\n                       \'increment\': 10,\n                       \'maxvalue\': 9223372036854775807,\n                       \'minvalue\': 0,\n                       \'schema\': \'dev\',\n                       \'sequence_name\': \'incremental_ids\',\n                       \'start\': 0}],\n       \'tables\': [{\'alter\': {},\n                   \'checks\': [],\n                   \'columns\': [{\'check\': None,\n                               \'default\': None,\n                               \'name\': \'content_type\',\n                               \'nullable\': True,\n                               \'references\': None,\n                               \'size\': None,\n                               \'type\': \'"schema--notification"."ContentType"\',\n                               \'unique\': False}],\n                   \'index\': [],\n                   \'partitioned_by\': [],\n                   \'primary_key\': [],\n                   \'schema\': \'"schema--notification"\',\n                   \'table_name\': \'"notification"\'}],\n       \'types\': [{\'base_type\': \'ENUM\',\n                   \'properties\': {\'values\': ["\'TEXT\'", "\'MARKDOWN\'", "\'HTML\'"]},\n                   \'schema\': \'"schema--notification"\',\n                   \'type_name\': \'"ContentType"\'}]}\n\nALTER statements\n^^^^^^^^^^^^^^^^\n\nRight now added support only for ALTER statements with FOREIGEIN key\n\nFor example, if in your ddl after table defenitions (create table statements) you have ALTER table statements like this:\n\n.. code-block:: sql\n\n\n   ALTER TABLE "material_attachments" ADD FOREIGN KEY ("material_id", "material_title") REFERENCES "materials" ("id", "title");\n\nThis statements will be parsed and information about them putted inside \'alter\' key in table\'s dict.\nFor example, please check alter statement tests - **tests/test_alter_statements.py**\n\nMore examples & tests\n^^^^^^^^^^^^^^^^^^^^^\n\nYou can find in **tests/** folder.\n\nDump result in json\n^^^^^^^^^^^^^^^^^^^\n\nTo dump result in json use argument .run(dump=True)\n\nYou also can provide a path where you want to have a dumps with schema with argument .run(dump_path=\'folder_that_use_for_dumps/\')\n\nSupported Statements\n--------------------\n\n\n* \n  CREATE TABLE [ IF NOT EXISTS ] + columns defenition, columns attributes: column name + type + type size(for example, varchar(255)), UNIQUE, PRIMARY KEY, DEFAULT, CHECK, NULL/NOT NULL, REFERENCES, ON DELETE, ON UPDATE,  NOT DEFERRABLE, DEFERRABLE INITIALLY, GENERATED ALWAYS, STORED\n\n* \n  STATEMENTS: PRIMARY KEY, CHECK, FOREIGN KEY in table defenitions (in create table();)\n\n* \n  ALTER TABLE STATEMENTS: ADD CHECK (with CONSTRAINT), ADD FOREIGN KEY (with CONSTRAINT), ADD UNIQUE, ADD DEFAULT FOR\n\n* \n  PARTITIONED BY statement\n\n* \n  CREATE SEQUENCE with words: INCREMENT, START, MINVALUE, MAXVALUE, CACHE\n\n* \n  CREATE TYPE statement:  AS ENUM, AS OBJECT, INTERNALLENGTH, INPUT, OUTPUT\n\n* \n  LIKE statement (in this and only in this case to output will be added \'like\' keyword with information about table from that we did like - \'like\': {\'schema\': None, \'table_name\': \'Old_Users\'}).\n\n* \n  TABLESPACE statement\n\n* \n  COMMENT ON statement\n\n* \n  CREATE SCHEMA [IF NOT EXISTS] ... [AUTHORIZATION] ...\n\n* \n  CREATE DOMAIN [AS]\n\nHQL Dialect statements\n^^^^^^^^^^^^^^^^^^^^^^\n\n\n* PARTITIONED BY statement\n* ROW FORMAT, ROW FORMAT SERDE\n* WITH SERDEPROPERTIES ("input.regex" =  "..some regex..")\n* STORED AS\n* COMMENT\n* LOCATION\n* FIELDS TERMINATED BY, LINES TERMINATED BY, COLLECTION ITEMS TERMINATED BY, MAP KEYS TERMINATED BY\n\nMSSQL / MySQL/ Oracle\n^^^^^^^^^^^^^^^^^^^^^\n\n\n* type IDENTITY statement\n* FOREIGN KEY REFERENCES statement\n* \'max\' specifier in column size\n* CONSTRAINT ... UNIQUE, CONSTRAINT ... CHECK, CONSTRAINT ... FOREIGN KEY, CONSTRAINT ... PRIMARY KEY\n* CREATE CLUSTERED INDEX\n\nOracle\n^^^^^^\n\n\n* ENCRYPT column property [+ NO SALT, SALT, USING]\n* STORAGE column property\n\nTODO in next Releases (if you don\'t see feature that you need - open the issue)\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\n\n#. Add support for CREATE TABLESPACE statement\n#. Add support for properties for TABLESPACE like ``TABLESPACE user_data ENABLE STORAGE IN ROW CHUNK 8K RETENTION CACHE``\n#. Add CREATE DATABASE statement support\n#. Add more support for CREATE type IS TABLE (example: CREATE OR REPLACE TYPE budget_tbl_typ IS TABLE OF NUMBER(8,2);\n#. Add support for MEMBER PROCEDURE, STATIC FUNCTION, CONSTRUCTOR FUNCTION,  in TYPE\n#. Add support (ignore correctly) ALTER TABLE ... DROP CONSTRAINT ..., ALTER TABLE ... DROP INDEX ...\n#. Add support for COMMENT ON statement\n#. Add support for case COMMENT column after DEFAULT word like ``col1 int DEFAULT \'1\' COMMENT \'Integer Column\'``\n\nnon-feature todo\n----------------\n\n\n#. Provide API to get result as Python Object\n#. Add online demo (UI) to parse ddl\n\nHistorical context\n^^^^^^^^^^^^^^^^^^\n\nThis library is an extracted parser code from https://github.com/xnuinside/fakeme (Library for fake relation data generation, that I used in several work projects, but did not have time to make from it normal open source library)\n\nFor one of the work projects I needed to convert SQL ddl to Python ORM models in auto way and I tried to use https://github.com/andialbrecht/sqlparse but it works not well enough with ddl for my case (for example, if in ddl used lower case - nothing works, primary keys inside ddl are mapped as column name not reserved word and etc.).\nSo I remembered about Parser in Fakeme and just extracted it & improved. \n\nChangelog\n---------\n\n**v0.16.0**\n\n\n#. Fixed the issue when NULL column after DEFAULT used as default value.\n#. Added support for generated columns, statatements: AS , GENERATED ALWAYS, STORED in Column Defenitions, in output it placed to key \'generated\'. Keyword \'generated\' showed only if column is generated.\n#. Half of changelogs moved to ARCHIVE_CHANGELOG.txt\n#. Added base support for CREATE DOMAIN statement\n#. Added base support for CREATE SCHEMA [IF NOT EXISTS] ... [AUTHORIZATION] statement, added new type keyword \'schemas\'\n\n**v0.15.0**\n\n\n#. Garbage like \'‘’\' quotes are ignored now and changed to normal. \n#. Added support for HQL: LINES TERMINATED BY, COMMENT (for table), ROW FORMAT SERDE, WITH SERDEPROPERTIES (\n   "input.regex" =  "..some regex..")\n#. Fixed issue when primary key with default option was not parsed correct - https://github.com/xnuinside/simple-ddl-parser/issues/40\n#. Fixed issue when expression in default value was not parsed correct - https://github.com/xnuinside/simple-ddl-parser/issues/39\n#. Added support for comments in Columns (except one case when COMMENT goes after DEFAULT word, in this case does not parse correct now - will be fixed in next releases)\n\n**v0.14.0**\n\n\n#. Added support for CONSTRAINT ... PRIMARY KEY ...\n#. Added support for ENCRYPT [+ NO SALT, SALT, USING] statements for Oracle dialect. All default values taken from this doc https://docs.oracle.com/en/database/oracle/oracle-database/21/asoag/encrypting-columns-tables2.html\n   Now if you use output_mode=\'oracle\' in column will be showed new property \'encrypt\'. \n   If no ENCRYPT statement will be in table defenition - then value will be \'None\', but if ENCRYPT exists when in encrypt property you will find this information:\n\n{\'encrypt\' : {\n    \'salt\': True,\n    \'encryption_algorithm\': \'AES192\',\n    \'integrity_algorithm\': \'SHA-1\'\n    }}\n\n\n#. Added support for oracle STORAGE statement, \'oracle\' output_mode now has key \'storage\' in table data defenition.\n#. Added support for TABLESPACE statement after columns defenition\n\n**v0.12.1**\n\n\n#. () after DEFAULT now does not cause an issue\n#. \' and " does not lost now in DEFAULT values\n\n**v0.12.0**\n\n\n#. Added support for MSSQL: types with 2 words like \'int IDENTITY\', \n   FOREIGN KEY REFERENCES statement, supported \'max\' as type size, CONSTRAINT ... UNIQUE statement in table defenition,\n   CONSTRAINT ... CHECK, CONSTRAINT ... FOREIGN KEY\n#. Added output_mode types: \'mysql\', \'mssql\' for SQL Server, \'oracle\'. If chosed one of the above - \n   added key \'constraints\' in table defenition by default. \'constraints\' contain dict with keys \'uniques\', \'checks\', \'references\'\n   it this is a COSTRAINT .. CHECK \'checks\' key will be still in data output, but it will be duplicated to \'constraints\': {\'checks\': ...}\n#. Added support for ALTER ADD ... UNIQUE\n#. Added support for CREATE CLUSTERED INDEX, if output_mode = \'mssql\' then index will have additional arg \'clustered\'.\n#. Added support for DESC & NULLS in CREATE INDEX statements. Detailed information places in key \'detailed_columns\' in \'indexes\', example: \'\n   \'index\': [{\'clustered\': False,\n   .. code-block::\n\n               \'columns\': [\'extra_funds\'],\n               \'detailed_columns\': [{\'name\': \'extra_funds\',\n                                       \'nulls\': \'LAST\',\n                                       \'order\': \'ASC\'}],\n\n#. Added support for statement ALTER TABLE ... ADD CONSTRAINT ... DEFAULT ... FOR ... ;\n\n**v0.11.0**\n\n\n#. Now table can has name \'table\'\n#. Added base support for statement CREATE TYPE:  AS ENUM, AS OBJECT, INTERNALLENGTH, INPUT, OUTPUT (not all properties & types supported yet.)\n#. Added argument \'group_by_type\' in \'run\' method that will group output by type of parsed entities like: \n   \'tables\': [all_pasrsed_tables], \'sequences\': [all_pasrsed_sequences], \'types\': [all_pasrsed_types], \'domains\': [all_pasrsed_domains]\n#. Type in column defenition also can be "schema"."YourCustomType"\n#. " now are not dissapeared if you use them in DDL.\n',
    'author': 'Iuliia Volkova',
    'author_email': 'xnuinside@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/xnuinside/simple-ddl-parser',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
