LOCAL_FILE_URI_PREFIX = "file:"

SITE_ID_HELP = """The id or name of the building site. This enables path configurations
that include the site id to differentiate between different datasets."""

STORE_URI_HELP = """The URI where the generated data and models should be stored. If not
provided, the function will search for an `EENSIGHT_STORE_URI` environmemt variable."""

NAMESPACE_HELP = """There are three (3) namespaces in eensight: train, test, apply.
Datasets and pipelines that exist in the train namespace will be used for baseline model
training. Datasets and pipelines that exist in the test namespace will be used for baseline
model evaluation. Datasets and pipelines that exist in the apply namespace will be used for
counterfactual prediction (during reporting period). The default value is `train`."""

AUTO_HELP = """Flag to indicate that out-of-sample and counterfactual predictions should
use the autoencoding approach."""

INPUT_URI_HELP = """The URI where the input data can be found. If provided, the input features
are expected to be found at `{{ input_uri }}/{{ namespace }}/features` and the input labels
at `{{ input_uri }}/{{ namespace }}/labels`. If not provided, eensight will use
`{{ store_uri }}/{{ site_id }}/01_raw/{{ namespace }}/features` path as default for the input
features and `{{ store_uri }}/{{ site_id }}/01_raw/{{ namespace }}/labels` for the input labels."""

BATCH_HELP = """The batch id for the input data (features and labels) to apply the pipelines on.
In eensight, training and testing of pipelines (`train` and `test` namespaces) is done on specific
datasets, but applying the pipelines (`apply` namespace) can be done on different batches of the data.
If `batch` is provided, the input data is expected to be inside a `.../apply/{{ batch }}/features`
path for features and `.../apply/{{ batch }}/labels` for labels. If `--namespace` is not `apply`,
this option will be ignored since no `apply` pipeline (i.e. pipeline that operates on `apply` data)
will run. The default value is `None`."""

DISABLE_TRACKING_HELP = """Flag to disable MLflow tracking. By default, MLflow tracking is
enabled, which means: (a) all runs get a unique id (run_id), (b) all artifacts generated by
a run are saved in a `{{ store_uri }}/{{ site_id }}/tracked/{{ run_id}}/` path, and (c) all
parameters and metrics are stored by the MLflow tracking server. If disabled, (a) runs do not
get a run_id, (b) all artifacts generated are saved in a `{{ store_uri }}/{{ site_id }}/untracked/`
path, and (c) parameters and metrics are not stored by MLflow. If namespace is `apply`, MLflow
tracking is disabled automatically."""

EXP_NAME_HELP = """The name of the experiment for experiment tracking by MLflow. If not provided,
the MLflow default will be used. This argument will be ignored if MLflow tracking is disabled."""

TRACK_URI_HELP = """The URI of the local or remote MLflow tracking server to persist experiment
metrics. Acceptable URIs are SQLAlchemy-compatible database connection strings (e.g.
'sqlite:///path/to/file.db') or local filesystem URIs. If not provided, defaults to the
`MLFLOW_TRACKING_URI` environment variable if set, otherwise to `{{ store_uri }}/{{ site_id }}/mlruns`
if `store_uri` is a local directory."""

RUN_ID_HELP = """The ID string for the run that contains the artifacts to be used (by `test` and
`apply` pipelines) or updated (by `train` pipelines). If not provided and namespace is `train` and
MLflow tracking is enabled, a new run ID will be created. If not provided and namespace is `test`
or `apply`, the untracked artifacts will be used."""

FORMAT_HELP = (
    lambda x: f"""The file format of the dataset that contains the input {x}. The supported
file formats are csv, parquet and json. The default value is `csv`."""
)

FEATURES_FORMAT_HELP = FORMAT_HELP("features")
LABELS_FORMAT_HELP = FORMAT_HELP("labels")

LOAD_HELP = (
    lambda x, y: f"""The arguments for loading the dataset that contains the input {x}. For csv files,
the arguments are passed to pandas.read_csv (https://pandas.pydata.org/docs/reference/api/pandas.read_csv.html),
for json files to pandas.read_json (https://pandas.pydata.org/docs/reference/api/pandas.read_json.html) and
for parquet to pandas.read_parquet (https://pandas.pydata.org/docs/reference/api/pandas.read_parquet.html).
This option can be used multiple times, and each time the expected format is `--{y} key=value`. As an
example, `--{y} sep=,`."""
)

FEATURES_LOAD_HELP = LOAD_HELP("features", "f-load-arg")
LABELS_LOAD_HELP = LOAD_HELP("labesl", "l-load-arg")

PARAMS_ARG_HELP = """One or more extra parameters for the run. This option can be used
multiple times. Each parameter should be provided in `key=value` format. Hierarchical
structure can be defined by using dot-lists, such as '--param a.bb.ccc=1'."""

FROM_INPUTS_HELP = """A comma-separated list of artifact names which should be used as
the starting point of the run."""

TO_OUTPUTS_HELP = """A comma-separated list of artifact names which should be used as
the end point."""

FROM_NODES_HELP = """A comma-separated list of node names which should be used as the
starting point."""

TO_NODES_HELP = """A comma-separated list of node names which should be used as the
end point."""

NODE_ARG_HELP = """Run only nodes with specified names. This option can be used multiple
times."""

RUNNER_ARG_HELP = """Specify a runner that you want to run the pipeline with. Available
runners: `SequentialRunner`, `ParallelRunner` and `ThreadRunner`. The default is
`SequentialRunner`."""

TAG_ARG_HELP = """One or more tags for the run. The tags are logged in the MLflow tracking
server, so they will be ignored if MLflow tracking is disabled. They should be provided in
`key=value` format."""

CONFIG_FILE_HELP = """A YAML configuration file to load the run command arguments from. The
values provided by this file will fill in any missing arguments of the run command with the
expection of the `run_id` argument. This should be provided only through the command line. If
command line arguments are also provided, they will override the ones inside the configuration file."""
