"""
This module contains the common PennyLane footer data.
"""

FOOTER = {
    "footer_about": {
        "title": "PennyLane",
        "description": """\
        PennyLane is an open-source software framework for quantum
        machine learning, quantum chemistry, and quantum computing, 
        with the ability to run on all hardware.
        Maintained with ❤️ by Xanadu.
        """,
    },
    "footer_links": [
        {
            "title": "PennyLane",
            "links": [
                {
                    "name": "Home",
                    "href": "https://pennylane.ai/",
                },
                {
                    "name": "Learn",
                    "href": "https://pennylane.ai/qml",
                },
                {
                    "name": "Demonstrations",
                    "href": "https://pennylane.ai/qml/demonstrations.html",
                },
                {
                    "name": "Documentation",
                    "href": "https://docs.pennylane.ai/",
                },
                {
                    "name": "GitHub",
                    "href": "https://github.com/PennyLaneAI/pennylane",
                },
                {
                    "name": "Twitter",
                    "href": "https://twitter.com/pennylaneai",
                },
                {
                    "name": "Blog",
                    "href": "https://pennylane.ai/blog",
                },
            ],
        },
        {
            "title": "Xanadu",
            "links": [
                {
                    "name": "Home",
                    "href": "https://xanadu.ai/",
                },
                {"name": "About", "href": "https://xanadu.ai/about/"},
                {
                    "name": "Hardware",
                    "href": "https://xanadu.ai/photonics",
                },
                {"name": "Careers", "href": "https://xanadu.ai/careers/"},
                {"name": "Cloud", "href": "https://cloud.xanadu.ai"},
                {
                    "name": "Forum",
                    "href": "https://discuss.pennylane.ai/",
                },
                {
                    "name": "Blog",
                    "href": "https://xanadu.ai/blog",
                },
            ],
        },
    ],
    "footer_socials": [
        {"icon": "fab fa-twitter", "href": "https://twitter.com/PennyLaneAI"},
        {"icon": "fab fa-github", "href": "https://github.com/PennyLaneAI/pennylane"},
        {"icon": "fab fa-linkedin-in", "href": "https://linkedin.com/company/xanaduai/"},
        {"icon": "fab fa-discourse", "href": "https://discuss.pennylane.ai"},
        {
            "icon": "fab fa-slack",
            "href": "https://xanadu-quantum.slack.com/join/shared_invite/zt-nkwn25v9-H4hituCb_PUj4idG0MhSug#/shared-invite/email",
        },
        {"icon": "fas fa-rss", "href": "https://pennylane.ai/blog/"},
    ],
    "footer_tagline": {
        "text": "Stay updated with our newsletter",
        "href": "https://xanadu.us17.list-manage.com/subscribe?u=725f07a1d1a4337416c3129fd&id=294b062630",
    },
}
