# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/cli.ipynb (unless otherwise specified).

__all__ = ['run_forecast']

# Cell
import pandas as pd
import typer

from .api import (
    _paste_dynamic,
    _path_as_str,
    _prefix_as_path,
    _read_dynamic,
    fcst_from_config,
    parse_config,
    perform_backtest,
    read_data,
    setup_client,
)

# Internal Cell
app = typer.Typer()

# Cell
@app.command()
def run_forecast(config_file: str):
    """Run the forecasting pipeline using the configuration defined in `config_file`."""
    config = parse_config(config_file)
    is_distributed = config.distributed is not None
    if config.distributed is not None:  # mypy
        client = setup_client(config.distributed.cluster)
    try:
        data = read_data(config.data, is_distributed)
        dynamic_dfs = _read_dynamic(config.data)
        data = _paste_dynamic(data, dynamic_dfs, is_distributed)

        path = _prefix_as_path(config.data.prefix)
        output_path = path / config.data.output
        output_path.mkdir(exist_ok=True)

        fcst = fcst_from_config(config)
        if config.backtest is not None:
            perform_backtest(fcst, data, config, output_path, dynamic_dfs)
        if config.forecast is not None:
            fcst.fit(
                data,
                static_features=config.features.static_features,
                keep_last_n=config.features.keep_last_n,
            )
            preds = fcst.predict(config.forecast.horizon, dynamic_dfs)
            writer = getattr(preds, f'to_{config.data.format}')
            write_path = _path_as_str(output_path / 'forecast')
            if isinstance(data, pd.DataFrame):
                write_path += f'.{config.data.format}'
            writer(write_path)
    except Exception as e:
        raise e
    finally:
        if is_distributed:
            client.cluster.close()
            client.close()
