"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpnGateway = exports.VpnGatewayProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "VpnGatewayProperty", { enumerable: true, get: function () { return vpc_generated_1.RosVpnGateway; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::VpnGateway`
 */
class VpnGateway extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::VpnGateway`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosVpnGateway = new vpc_generated_1.RosVpnGateway(this, id, {
            enableIpsec: props.enableIpsec ? props.enableIpsec : true,
            enableSsl: props.enableSsl ? props.enableSsl : false,
            sslConnections: props.sslConnections,
            description: props.description,
            vpcId: props.vpcId,
            instanceChargeType: props.instanceChargeType ? props.instanceChargeType : 'PREPAY',
            bandwidth: props.bandwidth,
            vSwitchId: props.vSwitchId,
            period: props.period,
            autoPay: props.autoPay ? props.autoPay : false,
            tags: props.tags,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosVpnGateway;
        this.attrInternetIp = rosVpnGateway.attrInternetIp;
        this.attrOrderId = rosVpnGateway.attrOrderId;
        this.attrSpec = rosVpnGateway.attrSpec;
        this.attrSslMaxConnections = rosVpnGateway.attrSslMaxConnections;
        this.attrVpnGatewayId = rosVpnGateway.attrVpnGatewayId;
    }
}
exports.VpnGateway = VpnGateway;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidnBuZ2F0ZXdheS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInZwbmdhdGV3YXkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsOENBQThDO0FBQzlDLG1EQUFnRDtBQUV0QixtR0FGakIsNkJBQWEsT0FFc0I7QUErRTVDOztHQUVHO0FBQ0gsTUFBYSxVQUFXLFNBQVEsR0FBRyxDQUFDLFFBQVE7SUFnQ3hDOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBc0IsRUFBRSxtQ0FBMkMsSUFBSTtRQUNqSCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sYUFBYSxHQUFHLElBQUksNkJBQWEsQ0FBQyxJQUFJLEVBQUUsRUFBRSxFQUFHO1lBQy9DLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxJQUFJO1lBQ3pELFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxLQUFLO1lBQ3BELGNBQWMsRUFBRSxLQUFLLENBQUMsY0FBYztZQUNwQyxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsS0FBSyxFQUFFLEtBQUssQ0FBQyxLQUFLO1lBQ2xCLGtCQUFrQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQyxRQUFRO1lBQ2xGLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztZQUMxQixTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVM7WUFDMUIsTUFBTSxFQUFFLEtBQUssQ0FBQyxNQUFNO1lBQ3BCLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxLQUFLO1lBQzlDLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSTtZQUNoQixJQUFJLEVBQUUsS0FBSyxDQUFDLElBQUk7U0FDbkIsRUFBRSxnQ0FBZ0MsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLGdDQUFnQyxDQUFDLENBQUM7UUFDcEYsSUFBSSxDQUFDLFFBQVEsR0FBRyxhQUFhLENBQUM7UUFDOUIsSUFBSSxDQUFDLGNBQWMsR0FBRyxhQUFhLENBQUMsY0FBYyxDQUFDO1FBQ25ELElBQUksQ0FBQyxXQUFXLEdBQUcsYUFBYSxDQUFDLFdBQVcsQ0FBQztRQUM3QyxJQUFJLENBQUMsUUFBUSxHQUFHLGFBQWEsQ0FBQyxRQUFRLENBQUM7UUFDdkMsSUFBSSxDQUFDLHFCQUFxQixHQUFHLGFBQWEsQ0FBQyxxQkFBcUIsQ0FBQztRQUNqRSxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsYUFBYSxDQUFDLGdCQUFnQixDQUFDO0lBQzNELENBQUM7Q0FDSjtBQS9ERCxnQ0ErREMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyByb3MgZnJvbSAnQGFsaWNsb3VkL3Jvcy1jZGstY29yZSc7XG5pbXBvcnQgeyBSb3NWcG5HYXRld2F5IH0gZnJvbSAnLi92cGMuZ2VuZXJhdGVkJztcbi8vIEdlbmVyYXRlZCBmcm9tIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgU3BlY2lmaWNhdGlvblxuZXhwb3J0IHsgUm9zVnBuR2F0ZXdheSBhcyBWcG5HYXRld2F5UHJvcGVydHkgfTtcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBBTElZVU46OlZQQzo6VnBuR2F0ZXdheWBcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBWcG5HYXRld2F5UHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgYmFuZHdpZHRoOiBUaGUgcHVibGljIG5ldHdvcmsgYmFuZHdpZHRoIG9mIHRoZSBWUE4gZ2F0ZXdheSwgaW4gTWJwcy5cbiAgICAgKiBWYWx1ZTogNXwxMHwyMHw1MHwxMDB8MjAwLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGJhbmR3aWR0aDogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgdnBjSWQ6IFZQQyBJRCB0byB3aGljaCB0aGUgVlBOIGdhdGV3YXkgYmVsb25ncy5cbiAgICAgKi9cbiAgICByZWFkb25seSB2cGNJZDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgYXV0b1BheTogV2hldGhlciB0byBhdXRvbWF0aWNhbGx5IHBheSB0aGUgYmlsbCBvZiB0aGUgVlBOIGdhdGV3YXksIHRoZSB2YWx1ZTpcbiAgICAgKiBUcnVlOiBBdXRvbWF0aWNhbGx5IHBheXMgdGhlIGJpbGwgZm9yIHRoZSBWUE4gZ2F0ZXdheS5cbiAgICAgKiBGYWxzZSAoZGVmYXVsdCk6IERvZXMgbm90IGF1dG9tYXRpY2FsbHkgcGF5IHRoZSBiaWxsIGZvciB0aGUgVlBOIGdhdGV3YXkuXG4gICAgICovXG4gICAgcmVhZG9ubHkgYXV0b1BheT86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkZXNjcmlwdGlvbjogRGVzY3JpcHRpb24gb2YgdGhlIFZQTiBnYXRld2F5LlxuICAgICAqIFRoZSBsZW5ndGggaXMgMi0yNTYgY2hhcmFjdGVycyBhbmQgbXVzdCBzdGFydCB3aXRoIGEgbGV0dGVyIG9yIENoaW5lc2UsIGJ1dCBjYW5ub3Qgc3RhcnQgd2l0aCBodHRwOi8vIG9yIGh0dHBzOi8vLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRlc2NyaXB0aW9uPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZW5hYmxlSXBzZWM6IFdoZXRoZXIgdG8gZW5hYmxlIElQc2VjLVZQTi4gVGhlIElQc2VjLVZQTiBmZWF0dXJlIHByb3ZpZGVzIGEgc2l0ZS10by1zaXRlIGNvbm5lY3Rpb24uIFlvdSBjYW4gc2VjdXJlbHkgY29ubmVjdCB5b3VyIGxvY2FsIGRhdGEgY2VudGVyIG5ldHdvcmsgdG8gYSBwcml2YXRlIG5ldHdvcmsgb3IgdHdvIHByb3ByaWV0YXJ5IG5ldHdvcmtzIGJ5IGNyZWF0aW5nIGFuIElQc2VjIHR1bm5lbC4gVmFsdWU6XG4gICAgICogVHJ1ZSAoZGVmYXVsdCk6IEVuYWJsZXMgdGhlIElQc2VjLVZQTiBmZWF0dXJlLlxuICAgICAqIEZhbHNlOiBUaGUgSVBzZWMtVlBOIGZ1bmN0aW9uIGlzIG5vdCBlbmFibGVkLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVuYWJsZUlwc2VjPzogYm9vbGVhbiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGVuYWJsZVNzbDogRW5hYmxlIHRoZSBTU0wtVlBOIGZ1bmN0aW9uLiBQcm92aWRlIHBvaW50LXRvLXNpdGUgVlBOIGNvbm5lY3Rpb24sIG5vIG5lZWQgdG8gY29uZmlndXJlIGN1c3RvbWVyIGdhdGV3YXksIHRlcm1pbmFsIGRpcmVjdGx5IGFjY2Vzcy4gVmFsdWU6XG4gICAgICogVHJ1ZTogRW5hYmxlIFNTTC1WUE4uXG4gICAgICogRmFsc2UgKGRlZmF1bHQpOiBEb2VzIG5vdCBlbmFibGUgU1NMLVZQTi5cbiAgICAgKi9cbiAgICByZWFkb25seSBlbmFibGVTc2w/OiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgaW5zdGFuY2VDaGFyZ2VUeXBlOiBBY2NvdW50aW5nIHR5cGUgb2YgdGhlIFZQTiBnYXRld2F5LCB0aGUgdmFsdWUgaXM6XG4gICAgICogUFJFUEFZLCBQT1NUUEFZXG4gICAgICovXG4gICAgcmVhZG9ubHkgaW5zdGFuY2VDaGFyZ2VUeXBlPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgbmFtZTogTmFtZSBvZiB0aGUgVlBOIGdhdGV3YXkuIFRoZSBkZWZhdWx0IHZhbHVlIGlzIHRoZSBJRCBvZiB0aGUgVlBOIGdhdGV3YXkuXG4gICAgICogVGhlIGxlbmd0aCBpcyAyfjEwMCBFbmdsaXNoIG9yIENoaW5lc2UgY2hhcmFjdGVycy4gSXQgbXVzdCBzdGFydCB3aXRoIGEgbGFyZ2Ugb3Igc21hbGwgbGV0dGVyIG9yIENoaW5lc2UuIEl0IGNhbiBjb250YWluIG51bWJlcnMsIHVuZGVyc2NvcmVzIChfKSBhbmQgZGFzaGVzICgtKS4gSXQgY2Fubm90IHN0YXJ0IHdpdGggaHR0cDovLyBvciBodHRwczovLy5cbiAgICAgKi9cbiAgICByZWFkb25seSBuYW1lPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcGVyaW9kOiBQdXJjaGFzZSB0aW1lLCB2YWx1ZTogMX45fDEyfDI0fDM2LlxuICAgICAqIFdoZW4gdGhlIHZhbHVlIG9mIHRoZSBJbnN0YW5jZUNoYXJnZVR5cGUgcGFyYW1ldGVyIGlzIFBSRVBBWSwgdGhpcyBwYXJhbWV0ZXIgaXMgbWFuZGF0b3J5LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHBlcmlvZD86IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHNzbENvbm5lY3Rpb25zOiBUaGUgbWF4aW11bSBudW1iZXIgb2YgY2xpZW50cyBhbGxvd2VkIHRvIGNvbm5lY3QgYXQgdGhlIHNhbWUgdGltZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBzc2xDb25uZWN0aW9ucz86IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHRhZ3M6IFRhZ3MgdG8gYXR0YWNoIHRvIGluc3RhbmNlLiBNYXggc3VwcG9ydCAyMCB0YWdzIHRvIGFkZCBkdXJpbmcgY3JlYXRlIGluc3RhbmNlLiBFYWNoIHRhZyB3aXRoIHR3byBwcm9wZXJ0aWVzIEtleSBhbmQgVmFsdWUsIGFuZCBLZXkgaXMgcmVxdWlyZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFncz86IFJvc1ZwbkdhdGV3YXkuVGFnc1Byb3BlcnR5W107XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB2U3dpdGNoSWQ6IFRoZSBJRCBvZiB0aGUgVlN3aXRjaCB0byB3aGljaCB0aGUgVlBOIGdhdGV3YXkgYmVsb25ncy5cbiAgICAgKi9cbiAgICByZWFkb25seSB2U3dpdGNoSWQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogQSBST1MgcmVzb3VyY2UgdHlwZTogIGBBTElZVU46OlZQQzo6VnBuR2F0ZXdheWBcbiAqL1xuZXhwb3J0IGNsYXNzIFZwbkdhdGV3YXkgZXh0ZW5kcyByb3MuUmVzb3VyY2Uge1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIHByb3BlcnRpZXMgb2YgdGhpcyBST1MgcmVzb3VyY2UsIHdoaWNoIHdpbGwgYmUgYXNzaWduZWQgdG8gUk9TIHJlc291cmNlLlxuICAgICAqL1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIEludGVybmV0SXA6IFRoZSBwdWJsaWMgSVAgYWRkcmVzcyBvZiB0aGUgVlBOIGdhdGV3YXkuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJJbnRlcm5ldElwOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgT3JkZXJJZDogVGhlIG9yZGVyIElELlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyT3JkZXJJZDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIFNwZWM6IFRoZSBzcGVjaWZpY2F0aW9uIG9mIHRoZSBWUE4gZ2F0ZXdheS5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0clNwZWM6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBTc2xNYXhDb25uZWN0aW9uczogVGhlIG1heGltdW0gbnVtYmVyIG9mIGNvbmN1cnJlbnQgU1NMLVZQTiBjb25uZWN0aW9ucy5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0clNzbE1heENvbm5lY3Rpb25zOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgVnBuR2F0ZXdheUlkOiBJRCBvZiB0aGUgVlBOIGdhdGV3YXkuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJWcG5HYXRld2F5SWQ6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQUxJWVVOOjpWUEM6OlZwbkdhdGV3YXlgLlxuICAgICAqXG4gICAgICogUGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBQYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBQYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogcm9zLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFZwbkdhdGV3YXlQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgICAgICBjb25zdCByb3NWcG5HYXRld2F5ID0gbmV3IFJvc1ZwbkdhdGV3YXkodGhpcywgaWQsICB7XG4gICAgICAgICAgICBlbmFibGVJcHNlYzogcHJvcHMuZW5hYmxlSXBzZWMgPyBwcm9wcy5lbmFibGVJcHNlYyA6IHRydWUsXG4gICAgICAgICAgICBlbmFibGVTc2w6IHByb3BzLmVuYWJsZVNzbCA/IHByb3BzLmVuYWJsZVNzbCA6IGZhbHNlLFxuICAgICAgICAgICAgc3NsQ29ubmVjdGlvbnM6IHByb3BzLnNzbENvbm5lY3Rpb25zLFxuICAgICAgICAgICAgZGVzY3JpcHRpb246IHByb3BzLmRlc2NyaXB0aW9uLFxuICAgICAgICAgICAgdnBjSWQ6IHByb3BzLnZwY0lkLFxuICAgICAgICAgICAgaW5zdGFuY2VDaGFyZ2VUeXBlOiBwcm9wcy5pbnN0YW5jZUNoYXJnZVR5cGUgPyBwcm9wcy5pbnN0YW5jZUNoYXJnZVR5cGUgOiAnUFJFUEFZJyxcbiAgICAgICAgICAgIGJhbmR3aWR0aDogcHJvcHMuYmFuZHdpZHRoLFxuICAgICAgICAgICAgdlN3aXRjaElkOiBwcm9wcy52U3dpdGNoSWQsXG4gICAgICAgICAgICBwZXJpb2Q6IHByb3BzLnBlcmlvZCxcbiAgICAgICAgICAgIGF1dG9QYXk6IHByb3BzLmF1dG9QYXkgPyBwcm9wcy5hdXRvUGF5IDogZmFsc2UsXG4gICAgICAgICAgICB0YWdzOiBwcm9wcy50YWdzLFxuICAgICAgICAgICAgbmFtZTogcHJvcHMubmFtZSxcbiAgICAgICAgfSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgJiYgdGhpcy5zdGFjay5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XG4gICAgICAgIHRoaXMucmVzb3VyY2UgPSByb3NWcG5HYXRld2F5O1xuICAgICAgICB0aGlzLmF0dHJJbnRlcm5ldElwID0gcm9zVnBuR2F0ZXdheS5hdHRySW50ZXJuZXRJcDtcbiAgICAgICAgdGhpcy5hdHRyT3JkZXJJZCA9IHJvc1ZwbkdhdGV3YXkuYXR0ck9yZGVySWQ7XG4gICAgICAgIHRoaXMuYXR0clNwZWMgPSByb3NWcG5HYXRld2F5LmF0dHJTcGVjO1xuICAgICAgICB0aGlzLmF0dHJTc2xNYXhDb25uZWN0aW9ucyA9IHJvc1ZwbkdhdGV3YXkuYXR0clNzbE1heENvbm5lY3Rpb25zO1xuICAgICAgICB0aGlzLmF0dHJWcG5HYXRld2F5SWQgPSByb3NWcG5HYXRld2F5LmF0dHJWcG5HYXRld2F5SWQ7XG4gICAgfVxufVxuIl19