"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpnConnection = exports.VpnConnectionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "VpnConnectionProperty", { enumerable: true, get: function () { return vpc_generated_1.RosVpnConnection; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::VpnConnection`
 */
class VpnConnection extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::VpnConnection`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosVpnConnection = new vpc_generated_1.RosVpnConnection(this, id, {
            localSubnet: props.localSubnet,
            effectImmediately: props.effectImmediately ? props.effectImmediately : false,
            remoteSubnet: props.remoteSubnet,
            customerGatewayId: props.customerGatewayId,
            vpnGatewayId: props.vpnGatewayId,
            ipsecConfig: props.ipsecConfig,
            healthCheckConfig: props.healthCheckConfig,
            ikeConfig: props.ikeConfig,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosVpnConnection;
        this.attrPeerVpnConnectionConfig = rosVpnConnection.attrPeerVpnConnectionConfig;
        this.attrStatus = rosVpnConnection.attrStatus;
        this.attrVpnConnectionId = rosVpnConnection.attrVpnConnectionId;
    }
}
exports.VpnConnection = VpnConnection;
//# sourceMappingURL=data:application/json;base64,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