"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SslVpnServer = exports.SslVpnServerProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "SslVpnServerProperty", { enumerable: true, get: function () { return vpc_generated_1.RosSslVpnServer; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::SslVpnServer`
 */
class SslVpnServer extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::SslVpnServer`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosSslVpnServer = new vpc_generated_1.RosSslVpnServer(this, id, {
            compress: props.compress ? props.compress : false,
            localSubnet: props.localSubnet,
            clientIpPool: props.clientIpPool,
            proto: props.proto ? props.proto : 'UDP',
            vpnGatewayId: props.vpnGatewayId,
            port: props.port ? props.port : 1194,
            cipher: props.cipher ? props.cipher : 'AES-128-CBC',
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSslVpnServer;
        this.attrSslVpnServerId = rosSslVpnServer.attrSslVpnServerId;
    }
}
exports.SslVpnServer = SslVpnServer;
//# sourceMappingURL=data:application/json;base64,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