"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnycastEIPAssociation = exports.AnycastEIPAssociationProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "AnycastEIPAssociationProperty", { enumerable: true, get: function () { return vpc_generated_1.RosAnycastEIPAssociation; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::AnycastEIPAssociation`
 */
class AnycastEIPAssociation extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::AnycastEIPAssociation`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosAnycastEIPAssociation = new vpc_generated_1.RosAnycastEIPAssociation(this, id, {
            bindInstanceId: props.bindInstanceId,
            bindInstanceRegionId: props.bindInstanceRegionId,
            bindInstanceType: props.bindInstanceType,
            anycastId: props.anycastId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAnycastEIPAssociation;
        this.attrAnycastId = rosAnycastEIPAssociation.attrAnycastId;
        this.attrBindInstanceId = rosAnycastEIPAssociation.attrBindInstanceId;
        this.attrBindInstanceRegionId = rosAnycastEIPAssociation.attrBindInstanceRegionId;
        this.attrBindInstanceType = rosAnycastEIPAssociation.attrBindInstanceType;
    }
}
exports.AnycastEIPAssociation = AnycastEIPAssociation;
//# sourceMappingURL=data:application/json;base64,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