# -*- coding: utf-8 -*-
#
# Copyright (c) 2015, Alcatel-Lucent Inc
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of the copyright holder nor the names of its contributors
#       may be used to endorse or promote products derived from this software without
#       specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.



from .fetchers import NUBFDSessionsFetcher

from bambou import NURESTObject


class NUBRConnection(NURESTObject):
    """ Represents a BRConnection in the VSD

        Notes:
            None
    """

    __rest_name__ = "brconnections"
    __resource_name__ = "brconnections"

    
    ## Constants
    
    CONST_ADVERTISEMENT_CRITERIA_LINK_BASED = "LINK_BASED"
    
    CONST_ADVERTISEMENT_CRITERIA_BFD = "BFD"
    
    CONST_ADVERTISEMENT_CRITERIA_OPENFLOW = "OPENFLOW"
    
    CONST_MODE_STATIC = "Static"
    
    

    def __init__(self, **kwargs):
        """ Initializes a BRConnection instance

            Notes:
                You can specify all parameters while calling this methods.
                A special argument named `data` will enable you to load the
                object from a Python dictionary

            Examples:
                >>> brconnection = NUBRConnection(id=u'xxxx-xxx-xxx-xxx', name=u'BRConnection')
                >>> brconnection = NUBRConnection(data=my_dict)
        """

        super(NUBRConnection, self).__init__()

        # Read/Write Attributes
        
        self._dns_address = None
        self._gateway = None
        self._address = None
        self._advertisement_criteria = None
        self._netmask = None
        self._mode = None
        self._uplink_id = None
        
        self.expose_attribute(local_name="dns_address", remote_name="DNSAddress", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="gateway", remote_name="gateway", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="address", remote_name="address", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="advertisement_criteria", remote_name="advertisementCriteria", attribute_type=str, is_required=False, is_unique=False, choices=[u'BFD', u'LINK_BASED', u'OPENFLOW'])
        self.expose_attribute(local_name="netmask", remote_name="netmask", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="mode", remote_name="mode", attribute_type=str, is_required=False, is_unique=False, choices=[u'Static'])
        self.expose_attribute(local_name="uplink_id", remote_name="uplinkID", attribute_type=int, is_required=False, is_unique=False)
        

        # Fetchers
        
        
        self.bfd_sessions = NUBFDSessionsFetcher.fetcher_with_object(parent_object=self, relationship="child")
        

        self._compute_args(**kwargs)

    # Properties
    
    @property
    def dns_address(self):
        """ Get dns_address value.

            Notes:
                DNS Address for the vlan

                
                This attribute is named `DNSAddress` in VSD API.
                
        """
        return self._dns_address

    @dns_address.setter
    def dns_address(self, value):
        """ Set dns_address value.

            Notes:
                DNS Address for the vlan

                
                This attribute is named `DNSAddress` in VSD API.
                
        """
        self._dns_address = value

    
    @property
    def gateway(self):
        """ Get gateway value.

            Notes:
                IP address of the gateway bound to the VLAN.

                
        """
        return self._gateway

    @gateway.setter
    def gateway(self, value):
        """ Set gateway value.

            Notes:
                IP address of the gateway bound to the VLAN.

                
        """
        self._gateway = value

    
    @property
    def address(self):
        """ Get address value.

            Notes:
                Static IP address for the VLAN

                
        """
        return self._address

    @address.setter
    def address(self, value):
        """ Set address value.

            Notes:
                Static IP address for the VLAN

                
        """
        self._address = value

    
    @property
    def advertisement_criteria(self):
        """ Get advertisement_criteria value.

            Notes:
                Advertisement Criteria for Traffic Flow

                
                This attribute is named `advertisementCriteria` in VSD API.
                
        """
        return self._advertisement_criteria

    @advertisement_criteria.setter
    def advertisement_criteria(self, value):
        """ Set advertisement_criteria value.

            Notes:
                Advertisement Criteria for Traffic Flow

                
                This attribute is named `advertisementCriteria` in VSD API.
                
        """
        self._advertisement_criteria = value

    
    @property
    def netmask(self):
        """ Get netmask value.

            Notes:
                network mask

                
        """
        return self._netmask

    @netmask.setter
    def netmask(self, value):
        """ Set netmask value.

            Notes:
                network mask

                
        """
        self._netmask = value

    
    @property
    def mode(self):
        """ Get mode value.

            Notes:
                Connection mode: Static.

                
        """
        return self._mode

    @mode.setter
    def mode(self, value):
        """ Set mode value.

            Notes:
                Connection mode: Static.

                
        """
        self._mode = value

    
    @property
    def uplink_id(self):
        """ Get uplink_id value.

            Notes:
                Internally generated ID in the range that idenitifies the uplink within the cotext of NSG

                
                This attribute is named `uplinkID` in VSD API.
                
        """
        return self._uplink_id

    @uplink_id.setter
    def uplink_id(self, value):
        """ Set uplink_id value.

            Notes:
                Internally generated ID in the range that idenitifies the uplink within the cotext of NSG

                
                This attribute is named `uplinkID` in VSD API.
                
        """
        self._uplink_id = value

    

    