"""
  selection of composition integration methods
    
  always of the form:
    name(EVOLVEA,EVOLVEB,dt)

  in case EVOLVEA and EVOLVEB are symplectic, the compositions
  are symplectic

    
  included:
    LEAPFROG
    SPLIT_4TH_S_M6
    SPLIT_4TH_S_M5
    SPLIT_4TH_S_M4
    SPLIT_6TH_SS_M11
    SPLIT_6TH_SS_M13
    SPLIT_8TH_SS_M21
    SPLIT_10TH_SS_M35
"""

def LEAPFROG( EVOLVEA, EVOLVEB,dt):
  EVOLVEA(dt/2)
  EVOLVEB(dt)
  EVOLVEA(dt/2)

def SPLIT_4TH_S_M6(EVOLVEA,EVOLVEB,dt): 
  K1 = 0.0792036964311957
  K2 = 0.353172906049774
  K3 = -.0420650803577195
  K4 = 1. - 2*(K1 + K2 + K3)
  D1 = 0.209515106613362
  D2 = -.143851773179818
  D3 = 0.5 - D1 - D2
  EVOLVEA(K1*dt) 
  EVOLVEB(D1*dt) 
  EVOLVEA(K2*dt) 
  EVOLVEB(D2*dt) 
  EVOLVEA(K3*dt) 
  EVOLVEB(D3*dt) 
  EVOLVEA(K4*dt) 
  EVOLVEB(D3*dt) 
  EVOLVEA(K3*dt) 
  EVOLVEB(D2*dt) 
  EVOLVEA(K2*dt) 
  EVOLVEB(D1*dt) 
  EVOLVEA(K1*dt)

def SPLIT_4TH_S_M5(EVOLVEA,EVOLVEB,dt):
  K1 = ( (14-(19.**0.5))/108 )
  K2 = ( (20-7*(19.**0.5))/108 )
  K3 = ( (1/2.)-(K1+K2) )
  D1 = ( 2/5. )
  D2 = ( -1/10. )
  D3 = ( 1-(2*D1+2*D2) )
  EVOLVEA(K1*dt)
  EVOLVEB(D1*dt)
  EVOLVEA(K2*dt)
  EVOLVEB(D2*dt)
  EVOLVEA(K3*dt)
  EVOLVEB(D3*dt)
  EVOLVEA(K3*dt)
  EVOLVEB(D2*dt)
  EVOLVEA(K2*dt)
  EVOLVEB(D1*dt)
  EVOLVEA(K1*dt)

def SPLIT_4TH_S_M4(EVOLVEA,EVOLVEB,dt):
  K1 = ( (642+( 471.**0.5 ))/3924 )
  K2 = (  121*(12- ( 471.**0.5 ) )/3924 )
  K3 = ( 1.-2*(K1+K2) )
  D1 = ( 6/11. )
  D2 = ( 0.5 - D1 )
  EVOLVEA(K1*dt)
  EVOLVEB(D1*dt)
  EVOLVEA(K2*dt)
  EVOLVEB(D2*dt)
  EVOLVEA(K3*dt)
  EVOLVEB(D2*dt)
  EVOLVEA(K2*dt)
  EVOLVEB(D1*dt)
  EVOLVEA(K1*dt)

# symmetric composition of symmetric maps, 6th order, m=11
def SPLIT_6TH_SS_M11(EVOLVEA,EVOLVEB,dt):
  C1 = (  0.21375583945878254555518066964857 )
  C2 = (  0.18329381407425713911385974425217 )
  C3 = (  0.17692819473098943794898811709929 )
  C4 = ( -0.44329082681170215849622829626258 )
  C5 = (  0.11728560432865935385403585669136 )
  C6 = (  0.50405474843802736404832781714239 )
  EVOLVEA(C1*dt/2)
  EVOLVEB(C1*dt)
  EVOLVEA((C1+C2)*dt/2)
  EVOLVEB(C2*dt)
  EVOLVEA((C2+C3)*dt/2)
  EVOLVEB(C3*dt)
  EVOLVEA((C3+C4)*dt/2)
  EVOLVEB(C4*dt)
  EVOLVEA((C4+C5)*dt/2)
  EVOLVEB(C5*dt)
  EVOLVEA((C5+C6)*dt/2)
  EVOLVEB(C6*dt)
  EVOLVEA((C5+C6)*dt/2)
  EVOLVEB(C5*dt)
  EVOLVEA((C4+C5)*dt/2)
  EVOLVEB(C4*dt)
  EVOLVEA((C3+C4)*dt/2)
  EVOLVEB(C3*dt)
  EVOLVEA((C2+C3)*dt/2)
  EVOLVEB(C2*dt)
  EVOLVEA((C1+C2)*dt/2)
  EVOLVEB(C1*dt)
  EVOLVEA(C1*dt/2)

# symmetric composition of symmetric maps, 6th order, m=13
def SPLIT_6TH_SS_M13(EVOLVEA,EVOLVEB,dt):
  C1 = (  0.13861930854051695245808013042625 )
  C2 = (  0.13346562851074760407046858832209 )
  C3 = (  0.13070531011449225190542755785015 )
  C4 = (  0.12961893756907034772505366537091 )
  C5 = ( -0.35000324893920896516170830911323 )
  C6 = (  0.11805530653002387170273438954049 )
  C7 = (  0.39907751534871587459988795520665 )
  EVOLVEA(C1*dt/2)
  EVOLVEB(C1*dt)
  EVOLVEA((C1+C2)*dt/2)
  EVOLVEB(C2*dt)
  EVOLVEA((C2+C3)*dt/2)
  EVOLVEB(C3*dt)
  EVOLVEA((C3+C4)*dt/2)
  EVOLVEB(C4*dt)
  EVOLVEA((C4+C5)*dt/2)
  EVOLVEB(C5*dt)
  EVOLVEA((C5+C6)*dt/2)
  EVOLVEB(C6*dt)
  EVOLVEA((C6+C7)*dt/2)
  EVOLVEB(C7*dt)
  EVOLVEA((C6+C7)*dt/2)
  EVOLVEB(C6*dt)
  EVOLVEA((C5+C6)*dt/2)
  EVOLVEB(C5*dt)
  EVOLVEA((C4+C5)*dt/2)
  EVOLVEB(C4*dt)
  EVOLVEA((C3+C4)*dt/2)
  EVOLVEB(C3*dt)
  EVOLVEA((C2+C3)*dt/2)
  EVOLVEB(C2*dt)
  EVOLVEA((C1+C2)*dt/2)
  EVOLVEB(C1*dt)
  EVOLVEA(C1*dt/2)


# symmetric composition of symmetric maps, 8th order, m=21
def SPLIT_8TH_SS_M21(EVOLVEA,EVOLVEB,dt):
  C1  = (  0.10647728984550031823931967854896 )
  C2  = (  0.10837408645835726397433410591546 )
  C3  = (  0.35337821052654342419534541324080 )
  C4  = ( -0.23341414023165082198780281128319 )
  C5  = ( -0.24445266791528841269462171413216 )
  C6  = (  0.11317848435755633314700952515599 )
  C7  = (  0.11892905625000350062692972283951 )
  C8  = (  0.12603912321825988140305670268365 )
  C9  = (  0.12581718736176041804392391641587 )
  C10 = (  0.11699135019217642180722881433533 )
  C11 = ( -0.38263596012643665350944670744040 )
  EVOLVEA(C1*dt/2)
  EVOLVEB(C1*dt)
  EVOLVEA((C1+C2)*dt/2)
  EVOLVEB(C2*dt)
  EVOLVEA((C2+C3)*dt/2)
  EVOLVEB(C3*dt)
  EVOLVEA((C3+C4)*dt/2)
  EVOLVEB(C4*dt)
  EVOLVEA((C4+C5)*dt/2)
  EVOLVEB(C5*dt)
  EVOLVEA((C5+C6)*dt/2)
  EVOLVEB(C6*dt)
  EVOLVEA((C6+C7)*dt/2)
  EVOLVEB(C7*dt)
  EVOLVEA((C7+C8)*dt/2)
  EVOLVEB(C8*dt)
  EVOLVEA((C8+C9)*dt/2)
  EVOLVEB(C9*dt)
  EVOLVEA((C9+C10)*dt/2)
  EVOLVEB(C10*dt)
  EVOLVEA((C10+C11)*dt/2)
  EVOLVEB(C11*dt)
  EVOLVEA((C10+C11)*dt/2)
  EVOLVEB(C10*dt)
  EVOLVEA((C9+C10)*dt/2)
  EVOLVEB(C9*dt)
  EVOLVEA((C8+C9)*dt/2)
  EVOLVEB(C8*dt)
  EVOLVEA((C7+C8)*dt/2)
  EVOLVEB(C7*dt)
  EVOLVEA((C6+C7)*dt/2)
  EVOLVEB(C6*dt)
  EVOLVEA((C5+C6)*dt/2)
  EVOLVEB(C5*dt)
  EVOLVEA((C4+C5)*dt/2)
  EVOLVEB(C4*dt)
  EVOLVEA((C3+C4)*dt/2)
  EVOLVEB(C3*dt)
  EVOLVEA((C2+C3)*dt/2)
  EVOLVEB(C2*dt)
  EVOLVEA((C1+C2)*dt/2)
  EVOLVEB(C1*dt)
  EVOLVEA(C1*dt/2)


# symmetric composition of symmetric maps, 10th order, m=35
def SPLIT_10TH_SS_M35(EVOLVEA,EVOLVEB,dt):
  C1  = (  0.078795722521686419263907679337684 )
  C2  = (  0.31309610341510852776481247192647 )
  C3  = (  0.027918383235078066109520273275299 )
  C4  = ( -0.22959284159390709415121339679655 )
  C5  = (  0.13096206107716486317465685927961 )
  C6  = ( -0.26973340565451071434460973222411 )
  C7  = (  0.074973343155891435666137105641410 )
  C8  = (  0.11199342399981020488957508073640 )
  C9  = (  0.36613344954622675119314812353150 )
  C10 = ( -0.39910563013603589787862981058340 )
  C11 = (  0.10308739852747107731580277001372 )
  C12 = (  0.41143087395589023782070411897608 )
  C13 = ( -0.0048663605831352617621956593099771 )
  C14 = ( -0.39203335370863990644808193642610 )
  C15 = (  0.051942502962449647037182904015976 )
  C16 = (  0.050665090759924496335874344156866 )
  C17 = (  0.049674370639729879054568800279461 )
  C18 = (  0.049317735759594537917680008339338 )
  EVOLVEA(C1*dt/2)
  EVOLVEB(C1*dt)
  EVOLVEA((C1+C2)*dt/2)
  EVOLVEB(C2*dt)
  EVOLVEA((C2+C3)*dt/2)
  EVOLVEB(C3*dt)
  EVOLVEA((C3+C4)*dt/2)
  EVOLVEB(C4*dt)
  EVOLVEA((C4+C5)*dt/2)
  EVOLVEB(C5*dt)
  EVOLVEA((C5+C6)*dt/2)
  EVOLVEB(C6*dt)
  EVOLVEA((C6+C7)*dt/2)
  EVOLVEB(C7*dt)
  EVOLVEA((C7+C8)*dt/2)
  EVOLVEB(C8*dt)
  EVOLVEA((C8+C9)*dt/2)
  EVOLVEB(C9*dt)
  EVOLVEA((C9+C10)*dt/2)
  EVOLVEB(C10*dt)
  EVOLVEA((C10+C11)*dt/2)
  EVOLVEB(C11*dt)
  EVOLVEA((C11+C12)*dt/2)
  EVOLVEB(C12*dt)
  EVOLVEA((C12+C13)*dt/2)
  EVOLVEB(C13*dt)
  EVOLVEA((C13+C14)*dt/2)
  EVOLVEB(C14*dt)
  EVOLVEA((C14+C15)*dt/2)
  EVOLVEB(C15*dt)
  EVOLVEA((C15+C16)*dt/2)
  EVOLVEB(C16*dt)
  EVOLVEA((C16+C17)*dt/2)
  EVOLVEB(C17*dt)
  EVOLVEA((C17+C18)*dt/2)
  EVOLVEB(C18*dt)
  EVOLVEA((C17+C18)*dt/2)
  EVOLVEB(C17*dt)
  EVOLVEA((C16+C17)*dt/2)
  EVOLVEB(C16*dt)
  EVOLVEA((C15+C16)*dt/2)
  EVOLVEB(C15*dt)
  EVOLVEA((C14+C15)*dt/2)
  EVOLVEB(C14*dt)
  EVOLVEA((C13+C14)*dt/2)
  EVOLVEB(C13*dt)
  EVOLVEA((C12+C13)*dt/2)
  EVOLVEB(C12*dt)
  EVOLVEA((C11+C12)*dt/2)
  EVOLVEB(C11*dt)
  EVOLVEA((C10+C11)*dt/2)
  EVOLVEB(C10*dt)
  EVOLVEA((C9+C10)*dt/2)
  EVOLVEB(C9*dt)
  EVOLVEA((C8+C9)*dt/2)
  EVOLVEB(C8*dt)
  EVOLVEA((C7+C8)*dt/2)
  EVOLVEB(C7*dt)
  EVOLVEA((C6+C7)*dt/2)
  EVOLVEB(C6*dt)
  EVOLVEA((C5+C6)*dt/2)
  EVOLVEB(C5*dt)
  EVOLVEA((C4+C5)*dt/2)
  EVOLVEB(C4*dt)
  EVOLVEA((C3+C4)*dt/2)
  EVOLVEB(C3*dt)
  EVOLVEA((C2+C3)*dt/2)
  EVOLVEB(C2*dt)
  EVOLVEA((C1+C2)*dt/2)
  EVOLVEB(C1*dt)
  EVOLVEA(C1*dt/2)
