from enum import Enum

class Glass(Enum):
    COCKTAIL = "cocktail glass"
    HIGHBALL = "highball glass"
    OLD_FASHIONED = "old-fashioned glass"
    WHISKEY = "whiskey glass"
    COLLINS = "collins glass"
    POUSSE_CAFE = "pousse cafe glass"
    CHAMPAGNE_FLUTE = "champagne flute"
    WHISKEY_SOUR = "whiskey sour glass"
    CORDIAL = "cordial glass"
    BRANDY_SNIFTER = "brandy snifter"
    WHITE_WHINE = "white wine glass"
    NICK_AND_NORA = "nick and nora Glass"
    HURRICANE = "hurricane glass"
    COFFEE_NUM  = "coffee mug"
    SHOT_GLASS = "shot glass"
    JAR = "jar" 
    IRISH_COFFEE_CUP = "irish coffee cup"
    PUNCH_BOWL = "punch bowl"
    PITCHER = "pitcher"
    PINT =  "pint glass"
    COPPER_MUG = "copper mug"
    WINE = "wine glass"
    BEER_MUG = "beer mug"
    COUPETTE = "margarita/coupette glass"
    MARGARITA = "margarita glass"
    BEER_PILSNER = "beer pilsner"
    BEER = "beer glass"
    PARFAIT = "parfait glass"
    MASON = "mason jar"
    MARTINI = "martini glass"
    BALLOON = "balloon glass"
    COUPE = "coupe glass"

    def __str__(self) -> str:
        return " ".join([x.title() for x in self.value.split(" ")])


class Category(Enum):
    ORDINARY_DRINK = "ordinary drink"
    COCKTAIL = "cocktail"
    SHAKE = "shake"
    OTHER_UNKNOWN = "other / unknown"
    COCOA = "cocoa"
    SHOT =  "shot"
    COFFEE_TEA = "coffee / tea"
    HOMEMADE_LIQUER = "homemade liqueur"
    PUNCH_PARTY ="punch / party drink"
    BEER = "beer"
    SOFT_DRINK = "soft drink"

    def __str__(self) -> str:
        return " ".join([x.title() for x in self.value.split(" ")])


class Ingredient(Enum):
    APPLEJACK = "applejack"
    LIGHT_RUM = "light rum"
    GIN = "gin"
    DARK_RUM = "dark rum"
    SWEET_VERMOUTH = "sweet vermouth"
    STRAWBERRY_SCHNAPPS = "strawberry schnapps"
    SCOTCH = "scotch"
    APRICOT_BRANDY = "apricot brandy"
    TRIPLE_SEC = "triple sec"
    SOUTHERN_COMFORT = "southern comfort"
    ORANGE_BITTERS = "orange bitters"
    BRANDY = "brandy"
    LEMON_VODKA = "lemon vodka"
    BLENDED_WHISKEY = "blended whiskey"
    DRY_VERMOUTH = "dry vermouth"
    AMARETTO= "amaretto"
    TEA = "tea"
    CHAMPAGNE = "champagne"
    COFFEE_LIQUEUR = "coffee liqueur"
    BOURBON = "bourbon"
    TEQUILA = "tequila"
    VODKA = "vodka"
    ANEJO_RUM = "añejo rum"
    BITTERS = "bitters"
    SUGAR = "sugar"
    KAHLUA = "kahlua"
    DEMERARA_SUGAR = "demerara sugar"
    DUBONNET_ROUGE = "dubonnet rouge"
    WATERMELON = "watermelon"
    LIME_JUICE = "lime juice"
    IRISH_WHISKEY= "irish whiskey"
    APPLE_BRANDY = "apple brandy"
    CARBONATED_WATER = "carbonated water"
    CHERRY_BRANDY = "cherry brandy"
    CREME_DE_CACAO = "creme de Cacao"
    GRENADINE = "grenadine"
    PORT = "port"
    COFFEE_BRANDY = "coffee brandy"
    RED_WINE = "red wine"
    RUM = "rum"
    GRAPEFRUIT_JUICE = "grapefruit juice"
    RICARD = "ricard"
    SHERRY = "sherry"
    COGNAC = "cognac"
    SLOE_GIN = "sloe gin"
    APPLE_JUICE = "apple juice"
    PINEAPPLE_JUICE = "pineapple juice"
    LEMON_JUICE = "lemon juice"
    SUGAR_SYRUP = "sugar syrup"
    MILK = "milk"

    def __str__(self) -> str:
        return " ".join([x.title() for x in self.value.split(" ")])