# flake8: noqa: E501
# SHA256 hashes of kernel files
KERNEL_KEY_MAP = {
    # FFW_1801F-v7.4.2.F-build2571-FORTINET
    "d719f7fd533d05efb872907cf3711d0d895750d288b856ce70fefecbd7ace482": "71326d86adfd809fa4a7b754810be9a6552d9091cdd0ebe654944fd3e159eacf",
    # FFW_1801F-v7.4.3.F-build2573-FORTINET
    "33b9f6b7367b3f47f447a68750059b0228f3fdbae4e5012d0dcca95223177dc3": "78960af1902b1518579baddb0f233e39443b1e699a6fdc7b6ba9995ced37900b",
    # FFW_2600F-v7.4.2.F-build2571-FORTINET
    "0119cc4269540cbcd71ca054334e8856d4d22164d54459733408d46eb4bdf038": "c26422591c61d94810112c48472559efd22a795e4b14f81821559019674b9eeb",
    # FFW_2600F-v7.4.3.F-build2573-FORTINET
    "9e959835fb82f22ddda6913d78c1f17fa0dcb17aea296b38698efff19ecfa07d": "087803987aa975a5d7b01f542b966cf8067e8f4486da2a4cd0c375e17c3e4e2f",
    # FFW_3980E-v7.0.14.M-build0601-FORTINET
    "a494ec1713ab75a5ab58a847f096951e2de7ba899bef1a9a88a9c94d8efc4749": "bb48ece8482e277f307479b8923796aed3b536e83f5fadc0d758b36192626762 5394687ae6c679a74c7901267dfb9bb3",
    # FFW_3980E-v7.4.1.F-build2463-FORTINET
    "9e914ac65820861e742791edbb8835bf2f4c14296b9fbe9cb511f8b514f186d8": "58e03d75d69f5d6e5147f4a13fe7a83f1d617ddefdb3cc77be6fd906c8a94aff",
    # FFW_3980E-v7.4.2.F-build2571-FORTINET
    "f62a56569f39355edff88412e3a572a064308a82c328bd276bccd3d41976563f": "e384310901d031ac678421088c81d69ced4cfd5c693bd0c6262528ea74385db6",
    # FFW_3980E-v7.4.3.F-build2573-FORTINET
    "d4f13c28befbd8d68ab2b5a3a3c752696c0a199497a94b12943bf0f102b1c4bc": "ca0845b2f66fcef4e971e4e9327b2cb59eccdf0ce4cd53f54745508888088764",
    # FFW_4200F-v7.4.2.F-build2571-FORTINET
    "94d96415062579eb9b311cdb9b94bf533374453793b4d9e62cc219d04aa8a00b": "911ee4ac1e798b18139a0f24ead468190f6e70ad19276723bdbea3b7e3f448dd",
    # FFW_4200F-v7.4.3.F-build2573-FORTINET
    "4e947cc0b1259f77cac04811bfdee87d3b4e854c5a7942d5b9ee3e360180797f": "a8c08f94c09809da70f14ee82f72b8f48b67f91decf327b223cf822258e06ee0",
    # FFW_4400F-v7.4.2.F-build2571-FORTINET
    "e31d269f28b15d1ab061d19a2dc2692f963c1997ff2e1c21bcbf1dadc9afdfc9": "20206bb7b2f67684c73e61b33554de860c6dcda3453f365b459717aba848619a",
    # FFW_4400F-v7.4.3.F-build2573-FORTINET
    "cf475e87fda031a5fdc03c716c8b8ad7d9733c17df95ba3a7addb0b668258b82": "fa90c8bc16ddc81ea4b595e395f87e57473b41944ffb2d77a7a6d358a73385f5",
    # FFW_4401F-v7.4.2.F-build2571-FORTINET
    "8db6ee76a3e488c259b067f701e2249207a751f3592b6c378b16a7b16570350d": "a429f4c6774c5f7aa9e34730775047cc24cf0f379898498168d4d110bcd810a5",
    # FFW_4401F-v7.4.3.F-build2573-FORTINET
    "7f0ce4a821ee4c51bbdf7013aa02d87e00b5c48f1cdb5dd9a3a312b3b1f7b59c": "cc9a3faa14b66882fc029ee0535faa3390ae86eb9279464f419827d32e9f60f4",
    # FFW_VM64-v7.0.14.M-build0601-FORTINET
    "4f487c3f8fb31ec0cfbf881f38c59b87933a0fd43713963efad309990b18bca4": "de54d7020140ccec9c01785f64696a35ec109129a5a8ff22f61dabd6850d4644 bcb87a3cf58b614f83d6d34b077b5468",
    # FFW_VM64-v7.4.1.F-build2463-FORTINET
    "74aaf377c35e3592ba130f1a3ad393014d74ced6494b6f8857195ec0a8b45d3d": "65f520a90e4903cab66ec7e4cd0221e102befc69cac2e0bc60410654fe66ac56",
    # FFW_VM64-v7.4.2.F-build2571-FORTINET
    "5fb3d57c31e761aa3da3b8a61a3688f77a7940efd47955d5a134a297d523cf46": "d89857dce1809dffee19ee773249b5e2317a00e4f70de46407b3193c08e96ddc",
    # FFW_VM64-v7.4.3.F-build2573-FORTINET
    "0f630720307dd95991a4d09621a61374c254d622b5a097d46abad6a5e80f90e0": "d3cf58939399d08891d338b81de71764bd67f5d1f74ddeeef923cdacdda6b410",
    # FFW_VM64_KVM-v7.0.14.M-build0601-FORTINET
    "1c57cb3bcb646bebdbf9140e65ddfb3cb6bc579f60a900fe77a623f74944dfc1": "f02f10bb43f0f0513dedcbe8b4db78bee0b2d7ace75e2ec6cbfbac6e65343e88 5cd3b34d491f99f5d30b3f676ccf3c9d",
    # FFW_VM64_KVM-v7.4.1.F-build2463-FORTINET
    "7060dfc699c8a22ebaebbf8e00dcb9f49cebd49ebea26c596057bede82625274": "1a24e0ff0acb765d783005e7f2df5ab49457e8be37e62c7f4697e6830fd0ad13",
    # FFW_VM64_KVM-v7.4.2.F-build2571-FORTINET
    "ff962ae3aefcc47b8f5006c9f949258068101426da6952cf5948f074391f987b": "135cfb746f7131b3c4975aae05900803a3d71894b64a6e4cbe03e453e784f31f",
    # FFW_VM64_KVM-v7.4.3.F-build2573-FORTINET
    "a2f37aff58fffdf707bf6e56ce0d80c1334a40f478ca98a83a5b1a0827f83309": "b895eb46711bf617f25ffb703b3c1cfcdc51814920485fee7ab26b377a0bcf07",
    # FGR_60F-v7.0.14.M-build0601-FORTINET
    "a61be94a8f3d89e854f7828dea1f5342386af191b5adeab1f6d5c90144ed88e5": "c2c5cf9c929a3787a05d30035cdbb6f85ed79dfb941fd6b8fbc4ad2903a68fd0 f8bcdddffb3e1673eb0450660afc7c41",
    # FGR_60F-v7.4.1.F-build2463-FORTINET
    "3fe6c6f47c12ace17d760fedd093a52d8433fd717c22b9d7273abd451f5235a5": "d320ec6ce7b871a9b305faa970b3b2cf5f1ba13af5bf18e390f4f588fa841071",
    # FGR_60F-v7.4.2.F-build2571-FORTINET
    "dbe2d8134a661bab6ba277f07675f650f49f06fcdb192252a75039e6d8f7d593": "c43220c28b6e17e30e33fa3570a5a0022bdc109c09a1ae9384a0832a0699a23b",
    # FGR_60F-v7.4.3.F-build2573-FORTINET
    "4ea37206430d85573ddca94507dbeb1a520a8b3b966445d9afb6429ac4a6b25b": "ee5784e1ce094f71d721334a0d9440ce010939a3431babe2f6dfed2b32fb970b",
    # FGR_60F_3G4G-v7.0.14.M-build0601-FORTINET
    "7826b6d3878a17b8d631bfc8312b48fa241d1a0de0e4f3694847963911c9316e": "922ded4f6f5ed745be172bbe803fd795ec51be398cce3738e31fdfc1bc3427b7 01a6a463513d921edd183a98a62d1cef",
    # FGR_60F_3G4G-v7.4.1.F-build2463-FORTINET
    "9ba66cd40fabdb93e9e8882c8e79c4334d8220fc96e87aaba9c70ede64751202": "84b021083224541d6918d52d1ee6a90e11a658f2d914fbb2de87c760204e683c",
    # FGR_60F_3G4G-v7.4.2.F-build2571-FORTINET
    "8181edaa59a447d0f9ca8743d99c11a4f833732bcdd42147364915bd91cb78ae": "6db1ececa37141697c57628dc0f1152a1070187c5e930ce4e358fad559ddb317",
    # FGR_60F_3G4G-v7.4.3.F-build2573-FORTINET
    "3ce94092ee0589d93ecc7e2658dfd6bc727c73f382824afa74631116ac0f9ba5": "3903fd19b37c2cc405e3f4b6da5c0c2e73c5f1beb6492d93ec0d1c37a6edf01d",
    # FGR_70F-v7.0.14.M-build7175-FORTINET
    "10fe8536c66586bc7ad51a3dca7038c5111121810e42a5f077883bb6b37bf988": "1f9b8023ba39b82abd2876c63fc9937d4101795007c4e57f2a7a44e79b6618ad d01b87c5b1f75d595b5dc17ae45eab34",
    # FGR_70F-v7.4.1.F-build2463-FORTINET
    "d5fb5113b2b101c2474f3f7d960a4f2e2f1e3b8ae85bba356c5919a3fb0e6077": "144e746d4a9801cd44ff9fd574e9715b40fdbe41e38a4e812d507426538792ba",
    # FGR_70F-v7.4.2.F-build2571-FORTINET
    "c3360f4c03c696e04c8a1b711847f6556110bff6c78b17264d7fb2f8f533e0d4": "50abb6d5e96ae397b626f3bf0ecbe9a67511f8b19e5037583dd8dadbdc685614",
    # FGR_70F-v7.4.3.F-build2573-FORTINET
    "99d581fb071750ce33d22c01e3e9ac16b7e74529721885012f5cf40472760548": "66d0f8614ead03a66de268fa997bd8d87fd04ca64fb74ab56b44f13d1db84744",
    # FGR_70F_3G4G-v7.0.14.M-build7175-FORTINET
    "dc6fd1df4db0421e679a99b03f65620d83de55d46bf5fbc9ba942a8f764cdd2a": "ceb51821af0c8265105fb4a2656a96b70dc5998b7c4d067931e884af07c886ff d8fc07500f7f230460fc67c51b5817f7",
    # FGR_70F_3G4G-v7.4.1.F-build2463-FORTINET
    "9bde52b04bdc8d3096128a1ffb2b9488ed5d9e6ce8ae17840f75e5eb00d646ba": "e3c519e7dbdaff8486be227279699b5c56d9a9b01b843f4760eecbecb07b9694",
    # FGR_70F_3G4G-v7.4.2.F-build2571-FORTINET
    "cd12f1b25a21cce69652f1e63848f342585d4b3b90a296c845757d30594f6d73": "e6767ff6445d043a00c72fa198c7c6c058dfddb5f95bda06292469f25cea1072",
    # FGR_70F_3G4G-v7.4.3.F-build2573-FORTINET
    "14e6d04df495e46d1a6277e9c48824214f202705b873265b376f1013db498a42": "ebd2ef5eb94d9af0ce907d445a4ef83f55f00f0e132aefb5e3c0b966616c3ecb",
    # FGT_1000D-v7.0.14.M-build0601-FORTINET
    "90f32843f15f73fc0a47020ba855a386b4893e2c0f511ae40f7c8778ebeed447": "eef595024b146555c1f29e17a6ad9f129840e3c4e465987122de37355e1df88c bb2bee68707ae99663a5740cf8b20c24",
    # FGT_1000D-v7.4.1.F-build2463-FORTINET
    "4021c0d941530758a25ec4ca850dc356c93ec6401609d486b57bf22e3c62d7a7": "eec5093c5ccab0db90cc584564280f67288a1669b51938e9d19e38f3ca1ac869",
    # FGT_1000D-v7.4.2.F-build2571-FORTINET
    "076bfbdcc2710e622182f07a8a2f39ce6f87c357eec4aebaf54c5a76ad522245": "8ea186dd8339181fed2234621bd9a27c88c691cd1ef37e829ebabba66e9f2447",
    # FGT_1000D-v7.4.3.F-build2573-FORTINET
    "e1dfac9f413cc265e4271057f3d96580410b0557bc563348a049c56fc1084595": "0bb0cf4c313a3d663ee55f4e8a26680586cf96457f8da54dbfff1d4849cbf9bf",
    # FGT_1000F-v7.0.14.M-build7164-FORTINET
    "b8dec3b4ed4e0cf1719af453d7fef6d7e23ad24e9663501f8c766d9dd3167aa9": "b6bd362e23408f5eda689d43471121dce279db02b290883bda1539bf43728ca6 66919a4fda61b58275e6c397b04a2f81",
    # FGT_1000F-v7.4.2.F-build2571-FORTINET
    "f8c55cf34f7264ba2e97816dc073162975ad30aaa9722694764573138b8307b9": "7062a2e903e5b08ab6eefc325124588c005ec202afd786de152f7515257334b8",
    # FGT_1000F-v7.4.3.F-build2573-FORTINET
    "4e13251763649becafbf132e1f2fc3d2885dca80d9eeffc1de110db5ae22e44f": "7d24c6056736146fac923fa962c9e65828746371ceacf57f73225c9438b6a6a3",
    # FGT_1001F-v7.0.14.M-build7164-FORTINET
    "00b0c8070fa41f1a78f0282c9f6db86318d91c245db15282ed1c5563eb960df4": "0c01854b6b4a46f143a6a7546fc9d91c6bde09bb0cb0bff0489dd0e36636bd32 65506b02b4b168f36646729899b38543",
    # FGT_1001F-v7.4.2.F-build2571-FORTINET
    "74561888b50a5f1e5606d8be1158082e0820101448306caa32df0e283f188525": "41b43c6edc3508c0acc2ad67e9c0f97010c2d509f1ae8cdf8a7c6777cabf26ae",
    # FGT_1001F-v7.4.3.F-build2573-FORTINET
    "18dca02eb20d946da6584aa8ed497966178d2d250863608671aa3aa636af72ef": "fe941b4bef1c09fd6f653ca74a60a76a3dffdd8d947d93ca5cb96846f54f0d4a",
    # FGT_100E-v7.0.14.M-build0601-FORTINET
    "735236bbc9954ad998c396ba772f8b027a4144025b9a843b90fa550504c2ea94": "f0f1f4c444d96d4b54430fad0d1f2d54ae0f6adbb816e26b8f6773a3311eae90 64097ef98482d85b875b5ecc35f65fe5",
    # FGT_100EF-v7.0.14.M-build0601-FORTINET
    "dcc0b24fecaca4488f6580cac4c43b1bd0b7dd7324456bcc73e25afaaee93885": "6e45bd1af3f2328e07ef245e1614622b1644811dcace014c3ad9068a2476ac2c 58d592dac3ae404c9207592147eee490",
    # FGT_100F-v7.0.14.M-build0601-FORTINET
    "7d077857e8d4f8c53727f3767de9ef873e73231dab91a42001006b7e21862a6c": "c0a4af4e0d6e7ef2ec37bf01357233b383d2d071cf4d5fd749d36b76667c628e 36bfe96a0eb980c96521500917b23777",
    # FGT_100F-v7.4.1.F-build2463-FORTINET
    "14ecf0d92e95da1a21c120c1c8baf430fb60e15c516345df952a7528e27eba20": "e4c32af8720f9be39d856cf444ca7a63794736c0389322a766079b2f5b8d0afb",
    # FGT_100F-v7.4.2.F-build2571-FORTINET
    "63d133ebd7aa7fdc6be5c957ea6e160f497140d5b594535c6ad5a64be571b2ec": "e68bc852fbb8d17f6b280925b270b375385e847e55985739236d9be0d6b49f4c",
    # FGT_100F-v7.4.3.F-build2573-FORTINET
    "535e3a94c0f7746d25bc580c47d18a23dd9991e16e84124392f9576a362453d7": "0d2e1976c226cd3f122b2084838be1f0e374567105979b95aa9047a1db85d2e7",
    # FGT_101E-v7.0.14.M-build0601-FORTINET
    "9d724eb129e2d4313bfb69132460e04956937726a3424dd87d744e15386c70ef": "34d770d12ffebcad143891e605df1868bf31129dd5dacb341b73dac8aa465918 3e850b2baa616cdc1396d916243ba8df",
    # FGT_101F-v7.0.14.M-build0601-FORTINET
    "ca0f7d7209638a905f1773d7e90a0409747d56ff745ac3aba91f4674462b8f5e": "b4820e3aa8c7a62f65c0c26f5a7bd2337e2743db5ad716b877271facbb0eb181 de2030b3c257f8102289b0a78fc5e074",
    # FGT_101F-v7.4.1.F-build2463-FORTINET
    "9b33ed129f7a948852d9eb108c8d6cd1686485e20cc46b9ec94e27dbefb6c7f0": "b9c987d835c1e36b51d3c8ef88cf3c6904f9812c4925fb44db1ab2e691193ba2",
    # FGT_101F-v7.4.2.F-build2571-FORTINET
    "d9e37266c18d0239dda5dfe212ab85aae27c9291fa7dc7529edce5eb40ac7043": "7a4d041aace35f15c5d4466807035e7447d6511729ddbcb53052ce1476234b65",
    # FGT_101F-v7.4.3.F-build2573-FORTINET
    "77d567cdabb07d02822dd269954b4c30be7d70bc6d90c11fff425656bc4a0ce5": "fc5d01e0c7376671542d65aa245b7f9e5a3bf48411b7ef6b362c205b4a496ad7",
    # FGT_1100E-v7.0.14.M-build0601-FORTINET
    "5d3d611afc5eddb3bab82a702a790ab3ed2e84e1a406c1c76283cfce451888ae": "271e6a5af1a7ba95955af8a43e7f53dbc51f2f0aabbf46eb67cf076141c0d79b d65a8fa834621b5fc657cea46354e5d3",
    # FGT_1100E-v7.4.1.F-build2463-FORTINET
    "1e2ad1f744610d80acdf9f5158f341aaf03940ea1a24d3865fa8c418d1f9ba2a": "cd0a1a52b9ff0543c81bf548791e3aaaaa4575e6ff8b5e024550adf558b78269",
    # FGT_1100E-v7.4.2.F-build2571-FORTINET
    "ab0e974e922816840d585e92bf221fcef7d39119fc18c18f3a274e19e4f253e2": "a6f4d5d5555ebf9d0fcae4fe98ef95f94212cb46a88a19b7b2607f57867b473e",
    # FGT_1100E-v7.4.3.F-build2573-FORTINET
    "328c9958cdffba640796c0c7e72e261dc743532b47e16dad7be473b1dd6cbd24": "96eee6df04ca662bc430830f9b10f4ba0358b33e284e938fb09d0b5dcf5a2005",
    # FGT_1101E-v7.0.14.M-build0601-FORTINET
    "3baca8d39c545b19095a5fe411a4dad59c194a16c6b16335c39e8b24db0f138a": "9f7fba2d0da094f2f1dca713406a03c94a0e6e09423392a355e7aafbeb72006f 4441c2ff05c141263effab494cc38bd5",
    # FGT_1101E-v7.4.1.F-build2463-FORTINET
    "af9cca9d00369f2e9c3fd43318e08224b31387fbb6521184cb7ba81979611b10": "4e6cfa4e761341aef416148a7f108f9f82f79e2bb802d5818820ba3971d6a468",
    # FGT_1101E-v7.4.2.F-build2571-FORTINET
    "dcd9ec7b4117c0a423e98a6b2dd610ab17b50d9fef0b2dd3b949410538ac1ada": "5bc475f36bb6854ee0c2b78e8d0a0ed176397a7e71e6a72fee0e57b8e05152f0",
    # FGT_1101E-v7.4.3.F-build2573-FORTINET
    "a0804adfa07fe12f13ab2324fd5e589bba41fc756c951799e3a3d7dab528f8fb": "f4ffd198e20af858310bfa39deded2638cae4c3aadcb2ec6d00efe303d62c24b",
    # FGT_1200D-v7.0.14.M-build0601-FORTINET
    "97d48b909b13bc60938605d1ea353ee575f831c87cf5839856d7775e71761c74": "3e3ea73b9c49c0984cf35d000b0dfab6a583cea62609507967971c8c79f204fd 1fb6cda3184a6290d819457c0354eaea",
    # FGT_140E-v7.0.14.M-build0601-FORTINET
    "31dd7a552850a316df085d1978df62e55db7fa7bd0710467aa1f02bd9605a9c6": "21319908cc781e96ea99f2e48f26e486da96a00afc770af390e7c98141a1d5ec edf75cc42bd0efbacbf52e1fb99dcc69",
    # FGT_140E-v7.4.1.F-build2463-FORTINET
    "c5a3d2863f8bb8c3ac92504f85c50753240a9d274a44c6b940d244a55aa99e28": "ee35b84503c7d6af634337f72f7e62a6718713de8892599c7eff255ee3d25091",
    # FGT_140E-v7.4.2.F-build2571-FORTINET
    "c0686e4230b318e706d7bb8c1b1550884c9d371b7730094d1af80787b08a4533": "b522f72f71741abd4a4b666ceec1ef15679c38ee8be8dc16b23e764643522975",
    # FGT_140E-v7.4.3.F-build2573-FORTINET
    "11f08964d7426ea7277847e01cfaa5b71ef8fe6ba19791bbe67b54f3135a90e8": "6bb953bd1fae42887c8553f7e681d96a355198197fbfdf302220b641bb1bd4ea",
    # FGT_140E_POE-v7.0.14.M-build0601-FORTINET
    "2b512ff51b4d867d768daba763dcb17f9508f24bb97eb1cf523cc55083af5a0e": "db9a1fedd4e677e1ddd982795ac6c56fafffb4a74ff19a79aa227adc96294a2b 0f5d34f983b9d965910dfefcfddc0459",
    # FGT_140E_POE-v7.4.1.F-build2463-FORTINET
    "fe4d009649cc9f13bb9d1c09207afcf4330b08ee4e6b13128834d8ce41e512d7": "fc3b303b0323cdc142da9364c52c3bedfb61378ea87057e8fb7e1377971bca60",
    # FGT_140E_POE-v7.4.2.F-build2571-FORTINET
    "73581118d9dd55225fe570d7adaf1dbe94c7b0b75a2a62b8dbe93267f9887f04": "32ad8e039cd90502b76d0c9b43150af59735d90eb59928ada6d5153407da41fe",
    # FGT_140E_POE-v7.4.3.F-build2573-FORTINET
    "13bb79243131fe159dc60ad2f82b856ae4e471114da7b6500f39f33ab18822cb": "fb3487e57d467c675562bcb21df93c9cb8adf38fddd7f2e987c14825df09a1af",
    # FGT_1500D-v7.0.14.M-build0601-FORTINET
    "47784c7a35366df7f37285ad71fa388b738ed32ebc5f3b8106b4bade58c5761a": "cf81d17db1d2aa12d4068741adbd3b64c579e71997eb2851c92969301c837b5f 351c2e60f57d05a7f6e1de15a1f81de6",
    # FGT_1500DT-v7.0.14.M-build0601-FORTINET
    "2993b578f1ded6bd5ca51db8c0066feb2656497f85ee10f54fc77236686cf760": "0e41d56148d0602f226c4090570fcecc6e8b91a97d551c2a2e2e3c66ad189148 6c71792d7651144448bc8f60034482ff",
    # FGT_1800F-v7.0.14.M-build0601-FORTINET
    "56e07f7590bf925fe957671a1a6584633b7a3e9992cd0c8d2c02b1f696e6af9d": "8f797901c90c7b029e72817a846516dc44f5269850e5dd76a3fc56d4894447e4 fd78e7b5cc93984d473523847cae442c",
    # FGT_1800F-v7.4.1.F-build2463-FORTINET
    "b4e60cfffd1c8d93fee0089aaa3306245052363075f5d293d9123682a2ec97b5": "46e2baca603dff00948c93902d1e7e00af48fe7cea196180742b0c259a23f2ba",
    # FGT_1800F-v7.4.2.F-build2571-FORTINET
    "e38da7c8f99553b68f40dafd08e78eb02d585bf6bc35c495fcbc0f8f193d1ec9": "06768bdd841113e7b2df7d91ac38638f81f7c3bef551bd0934d19d92310e7740",
    # FGT_1800F-v7.4.3.F-build2573-FORTINET
    "e146bbeb4d5c9f3662f9205f9fbeb5689799a8b54fb25e07a2da27c3fff99210": "c0f205878897bd57fa6ae79aca31c762cd902f7b866ff308eba08208b1d101bc",
    # FGT_1801F-v7.0.14.M-build0601-FORTINET
    "834b193bbfe0053c52807bea8f572c802e5644c2f1d5e969168677d3d45ecb43": "cb3a2ea4e1990f03058d8979cfe804eee984176230e101bd4e50203325319057 edcf71c6b1998024a9ba569a1280e762",
    # FGT_1801F-v7.4.1.F-build2463-FORTINET
    "abfdf3d215accd530df81794af4a1f337645a678dea53a7e8b22a3cb316894ae": "d7403be5ad2fbfac7c509f0df82c30de2809eef30d2e43a908c0435349d0f0af",
    # FGT_1801F-v7.4.2.F-build2571-FORTINET
    "07dcfa8a295137f401aa258ca4c3d68dc16cb7591f6c413626c8ac68e9bd5882": "8ac42353ad24ed86c2f49eaeb8dc912c30732d9b6f6c4b89b33725dce2b1e9bb",
    # FGT_1801F-v7.4.3.F-build2573-FORTINET
    "93228d913a835128747df4d280c76607e6e1f4b0a4233246979fdcaf0789bdd1": "e88686832e1ac77d27fe9f2bf4a98d0d1f49cfef6777f6f90adba5e0fd80120a",
    # FGT_2000E-v7.0.14.M-build0601-FORTINET
    "ca45f4ac8491b51c6819b5dc003f3bd0a4fa137c9bfbf82213ebb3181aef4e55": "3694a331624f5bc9a39c3ba32eda046bf1351f3b0874d0d8c0c6e210fe39b437 ab860b8e50468e76c09e60e2fafb6743",
    # FGT_2000E-v7.4.1.F-build2463-FORTINET
    "0de726e2cca0d1e51807ad33ffc83eaf29fc35033dceaa5960b3a48868fa7121": "dfd8cb576bf67ee8904fc873d1056e44999987b332ca3eb5f4178f2c692afbac",
    # FGT_2000E-v7.4.2.F-build2571-FORTINET
    "ebc93e63aadaf46895dca67923a50b301da3a61d386d2f4a0e670859e1af6f50": "294e5ee185eb663824c9be6e2733383387686adaae71e8c1acb11a2d4dcde8c3",
    # FGT_2000E-v7.4.3.F-build2573-FORTINET
    "69c19ad2fe0abda2b5a7a29529025188f42a1d99964412319dfb9b3ceeff4f86": "1262a44b37c62cb27b67e8b8bdbd4c43a7ae6d3aaaf7b04302bfae319491df68",
    # FGT_200E-v7.0.14.M-build0601-FORTINET
    "79134729e422a25c5aca1f9c846c59925d17f0089d457303732a4e103104ff3e": "3fa042301038e798fb24035b8de4d0628b4a6cc491d75ea80ddb95ffa0d3316d 54e1bdbd993bd601076e2df8ca5bb915",
    # FGT_200E-v7.4.1.F-build2463-FORTINET
    "ddfd9fe3cf4451b0686cfb87688c9b5216265518c781c7a3d3fef0c65ea49629": "20d6371aad176da5a3ec54317057af54aedeca91a57c27e8623c79b05a3bb27a",
    # FGT_200E-v7.4.2.F-build2571-FORTINET
    "347c8b6b20f002ec8e34bea2427b8d0f25ec44c2c000c9602676763c0e5eeb71": "94711929a3ecee9976798511fcbdb799eea823772947e6db9ac5429ed8080bbd",
    # FGT_200E-v7.4.3.F-build2573-FORTINET
    "200282e2325fe0badc0d3883ba95c720f0fb0dff2c1e7d55a88d55243363a648": "243a30473a334f6ca8c06a3c806ff49e34e4286d7b3c80c80cf32fa6fabdb5aa",
    # FGT_200F-v7.0.14.M-build0601-FORTINET
    "dcad268fc1c7d4b66f2f5957df41025a57d8fbae575eb9ea0f793d22dfd6a64c": "610cc73ecf0556e0cfa649e31e46433e2b482120078886981c29a274a081e958 01b74b46e0ba6dd7af5e3893a8e296d5",
    # FGT_200F-v7.4.1.F-build2463-FORTINET
    "9895c2409ef038c891abd398c54b0a9100b1986e1e32212f603e558c88be95b0": "ddb5cfc02729c9b3c84d34b1beefd1eaaec59c8e888391e6842ccdb84964e037",
    # FGT_200F-v7.4.2.F-build2571-FORTINET
    "f818e0d235b39fcad80b8a21829e6c52c9be7852c236a1fa8042835d0f28712e": "b7ceea44378f5b98beb87109f7124b84d6e7557aee011b68028a8fba4f56bcbc",
    # FGT_200F-v7.4.3.F-build2573-FORTINET
    "6a2da9675ec5302f5da0a55087e67abaa835b92a7c9731e3d7caf810cb977df9": "c121c6749e0a77c90ded9d80cb2c1ceb32a11b66b9ecfdda1e36d04268587565",
    # FGT_201E-v7.0.14.M-build0601-FORTINET
    "790a0ba68ce3cfa20c926228c733d79e64a3ebbe8d42c400b5aed99f444375a1": "d24378af8413cafdeb7db1475ebead81f3264a16c7c5411ab42a48279924e0a5 82aafb890fbfd2594f0dfd65af5a3e8d",
    # FGT_201E-v7.4.1.F-build2463-FORTINET
    "3a0389757fe757c7a993891932a8c2d9cdfbdcc914ef2e4263b55f27cd58570e": "f61bc5abc2f710631cf8a9ec8fbf4025d73b12ca298a8bdc8b0c9ef3b729de65",
    # FGT_201E-v7.4.2.F-build2571-FORTINET
    "940b522d8d0018785aef3c59dda075790959d769d2c670a50c027ab13abde951": "e9d33f10bcef951960a1d7dbfd13c81f9ba9674d24fe30eb5030a49c3300874e",
    # FGT_201E-v7.4.3.F-build2573-FORTINET
    "283c59bfae478d1b4446d516210b053a1398b9aebca54e50504bbb72c7efbd0b": "9e4c3f618af16112ff6812d42d1b190321dfc66598838e51dfc71301520c3992",
    # FGT_201F-v7.0.14.M-build0601-FORTINET
    "4241d305621ea9753fe9f1a4ef731b6e31b1fabe32e3a1316e3e70759f6b05cc": "038f66c326d44f5fdaf02b41aa0123fefd9cef9c13a7e101b1c823d759f8d591 cf493277240ddaacab994fb2abe1c6e2",
    # FGT_201F-v7.4.1.F-build2463-FORTINET
    "7482c176dfcbc15571c642875557d3e2d0b1de6cefc8c7abbc2ea30c7b1a0bfd": "aaf8574343e704cdb66e57c1e053d0dcf99e9760d4c37bbd168940bb9f7686ee",
    # FGT_201F-v7.4.2.F-build2571-FORTINET
    "9393d69dc693c76e0ddf19fd0a00a08e30d0c7eaff7a9977a3a7c6becd675b05": "41c4d71273d6f10dc39aaacd0b1f7595c3d9c858f3aee273b4f673b843d969b6",
    # FGT_201F-v7.4.3.F-build2573-FORTINET
    "a9006f06b361a8c83ff3341791be43489e5643cac63fe3749e60105f0f956574": "9f195496ef9ddb5f4fcd404e5af107a2fdcf542180400c178568f89aacbee31d",
    # FGT_2200E-v7.0.14.M-build0601-FORTINET
    "23623030ad1a66adc595ee730523a59f4557ce14501a79e9abae168ddf453569": "bff8dc305e7c348967ec29c856a8ecd93a3d481e33ad776cfeee2d118e1825e9 78ec6909df614aa0aa6f365e30a0704e",
    # FGT_2200E-v7.4.1.F-build2463-FORTINET
    "8bf8d88a0183db5805dcd47471feb2c4d6e2ed06c1254d87b1a11fb8d895e99f": "ce270a51243a69311a31f1976fca09ca45a43406bb5d6bcf6f5571ed95b298fc",
    # FGT_2200E-v7.4.2.F-build2571-FORTINET
    "ae09a4e905eb1b63bf38bfb08dde09efca5f2ae52a83a9b5c06d51d187d82e6b": "46cefc1f75fc7f4862326cd92a1cebb8ca1535b269dd405be5e4f54083a9f98e",
    # FGT_2200E-v7.4.3.F-build2573-FORTINET
    "110cfbca94683f5a62eccb6875102e9b4074e5d209e79816f5081e70e4519a4f": "5e7b3c99e5830eca9007a5ad84e4222e9da49e43c1673645e741a472ea2b7017",
    # FGT_2201E-v7.0.14.M-build0601-FORTINET
    "64dbd3a15bb53e46efed797da3d3bc26ef1735768b312bcbefa4a4699d5d6a96": "0eb788f18fff571a78d0ebf661112eeebcf42985d24a1d2d4fcb83833fc79749 ce482ab43f58590de5f78a3f924fa218",
    # FGT_2201E-v7.4.1.F-build2463-FORTINET
    "ca65b3e70b4bc1c312214a0d4eb6dfdbc9e3c4f63937ca71d67ebb530eecf3cd": "33cb01dcf5deb69a0b066bcddbec4325383fd1ca36674d31196577a65b5a0fe6",
    # FGT_2201E-v7.4.2.F-build2571-FORTINET
    "0dcb0964661d59fcdc159e2e825e060d736cbf85c41ff403e7b4e940806f4760": "f7b572a57b59669d36a21b22c46da6df82938c7ce12d27fb3f388faace0ce202",
    # FGT_2201E-v7.4.3.F-build2573-FORTINET
    "f903755cee5328be65b78782a44f7ba86e0eb2830caa7b7058ff0cf329755d1f": "717eb166da6cbe84caab418168fdedfa1f3b5296230ac7b65c039b2e2bddc7cd",
    # FGT_2500E-v7.0.13.M-build0566-FORTINET
    "ec9b5a8fb947072a4543eac08773762bc11070b3a0f7e44760faad56b39310d3": "160a4aa9d413093a2b184ee57593d4d46f68db3e521c90957841d2595a71cf7b 99f3910af14e2e959e9210ac8a05e8cf",
    # FGT_2500E-v7.0.14.M-build0601-FORTINET
    "cdbee601e76482ab6f68767e62a9f5626e9e7a954870009fa7ea2255869ec9fc": "a3c25168ddb00f08be86308b06259965c3a49dc745759cd1c689c5a80caf2677 54a5afdf778890c91c03c5e9a46bcb7e",
    # FGT_2500E-v7.4.1.F-build2463-FORTINET
    "94708dc9a18056e90b52bd362e09a701ae64fb3d685ac0ce9c2d1ff2dafbce15": "1ae197abfc3e0bc695c6f66cec16feec8a047ba81e6331f5b2305f5827e7bd72",
    # FGT_2500E-v7.4.2.F-build2571-FORTINET
    "b7417971de2ab8f006846b88b69ad8aaecc7ab9dc21241833fa8a0f85aa21147": "13c93243d25bd34a12d1476a7e8f7ef4c27253aff41d0aaa9d744f3c5a9a4f50",
    # FGT_2500E-v7.4.3.F-build2573-FORTINET
    "fbee3b15bb3d72cb1dbac58775f1b7b0741eb387c7410e6702fc1bb72fc6db0f": "3c2777d8ccf9b50947a85a0bf3ee644f70e13f5f9afc4e0643f577571d252fc1",
    # FGT_2600F-v7.0.13.M-build0566-FORTINET
    "fedb35511e15713e029daf42fbe7e7cd13ef7d054e497f3d1ec3e8897f60544c": "7f9632555ad352d23d848b78626b05155cef73b4d7451db76b1771e87b5c272e d9ca2c34549370786f8f9b4ea31c0b39",
    # FGT_2600F-v7.0.14.M-build0601-FORTINET
    "785ecba04eb830cc0f2aac7ce52270f3475f2f9fab7c6471161e8d1fef242645": "0fbb70ac73c0688810ea604bf02f57532cdf93ddd5dd6d3a602f0af87d162cac 46c5ac75b23e7158b50d17c6fa77b1c5",
    # FGT_2600F-v7.4.1.F-build2463-FORTINET
    "4f4788d23877fc6e372209890b1f5f16665454e44078ebeb2f33330657ecdad3": "02f6c77e03d4e41c4dbb352ff484685abea36066dc4116eb20964bb3d5554a55",
    # FGT_2600F-v7.4.2.F-build2571-FORTINET
    "95b5430be956fa33fab5c49fdd8f53f1905f58d1cf3cbff890c0f78f0372ffb4": "fec35189cb0b857af94cbd7b03e2bbeab9003f86ca0b9f2b975401c556804416",
    # FGT_2600F-v7.4.3.F-build2573-FORTINET
    "17cac4572d9364eee47dd875819c1c2f6c522dcde372d4d0a57ec810e959e241": "9dfe11afb155d6fe0df6dfe95e67fc4c58959a2becd3a6ab9ec13af4f09b0ddb",
    # FGT_2601F-v7.0.13.M-build0566-FORTINET
    "b8d946cc89294d219db99859213eb02dea083c089d4434c78c3644af5b95cc8f": "234dead04192e4342fc0124c07ed6fa162c2292f0b68bf86703ad00f2bb25a85 49b16d4c1203cb02daa0b4e0076b328c",
    # FGT_2601F-v7.0.14.M-build0601-FORTINET
    "e692ef51d58f1f39aabe0875dadf40e71cf0491e633a37fce3dc494f67242c3b": "9b0743646f95814dd5d7d0264b1618adb86ed08389048f6838f693e6e39ac411 299bb180c40d747c6a63653658eedffa",
    # FGT_2601F-v7.4.1.F-build2463-FORTINET
    "74d9d1bde6cdb3671600cb168cb88ec0006a1ec3f39232d6549a15dcad9f6c15": "ad83d65a776bd3dc72177f3f94d350f302c11da5722811f60a1c631a7b154fac",
    # FGT_2601F-v7.4.2.F-build2571-FORTINET
    "39bb0a900d45857e081647854c2190533100526dc7ade21cbc18cdd0d886dbc4": "7e811b3cb20c5eb25f76e0887b4e533f3cc335a35cf8ca159395252b86eb0e61",
    # FGT_2601F-v7.4.3.F-build2573-FORTINET
    "948013155426951d6dca89bedc25060b7ee29073244964516e03c2a102b13cfe": "e14c0b96d0cc7550fb96320d2181a175b9fc35a53d2bd93489b71e2b89b0c119",
    # FGT_3000D-v7.0.13.M-build0566-FORTINET
    "74bf9f6e89df48c173c253a657a0a2cfb26366fa94f878e846eec55075901e57": "c05ecba7784982a2288c62544b412f90bed72a236355c087d056844e55402294 c529253bbd1548a308d3a25a0f685db6",
    # FGT_3000D-v7.0.14.M-build0601-FORTINET
    "5bca1b904c7063ab02e345da6ae6515e8f96f3152c6c6de84060a1a574a5b6ea": "b18de35babeee5b9dce83859ede93ef19b36f2ab36814819adc872ac332175eb b4f40b1912e151ee973ccb14e3b585ca",
    # FGT_3000D-v7.4.1.F-build2463-FORTINET
    "38b9eb63255c742f1177ca040f0283938e71a7443fce0c706cd1a862bd1439c6": "7fa957c49d1ddd9a5388af320a0ff164a15c98879b65ca3baeb71d1d9cddaebc",
    # FGT_3000D-v7.4.2.F-build2571-FORTINET
    "80d084e0679001f513f834b23a35defb9c03d19da241e73539ba150b20b91f47": "93acab9436e2e3eaa1c7b7af37e6d2304da87278316553b3f9992a9abf560d61",
    # FGT_3000D-v7.4.3.F-build2573-FORTINET
    "196e58ead4a7cce385b38c5311a5ea7f456297f04ed0c2775f725794453b4525": "ffe048d441652a2b5b62f5bfcbfe51e71af51222b512480dd25aaa0a3ba7e919",
    # FGT_3000F-v7.0.13.M-build0566-FORTINET
    "a0ac87f260d59b6b2315c6c6d2af7c758e3245e9f5d5c1201613129583aeac46": "44bbbfd667dcdd4d5e9ffaa03a2dd8377086ab74c29ed5c1345ec6128edd20ab 1fe95a6f9d8e9058b462ca59fa37ba2f",
    # FGT_3000F-v7.0.14.M-build0601-FORTINET
    "55c51752a3948e64cc977b0c02d23e32a10a6c8b6a588a6499da7abd0f0474eb": "7bb480ce594699e0ab143ab1d8ddf6e7d2cce15e9c6c0c3f0edde6677c08e04d 514959fee7da51e2ce4737c32be4fe0e",
    # FGT_3000F-v7.4.1.F-build2463-FORTINET
    "ac6e4d86c5a6e75dd0daad64d137e20f6d5032ac379800852c776f732d1bf7a5": "2b8796ad2aecc297670b87d186377b4b68a582742ee8d76a061ad073782b21af",
    # FGT_3000F-v7.4.2.F-build2571-FORTINET
    "6f25e41c905ab057e0c3df6be416c2303c6bc3958ce98b1cca9431c3c3c8bf76": "eae0cedae4347b4c2c531bd53bf1723fd03b3cb67628122af2182919349d7b67",
    # FGT_3000F-v7.4.3.F-build2573-FORTINET
    "24f01b46fae116dd452f26fa1adeb68330b98f67b60c723e8a9fec988fd615cb": "e0acbfad7c2d1efd371d97e448d7324df24d66d3c04aa5c24d51b14284ab2af6",
    # FGT_3001F-v7.0.13.M-build0566-FORTINET
    "9182381a146086cb5fcaa5f52429ff860fd20a62faf35c729da8c0c3185bd57a": "4ad441db08152060e48910b933175370a0c36c59e2dbd36ccc909027b5b1ad34 cf9835189e26c454c941b00e74ea4241",
    # FGT_3001F-v7.0.14.M-build0601-FORTINET
    "8a7d70507e71f189d419d4f34c8ea5ba42ee42865579a24de592efb3b6d5a3f4": "2a0ec397b4521f9b95ca660e44987465b66853d0857b3e213c16983f827715c4 e92cd0fc03bfbdf70ea4e9d05e792a3d",
    # FGT_3001F-v7.4.1.F-build2463-FORTINET
    "99dbf50cef9a349d84b82be86f005383d49a27a4482902aa9cb7daf3e0a7f52e": "38c2ca82a2a072be48534e6e42c30aee9c7dcb89da3be2526ec2a7787c8d3477",
    # FGT_3001F-v7.4.2.F-build2571-FORTINET
    "862590710ad5b4ad6447681982979cc2015730bd9a3494056d6162c4ba870225": "4c8eba66451123945bbf3a6bb30f8879fe111f0becd9dca07ab0a5979ab3c978",
    # FGT_3001F-v7.4.3.F-build2573-FORTINET
    "882f70757cc1126c215848638cb1bd3556a350da8f217d22fc1fd7601c9d63a8": "25f9424b6431a2160dade1b2324879e1435f23b4db671f79d730d2ad73872512",
    # FGT_300E-v7.0.13.M-build0566-FORTINET
    "e1a43472e40174cd34dcdae47fa9caf404fb81bc70245f2dfa10801922968e0a": "e4559c436e8a64947b1981c6dc256301440ee90bd53ee5bba811859a26e8da8c cddba491c53e7ab9fb511c8c63427d97",
    # FGT_300E-v7.0.14.M-build0601-FORTINET
    "b5aafa087d85f33d90a459cfc5cfff2f73d5c22757c3b4367e7fdf447f76d87d": "81be8fa438dd012b0d57fda5341d5cdfb00dc8c4ae7eda4b5e2969f1dea44512 c9ebe2c0973cc1b5dc1c46303294fbf3",
    # FGT_300E-v7.4.1.F-build2463-FORTINET
    "b9da7b2dce7fcfd398a4183f37fd045ba90862e7848edbf0022d8b8f22c2a8ee": "6c41010043bd2184b4f7e10546982bdb5199acf3af70ab9ffa6215593fe349ae",
    # FGT_300E-v7.4.2.F-build2571-FORTINET
    "cdcc05202cf3f8f838f85a75bebb98795f2ddaaa8ebc27d7a7d36e9e6d77e4db": "41767b3918a2e27ba92fb5652847efe2bbc5c754e70526548bedf35c8b4a55eb",
    # FGT_300E-v7.4.3.F-build2573-FORTINET
    "c6f809467dc4dea4d260cf881fbb65523d65d4b5059e2fdf512fa54ab4211514": "87a29b9c0083019e07a4a61c93962c011825755507910fb7a39b5288992266fe",
    # FGT_301E-v7.0.13.M-build0566-FORTINET
    "186b784fc5bc969a46417aec2aaa96e8459a8e8a2e7531300cec70d32f2c9784": "0c9e4ef8593e85dbd0e07b34d8c18914c15cc18096ac9edb197de4e8a83fcccf 89984e4cbfee8479e809eade54639609",
    # FGT_301E-v7.0.14.M-build0601-FORTINET
    "da8101b29668a3166843c372c265735c5a6ebaa58cd25ca4a597e48bf93a6f9a": "320cb1d84c8fb3fe31feda8fe915da39c132fb3b4246981b278807f17323dc08 62870616fce11317393df1b3c1bf18f2",
    # FGT_301E-v7.4.1.F-build2463-FORTINET
    "15ceee06b491ff908f2a89bab2a531fbfe611d5d008144afb96bc3fc400999fb": "cdb8b811d4b3187e53c16513d2f3c22ef33bb43935100caa18db935487fb7ef0",
    # FGT_301E-v7.4.2.F-build2571-FORTINET
    "29973f634ae45118d9edd044fb5493bb5a01fc36a5bb83e3c83f8880b58f02c6": "c86e570f298468c15cd3bc2ec91f2f64fdbe23b46eed85484431b1da5c2adeb2",
    # FGT_301E-v7.4.3.F-build2573-FORTINET
    "a743ce34be3c804d045528a6564233d3b3d8c6166a1f77465dd98ea6c6fba17d": "d3bbff256d47128eaea57efe95d8bf85cf272dc9a2fcd572fc14c84af871fb83",
    # FGT_3100D-v7.0.13.M-build0566-FORTINET
    "012cef950471e877455ec8904728a5396c42ed314726a2b74e78ff77a6e8fe24": "f67181fa3ab468ce48bcbb95b000aa6f2ac88b14abf14221e87779d3058c0d28 65ec9b2ed2ded36152d7d34fac0dae39",
    # FGT_3100D-v7.0.14.M-build0601-FORTINET
    "09fe9f336058d25c9b1c0bc8b4f38b9fa65e8e6f78df64eaceccfd0fb50dc131": "103c9e37c30eee556d11598f48d690561c58469ab8f573cc0632463cff76e716 fede082c5e15f2bd1b4cd5860ba8f050",
    # FGT_3100D-v7.4.1.F-build2463-FORTINET
    "0895859b227d1206eeb7e55153d80f1480cc5fa92fbe511cd92472b309cb73ef": "8d955d19bbb4f3562a84154f674b82ef5cac7f0265fa956c57da99bbf3f08283",
    # FGT_3100D-v7.4.2.F-build2571-FORTINET
    "2c98618e5a861454fb834dca8a2562b39ab77c1a38c94e86113312588442e579": "d391ec9515c6b729c86a0f3cf75d3450b143c8773d29a4545ea4b2b1883ea239",
    # FGT_3100D-v7.4.3.F-build2573-FORTINET
    "6ca700626d72744939b84b66049d920eb2d851c3f690917fbbcf1446a080fad6": "2a8651e58c42346df645944afb57d4e269c7de2b74b0816037ee47d49bf2f155",
    # FGT_3200D-v7.0.13.M-build0566-FORTINET
    "f3a6297a78b2ef37c52683c96fcdbbcaaf33803c56c30570fbe43a6330830a83": "b9f223c005910594a5b1af12a0720be85878eff088a90a57a28840cb3d558d34 0381555f77d4039c92a59ed49615a7a2",
    # FGT_3200D-v7.0.14.M-build0601-FORTINET
    "538a99a8e194cc304d9a3d93d2e3d9fcea31188d4492c1746c049d26fbb91261": "97fe630a0691da45b4acc33ff7496020357f5f62e4a9773f05a04d3db23480c5 21d50ea7ace7caad370f0663e3135c8f",
    # FGT_3200D-v7.4.1.F-build2463-FORTINET
    "615532f8300b58effaaf4a9fd82f0fe426ce63d5bcb9b0c7eda8acc100730c2e": "cf8c2702806e2c8e3689d5d586d78eaa19f639fafa5935bef5fecd9bf602d94f",
    # FGT_3200D-v7.4.2.F-build2571-FORTINET
    "0e6e452b54c14124a5cb218cc81e6cd76526b182e10eba122e8d262fe01b1076": "338c4c0dffa7192ad02bcfd4f1ea87eaf4903188d678252b03b94e28199a007a",
    # FGT_3200D-v7.4.3.F-build2573-FORTINET
    "2ab22436ac247e79ac730dc9f1edafbe3acb424ab56a004c7a91ddb70ee80b92": "a2354017718db0367627efd0645adc50f7a475404e5daf5ac06f76ac018bfcad",
    # FGT_3200F-v7.0.13.M-build6912-FORTINET
    "f90483186f81558e7b945a627c2cc121e73aeab5d4aeab3b47c9ef7f75426b4d": "6798507b1fd8f8cdf4e9c9ff2c71e5b02c55e1b0776db4fa04d410ade3c6bb02 495c85ca3efdf3e60c195996a0736392",
    # FGT_3200F-v7.0.14.M-build7176-FORTINET
    "7983cf93dbbc6e8ff2bcd0e67a78a04b5891e1d0aad5a49c13f07910a68e3bf8": "bced9f1f5b8f392a05bf755743d08daaf35669463ff58379710c032bf8fbd9f9 587c9f562fc3f00c63b09345723f2cea",
    # FGT_3200F-v7.4.2.F-build2571-FORTINET
    "1750eae5f320c88e3b6a939a193117650cd066641c40f252c04432525690b32a": "88e4b8e96ad822b9cf6861e9d9aad31c82d70978e4ebda255229b1d97f6b65d8",
    # FGT_3200F-v7.4.3.F-build2573-FORTINET
    "ef43edacf450736f338e1ac54dd3671f653d021c6368862178098e8d9d0c971e": "cfdd494f913cdf2933b8a0594b841d0f3c2edf4db744f390b51879c18cd92721",
    # FGT_3201F-v7.0.13.M-build6912-FORTINET
    "f22803b3791d8005319903e7676770dc57e916af9d7ca270f6a78e0326369fad": "eebed725c54ded6385bd31b3eeb768921ce7593f337a7a29a7d609261a350be7 8f651eaa6fd7688dfe263c2ce19a4d2a",
    # FGT_3201F-v7.0.14.M-build7176-FORTINET
    "2b9d31aa8aafea08cc7b170f7fda8ce72b803d52c32b5f91f556a3785e01d063": "f6f128bcad7713fea20c477c4809281c4374435531806101fea3030716212764 00638743e67a160faf854def19adc3ef",
    # FGT_3201F-v7.4.2.F-build2571-FORTINET
    "858d704d29e321eeef39e99cb2f0ac35b35530fe9b665bee8b099769d3fc9f26": "a7351af32ca979d6c859b9efe1b2d19b516f000e7c7c1fe97d9776b732ddceaf",
    # FGT_3201F-v7.4.3.F-build2573-FORTINET
    "09f1d5c6c3c9e92dc660a8c01ae9e2ee7cc620e421a9abee6ec83b6ec30187d2": "67c27552e6a20db1bd6ef872cb17d4f52ddacd147b5bd7afb63a7f20344afb75",
    # FGT_3300E-v7.0.13.M-build0566-FORTINET
    "d3cde6c0a0bc4d267aa76f08af3c26d434006fd0cf498e7d8dd0181677cf7eab": "53c7120489168f49abd198400973c4e001e3a6a0eb43ac24832e6384877c0b06 062b70cd757b387b30682dc895e58b8c",
    # FGT_3300E-v7.0.14.M-build0601-FORTINET
    "86267ae529a9fe2b02947470f5281443696eca82d93f915a96d9c535e2ecd189": "f76825473070a56a02537c73cfbe68671c596975e0c0053c0e87add13fdf395b 5d01db8a3015a8c6409c7075379ec83a",
    # FGT_3300E-v7.4.1.F-build2463-FORTINET
    "6f22018cc11841591ce26722290b8aee7415df52d5277e72dcccdc94e6d56b9f": "fdf306d45431426019ad231bf14477a1378a518822baa95bc08bf8c0722f2fd4",
    # FGT_3300E-v7.4.2.F-build2571-FORTINET
    "4dbe62b952ab27a3f78e7adc17ed82607d79ecb0ef23cd62c4f9b0125f669a30": "515515ed4a3b1ea27a7aaf79a732e3de693c5e9b4276bfc9eaa1816d86d16394",
    # FGT_3300E-v7.4.3.F-build2573-FORTINET
    "7fad940f5b6c29cc9c2124fa01b7a7e7238786b2326ed425039b0c48ee9d4f1f": "a3872f77b2e8bda47d53cb98de99b9124f02c799628acab4410d5c0bba0bda7e",
    # FGT_3301E-v7.0.13.M-build0566-FORTINET
    "b0572a6f3ab7761393736991f48d474771e79c9da9e60c5d14fda799e4a56ec3": "d396fcc7399112aca10542b5afc3dfb25d1de09adb5f08f33158db468d28a274 54d216f2464b12bb29b685bd1c8ab88c",
    # FGT_3301E-v7.0.14.M-build0601-FORTINET
    "67da66915d162960a1ca3b7a3cfe7d7c5cff507d0df66f739058b557389474f7": "b08c3501c31b08b6f8fa5a3cb9a258e0e2a4921d8aff2a9393ecc241014ac52e 1496645f163a5c65af25bc906bf8e0b4",
    # FGT_3301E-v7.4.1.F-build2463-FORTINET
    "e2d32d1cc59d30c254405472c70dc994969bf445f4e9dd86a7d9a8202e99ea7c": "dac62efb21b5ba0c5f71b0d0ab4021b949d38ca681d07cfe52dacddac0f2e590",
    # FGT_3301E-v7.4.2.F-build2571-FORTINET
    "1a527c837707a63175ae7a483c7bff00b030a1edc52be61f97173192d7e7bd0b": "d6ae4d8259cfde3413669df36846a94f1b0035c8550a778a74184cb7c2a0da70",
    # FGT_3301E-v7.4.3.F-build2573-FORTINET
    "b926e879bac646b71b6cf89524e80eaca36974ec416abd936d24c6c16916b65c": "4c183284d80364fe6ddf34d9c93a7aa062d8ad49f056c02a2e15ae8119bd8383",
    # FGT_3400E-v7.0.13.M-build0566-FORTINET
    "6e7bed0ec7c31c63a5d82d837f9d237b09a7fd3bc865109be8fe92f4df7e32b6": "29bdef2b74b20813f5ed073633b70920f2515f0c3743e29a0b0e1aa097dd9b32 b384d0098878a77e2a9b9e07b9c22bd9",
    # FGT_3400E-v7.0.14.M-build0601-FORTINET
    "8f652cca1c08e28f6256cef7f4c09d09e74f78597e4d8a4b115563e6dce554a4": "7c744f554a32d822b3c8e9fe2207f3a074ed2e4f8c2151f1475bcdb2b17f567c 90272ff7bd9e43e29e2ddd3fa38ee753",
    # FGT_3400E-v7.4.1.F-build2463-FORTINET
    "e9ccaa34ad2d763b9195c1098792bc6401bf6401730ebb74df4ef3278f286667": "e9b86f290db947142c453368fe0420e23897a9879fb2e62ca6db5350e51d24a0",
    # FGT_3400E-v7.4.2.F-build2571-FORTINET
    "9fae035eb9b17960bb644ff8ffd2f1233145bc88b551368fd82cf27caf1ca0f6": "3fb6a043d5b957ac9f4e46c851d059475d6113a9a98c45da4c73ec58cfd5e432",
    # FGT_3400E-v7.4.3.F-build2573-FORTINET
    "5b3d2d66e575777699d3a9edb856f3ded5f30d9bf228754501d2888b9381890c": "39026bf05b8497509b6fc4fcdade412b6dcc2faac63a52f87cec292d59d8dbea",
    # FGT_3401E-v7.0.13.M-build0566-FORTINET
    "5d6456a4fdac5a79d8b3f2a66eea7ba47d0adf5f750f306fc3e80caca9195401": "b8005086198351403970d85d511c554a377551458cd90310da9be6613fa64609 86e6f5e5390e70c002d8e71d549e5cac",
    # FGT_3401E-v7.0.14.M-build0601-FORTINET
    "6f582bc1df1c454ec967f2035925f99185e4094ec358dbdb79a85cfbd930bea1": "e509ff5c042fa1e6af0f26f235ce049fc160a237ebebc77bc1333d424c248af3 bef0e582050daed2e0cec331a09fdb5f",
    # FGT_3401E-v7.4.1.F-build2463-FORTINET
    "7c0e748f231d36385d785084faaae69dbb500579eb3f2163536e3a2571563c88": "7db80a8cfcf4f52aa67eab091db39d79b13c015cc38f259914b4af58e539f36b",
    # FGT_3401E-v7.4.2.F-build2571-FORTINET
    "ff68d1fe60f5e92d5e66beb4ab98d15207d5e97f4c28c51b7347b1f9ba2854c8": "6ed774fa730f422aaf20b5c8d1bb135cf8aa629ccb3b245d71826b86fe8da142",
    # FGT_3401E-v7.4.3.F-build2573-FORTINET
    "113db377e9331ebef33b931bcd26fa8fbfc6fd4ee5da3745d3e42405e790510b": "2e16c3bdc585c5a4c7bfc4ddc73c1a678526daf38c5b3d4ecb85eba57dc87e9e",
    # FGT_3500F-v7.0.13.M-build0566-FORTINET
    "19c288c66935e11fe7a3e2d0c132e79659f76d2b2b4be42a25f9bc874f85b76a": "63ae87be0ddc686baa731b635ea1aed07a7141963a64f1ddac069071e50a7aff a3b29fc5efd4a8e143bd35da870febcc",
    # FGT_3500F-v7.0.14.M-build0601-FORTINET
    "1de873a2f877390da8315fc3ca1af261b58273aed150c82e9dc9d53373823534": "d8edb3fe53fdb309f923781e999dcf484d1d7061cf12e092918251e9cce1bed1 5deba686b4677cf6876d61dad87440e8",
    # FGT_3500F-v7.4.1.F-build2463-FORTINET
    "ae1456508a6f6efd84b9aa23ded90011fa16f816c2875eca4240e884361495d3": "c7a910fe0aa385b7260f9b8b784ade9e9fac3548d0f0813110f3645ba696bb2f",
    # FGT_3500F-v7.4.2.F-build2571-FORTINET
    "0e353cd2c73450c8a36766f73dd200d35fb8211b6540585a0e3b312e7d87927f": "00146e4517e399ee7f9fc4dbc492d461762900fcdffb9af7e7f693d9d9d6eff9",
    # FGT_3500F-v7.4.3.F-build2573-FORTINET
    "f05a02d4611980e491285edbf74d766c0bd9e8e8c974af33fc62bd80856d3a4a": "3a9cae58dd86d9cb36e62763290728d6fc67da71bd8fd72ff0b5be049c2141ab",
    # FGT_3501F-v7.0.13.M-build0566-FORTINET
    "11a6c1b2cabfaaee221730182fa0cf127d6977e03ea73bf62230aaf97fdb5ff0": "f1cb5957d8d0f03f17aa7735b4844f4d289fde35fb9c0751232696dd52ce939d 3dfe196adc3ccbe996b7a9cf691af94f",
    # FGT_3501F-v7.0.14.M-build0601-FORTINET
    "e3d7aa20c3d2f68ff0c6c7e7115958b6367b554b090ee960e48e31ad2438d395": "233c0a4771e5676adc0b0af2c452d6c18ef87c1f6fba6989f25527745d199552 79a1da1f5fc108e25cd8bee288038d02",
    # FGT_3501F-v7.4.1.F-build2463-FORTINET
    "004e745f971eaed55f86e64a093f903776d995c2ebcbadc76cfd0085ddaa4ea5": "f60318d3a3ae8444466f3248332daad990276edf8380bab9da6eec8090fba0b3",
    # FGT_3501F-v7.4.2.F-build2571-FORTINET
    "06ec4c29f0270fdbd97ba99a4155469f3f6b5da4faad9a55f0923c856ca530b2": "0542af7a6f6c179efe21dff3f2b371b1346ae4617acdc81b2f803faf8276c72c",
    # FGT_3501F-v7.4.3.F-build2573-FORTINET
    "7623a601bce40ace3bf01d7625678304aa01e32aa6b63dae08564a112bb29d3c": "9209c08c5e92fad448be4d039619574eb350d5ba8b6db9062e14465ffa68296f",
    # FGT_3600E-v7.0.13.M-build0566-FORTINET
    "6e33b2c17da5bee44641ae119c71f8cb52369823f1006655511a910ddc77e899": "67a07ec22a22abdbb688ad06f8e2c8323ee6ea3ce27d49e2093e3c83dfe7c75c b33ed956137f62d4dbff8186990625e9",
    # FGT_3600E-v7.0.14.M-build0601-FORTINET
    "08e521a98eb3d2949bf59ab8c0ec2f7e6aeaf24b7f7e5ed15985d9f5afb4706f": "c0b2d809d6e5341545e29995b59863b0b56f177e6b46cf30e24cf66f2bb49e7b a4848ba55b689ba0b4ccecc261f2d608",
    # FGT_3600E-v7.4.1.F-build2463-FORTINET
    "83c5076b8c22543d25ba352e2b7acc0d124352713c160a8df1a91a475206bb23": "edc09f4f9bd3f6799939241570f3810ff260f6dd78bda474da7c3b199e761df4",
    # FGT_3600E-v7.4.2.F-build2571-FORTINET
    "027dd95ba9f99ce2968fed67aa38b866e5ef424891d95e7e2620a6443d229406": "b425e05acb080efa6a28a9f93590cef55d08b11c753f5e1a447b4ce8f8dbdd92",
    # FGT_3600E-v7.4.3.F-build2573-FORTINET
    "e000bb95f0aee65e78c9b8fb3da3ac8cf9fe1a357443692f065922fa444eeec6": "c74eb02f8cef63f9f52da5ec5903d9475dc1d3f8b12ea51221f3ddb2a8abd529",
    # FGT_3601E-v7.0.13.M-build0566-FORTINET
    "cf17cd6d81285d523362293889c2082bd25d00a9e7c62d202f5b592d9efce913": "bfac98bca97ad90cf52f45bcdb277a9ab721dfdd4501ccfee89ff98f3e3f0304 cc9c50cf4f209d2b85c35ac47b260852",
    # FGT_3601E-v7.0.14.M-build0601-FORTINET
    "bceb04119002b9f0cf4ef048cc9689ea9e77780f2719a3353e84de1203a3a075": "00a41720002ded4539e666fee34c4c682cc5247c821bfd85cde741d57d9017bb f81715ca743bb3a504c45729df6466c3",
    # FGT_3601E-v7.4.1.F-build2463-FORTINET
    "f7c7df101cc46c8c7f16529cfa1a02e775a8a199ae03ec9237d76eeca9caa4a1": "5d973972922801ed0a0fb36c494db8475a458d7c034de7434cc5eaa70149028d",
    # FGT_3601E-v7.4.2.F-build2571-FORTINET
    "c00934941568f16926bac683982abf76f99506cd3117ce205a7fcc2025021da6": "e32f2f3fe9f47a5b5b19919c7c0f4c62159809da9609a0645da62e49f260f318",
    # FGT_3601E-v7.4.3.F-build2573-FORTINET
    "b6231e85434c8918f36868774591efdb98561b310f19d4dba4587f80a958765b": "5c80a3adab2930dc1c3a0e855ece937084dfb055512cecaab27b1f0c0034e4ea",
    # FGT_3700D-v7.0.13.M-build0566-FORTINET
    "eac69d9c3deb6919756dd7b95df7a8cd8020129ba1f8ff7c92abac19c05db552": "793f7a778ab7d0528fab3cbee4994fbedc6ac74fea6fc4084bb58681cafff066 70e7a6182862f987dd2d955981f15664",
    # FGT_3700D-v7.0.14.M-build0601-FORTINET
    "868a7deb81f5b7b454435111a6f8a7a2023faab0da36959f45a23711ce6f1ae0": "2193fae5de6a0c6730f377eeeae06f4f9052a5cced61cecd6921c2379c4c4441 2fc9803fadfc85be0737201b5ddeabfb",
    # FGT_3700D-v7.4.1.F-build2463-FORTINET
    "bed972eb871857ec65aeed6f8552f9a3455af2d90304b61e007c94c99af150e3": "a8f102a4db47f52860d864a290eadb71831fd145a76007a5f342b6ac34ec4104",
    # FGT_3700D-v7.4.2.F-build2571-FORTINET
    "e163b9a6d7f60bd07e192abc28ad5b43fb6eb992a2a76ba25010510fc31d7d8a": "8eb2ceba4ca5cf2e1785c92626b060cea335269e59b232022b7b401c0cdc73d8",
    # FGT_3700D-v7.4.3.F-build2573-FORTINET
    "ce407d0c64667c549ed3a9df7c67b96be4adeed8c350d589885e739cb8c24045": "c85f3042f6a220562bc121df7395b9dca0ec5218098858fd9647bd5f9fe409f2",
    # FGT_3700F-v7.0.13.M-build6912-FORTINET
    "90931b7ac8990bc62604befcc2f9ae66c6c862bc06748f441171a6026e8b06f1": "4765d9258205b8dcad5301608b4f4ef83a190d44be895656c3c0d958f9b18601 2fb58865f5ec73b233462df2370f5171",
    # FGT_3700F-v7.0.14.M-build7176-FORTINET
    "65118e7148f0c96b609e806f2f716e3f6ffb53b3afe2f2e6b4243194e3afa5f4": "4e61b67cd4a16bcd3ae7629825c345925041dec6d99e86d59a088eb3c000ceac e911964af325d46d4c53cc5244e20953",
    # FGT_3700F-v7.4.2.F-build2571-FORTINET
    "e00fca729a8d1dccc67f491c35fc87f5d8217b889608a1d241df3d7d420eb5ea": "8d08d3d3853d35a5a270577bff1f0e64de2ad16f1970d1d9823a73333bb2236c",
    # FGT_3700F-v7.4.3.F-build2573-FORTINET
    "10046afb23dddd807cd1a68fb6460851c833211676891df3a9771adc6b92dce6": "d8fa8833b1ae2d75685089dcbc3887250ba85b940c89db441ab849f78b82921d",
    # FGT_3701F-v7.0.13.M-build6912-FORTINET
    "2c454e68b2d30cb75fc7a6d386b8bc1a47e563e5efd63159cdc898243b9d7876": "9f5e1701ff3c306acdb3ba52aa21fe8352c871af8ec06b64d8599a8c4125bb70 bff1e0a473e26dd974cf9d60c2df2bd5",
    # FGT_3701F-v7.0.14.M-build7176-FORTINET
    "2b50e27bbbe248495d1d5ff0a19b1fc667983b44677379505147979a0e2dffcc": "50b65669b264143688c0bddfbef5efb06070214cf24056f9bc75d9720483e3a7 038e1452560345d2e2f8917dac4d08dc",
    # FGT_3701F-v7.4.2.F-build2571-FORTINET
    "b467b86bf37179b47d2249c87bc92e952bc9972cdc1ddf47559145371f816c03": "31ccc0c474d5dfe10343c7209c1c75b5dc3d3e09433da092100d87ccaaf332af",
    # FGT_3701F-v7.4.3.F-build2573-FORTINET
    "68dc714ebbd4011d388c0dcaf934700a7a64ed29878aadfbcf134d052381dfab": "7229f19f080e53d85dcefeed5fbcebb269dd32ca15ae5e7d03a05518658e26f7",
    # FGT_3800D-v7.0.13.M-build0566-FORTINET
    "1cf89d1bfd18dea85fa47ce507d0c51c9618670d0c29455af938ebd08743bd30": "a7f521031866a47c6edd4336e39db0b00c1b718a6b52fcc72eb78315d67b3445 215902bcdd8a30b053621e19063079ba",
    # FGT_3800D-v7.0.14.M-build0601-FORTINET
    "b036c04c7d8cbdefb0b33e6102b826060bc8677c49330c5b6705f45a21e5e546": "2cd57cc927aa7eee9a00d6a5084e711aeb612d62251fc232226da896113a9b83 f97780c29ecb4413693bdb0909d4ce08",
    # FGT_3960E-v7.0.13.M-build0566-FORTINET
    "a19604b95dfb74edb27ed14929511b1bf19daae34a3a35f5fb0d6f305e9d063d": "2b9050856322d615245121dd35fb65b3305381cbf3d68fd4d7ae0d4f252d5bd0 3f134e2880e1dcd6896fb7629b200d66",
    # FGT_3960E-v7.0.14.M-build0601-FORTINET
    "254583831bbb6c8cdc649a2d4c17f4498c2085da72863d9564be53bc5c544189": "51d4c8ace0634b12e1b4df8eb1b248d789c2815245a3010d2f1691c795b83edd 792079cf5e1f9c9b963be535131c5cb3",
    # FGT_3960E-v7.4.1.F-build2463-FORTINET
    "1670efa7d1bb8bfb16d563412947444e484822897dac4534159bb12c8b1b8ecb": "66f1ddf3f18f204d7f229d5afacfa93012b19877afbec6aa16fe260b73015ea5",
    # FGT_3960E-v7.4.2.F-build2571-FORTINET
    "dada3015aa28e6a207daa287ef4e37ddc6834cbad5b694c7c0337dcbd351d75b": "bcc983630b9beccef3e178301b81b0f5e41088f618bc56b883f13353a0d64c5f",
    # FGT_3960E-v7.4.3.F-build2573-FORTINET
    "9370008736ded12586d04778ad7af09f8c5e9b3cc97a96671c5a955f44e3cee0": "bcfd5b869744be773abdf5ee76830df2639dadbd60d631225c24b627b256aa91",
    # FGT_3980E-v7.0.13.M-build0566-FORTINET
    "3b912602a2f8bf334c3bd8d6e8bf1b9564834e025b9c3049381ac05812822633": "a0c43c44be6bd56db6cef38f8c85ec565492d8a04c4a9cbe40ffacf4a3f7d360 dfe91da873753e11ef1b581c5276e1c0",
    # FGT_3980E-v7.0.14.M-build0601-FORTINET
    "1cb3fac5aca2c7cac2991375c3ec0f34189b419a7e07ac67f3c83c1190aba93c": "28f4e96035f2eaa269ac856c9a848f8cf35f6d562d32cc7fcdd1d8a51e3f421a 4154d2d85720e0f75932e44eff190230",
    # FGT_3980E-v7.4.1.F-build2463-FORTINET
    "4a52366afc2c38f5ef1fe7cae6a71fd836da8b97f1766b59e973d8f03cd31c80": "68bd4971713049c47708c331906d24a5b72de65db48c311b5414693be5c368ba",
    # FGT_3980E-v7.4.2.F-build2571-FORTINET
    "cba0d61c3675703e3702fe1af2a0ac2820d3332ffb8f78db1f226011cb94291e": "43b710ecedb024838167562bdd60a1d6ed2eafca719036e032ebb061c198b1ca",
    # FGT_3980E-v7.4.3.F-build2573-FORTINET
    "9a0317269267c0bc9199a2bbd1ed89f7d455b5b59c4bd3e44d3662fa3efa91b1": "a1c35521ce5c82d831f5feacc178a36e3f258e17eec7f0357374671c5dd2694c",
    # FGT_400E-v7.0.13.M-build0566-FORTINET
    "999290009f7768d08ab05b36724bcb6cd866cab29351d02d82ab4f7c8607d78f": "608bc559c9c3a35d4d9eb10d4158edbc84f43932eadd69b41fc7264733167841 43f4b231100f9e73e2584bf367563316",
    # FGT_400E-v7.0.14.M-build0601-FORTINET
    "51e663bfccfb0958b5428096eee50ee29851747ced44d342c7d5b22648aeba5e": "28e2f4cd72fbd0caa6429e3d6832227174db8292db54771a95171bf00424112d 645ebfef030a46ba326995aa908cd5a1",
    # FGT_400E-v7.4.1.F-build2463-FORTINET
    "1b263f3ac490baa5ceddb1978c8190b9be97e63149efdb757fcbaf3c4fa4df86": "d5ec0b794ec2cf79334f5cd7532a9f5c3a702933dea99f3926044751c1b8d50b",
    # FGT_400E-v7.4.2.F-build2571-FORTINET
    "f3c1d335e592c4397b69b63a5b7d336befffbdc62bd4974f00209c10133c2bd3": "4cca4b550ee4ef1f124b93fbb62cf59ede7d358c93ba8ee6df4e603722089af8",
    # FGT_400E-v7.4.3.F-build2573-FORTINET
    "2373f78fee66055e306d67973d0593453798c434086021cc46a6237406d0775f": "a157210bc1bd469381c8038495003f5134d13a9430631e50fad64b49cd6924ca",
    # FGT_400E_BP-v7.0.13.M-build0566-FORTINET
    "d8be6c74372f0427f4c940fa5683767705eb5755acca22ccdeec63cc2443d8a4": "64ecb25979834b79fefa634ccd25ef959ece515a20d1ca30acfaa562f77ca182 a31b75b107a3e43e6df087a7a2aa4442",
    # FGT_400E_BP-v7.0.14.M-build0601-FORTINET
    "7566473b31d8688a7fdaaaf2eb6fc9ae189a97a0501c40334a401b76bbf08420": "e84da6a08e3893a5b099ca1515f142e723e289650c7a82db8b420424552fd175 0e4141cae9e27becd266d05a03c7ff24",
    # FGT_400E_BP-v7.4.1.F-build2463-FORTINET
    "5d2d33f0046a90f763fdc279e5208dc4e44536934afdf8d0d2bfdfcc32b610b8": "c03f87c61fba6e88af8d88422c5336e2fa41375df67c506ac5d4249a93c2437f",
    # FGT_400E_BP-v7.4.2.F-build2571-FORTINET
    "a9318414b2c8fa8a8daba150c43cdadbc9643dbb8ad763bd2698290dcfe78303": "28038fc62a4eca42e3e55c212379f0b8287fb96ae5938c86f74bec61ecf2bdf8",
    # FGT_400E_BP-v7.4.3.F-build2573-FORTINET
    "406c5d5d3a63e807a0aff9f9b10a74a93b1739095c93863a9263a69eeae8d24b": "1d3b038c2e747ad3aa69855f08275719112134b96f31049dcd232cd7989461e7",
    # FGT_400F-v7.0.13.M-build0566-FORTINET
    "f671dea3538ec44a8ce9af39f09bf2d1b01b916403792c6b192f625b61f42426": "270c0b942956b131839ad665ed0db357d7b0d29504c17edcfcc33c45b4352b7e 34aa0e89ef13a464d9e3b87797da7371",
    # FGT_400F-v7.0.14.M-build0601-FORTINET
    "697276b4b9fba88a18231b2a5245f4bad1204fbc617b8b514d8f560af795eb9e": "e227bf3195c0decac74a5bca4ccde526ebb873b19b11c1cfa145a57029f30266 3dfc7e95249eebd95538cd6386902c20",
    # FGT_400F-v7.4.1.F-build2463-FORTINET
    "4b7c7db4e41ab956b573061eb7ea512083891506ffd7c103fb322cc93f27748d": "db0f0fed91caad0a2bd10ca9005f8fa0d582f10c954932e822decab636bbb4b8",
    # FGT_400F-v7.4.2.F-build2571-FORTINET
    "c66a34cde218fb36a042db72075ecf01b5d9aaf0bcbed9fc8b6385553f2373f1": "3580d17ef54522464f3f3376ecce47ccdb63f10bb44980a0bfb60097495b8c24",
    # FGT_400F-v7.4.3.F-build2573-FORTINET
    "46d3b406bd8692e23a83155fdb95b704d75042fcd1bc7bd2ef29c860341d662e": "204c64991add7ff3b5f27fc1420e95ebca6ba7bb8236a08a6dd701d646e06c28",
    # FGT_401E-v7.0.13.M-build0566-FORTINET
    "bd6498552183ffe464dc0727ca80e32e17a9671b5ce49206c76182c120876101": "c5972ee243c348a2c66ee93eb7f9950a71e914364aeec622a495aeb5e2fe805e a423e2357155489e817c7cbf0a9d4474",
    # FGT_401E-v7.0.14.M-build0601-FORTINET
    "cd3c1c94dcebf799e4edf020fa4e5c1f3713b9e9b6c5c090ffdb245dbdee6452": "77a27913b8d4a39cb5ae58785e3386f4b7bfd59d292820fe32492af341c14594 4ea94276dfe239a9c0e503bc729a457e",
    # FGT_401E-v7.4.1.F-build2463-FORTINET
    "776564183e0b30200046cf1ca459daca02d8609868609ba665bb2eadc33427ad": "431d614eb0578aa325666d7f02f521774dab1a208b6f5a13955b7d5237202725",
    # FGT_401E-v7.4.2.F-build2571-FORTINET
    "7a2a7c7d90ed0eee91917a69e274755d7abbd11bf3f9662698af86e1b6f56dac": "055ccceb976ecbab4c8ac9f3d6362988c2ef9eebcc21aa61d608a9c8eb65efdd",
    # FGT_401E-v7.4.3.F-build2573-FORTINET
    "70e97710a6e5fbbed4fc9633bd500b92681f9a78ecf3d7ef5c75023d7653cdd5": "9fb2b166a47a07d95634b8306a063e616ccfe16e6bffa43afb547dd57a3a48a7",
    # FGT_401F-v7.0.13.M-build0566-FORTINET
    "21187790ae0f6cbc9f7de40f20c7870386abf5aa37ba5697f5d576c4abc5138c": "be26a3c7c3048a86f73f12f2219a16d37bcc4a6350fd76660f83d26e57ee9975 f1d30d94cded14a9d1cb7cf578716d67",
    # FGT_401F-v7.0.14.M-build0601-FORTINET
    "c390a83cb58328c717937ad0473e2eae5697b844cdfcd9b2a6828aebedc48bc0": "3b030cf26773914e9ee9e78b53ef282c6786ee82777fbe2ac0ce158818943e78 c7e1c67b6e45f30217c4de535ca9172e",
    # FGT_401F-v7.4.1.F-build2463-FORTINET
    "032733f15f5de007a0527273f2da2446e7d7d19d8a6cc4915b355288fb0184b3": "96dc2f48e003a6b701070da199f718e838dc3c96d27c7b58375eee63d7584491",
    # FGT_401F-v7.4.2.F-build2571-FORTINET
    "7193d7221ac960fb150564637e8756e0bca1df1acd85803403949fca793885d8": "8c36ff29e02dfda419e1c2f34a9acbe6d679e84332bc9b674962aabc15d37073",
    # FGT_401F-v7.4.3.F-build2573-FORTINET
    "1b9cfd7cd6c0a62accb108b00d6ff80a889bf30caf6820b7200c635f63e5a356": "06d96dad65e0a3307ef225d7015a3733d4cce8113817cd7db2c99fc9503eb7c8",
    # FGT_40F-v7.0.13.M-build0566-FORTINET
    "835f7e6528640898e140bc8966557a631a11d10c0cecb6f9a6ce493d48528993": "66539b176e8e95c28d7ce3e91d21fdde63c05488fb246976a2e37dfa2ad8c576 210986fc252d9bb4e7329af28c8574ee",
    # FGT_40F-v7.0.14.M-build0601-FORTINET
    "737173863495aef9f2018339a7062b7c82ce1bb2923e224a5df9dea372ef5500": "228f9936477d2b24095e77dde352ea72aa11931819dd90b92ccd0efb492d30e2 5c1effe6fd9e53a74b600fbf8ab93f07",
    # FGT_40F-v7.4.1.F-build2463-FORTINET
    "959afcba72c55339f3b1c064f0caadfe5aaa3ff5ee481839a9365ef296ee6990": "024ee6402987a06f9900feedf296bcaea7e02ee0c95cb1efcd8626b52e304698",
    # FGT_40F-v7.4.2.F-build2571-FORTINET
    "2ce5a50515810756bcb5500171ebcc1d0e1224278589f53bb6c9a3991c395704": "ad94627918aaaf45a2f1446bf98fcf7e6b71fe4f59ffbe323b67a9d1214ceecb",
    # FGT_40F-v7.4.3.F-build2573-FORTINET
    "7f2769d6c204d7b1e7d41b91d8de2295a179353aae4bd69192a7c0d48e40e24a": "9969a2064d9dafc48152aa5b10f4b5b8d1d7f5928f0f58ec34c67809415f2b96",
    # FGT_40F_3G4G-v7.0.13.M-build0566-FORTINET
    "bd794d4d213ff1f4d504e30e8ae689056f9871663f5de34d31e9ddc18610f3c6": "d50ad8e028c22e5030f475e0d68f0f539c6fa00c8042ce4f3e66bdaafb26dbc3 891ec5dc3b3a07803406f016388a5e81",
    # FGT_40F_3G4G-v7.0.14.M-build0601-FORTINET
    "ee3d4f0bc048a2747c1244ac7db85274f815aa4f9cdf91b63fa921987b214376": "7037b6fe4c992592545dff0d045d8baab2a090f17f6baa7972cc598fe51b8669 3c318d1def681577430f9d87dd3edbd9",
    # FGT_40F_3G4G-v7.4.1.F-build2463-FORTINET
    "1e759e7402e2f2e4008cf686709a6b6a81130fe73cd7337b6ad071fad45e828d": "efeba725d9f31d36eb8f7072cbbe25c826211382a90115e54fa24111058017f4",
    # FGT_40F_3G4G-v7.4.2.F-build2571-FORTINET
    "8bd5c3be1fa780fec0381c52813435ba8640d71ce7d81be71e945ed3c5a69a2a": "e5505db82c0f77581185c8487c835a931ab5a6add9f535997727b4707df71ad8",
    # FGT_40F_3G4G-v7.4.3.F-build2573-FORTINET
    "4e6138a4193caa5a59e695cf32a8c045d32d310aa48a606e99402ed76205439a": "91b532eaf99eb9f976a32e5a920e20a4adb1c8cc56f4c2cec45c8c671e3ac2a5",
    # FGT_4200F-v7.0.13.M-build0566-FORTINET
    "0247785804ff7eaa338e1deea2d052c4eb12c60c0ff93cae1f9dc77e92395d82": "aed73decc6e1657a12f46742130ce9a322bd9a57cd504e6354f62f9aa09e4b54 25727d92fc6613f3094462e1885938ad",
    # FGT_4200F-v7.0.14.M-build0601-FORTINET
    "d7bde4cd51e6fb22578dbb042d181024d334affcba3de9c92b680fa964196055": "b785df1e426e60c16ca457716141d63ebf67f04fa030fe2a6eafba53b774f7fe c91f7c769afaf76fe6cb99b1254d35fc",
    # FGT_4200F-v7.4.1.F-build2463-FORTINET
    "b2b8eeddb699680d4075055603e023de001b713811adc1066834bc6167858080": "2f1da9cc0a6ed94ce19b3dc71f33bf4455ea0f700fa885525c0dc1f671818c2d",
    # FGT_4200F-v7.4.2.F-build2571-FORTINET
    "6321083d414d20f79b4a985605fe73fdd68cdbd1f9849104ea01845a8dd9d43e": "53d4a72649d6a1d475a0572b4a6ac8db88b232b5cb5a657e87d7307267274aba",
    # FGT_4200F-v7.4.3.F-build2573-FORTINET
    "3fa7fddbb1d6bd5367197c7e628dc28568f7d757627fdb6ef399d2847f2f33f1": "a535248c7ed14498192ba179e1e3605c2d00557da415cd0f710a0a4cc4c41a61",
    # FGT_4201F-v7.0.13.M-build0566-FORTINET
    "7e9ae5512311330a055448a5ed38aad420a98ce1acaf1c3e7817d987b8e84c1d": "3b50319a18b219a715384f8002c9000ee320ee7db5af29fefdb07225142a4693 6ac1f4a4e7817169ae7578c9b2ead926",
    # FGT_4201F-v7.0.14.M-build0601-FORTINET
    "dbf74fca4e58a2b29a85355ed792809c8019acbf31eff04fb3380cc511aae6b8": "cd5d36eb204d4499ed8ec32f3b51a8055ea521222fbe73e055df020db3b0fef0 741c200c0d82969c4a46461e7ddd2f59",
    # FGT_4201F-v7.4.1.F-build2463-FORTINET
    "3aa6f18e76e723de7cd26c12c472bcb2e7deb684b7c15858abad0a37b372d889": "1faf997b2436b9db97866d1ee7a8881e01bcea10dc9f3f92647f94f54e7203e2",
    # FGT_4201F-v7.4.2.F-build2571-FORTINET
    "a4e41ed85ae2a2ce3982b4fd204850950e5b4e29164f360be42594f96bda615e": "458c3f3265d20cb6a2f406a3069feb8f11fb0c93ee2025d1f1915c7d76c05bab",
    # FGT_4201F-v7.4.3.F-build2573-FORTINET
    "601e9dacc91a664307b8f3e66bdaa7a1a273990f525cf269be849df0b10ad083": "e31f74e424374251556d103122a155e54940b0543224e9f20cd86583f84d7fd9",
    # FGT_4400F-v7.0.13.M-build0566-FORTINET
    "daa6ea92b0f61f01917d078367cf13780bf70f69d747e988612f2e48b76dc368": "970627729eb57dfb10e8c51399c58a36407faf6e8334b11b481a84b004cc9ea0 6a0d0bdfdb7615a040280fa9d64b8478",
    # FGT_4400F-v7.0.14.M-build0601-FORTINET
    "b1ee8b3223939d961c6144058f761f5bfdb35850d200c2a7bfe7f14d3da72224": "3eb592eff56b858dbfb682aaa45005f43a32175e2f8a89f4027b73e120659fba 87c16a50aef9c02cbe9395a419fa829b",
    # FGT_4400F-v7.4.1.F-build2463-FORTINET
    "0ac8be2c308d549b33f2c1bc0b616928d7aedc21323078511fc4fb70c0251d34": "d14c3688457e89db70b180f69b705638a86a8e6f975dddb77a8eb6e8595812a9",
    # FGT_4400F-v7.4.2.F-build2571-FORTINET
    "59f7ccc29f73366abb1cd26699d1148d38c9c626fb79fb397f4aafe53f8040ec": "48bacc11cc3c9b573599bf27f8a4b4765e72ce54eba968b0946c8b85d1f87884",
    # FGT_4400F-v7.4.3.F-build2573-FORTINET
    "9de173932ac9c0f201c42a89c2605c6a2d0dc41b6774ae047bd34c63fc491bc7": "283497a1e719ab5f93c9e9d869e42f5337d97e0e197cb28e7a98d3198f164d22",
    # FGT_4401F-v7.0.13.M-build0566-FORTINET
    "aaee44a24e1e0ed27525fd2d41859409ab7ba2d9995a0c1e3c84fb1c20b79eda": "8ea1e9468c9e4807aa521eaf6b281abb3810e64a599585758601807ae6afeee2 5df213d2d2fd5d530fb69e28ebfaf5a9",
    # FGT_4401F-v7.0.14.M-build0601-FORTINET
    "5aff11fe1daafeb2565de475e70c19193d25b37e25f06fb26a1f1b174b20909a": "d6aec32c48635b76b95ea23bf4a5de26f82a5e7ca81ddf300e889dbde9ab976b f5e208c5f8c41febe538445aac0fad00",
    # FGT_4401F-v7.4.1.F-build2463-FORTINET
    "22addbdbee2ee5248dc98a6bbc0d2db9702d1669cf9d15b1aa575c924c7b0e98": "41179c279c465b2fe3c2ce08ccd1dd5e7d030f453b47fc239a18d6338dabd901",
    # FGT_4401F-v7.4.2.F-build2571-FORTINET
    "b975b174740188576ce081722d387df30352fed80300c8c4be179b5e5ad5af57": "0d4b09096931cb0411d1ebf060ed3f40a08ef4a7c8a37ff4c8c124495354ded8",
    # FGT_4401F-v7.4.3.F-build2573-FORTINET
    "0be6464a2e09943fff0a22ecbb3d4c1133a377c9ba7e4423da5f44f2d81441ec": "3997b74e7693ad0f144bbfeb036afaa16d700de54d0986ac773d1710fbaf92a2",
    # FGT_4800F-v7.0.13.M-build6912-FORTINET
    "9482bbe44f20136966365c42cf71f339051f831ebd58ac12997adbdb2f9a2e41": "ef06c6affeecb5b66ea9ae3c6d8ea2e30fc5946b516f8f6817bbe9e269a12aa1 271ffe26b942b2a2c27c151dab1a359e",
    # FGT_4800F-v7.0.14.M-build7176-FORTINET
    "22bdb028c3a3a58c9004fcfcab5f14cd28c288eed516f65357ac56dbc3c731f9": "e32049c321660b1d34192523e72a41eef0fe265b39d98ce3c3445a058845d53c 17ea0458950dfb008b4c56345d5759c0",
    # FGT_4800F-v7.4.2.F-build2571-FORTINET
    "6379172ac54f7d7e758b8927d3c3bf8f1cf11d0fd06a26efb98773157fa0cc1a": "bc8814fe4651adf4ffa9b9df6628ae22ab66e620b91b9abfae0e75ce4be28f59",
    # FGT_4800F-v7.4.3.F-build2573-FORTINET
    "f359993a59d465f13720c865505cfe3a68581cadae8ee2d4eeeb8f6dd6916bc3": "74aa9af95926e0a5d42e1e1e96cfd3a8bb4b67531635a4b886ebbcc1334427e6",
    # FGT_4801F-v7.0.13.M-build6912-FORTINET
    "3ce2547ce86dbc9bebe04a393a833c681356499db00c3c6804a01daab58f4f52": "a4c009f15b899f5d6760491453227939b658ca50e54dbe7d927635f8dba040bf d601fa4f9891679e8e6ef5d93efaf2ee",
    # FGT_4801F-v7.0.14.M-build7176-FORTINET
    "e32c976bbf2c3669b4836c6db060c410c60ad9747d73e59db1ba61880d83ec68": "4ddeff03e0197d21716e4a998fd62eecde8ebb498baa1e512a896dec16c00037 a9266bc3df2911e1b132dd3786b36efd",
    # FGT_4801F-v7.4.2.F-build2571-FORTINET
    "9e8a3821b733a5463b9f456891143d6a10dc2726755feaaee7d3c4c0b6c2ad26": "b9440b366c4337eabe92553cb19baf07fb9ea0d9ef253a07cde2c07170b646f7",
    # FGT_4801F-v7.4.3.F-build2573-FORTINET
    "9868d5256f6900996b5ec243d282ea8766aa50ad4c6fae9eec172059c02aaf25": "6455923f3eb307db4cda8fce5dc8006496c1ce1cff2c395ed26ebd18312048d4",
    # FGT_5001E-v7.0.13.M-build0566-FORTINET
    "1e1eab6198da7e4cf7f421dbac8d11e504bff75e8bfc0deaef520d495fb1283e": "388125f1bdfe99b228ef681e636db5ac92d2ffed69956803c370d5771983ada1 c875a6c8190222c2b9c89aaed21ae621",
    # FGT_5001E-v7.0.14.M-build0601-FORTINET
    "2741a006a8cdca674f00adb9fbb2b9d59e3bffade8ee30899049db8522804f48": "a0243a2f1d942d4724e2655ca89080fb94c507dd0f0816409e3b646c0c677cba a4ed8930b27890371e7c99e349987eec",
    # FGT_5001E-v7.4.1.F-build2463-FORTINET
    "965c90e8f95d0522da91cabed7989eac603ca16379fc285574e5358e11f6a96c": "30ddb1745d0a1cc3383db94446c3118d5871aa2006edd5918ca523e79455b555",
    # FGT_5001E-v7.4.2.F-build2571-FORTINET
    "7f3e31168155da0b380587f1909e70fff278c68d77424cf5b1d9cd55c6d20141": "cb0da3d1d85c8f557ff816aeaedf960a3e1d03a0294c32e56dafc1af6b32663e",
    # FGT_5001E-v7.4.3.F-build2573-FORTINET
    "f6ba3bc6018e47b0ef84dc570379cb8509e78de5f5a9d5fe3d5c1e6db9c561bf": "5e0a76a02c8cb4e7f2d27b485bc8f3be2e9e803e72af7e111314637fd9926d5f",
    # FGT_5001E1-v7.0.13.M-build0566-FORTINET
    "755fab88c89510a38453ae05a5a0850e80c545dab85434dc102b22a74bc83ed2": "c88181e0623a2c40ce02dbe94fdb909c0416bcb6ba2226b15728448f3b87caa2 3e5326a5d76b9b88866c58b4bf21c759",
    # FGT_5001E1-v7.0.14.M-build0601-FORTINET
    "291ef9ebfd02250e07498116d883edfc0db6f053c7861a6689fd945a7b783bd2": "495b3e68303007a1298b6cb547ae0d9a2c4733c090b66b7d3d4b30601a0e9069 056d69675f6f9259fa2f9677998e0bf9",
    # FGT_5001E1-v7.4.1.F-build2463-FORTINET
    "ee490b6fe3f7fe5f1cf9ac63a038fb2a22d10e1018b560f41e79a102151c248c": "1cd37d86fec7e473a05ce880308a039b6803c55e90395ded8e308c4e0f9d614b",
    # FGT_5001E1-v7.4.2.F-build2571-FORTINET
    "9b0b72dcf24d487d056eb196dea9cbb22a23e4b27980010c7b4f231db6102c56": "2915b07cadc7d9144c6a1dc06b389c55a2c0b803f886225893cccaa40e7fe964",
    # FGT_5001E1-v7.4.3.F-build2573-FORTINET
    "4687ddb211278c294f3d23f524abdf0206f3c5149bfaa9a20b8360a5a2393fe9": "e290add642e8e5595398e4e8aae077a58ed8e8b79b651787d55a2dadc6ff3d78",
    # FGT_500E-v7.0.13.M-build0566-FORTINET
    "94495a94bb6ad81ff13c0392290a09194ddedd8b80c72d24a3b049311e8f116b": "71a07633b1ca42de68465b7b3faddcd62ce5bb17ec570c8d3196e8ec701b4519 e91223495706f0ca8d24b2bf21a56877",
    # FGT_500E-v7.0.14.M-build0601-FORTINET
    "bb73048eb3431f4e937291d2d6ccdc17bc2d26a390c9f2d65fce55efdc458ef3": "6207d93ac96fa7b963d9d308e2cfbbfac61c31f0fd90789a80dd96246a1c2f35 f9e9782c771f0ff83ea24eff771c7543",
    # FGT_500E-v7.4.1.F-build2463-FORTINET
    "0d769cdf540211be0fd952f5b99d09efccc9530715f19ae5a01f689a8e0aaf5e": "0d5de34c5f85fa4fd71d0924e437afd7ab60085783e9e6d8b9cb575e1579aa2e",
    # FGT_500E-v7.4.2.F-build2571-FORTINET
    "38ff055ed268e4981e2205151983e27c36ec648a5945e1ef537a3f3f2015c9cc": "75e9b7b43394bfeac250d25634fec5bcd067339b251394c18209004bec6da32c",
    # FGT_500E-v7.4.3.F-build2573-FORTINET
    "9c2a98dc04a08e40bddf29a3efed109b8ea00e4946ee34383175c62a7e20a0ba": "9663bef79e06e60c8b61938b182555d6db3f078488cbcb81a1048cc7298aafa3",
    # FGT_501E-v7.0.13.M-build0566-FORTINET
    "70509903e810a12fef2404e973195de7382a9092212691865a6299ba4ba8358a": "247c38ea8967897f1ee6d7f75f3eb994249a43782b0496938491912aabf54784 d3a7f53fcb7e686b47e1401b128ed095",
    # FGT_501E-v7.0.14.M-build0601-FORTINET
    "56729a3c795161921ac37d9eee884b06f17a2d65db344ca9e1385b192ab98be4": "7b96c27eae1598a65adeb046f73927ddd19d0c79f64d396a389fb4e9fac04451 5217410dd66648c8cf94923fed2b9dae",
    # FGT_501E-v7.4.1.F-build2463-FORTINET
    "7caedb9823eb944baf95bcedd533ae0a793e5696e5314368888e209a8c7c559e": "f3a7a69b0ce2df0430415044a06abd667657e62d5b44428b87c45a736d1f71d0",
    # FGT_501E-v7.4.2.F-build2571-FORTINET
    "070c606dfdf28595bf4c32329e2dc5fb443731b868b1d22b7c863f4e8b377572": "1e88b4e65142ff9a70431b49e4ca21d5c8a232d7e3411baeb31cdec6e4d74116",
    # FGT_501E-v7.4.3.F-build2573-FORTINET
    "05a44b3fedd95bdd2c1b90a1c8f7795cbd104161779ef5cec16d85f63f5741cc": "4aa1740f56fee5b100e81014c35ec2c25633053146d34dc641626ed833aa09f5",
    # FGT_6000F-v7.4.1.F-build2463-FORTINET
    "e3452be4fbf44aecf13154a5b32887487ab7f38254540f1b20d5214ab5cc4728": "3583a1dc9a922f4311c87cda9c70015cbd985b0380774907b1f060ff95f64d85",
    # FGT_6000F-v7.4.2.F-build2571-FORTINET
    "5138848c3def24d1738a476bd38d2b09aa2a02e4d172314cc477d65c484819d8": "8695181145e07e31f3cf64eb897859cdf44a0816303c419585a9c49144d8f50c",
    # FGT_6000F-v7.4.3.F-build2573-FORTINET
    "0a2894459e4735ecda36c257db9b72f896e452cbe28db298f9679632c67ce9bb": "25122b668a4b876c712b5fa2fed4f12c5d02737e3f9a6591f14418d58a7abf98",
    # FGT_600E-v7.0.13.M-build0566-FORTINET
    "2a5f91a655f9500dc5ee156aa2386eb2654735a720ca5da7483aca2da46ffd72": "7b4804f94c82ce624e8aeeedcc5685e3a91c57f4db9fe06b2501c867f9bc530f d10e6babc87f1234fdab5492ca1e2681",
    # FGT_600E-v7.0.14.M-build0601-FORTINET
    "2a63535a99e75e05894ee64dd0d6c2c35fffc5ec80fc9f4d45a541cc4d4f623f": "9ee5b2463f4bf7c5de9cb3c1164251594ce1139ca3f686d45d09635627f92606 ad049c34d1d12b663af378d830358ebc",
    # FGT_600E-v7.4.1.F-build2463-FORTINET
    "7f1a910e9ba7cb24c6ab47a31fa79104971a113cf5d239f4c1cc2c40edffcebb": "883e4fa95d7987886c93557c8447175b24a660a5a1290683a48aacfa9fd2c16f",
    # FGT_600E-v7.4.2.F-build2571-FORTINET
    "0561ddf5561860e05fe74621f43a06b7bc1b9fa9925c1b0c80f404f886d33a82": "7e61d7d8c0c57919deabea69f28dc33002134b10d533137e3306ccff85c0b479",
    # FGT_600E-v7.4.3.F-build2573-FORTINET
    "c038fe83385d57dc637b4519bbd546a42846f39c00499d77743effc4860ad559": "d57aac34a183d26f4fbad7848508c00fa040284b3add972fbf4067fdbdcd1ef6",
    # FGT_600F-v7.0.13.M-build0566-FORTINET
    "f80443b21d3f032064fc4f4da78b07e5fb4060819d66f397253914d818257875": "a7465746a1ac47b88fed4b9f9fcaec9cf0fcc44b7084db01c68d639593aeee82 40401c5c7195ce3eb3f8311b6d0d055c",
    # FGT_600F-v7.0.14.M-build0601-FORTINET
    "87528949d512d611c0e9502dc2f4afdf4d178301cbd176430b429bb87f0be3fa": "357f97156d29e59558fa9f88f0cbd9ea34d9a5185004377e7388c499caee57c7 ac01dc986055e23f61193201ef13c64b",
    # FGT_600F-v7.4.1.F-build2463-FORTINET
    "79fc37828ecad0c1cde6590f144aef72321307c8d96c7a82bf8cfe7e4024bee6": "1fd8e44190bfbe258c0d1b5b6b25347b06b20f45aaa4ded33ef2a3afc9c57cd0",
    # FGT_600F-v7.4.2.F-build2571-FORTINET
    "9f7baeaf9d68e7b622e1b50826a44a366aa9a51370e43b81a8c3c390ab9b885e": "f02123d5692c1480d0031ea7c70cedbbbe78c26a678a3b35923cfc5059beca35",
    # FGT_600F-v7.4.3.F-build2573-FORTINET
    "4964bb3f4f25af170ce29ebdcd890fbc4357da4971783913a33848ce2339137a": "de4409e998f0b463671cee8501dde4526cffd9aefcd15df8c33e531b2c6498d7",
    # FGT_601E-v7.0.13.M-build0566-FORTINET
    "f5295e2b8bfd59f9ed151f37c4cda16d236a62734fc58c735d085e2a109939f1": "0e550e8185b0a1bb982a429f3e22bd7f126861ee311ba056fd237287c2ef17b3 3a9295b29c3721812ed2d6c3ce0e2bbb",
    # FGT_601E-v7.0.14.M-build0601-FORTINET
    "8a82d3d815d49351581ca8b98d0a656db431784ebeebb88aaa888e8317a6030e": "f958c26cab5a3be9f8e0220467038dded17d1d8610558060fca38385f6a13d79 d3d8ddbdf18cba812aaa42b75dba69c5",
    # FGT_601E-v7.4.1.F-build2463-FORTINET
    "f53b9ae511c49dcbd2449a76322e1792e93f6c17b4f9b33cbea9e96b869bf166": "53a175bf8e900bb4da6e6751bf8131bfa68e1dc86c51a741d36d515e778b417b",
    # FGT_601E-v7.4.2.F-build2571-FORTINET
    "81d82ab8b194f4c75f9f3680e77546a1ee9bf98e6ffcb3152ca061f517784c57": "c476a7e981fc230d125c58a3a9f8a5c91f8dab14d6c36656ef6057f7484544d3",
    # FGT_601E-v7.4.3.F-build2573-FORTINET
    "20cfa85e4ce761094e81821101c8c0a86356d86223087db2474c7b46b8726654": "ced2acb0e8bec65051d08eeb5b4c22684f9400644e01c914538aa8891a632445",
    # FGT_601F-v7.0.13.M-build0566-FORTINET
    "1c263af26819549f55a8d441d3b8906b954f615edc054e19ea0ecff647fb4864": "01e868ace8395588c8ff8e6cc078a4c0541691360d79f9c714e54fb103c03b21 2e8d6892f402c8e495ffd3d356fa5605",
    # FGT_601F-v7.0.14.M-build0601-FORTINET
    "878ef1774eb1bd9e2393209a04416516273beaa611ffb160ed6f879f9bb5cbd2": "d20b5e066f6260795cd33802a40ab50803536c16a5e194fb50dcdc3fe2fb92d1 a2fe7dca68e6135bd054b2721caf470d",
    # FGT_601F-v7.4.1.F-build2463-FORTINET
    "5d4717a07b519708a78921e2d5fed1ef4106e05c70aea87cd5ae62db95df8e66": "a1ce7149709b76acff56692f8794543b055fb98201233995a8e915f876a84263",
    # FGT_601F-v7.4.2.F-build2571-FORTINET
    "39bd20df5c6f735206f3ecdd159fd7dbdb600a8ed123808d57d8851054a6b93c": "ba5b010431863503df8740ad2eb13d3a5b4c49e85d39eed8ac07985ebae384c0",
    # FGT_601F-v7.4.3.F-build2573-FORTINET
    "cd083b0e6a213e9cc9ef87da9298f97f7e2f34edf2e2b6441a5440d6342f6ed0": "0d12012224e11b7e971e60b4e5ac5e56f701ceb8d1aec0ff9ba6767fdc56a11f",
    # FGT_60E-v7.0.13.M-build0566-FORTINET
    "aaff977486edeb0ae188426e715ed4cca828cd6909e4e2b8f5135fc4c1fed219": "4eb9f6551021f8347382b3a777a1d49bc357061183e6e0c754ffc9faf89e5277 629627818dd4c147454477d27f2d279c",
    # FGT_60E-v7.0.14.M-build0601-FORTINET
    "ce9f24ad4f0948c6a810e1ac467eb2aa8f09ef2a0c98a1256528a982dbbc1a34": "9e3ac7a2bbc7f551a08c63421f4eea8bf6e5fb13ad9af6531f25a01e048a1a70 185af0948d77c7e4ba84b0e0eb45a655",
    # FGT_60E-v7.4.1.F-build2463-FORTINET
    "66c343c4962efa27ccef4d9a981861964c8795a7ca3a5fe72498a07fc51495d1": "f63876043426403d3f8fb0ee8050da42d5dede98204d4833aa1c0bb3ffcb0dab",
    # FGT_60E-v7.4.2.F-build2571-FORTINET
    "269089b501d1a552af741e0247722fa05072159bc6ee0629c369271b62208ea5": "32f2177d720e57ec4d1559ab442ff2a0d0bcb2780f612871f1ce802c5e3f8d55",
    # FGT_60E-v7.4.3.F-build2573-FORTINET
    "f29b96e197e213f1ae6b27f34c8960d7d4f0560ad1e446b4ff3314026e12b655": "fc56ee0abeb7ce692d1265c60407bba9722363a84dcccf11ed08bd67d68fd752",
    # FGT_60E_DSL-v7.0.13.M-build0566-FORTINET
    "cc962ac75467eb42f79e421c8b393e30037d5531d191359eecb1b506f214e5d4": "e204d9c6c5f53480548dd68037b87be1a028a0c445c3eefca29985dd9d8c4b51 787e897e14d33a7eba639b7edda6a722",
    # FGT_60E_DSL-v7.0.14.M-build0601-FORTINET
    "5e90d3eb3fd594ddec726d01dcab3da2c808dcaa7d4715d2fdd1fe5c3e06cffe": "4cde6e26e23c9aa701afc20378f1cfa1b5828252ae70554b4142441430776c69 b2fc7751c8785e9e2904252d53ce0d94",
    # FGT_60E_DSL-v7.4.1.F-build2463-FORTINET
    "faa2eb670304663b0d054fc77ed20bf76c7c53cf275b1c5d4579debd97d7063a": "789091ec6deb08f0253e363d84603521af6138273ab75797a34ab0aaac95ae34",
    # FGT_60E_DSL-v7.4.2.F-build2571-FORTINET
    "6b52e5213bc2f2ce22d9e832ac7c7fe5b19b1916301bfce586af294b746d2992": "55f2ea608fedf0a76117326e9c39db47bfce18a57241741c30045050145cfec3",
    # FGT_60E_DSL-v7.4.3.F-build2573-FORTINET
    "ba47c7442c7e2bae989bfa054dea8ddc9dbb9f8671cbd8357cacc03ca3e52d6f": "eddb2fa2645f994ce2ca1965b8283815fbc6fe3c1925002e1b2d0333ed91651d",
    # FGT_60E_DSLJ-v7.0.13.M-build0566-FORTINET
    "5541a7087d4700185eecef1b61cea1e699479a743e098052a49b4f2b7679719c": "9d09a11ee1b627c2aa844f97314db313c673fb5e0cd87544e684cb7a94f14b0c f4682350332390198d6883a9339cae3c",
    # FGT_60E_DSLJ-v7.0.14.M-build0601-FORTINET
    "b5818c680710be0353ce77ea773e295085c087c47d6c96c941428bfd44dd4968": "bcfea9c01d523feeefb031754d8255337297ab60ebf4d19d2c9a24d160d1df5e 9cca9ec53e8a60cbf9b14c24d5ca1dcc",
    # FGT_60E_DSLJ-v7.4.1.F-build2463-FORTINET
    "25774d522e673c29582bea76abd3a4f7a34dce78667295841ab47ad3e05e094c": "c6eeea8b4a73d0e9e8465046a1c8fa358818c042adb309cc147b27f0ec157d67",
    # FGT_60E_DSLJ-v7.4.2.F-build2571-FORTINET
    "c01bf5276dd7bd4e465cad5859914ad68a67b5013ec1d9fbb62417eb60041468": "bbf15e7e070f49ef6779981293cca99f67f2ded91a4c8d7b238b59d7669f0f29",
    # FGT_60E_DSLJ-v7.4.3.F-build2573-FORTINET
    "498c02e85dde980d66deee71d15755cafbabcf2827af4a29a751231d3b81afc6": "8e0e59d33746aa5ced2a00744a3c043ecdbcc6b56d89fec82b7657ee267c18a4",
    # FGT_60E_POE-v7.0.13.M-build0566-FORTINET
    "0ce1813f876eaa0e5ed7af23c4a78e03acf719cacef2de0fd741f64b48307971": "f954f2d49077844b718cfa659c2bf05fef817fd6b72b91c62468223df2479962 74fe9f90a0b0156476d3fd4ea4e3b458",
    # FGT_60E_POE-v7.0.14.M-build0601-FORTINET
    "ff273bbceb70f08e95c8b151e5129588bf07daedcd0fa81370118e93fa23e180": "de24cf16a47d5fea16136aa06a99657999fcd62f988938fbb546c8627e3efa89 d0d54be2d247732b53c8b5cec021d0b6",
    # FGT_60E_POE-v7.4.1.F-build2463-FORTINET
    "ad59eb8db2ed817bb4b428349897467413f227a736137512e3e6f3626dff6078": "1fcfaa3de3d4fdd95e0f09f9678f118b30bab82591e98b010d5e5757cdb1528d",
    # FGT_60E_POE-v7.4.2.F-build2571-FORTINET
    "59dbecc025b81675e2e9f3aa692114e52c0920e949be78f730dd1b3c9ba73833": "1b9805058602f020fbe5c0fd444a5036a07c25d9a0d74bf1e9c2627b5a377d7a",
    # FGT_60E_POE-v7.4.3.F-build2573-FORTINET
    "846a51fe987c6b57040b51f37303731cab0b7bc1995ca14ffe6f33690626fcf9": "d35ba950649fc5e9fcad3269bd5688cc31bcfd17b34664280d80acf2e0fa9925",
    # FGT_60F-v7.0.13.M-build0566-FORTINET
    "d1b159238795ba3d90e864797df2bedffb55ba906ed78a839a299407449f7708": "a74d31b077b65a9bc47202b2f00111892dfdf74caa82ae46551081ae505f8c8e f0c10498648d5704a85fc04096cf93a2",
    # FGT_60F-v7.0.14.M-build0601-FORTINET
    "109317daab3d380954b4df3dcf5f679a51678c624937c29bacb47707175629ab": "6c82cfcbb58dc01f807d28e0d02165c14f28e7bfcbbd7d16c5809639080bd235 03b7fdad3eb33e605bb8e7d7a194902e",
    # FGT_60F-v7.4.1.F-build2463-FORTINET
    "d5dfeae31429f1dce2a03825dd980368bb27418260e9bc35148b09f0519eb602": "b8af6023379d2c87eda698bdd5cfc5ef1433a0172413a0587b2a7d665877aa20",
    # FGT_60F-v7.4.2.F-build2571-FORTINET
    "ba8e439e40e45e15fb7b6f1f55d09029f68cfe7f458c13da5dbaeac172a1a7db": "7f8813062e87c1ea6b2a93f94919d2e35ca18ed34c18fdfa0ce16e71863e7ee9",
    # FGT_60F-v7.4.3.F-build2573-FORTINET
    "569d7dd505c7bcc55f5843eb6e64f6ee5c25413269fd65338fd9ee01457c8cba": "a505e70fdf117d5e48a3f62bb0083098590f78f5d4dcb8e9d32d9ebc4e5e3a10",
    # FGT_61E-v7.0.13.M-build0566-FORTINET
    "1b5ea9f257bab2ad12d838ed77b174aaaf406fa9f1c5e6e828d924bc3bc64620": "e8660b9ea4f2d9155947702e1ea1cf6b253288837eabe3bfb807b5df6f9d9690 de295fd85ce8f32007b05f68eb3bd30b",
    # FGT_61E-v7.0.14.M-build0601-FORTINET
    "8fe4cae3d8bbad83089bbf255df7f579cf691cb62c73e88c2cf32346ca589263": "36d4876a4ca59365f292bdcd9c1a401ccd82d73ef0ecaea0cc9fca602f495b5e 29a1abc608e79479b9aa8c04b4171ad9",
    # FGT_61E-v7.4.1.F-build2463-FORTINET
    "dca7669f8e16bf8f97b344a21d8c0d9569743969db9c5ef3cb567edd5e7a4544": "7ec486fc274137367e7af93d2a79247075a0c919499c4a919310cd0d833c0135",
    # FGT_61E-v7.4.2.F-build2571-FORTINET
    "eab8038cbb6d34c6143fb59015f89e2594af9056348d37ca36c565d6dfe11bde": "192af77f1fc1d5ce749a2751613370af365dd4f00841f8bed4f1a45e5bb90e32",
    # FGT_61E-v7.4.3.F-build2573-FORTINET
    "fcbfa464d95bc9256ea0e3183aaadf12689aa25b249e3840f31593ce1c08556a": "9354b1a205b849678dd6c3d7ec8b28c525086d51abc67692850ee43756620169",
    # FGT_61F-v7.0.13.M-build0566-FORTINET
    "94dbfb83eb2e48b63a303f09f54df4b36051dd09e3602b122a669b4da9d723e4": "e96e24ae4db6ef369c02cadd0e1b6cd85ec4a6f9e6a3b0645f5f7d6ad1fc2737 6287699bd1bad08a9b25618add09a8d2",
    # FGT_61F-v7.0.14.M-build0601-FORTINET
    "c8612592958665e97d9523282d82164eb53092e5d1f8d9fa0bc8dd57951afec2": "ba91a6e2e3f39053576de9f61a4d9078a08348a2b705f2745e9883c848a7443d a8ab8ef593e84708e03d48fbb3962c73",
    # FGT_61F-v7.4.1.F-build2463-FORTINET
    "7c2451fe465cf4fb17a67d685e36bd06dcda8a756217fd0d35e5eabd00475a8c": "cf65cc3fb029999b864b337e55008071751f4ef1c9d9cc93edd0c7b48d48ff9b",
    # FGT_61F-v7.4.2.F-build2571-FORTINET
    "72c6d12c88bbe857e45de1abf3251719e0083567daa73d3d6ebf59fda07a7a99": "eebf55b6bc8eac5216033f5589f8a01a0ebc07b456f72a60fcc450873529e764",
    # FGT_61F-v7.4.3.F-build2573-FORTINET
    "d33ba7abb98c6c714352d1b4e3f56777708ee326e68c29b7671acc0ed74743c2": "1cc29ad32283330a47a1bb181b9a9281bc2378b7719358e64d202452f6529e13",
    # FGT_7000E-v7.4.1.F-build2463-FORTINET
    "bfb01d306b3ee2994039a1993b045cbfdb3e1d862e57cfe23fa856c1f16aacbc": "1b7145f3b010febeca5bd4aedeabded85e359f2b2c0d6c6484419fe203e3d759",
    # FGT_7000E-v7.4.2.F-build2571-FORTINET
    "0183e4f79bc18d8781c405988269932a958877b1808090fa879e45fd3508253f": "b4608f87950cb679a2056955b2e48b68eae0f4d9c98c282b6d5b606d1988e808",
    # FGT_7000E-v7.4.3.F-build2573-FORTINET
    "c0b62417f69072192ecf17fcd253b5a64ea295833a9b25f2ae24c3306b252ac9": "6b5f79f90e04c2756d736b54e4e179b768685a921eecdea641d83e73b60c8af2",
    # FGT_7000F-v7.4.1.F-build2463-FORTINET
    "08ceeb4474ce6f2d4b2187a1abd5c7d3927f51bb5eeb36ba642b69095de2ad90": "add1ff85bb4143f74b6d13e96ec0ddff60c575d89c67d1b083316605d565e59a",
    # FGT_7000F-v7.4.2.F-build2571-FORTINET
    "01dbf256572e7ba106c218a8d62c9bcaf1f358e000e9fd720b31c64df1a64df2": "647a77e93e98f9fab61cb227d220c09738f2a802fc1a3148b27782fab25b922b",
    # FGT_7000F-v7.4.3.F-build2573-FORTINET
    "e06974675e4f9840180cd28267e27abc2d12650180946fa21c22c8f4c3cecfe4": "f7d2907173c9920277bf1382f83dace8fb2cf76e6b5337c3ca7d209817adc7be",
    # FGT_70F-v7.0.13.M-build0566-FORTINET
    "2871da81afe338742889ad715d97b7fc4a54ab5f8429a22a5f697d190016519c": "2b5bf41a186d0d727144a137cc5a83b91f030b77b0b299fb4220136827bb773a 56c998762967f0ae28eb173a8f9fda6b",
    # FGT_70F-v7.0.14.M-build0601-FORTINET
    "ab30f6235f217fab7f99e294efb234376984c663a326137bd68c4a30b756cc5e": "81dcdd0312fa386ac3aa4bc620c2aaa7ed1b6336fddb7a13868b3dc6e579e4c5 33f2f7ec32a91a505b4ff1f295f6d01d",
    # FGT_70F-v7.4.1.F-build2463-FORTINET
    "9b5907daa62eaa2da874cab078263a08ef1fd8a4960fa7131e8ca89e60effdde": "cfd25d831820e1f9c7314192dd13a88bd85f29f5f3c18d400476f54a58d13e79",
    # FGT_70F-v7.4.2.F-build2571-FORTINET
    "47591ff48b14d54a09bede9e5559867e36d0f8ad313906e8b00aa4b55780ea62": "0fccd6a228e24612109987557eb83799df49eb8f0005ef80a051a7f8e9de52b1",
    # FGT_70F-v7.4.3.F-build2573-FORTINET
    "21ca1f7cf0752836c0910553e473d4eb20ba05326c8a9f5a17891585ceea3cb2": "0254cdc0e5aaf9904225fd69f2119c57bdf67b953e1146fde1979b2e18973dfc",
    # FGT_71F-v7.0.13.M-build0566-FORTINET
    "112f796d7994d2727a59a5bb1429de92b4671c61fa86c117333dacfc6882757f": "41f7097b5f257f49878b84477b3b8ea45988bb312ef291473eed37ea67ea6378 618d51366a9efafef2177becad74032c",
    # FGT_71F-v7.0.14.M-build0601-FORTINET
    "669354b66202f3b8614042d4765557f199ec550f8777450535a8890e14e90dbb": "888dc87ba00b6ad3670a0dd73eb71371c782ac16fc879d7aa3feb3d6d1b519c7 858e44927eb5a9a853e76016c29e54f3",
    # FGT_71F-v7.4.1.F-build2463-FORTINET
    "030596f32f995552487c9daa851b03c139706202ad4319a6473848c289515775": "f50ccf050f7819aafeb71788a22ad5e66fdb4832cfa6b4bc3cd275f1e3b44929",
    # FGT_71F-v7.4.2.F-build2571-FORTINET
    "e0013fad2da99ad2a7ebc5e4ad59a207ad46b8d4fbdf44f178be6e81d58c0378": "21ef7a4bfc00ee66ae38e546d3a3d68afe62c98f67624189cbb60bdb71922749",
    # FGT_71F-v7.4.3.F-build2573-FORTINET
    "49fc706da4970b5a16fad06034ea160031647edead6f4df6c58607d6a2ed41b5": "9de5ceb6ac0efae1b032c7917cbadd0b3248ffde3187b70d992015e7c33fa55e",
    # FGT_800D-v7.0.13.M-build0566-FORTINET
    "374ec1f3a08de1e06df249a700dc187ea6d1189d4c8aadcd0a8b8eb723d1cb75": "9f9829e9afc7b69910ae9dc62b096af62ad3afc0c9343a95a10f5670581c78b9 a02a0c3ffb918f105689408e38a19053",
    # FGT_800D-v7.0.14.M-build0601-FORTINET
    "cfa57b9af2ee1c4594c6a6bddeb50af8a0332224c0915c905d0ed6758b6efbfa": "b3fca21556853cfe8b0a6230db97f4e20c75fcc77bf7b6090b521e00f063e281 d474c1e3a534984752472ed47244b18b",
    # FGT_800D-v7.4.1.F-build2463-FORTINET
    "04d802c0eda386402fbfe290a419b9ebd3bcb65403af0cca4cc55b0b1c491305": "9bb068f496ea2e719a82091332cd10ab4a1ba5fa574d1a2a42bfed587f4ed465",
    # FGT_800D-v7.4.2.F-build2571-FORTINET
    "5c9a1137a5f908e913f8b2c307fbe4b5ab2c25f790e15f6dd61d7c236a55f096": "a283d6c203ba1624656450b65191ca1daaad7ba1a65f7bbc1ca3f696de90d8a6",
    # FGT_800D-v7.4.3.F-build2573-FORTINET
    "7aff25c748b6a7c92e27bbdcfcf77aed0bc3cd25871ca90f3e5d0b69ee3c59a4": "620117abc66a1b1eeb3380433d132259fd1544c9da3a857929bc5311339e31d4",
    # FGT_80E-v7.0.13.M-build0566-FORTINET
    "a2bc20cadc423b50b3a5584a74be07def7bc32644057b1f6ac51bbf122f3aba0": "f26f47c4dc7efcd8c57c8757386c58207149161e276b247357d1b28b5aaf374e 57fab0a22ff8ce2278ccc24063b05d73",
    # FGT_80E-v7.0.14.M-build0601-FORTINET
    "fec952d2472bc256ea8f17192234103d21365aa874859020d9e1e43ecfc17ef6": "c00bd4b3059a6da6e35a75e69537c691648437f101a44709406e7a93a532a59c 057063ebe0616adf12e5b59a16ed552f",
    # FGT_80E-v7.4.1.F-build2463-FORTINET
    "241ac2c4104e75a283d414be93e5156c864d6c749521e14dd7fef9d67357f1ad": "8179d55acb80bd3b06920a818b7c008581d80146992d9c2efe2b1dcb4eae9ae1",
    # FGT_80E-v7.4.2.F-build2571-FORTINET
    "98a22f1649a31c1672b40b8b5139b82b756a96c273bf75ba62dc9922c5abbe21": "155b8f5bf8aa826788335c6607abbf2ab79d0a4aae80929e0015dc6d77032429",
    # FGT_80E-v7.4.3.F-build2573-FORTINET
    "4bc03ef0ab5520978318419a265f2aab903601a775de685be932151e203a180a": "f4d5cb7f1d80ce961194e1e23117829a1f2224da16497942da3ea3bcff0efd5e",
    # FGT_80E_POE-v7.0.13.M-build0566-FORTINET
    "652bf6ea845b3e474c289e00241f577e880bdef9bd2838288b58497091666c9a": "66277899bfc6afe571aef4584297986a3561a4072076ec15350ea4dddb4ec540 ede8c9e7ad3feed7f8d4c0ed9cc62866",
    # FGT_80E_POE-v7.0.14.M-build0601-FORTINET
    "e1467d29d956b36b903f97a7bf42757da910dcae7387423bd7a2589120ee8df4": "ff4676e59d3ba75338b678680ac552370f637e842c0e3e39203db611475e6364 b310313058c4bbbe166c063f1451d3bc",
    # FGT_80E_POE-v7.4.1.F-build2463-FORTINET
    "1f43c91fc76347bbbd4ed95a734c84d70b85e73bbdb1e3bf1f449c3e258eb363": "ee5e9a12801cd60321bc4e1abad9025954cd0e8ee438dfdcb344f31fb6f2dd14",
    # FGT_80E_POE-v7.4.2.F-build2571-FORTINET
    "09794f4982f07761559b6da59b506c3b993c01c3fe8353803d3816b8f2882a09": "114809b8e51c1a1f5ba471de6aebe5dc591d6db204bc0c6236c8b8d0896eb7e9",
    # FGT_80E_POE-v7.4.3.F-build2573-FORTINET
    "e1c5492bb79263bc892f664f1102a75edfca2da1dd8f270beaa58355db7c3092": "9db628a7eb04bad2440f02bb9ac00ec3bc71d12a6c2959308d4cbc50c681c66b",
    # FGT_80F-v7.0.13.M-build0566-FORTINET
    "e9c8373b6a9adaa14bbbc8cd311d8a6e7bc16c059696a5157463ba466509ba67": "92ab38246d8705361ceab53a1e451b0772deb9bd1638f30d334944cefdfa22aa 15611e1c16064ceb65ac84acfb7554e0",
    # FGT_80F-v7.0.14.M-build0601-FORTINET
    "6a0229798258a433b13b7aaf123d30226fe9bcd682530ceee42f2a5315285d87": "c2f4703621f6bca8a5270167af946d2a842251db6adbb5ba2c62db0bdaaf1f87 2a4d6c5f8ed747f1f73ac7df9321d051",
    # FGT_80F-v7.4.1.F-build2463-FORTINET
    "19d9d8349de1e768813b44490f2381bab534e44474200e11b853197f52bd1485": "5a34da5b906f7a6243e1c8437ad83ca28fa2a738017025e3a34670afcd94b484",
    # FGT_80F-v7.4.2.F-build2571-FORTINET
    "5a10cae79dcb7e520518937ff19be653799e7dd8101a69bbd9a67e12a928449a": "64ba12e35eebbfb665575a681c43b3428829e2901720ec4c68af2c7ff33506b7",
    # FGT_80F-v7.4.3.F-build2573-FORTINET
    "82459b46772901ebbafc2abab62f05827c52fc1e8d9c0eeb2c543f9ad0cb4e43": "e54a35f0aaf9764c9bbf129a64ade3b7ce347af28852f8478c490485f850a3ed",
    # FGT_80F_BP-v7.0.13.M-build0566-FORTINET
    "329df2163e7bdcfb540b3b70484a9ee83fe7a0c6470b0206e0ab7a8e71f16abc": "f4c572bcce5ed2feaaca12c4655e76e37f4338401eea3a5223a4ff6a3ec93b92 e178b6557a8ff61590b95b5fcf1d0ccc",
    # FGT_80F_BP-v7.0.14.M-build0601-FORTINET
    "5de891fa1a5699d9dd4ad1a4814c4f01d54821ae27d11686d3065bc9c4a6e17e": "edf09a7925a99b554047fc00bab37b4b936b88422df1a465104a8b18179d3237 068d0fd52eb461d1d17f0eedb6bd1c37",
    # FGT_80F_BP-v7.4.1.F-build2463-FORTINET
    "f006979ba01abfa8fb789e49d21a050d5d73201606672e6697bcf8d3a323a1ac": "41000e2fb91bd85029405a6aa587bfb637d56087e39bb9fc791fd950714599ab",
    # FGT_80F_BP-v7.4.2.F-build2571-FORTINET
    "544c5ffafc9fb412aeb69c4aa31f7bfdeeb34a3566b90a290926492ca52a3631": "6b39b1926c50bfbce090d8c3b74a6f4d9386a7adeca7bbabc5a2d5a4438b9c41",
    # FGT_80F_BP-v7.4.3.F-build2573-FORTINET
    "03b6d691ba27ca213d9a8f43615fee7eb2c38deadc62003117f3acb35f6b6c8e": "fbb8c865af02b6a74e4464f5a2871ac14fcdc19759d42b772c58674c0966bf75",
    # FGT_80F_DSL-v7.0.13.M-build6913-FORTINET
    "0ca45a1ab57d155f6a911ade44f249e81212a7670295cd6123d9a3aa468d1e01": "da69cc0da200c1602869cdc46ec23b5a05006a2367b73360fbc7bb2e326abe89 ea34cff38c0db76c50617df078fcd604",
    # FGT_80F_DSL-v7.0.14.M-build7173-FORTINET
    "28843013b40ceaeae3b71402e55e780af7f0a5267fbda651f17b7fdc78d2a7af": "abb8a493ccf0ab355b88671b2a94d3cae48a60073a371d960974710d944854be 372714adbe2414077a08e60e73b34cb9",
    # FGT_80F_POE-v7.0.13.M-build0566-FORTINET
    "f939bc5b5eaaebc9c54fde6227f5a1b555f489ac39b1eab89e7d58b69b64be99": "b7d8eb2c3cb87c968cca6c0b3c10729f66613dc51ba638e5ee06f8a434aeef51 b12b54f9f3cf2c3646a600e73a8c0333",
    # FGT_80F_POE-v7.0.14.M-build0601-FORTINET
    "7d8b4786023527531cdd7d2cdb84ba67a79e0b9a1907a1dcc636108310ef9758": "5af7b951f1aadd5b5f2357b09edaf0b677e71a4dee1f3274b00b033b83be4622 773b36879968345d042cedeaa2a9ea83",
    # FGT_80F_POE-v7.4.1.F-build2463-FORTINET
    "5b1a30d580dd2259c97dbeadd2bc666c6b35a08f3a15256fd67a5b0634df8a38": "62c42edc6643d6c7cc0709ff6592878f7a6a6e21c4bd2b4488752aff130479df",
    # FGT_80F_POE-v7.4.2.F-build2571-FORTINET
    "c28c9c132c55ed9d8a7e0dd4810a1d6fe68e07a4299134acad3ba72fc9be672a": "6b588eded8fa7932df384f346b6160514327445968c1908e5b9e300a3b22492a",
    # FGT_80F_POE-v7.4.3.F-build2573-FORTINET
    "e288d99496509c00a467b608cb5047e38ba8b98e703751033c569d166b7138d9": "0e1ecb9a0078dcb666d939f7c5024b2a059d99d5adc8f19e031d67e7e4614d18",
    # FGT_81E-v7.0.13.M-build0566-FORTINET
    "0ae8998dee4179e630bfc5cf76f08b420a9ee14d223eb6fc93a3370661bd99d1": "e279a23a377e996e6bb6640e1a387837322ae263175f2a23ee3409d69bf9c590 7a76a494e3636f48da0d098ad928227d",
    # FGT_81E-v7.0.14.M-build0601-FORTINET
    "4699b2bd340736f45e38c4de69e70ea50818b2b05570d68d6caaaeb714a02b6b": "dcf5b193fbb962a620868fe6228af80f3e022231adf8d1c7b22455511daa61db 1105da249586f1a8e98916347fa2e8a0",
    # FGT_81E-v7.4.1.F-build2463-FORTINET
    "1b5a34a14c59fa4a1eabc0e85f535c6eee207f4c70153a408e642333b65ee3fc": "77fd00ea6aab837d170be4af3198b6de67c32b397549c6879e492e768c0cec4f",
    # FGT_81E-v7.4.2.F-build2571-FORTINET
    "97b660b0f2c3d2c958ed00853f5016390b0e042dcbec835fa39706929e35364c": "c2e6760a3307891b1d6d20ac6de6ddf512dc7389627f18766ceeb5451c8b0ef1",
    # FGT_81E-v7.4.3.F-build2573-FORTINET
    "a2b2e6eac521a50d48b28e96df9eb694c08a6b0726e43bc1a89c78b54c149906": "2f50650b7a1b1fc5e5774dde8b632fa7d98df121b0918dfe088ee5f67c6cbbe5",
    # FGT_81E_POE-v7.0.13.M-build0566-FORTINET
    "a3837387a999faff93f3c3aae9ddb5fb0f9e89404ef839925cea8f89e5b5db74": "89027ab0db5460eadb1c4671f673aa457e55ac847a6a86fe00d7f18e590a346a 3aa592b1f33cd5e39caec1fd155f063b",
    # FGT_81E_POE-v7.0.14.M-build0601-FORTINET
    "995ae8fdd1eebd234ed3f5220fa600d74a75d215d6f30894139c01e20813d739": "75c7f97b0fa344846445a2430bea2aa3d3d765033d763c8f0ba8179758029d62 09511a9dfdb37b3a6c8a9c0afee3d63a",
    # FGT_81E_POE-v7.4.1.F-build2463-FORTINET
    "ef86a35f923e05d3502d3b0f15c1fd5b13b202ca81da7149cba5a4462396d8e3": "5c370df524abcfc36e59f25e86822fed2dd98b7bed0611bdfb0f66f7492c0209",
    # FGT_81E_POE-v7.4.2.F-build2571-FORTINET
    "7655df3959dbb9174432fd779174281dc80aef02d609fed7c0ceaac757e38dd9": "fc77f686da3e6839c11c4abc4da8b9e94ef51b669737a0ce17b91b7536d214b4",
    # FGT_81E_POE-v7.4.3.F-build2573-FORTINET
    "e44583ca5f9aea111ba119af947aa5a4def09746e653bd6ac5c5292a334f4de1": "984d4df74f0c3392506132070ae80a8d516313a5da53230398862ab4d8c7930b",
    # FGT_81F-v7.0.13.M-build0566-FORTINET
    "64dd486045ff5cbcf5d568bc352bc4185d5a3ab71de287a0f6613f4662a7697b": "12fe5d67a2d0e12d8c490feab84efed7f31b31fdf599dbd8f7c73d6f99fc356f 7eb8e19e71e28bd56d0bcb4575b00c1b",
    # FGT_81F-v7.0.14.M-build0601-FORTINET
    "bd6f4931c3f3c4127e4cc4eb0f5ffcd63cada2dfbd406169f4c9c95cab79cdc0": "42e241fffe91f3ce8d2ce31944e59d45882b36e014fd1f0971f4fdb06a259fc0 ec55a539997deddd5c8f1f4e78ba2d3c",
    # FGT_81F-v7.4.1.F-build2463-FORTINET
    "29f15a16a84f27c1d4151f6e7f672dda285c8f96380a0024de1235352c1145fe": "0091edabb21fca284ec67191c8f9552854369cb99371466a6e77804145a910da",
    # FGT_81F-v7.4.2.F-build2571-FORTINET
    "d8271cb81295e307b63cd012294d7fcaf575b920d68b4e831c8631aaf6d669bc": "8ba0efb794ed9ec1b3a5198fb5823dc5b34f96215c831e567c680e3b14ef8c83",
    # FGT_81F-v7.4.3.F-build2573-FORTINET
    "ee19d86770ba920d6d11fbbb0c388cb5efc3bfcc7d94f2ffed854c8c1522df46": "1a9ec01e6387fc602baeacc269d60507ccce7be80289e905d1a9a05309b56cb9",
    # FGT_81F_POE-v7.0.13.M-build0566-FORTINET
    "849bf32906cac7120d4f6d61db2aae884b702cf2a443ce535374bfa71953a473": "e0a3ef7c0bb58dac84181c07cb19d732ab688bf40f2ca8c42eee8230aff5eb08 9081ab12ba8037121b6031375d3b5b75",
    # FGT_81F_POE-v7.0.14.M-build0601-FORTINET
    "8c5e096d0c9e72a94ba4d4432919ceb4536340a809b26ae27df2b0bba8435611": "6d6a127addf6cee7be972d94d4da1d92a55de42f78cb981a2a4ef67e76b6d43f 9d9afde33085f09a6da4bc1eedb05735",
    # FGT_81F_POE-v7.4.1.F-build2463-FORTINET
    "c1aaf0dd54884f0159229a957ef8a504413e0b9105a3071412d3a5f73d3ccb5f": "b51db6649bcaec814ded0ffcb3e75f7ad11ac6b5bd56fd9b95c1a4b3b10f1ca7",
    # FGT_81F_POE-v7.4.2.F-build2571-FORTINET
    "951754e54ddf006c9da63fe041c20210f98bc61892c4706b251173d9c05b3a3c": "2a8d710cd8206407dbcb72bcc3ce57fa44d24447574fd129c7a30a9dba3babdd",
    # FGT_81F_POE-v7.4.3.F-build2573-FORTINET
    "500b94ab5dd1f13a55eb83ce862249f94aa728949d2e7601c0fd920a098a4f4f": "b51c59e45b8ea00ab9f7e788f5a4f34a1fb8924c0fe196076edc56d6ce1ae3c0",
    # FGT_900D-v7.0.13.M-build0566-FORTINET
    "f8ad6eed3f1c7cc081d8dd72fbaf33b03487bc2070c7496d9bd20785379dd77b": "41af3119409c049a63a9ef0ca1c555d5f6b0b42d130bef5901c789ac9714dc91 b3bee3bdf148e06710cb8f572f3936a9",
    # FGT_900D-v7.0.14.M-build0601-FORTINET
    "d2970b368998d137e179944eed4e6a7889eacd7b4a227629a2ee88cca0c4515f": "8bf1d2381db8ec94bdfd600ea6fff5e5c97b1e895730c4b2e29cf559953498c6 ec9b1e11ba3176c038d4821dcbd61ab1",
    # FGT_900D-v7.4.1.F-build2463-FORTINET
    "7cd5641f068187853d01cdf8ab7798b95018d522b08c7bf02e23159da5f3c91b": "2e4c11313eb24f36e1c190b005438104d1aad8fd737505de30638fc865d5b96e",
    # FGT_900D-v7.4.2.F-build2571-FORTINET
    "489b486b6fc290dafe5243bb69219ad50fb7aca4baaabb16d0f5443fbf0bbaa4": "8dc60d30171d413ec74f2bd8da1c64c24926928ba772711e3aed875b35c7f4f3",
    # FGT_900D-v7.4.3.F-build2573-FORTINET
    "370782d542af3f2ce52921cb4af5c14b78c1c04cbaef47fbe38fcc9552167623": "81c21e4190b7a3a8a461fd61d62c361c772ca5afba1ffdac02766c84e75fb099",
    # FGT_900G-v7.0.13.M-build6902-FORTINET
    "e6e0623d43256af5a7068a7c9a21ff9e7910854d4f3b6c7c20560f9eb0e60aea": "6415cf0046f44d713784ca21b515ae4654985136fd244b450e884c073388553f 99136b9186dd0dfb1551aafbd9ea65a5",
    # FGT_900G-v7.0.14.M-build7163-FORTINET
    "62df60ead71ae271b481c391e4fe99a8422b141aefb60614b8c1f11265f0680e": "a4b0e17dd7939ed3478a1fe30951d8cb7326ce31283437749eaa040dadbcb738 204fb15b740201bfa0bf685e0e50f3b6",
    # FGT_900G-v7.4.2.F-build2571-FORTINET
    "499295de29a835b8e610dd0e829aa658d479d12e23c0990b9b0a4aa89ceca4c0": "b426ba6c2c463b4590d656a090e1f6f9ee7c2882db573173bf5050bb3b71c2a1",
    # FGT_900G-v7.4.3.F-build2573-FORTINET
    "66207c46321d8acec06dd9d06793d47ca621941bbc551937d1377c3b515f110b": "264fc522ee956e7d296de4c86228cd3dedadb68d49c9b18a2a02eaed0b7d83f3",
    # FGT_901G-v7.0.13.M-build6902-FORTINET
    "f54839e997804ab50cd349cf4565f266d17c734009af2ad544155e212053f6c4": "8d93284eb813728c8672c8b7a812e7a3d316563840ebfa4204d3cb7cb53f20c6 51e14ae844be401a8ad153c27649ff02",
    # FGT_901G-v7.0.14.M-build7163-FORTINET
    "520d2983cb42440b1f8bcc2d3ece9581808007bd0d34a643a37d9acf9444a58a": "3ec494ae2732d54dca9b36170940fbda96f05cb4eaeba4a1a6335f8badfaf6e6 938960dc382e94d73d2fdec7c8be9c34",
    # FGT_901G-v7.4.2.F-build2571-FORTINET
    "b5b136ab23be53c60c832ced9b04e5c08e40058d27e5e070379cb8fa8a2eb964": "5db140dc60ca8d98cb58993ce47abf6846d2437e210531facaa060cdbc951275",
    # FGT_901G-v7.4.3.F-build2573-FORTINET
    "d536533736a54526ba567781330c84e9ae1601250caefc889e28c805fb047f6e": "91cd13f7a412c422f0afa994160585dcd5daf38a4324aba81a5dca41f757be7b",
    # FGT_90E-v7.0.13.M-build0566-FORTINET
    "7fded80e4fe0fa91f15b4af47b4785f2c0522941fbc9e8fee9ff0ddab526f60a": "68bef1e1e2ec798257197650e1de29fa149aca1be15091fb6171e03c8538a667 a97db76bef303484b6058628a6fe41ef",
    # FGT_90E-v7.0.14.M-build0601-FORTINET
    "84d793d766cbd228f8c2cd36fd4f2f8a47a908a17528daf727e5849f134edb36": "3980d5cd047e137a31d94e3a4e22f9204c5caca591e069af248e6be3a160a0a0 682edf174d93ecf8a083e97f24735e51",
    # FGT_90E-v7.4.1.F-build2463-FORTINET
    "7950066cb41c57b817125f8f189a214b6670e2fcf4e878b885c73e82d7857739": "19d7be8c07851b4765c953a107bcf223d4ee21d48f5a6557549af8fa796fe518",
    # FGT_90E-v7.4.2.F-build2571-FORTINET
    "6b7778652a1ee7177470d4b2fd49875d63f6c0e93f2806f0b4417a0a91561f94": "079ab478b0dea7c4c6d352e80ec0615bb70f6c89b6e7c108a023d0e68a838f2a",
    # FGT_90E-v7.4.3.F-build2573-FORTINET
    "e92e2c46ce12018f7039b3f6a9c8f0def3e0ae5857bf40313a7606ebb11ba54f": "126bb34e092fa827a275e54695c300d4211d3eeda05426552317987477e0b98d",
    # FGT_90G-v7.0.13.M-build7121-FORTINET
    "468eb7068023035aaea727f45c0c3d5035ea2cbb0fe154bdfa152957f1d95e8d": "5241bfa34b6f09a342fa47cd855540b615fdb453c1baa0aa1b4077164dc7f0fb bf5d34d6f81a21f10d739c0792cd29d5",
    # FGT_91E-v7.0.13.M-build0566-FORTINET
    "29d69d1119fe46c3885953a3492885bf3fb4127bd4432614d5aeb661a41ef2d1": "de7a9d7454e54d96e9a3ca3b2bc8805cecd9ba74e86cff9c0f65670e8a911666 311e58c3aa57ba40bcb90ec13d322fe6",
    # FGT_91E-v7.0.14.M-build0601-FORTINET
    "79e1ca2bb792407eb5fdf179e2609aa3e1fb2179249690ad50ec1a755cb02467": "638196d8f69b0af511fa5ecfc8dc7cff7a7ab2dc76f31b72b622f046c4f74d7b 190ffa36574c65c3dffb179d299dc67a",
    # FGT_91E-v7.4.1.F-build2463-FORTINET
    "bd36ed29e02e10f72c01c7b978d7a08740d1046278a2f6b1fd322b02e6b15560": "c235155077ea44fcbb522955458912bd8f65c593c1d8f68bd2a4b866d3b50e1c",
    # FGT_91E-v7.4.2.F-build2571-FORTINET
    "0ddf1e1de74261491fd1aea133748e7860c790f0dd726375236ffbdc5ae6694b": "3eaaeedcd7f0eb6fe2440ec6a5d625da46c20f23a3b92f7132e3209fdb79cd1f",
    # FGT_91E-v7.4.3.F-build2573-FORTINET
    "7acb2f38b50e2780bfd9b8e2604f70fc7c8a2a4e8cb1a3f60212749512e91bf6": "81adb1979d5459fbd9a5d06c3c4ba922eb44eb3677d946e0107b96a2492bbb6d",
    # FGT_91G-v7.0.13.M-build7121-FORTINET
    "d256aeb88c09e466235f37fb297cf6ee0bcfa18430b7786046942ee75e0a93bd": "bcd8a2341e091545385a683f921b19e1b8fe1a0fa5fef6597a1830653763f3fa 19576a40d56c587aad4470620a67825f",
    # FGT_ARM64_AWS-v7.0.13.M-build0566-FORTINET
    "ad90c19c11b13898023f08b8b5963f06d2555b1187b04ee47b290e8ffcfe3034": "edfa61bb14e535f4e20676421618be394c97d91ce07e8106b0198e3ff69fc477 559208f9230a8a9c8ba768f2c4e5af89",
    # FGT_ARM64_AWS-v7.0.14.M-build0601-FORTINET
    "b98d22f446ede13f2e733b8b1fbdf5500331dc6ad7a7bdf62c3a5a58907cde65": "3d1047c559b546e7c79f4243143ac6fde899846a9495bc65177dfd3e2f738da0 1bdc6a0ab03de62c96d2c4ea983160d4",
    # FGT_ARM64_AWS-v7.4.1.F-build2463-FORTINET
    "eb573e7e497fcf3dbe5f896af53b612d233467f20d2cea144796daf55212bdce": "2aff45af42a414bf98322967c1af3e3cc1328c5e60ce4e892f8d17b341b7a9cd",
    # FGT_ARM64_AWS-v7.4.2.F-build2571-FORTINET
    "cbdbf15bc00cc612fe420009ec47a9d831005eb4691452ceb16e94db656ce949": "6c9fa2758813038f1709757f78deb8f19adb385eccb0dd4d5cd144334a510263",
    # FGT_ARM64_AWS-v7.4.3.F-build2573-FORTINET
    "d0fd8a81274b57b08d4e14f5f3ddb420860e4794b2d1a551936a6cc54a4466c8": "2302cb858a750bd3fec4673a25e34809a38329595ff195a778cbe213b0d35284",
    # FGT_ARM64_AZURE-v7.4.1.F-build2463-FORTINET
    "dd427fe007668398e8ece8ae383a902076c3217232a2041059b4b57ed9317bd1": "c610b7119fd1564c8563f2bc364f3cb624d383e54150a30e9973ce1f973d0046",
    # FGT_ARM64_AZURE-v7.4.2.F-build2571-FORTINET
    "c12ae2394fe66edc2db6391b2bf08c13dadb7f9dfb3bb2fec0174736d6bf6deb": "5b524bbf44455b198ed554196e0bceea8747e85294c35957fa828cf7afd3df95",
    # FGT_ARM64_AZURE-v7.4.3.F-build2573-FORTINET
    "956f5a05d336cd3714e7ff4283862cf052b89ca621e1cdc41ba7512e553684d5": "584c64a64f70081c03505d14a50260d825e0cf78ef006d9eeef9a855605ba263",
    # FGT_ARM64_GCP-v7.4.1.F-build2463-FORTINET
    "6387ea04b0ef62276d71e5d6691e934ee0231246da7c9473c5a22abe477ca93b": "f2852af43ba8e2bd2f7007a4bfba65359400470e359f19e77151ab791cd1d677",
    # FGT_ARM64_GCP-v7.4.2.F-build2571-FORTINET
    "8bc2990e4ce948f4ddc4b04e29db5dbcf1e9a95b7d45953fd9341bd2ddee9b5a": "75f2d38ed37c4397431924d11c2c38a7adff513252fe3ff27a75141282776191",
    # FGT_ARM64_GCP-v7.4.3.F-build2573-FORTINET
    "ea13f87536965c50c628d865dde5d05b1a7229fdb856c8f95c9baa78f4356b66": "30a1429124666084406f7d17aef13e67bfc127e15827957d03a8d4de76dce8d0",
    # FGT_ARM64_KVM-v7.0.13.M-build0566-FORTINET
    "6262f9948fe53870b144326fe50dfdeb202b81461609bbea54b91a05164f7585": "6b4244062dd92b3333591d97f810632e79c1e9a940487b59edd76bf4736a2ffb d6449ccf89fdc47a66e8524f5a81808a",
    # FGT_ARM64_KVM-v7.0.14.M-build0601-FORTINET
    "16502c8be6e982cee9c76ba895ccd6dbc26c7b2f95b4900e94dc12344a9d0b4e": "a95e7342705d04fa7d23425bb8e59b680a6ec2ec005824f850c07cf172285eb4 f995e21acaa546a74cc05f445686a3c4",
    # FGT_ARM64_KVM-v7.4.1.F-build2463-FORTINET
    "2de8d8e3067343cc9a5b33efda19bc602bde5ec8cbf64b44373fc8e5a54a7e11": "96932b0825425183d2f27e848eb525d8a5cc6ea9e169c8ceafd220c176657679",
    # FGT_ARM64_KVM-v7.4.2.F-build2571-FORTINET
    "b41f6c3bbd9038f9dd5d254a4ffe640e9fd970011f6021ec0fab17c818d3464d": "e406774c8837e1244ebdb7fe5abc691f77ef332e7d0f34a3eb810d08e89dc573",
    # FGT_ARM64_KVM-v7.4.3.F-build2573-FORTINET
    "0b6c678058e48add5786444233438c97da87cc0134384e38237e8decbb287e1f": "e6690a64563c3f8b6a2d628aaa5d10e42d1ca73b973902f04d4fdc1169f0e47f",
    # FGT_ARM64_OCI-v7.0.13.M-build0566-FORTINET
    "c7d6e53eb599083dfc991b96590137c94d7ac4b971c97cec54ae77ee11b3d29e": "7d8d4aa7f2477e5f9ba6de8266700dfcdc7d0379f3ad182360cbcf53fceec4ff c7a6ec4c727ba8f5a35010b3b9dfcdc8",
    # FGT_ARM64_OCI-v7.0.14.M-build0601-FORTINET
    "317acf4397dd2bfd339a874e28eac0a817f8ef08af3a82d102407f8026926318": "77adeae20591b54afe6d6654bde260c105a89f2df119e1941c558774b9fc0ded 640216c293b4260d3aea6243b79a4e30",
    # FGT_ARM64_OCI-v7.4.1.F-build2463-FORTINET
    "889b3a98ac161859805752324b408334f81e484c5a0ce699b19424baafd84a87": "d97f2ba3e015caefdf1c433f6eee93296fa685efd60e0ecd5d5ecab19b89bd59",
    # FGT_ARM64_OCI-v7.4.2.F-build2571-FORTINET
    "fe8f12cb4c838bf09fabd3167c7fc774ce36389e17710b207a6240a5601cfd96": "23bc5895e31f3295158256a492004a56f5de77c87d07f2a7320ac1b406811a20",
    # FGT_ARM64_OCI-v7.4.3.F-build2573-FORTINET
    "ba4226140c8f06a2900975d589235ba509b3e98899df91bff09e2888ad3f8f3e": "466d8f0888a4989eb094bd2364fc24e9dce76ffef6108076ba3e18fb7121ba5e",
    # FGT_VM64-v7.0.13.M-build0566-FORTINET
    "25cb2c8a419cde1f42d38fc6cbc95cf8b53db41096d0648015674d8220eba6bf": "c87e13e1f7d21c1aca81dc13329c3a948d6e420d3a859f3958bd098747873d08 87486a24637e9a66f09ec182eee25594",
    # FGT_VM64-v7.0.14.M-build0601-FORTINET
    "67d4c913b1ceb7a62e2076ca835ebfdc67e65c7716fc604caa7552512f171197": "9ba00c035bcaa97717d936f8268a973eb1dd64d19388153fad5f7849b8fdf0d8 9df4ba40dbddcf5ec9d2983681eb1940",
    # FGT_VM64-v7.4.1.F-build2463-FORTINET
    "a008b47327293e48502a121ee8709f243ad5da4e63d6f663c253db27bd01ea28": "366486c0f2c6322ec23e4f33a98caa1b19d41c74bb4f25f6e8e2087b0655b30f",
    # FGT_VM64-v7.4.2.F-build2571-FORTINET
    "c392cf83ab484e0b2419b2711b02cdc88a73db35634c10340037243394a586eb": "480767be539de28ee773497fa731dd6368adc9946df61da8e1253fa402ba0302",
    # FGT_VM64-v7.4.3.F-build2573-FORTINET
    "ba0450947e51844588b29bd302d2a1a3802f7718cf6840011c1b34f1c1f0bb89": "4cf7a950b99cf29b0343e7ba6c609e49d9766f16c6d2f075f72ad400542f0765",
    # FGT_VM64_ALI-v7.0.13.M-build0566-FORTINET
    "2aa7faceb9a0b29235ce64dab0f552e9433fcd6081818710726593584b2e77b6": "60fbcc1a35d877256014517373862d1394184c968ea08adcd97fe01ce4a10119 5bfdddc7fcbf327e3669ee8112c100fc",
    # FGT_VM64_ALI-v7.0.14.M-build0601-FORTINET
    "e26deda186c600ab07ec65d44085c27a474b57a74ba481486f4c209a82d1b8c6": "bbf45b5a0c459d2fe3ed8d6fe578ec20455e764312c18e580a7dab91d9c935d5 d2d14e120056e30b9f3a371e088505b7",
    # FGT_VM64_ALI-v7.4.1.F-build2463-FORTINET
    "2043806c25d8de1edbe8c74e9c7414b415d10efd02368e8730b8bf8ce504ec9d": "6b3e00788380e9411750189079da5a4b53649a6b8d3e2b5dd67993e2498d119d",
    # FGT_VM64_ALI-v7.4.2.F-build2571-FORTINET
    "9ad30477bf7434f4d1b297e78d66e435c9209de1a0fefb4508fbd6b7e6691004": "cfddb90a8fe941254d8ebc8f97766c0d6c4f506c4d3ab7b4b01e6e58e5276cd5",
    # FGT_VM64_ALI-v7.4.3.F-build2573-FORTINET
    "7ff5564f07c7d01caf62c5b8bb117dcde87c86e01d1f8f4ab1ce2e6c697b7457": "ac80c561989829b4c6089fa504b10053a640fd0b40e2c6d40ed6b1146e1ae70d",
    # FGT_VM64_AWS-v7.0.13.M-build0566-FORTINET
    "c907c6237a14a52c60eaed344c910a0e1a2e4cd017d60b2406bc18d23299a245": "6740da9b78014fb3e4c18cd748112924bdf39b973bb876ff2e19f30f2367c627 404168e81353dd9a10401e081d74f6e2",
    # FGT_VM64_AWS-v7.0.14.M-build0601-FORTINET
    "4f54f970eaf5fd83e581f7c8e2613bcd196056eb9cd2f3327668ac7491df4587": "cbdc05444e6881ac3be2a7d055f1ac5cad95af49baaa48129b90ac13425c8399 0c83f80a274c0588bdabfb1970277cbe",
    # FGT_VM64_AWS-v7.4.1.F-build2463-FORTINET
    "bf1e14e0daac5db5bcac2b26df49b1d5f6abdeda5155f1b759192fd7ea1db699": "dd83e3d39d5a7d0ff14efe63970fb814e3e3c9e2ecaa17565189150e9a63b9fe",
    # FGT_VM64_AWS-v7.4.2.F-build2571-FORTINET
    "52738f8a1e1cbed207160d6bfb2251c0ab173f941a401525e0a5274f6ddd8786": "5fa20dd9bfd254f59c2e0c899c8f7e348cbe89231c39d2eb6726f4dd3fd658a7",
    # FGT_VM64_AWS-v7.4.3.F-build2573-FORTINET
    "02b66d72be45af0286bfff14a12c1f61b6056f5c0cc90d9a7f6ee3939d3731b0": "99b34081d2cdf769318475f4f51cf9379501160f39937a9ba1f552e8dfd39c87",
    # FGT_VM64_AZURE-v7.0.13.M-build0566-FORTINET
    "8d97cb5ec598bd81ceb8791344f89206d26c5d5752a6ae2ac942bf38695e5466": "9368b7c395089ab7a972172b4382cb10d01760c0138db8f758a988bf0899a727 8db1bfe592c008749a8394a9b9e141ef",
    # FGT_VM64_AZURE-v7.0.14.M-build0601-FORTINET
    "6f940ab0f4d25ab8621fdca9b6707ff22e18dff71d3aafdb95b7e829c8481da7": "6ac5e219032251127239715fa06fa76abb92e4e1f61f01a57594b305a62fc82d 68c121e91323ea4599152b267ea2f109",
    # FGT_VM64_AZURE-v7.4.1.F-build2463-FORTINET
    "fe803c4d7e21662c9fd86b6daf6d4d27bf290084971fb0d6d43415ce16c6d413": "ca86df4fba6710d0c82d2afcdb526f4eb59541a58835dc0f33a17d4d39d01792",
    # FGT_VM64_AZURE-v7.4.2.F-build2571-FORTINET
    "d625d0ef804e27094b744e0d1a70da1d97901cde3d51bfe05ecc0f12c99feb30": "6199df9c95c510c1cfacc95acc1d56c825f4e8f05e519680fe72feb2a25a1e53",
    # FGT_VM64_AZURE-v7.4.3.F-build2573-FORTINET
    "e13d9002fc056c67233b5455f2e244263bfc95dac3261f1e029140a8b7cac37f": "01b453db8d358d2cf8928afe879e9129685e28c630efdee891a405677ab5fa12",
    # FGT_VM64_GCP-v7.0.13.M-build0566-FORTINET
    "4647a0de16b20af15e407db242eabd686b86fb5d1b8436be38df69803e80cd1c": "6c42fd57625f5f094c6ffd4d62691536212aea938ca5094c6f4cb27acaed78aa 9bec66d11d95acce653abba5fb2113b0",
    # FGT_VM64_GCP-v7.0.14.M-build0601-FORTINET
    "dcf2d26ec7d1715abc91c99f0dcae3e3e76650137783262f9666632974fcc814": "844866268f3a6b22de691bc4fe9deddd5c760fd2c7ca993d7e86ecd029f601a1 32dc1e5ababf20150c09c65560bd805d",
    # FGT_VM64_GCP-v7.4.1.F-build2463-FORTINET
    "c70e0acab2acc0d287330993e83f81f81acd67a8810f85934ffd97b4eb6c6817": "c37334e6c13bc368b661b4698a5b6992acfbc502ab43736b1121407d064b2cc8",
    # FGT_VM64_GCP-v7.4.2.F-build2571-FORTINET
    "8cb9da64a28516715118c281c824eac0a09b4e8aeeff86fada7a4fbf86d39e97": "279d6d0b668d0dc2a6aa9dbff3cffaa8b41bd994236ccdf802b9326e65cb8b2e",
    # FGT_VM64_GCP-v7.4.3.F-build2573-FORTINET
    "5fc5e652bf02b3f42a7e1d2fd1e60a59e5af683a9bab5329ab0ac64d196f34a2": "7bfacb34cbbeda0f81b197cfed42220841210cf75c0806f0d5471f61a797e58d",
    # FGT_VM64_HV-v7.0.13.M-build0566-FORTINET
    "30bafb7b6dfcfa11b15315582d26a43e52351ee9a27797f45400f3a9460c8969": "c83a7d7fdacfa595f9658d68f6e88194745e5482ad596c42a9dc835a65bb62bd d5f8e9319d975f75f5d950cfd1aa2e23",
    # FGT_VM64_HV-v7.0.14.M-build0601-FORTINET
    "ad651fb1af2bb65c3810fd2d57d6a54257beb18cd51868b0a536a9f6be4fe8dc": "698ba1a961f3e989f475b9877f7d616cfb34df42c4cd6a4ddff5c6b64a05e66f 4ac33b9da53ddd8611421ca2e4c1bed0",
    # FGT_VM64_HV-v7.4.1.F-build2463-FORTINET
    "10c165bee8d5c2acaae3cf6299ae70313c9b371b2cefa06c30a347092fbca064": "673f9672d4e4518e4c1b0676d2cf7bb73745130d223f55ae5706db7aeb7ee0cb",
    # FGT_VM64_HV-v7.4.2.F-build2571-FORTINET
    "d9310c5274d9c606c4b64b6be9942589cf8f33c98f379ccd56b486a71d659036": "62cc0a65287de21fd0ae24d03baecbc3e08eee69f97bd5e41f4da5ed72859a10",
    # FGT_VM64_HV-v7.4.3.F-build2573-FORTINET
    "8ddbab6589233844d7943cbcf48de13d2816c8db2b85edc129e24fd6e68bb7d1": "042d15d38867f65b5b6719f09b4d5679d6c9278f6aed5cfe45a87804311a669c",
    # FGT_VM64_IBM-v7.0.13.M-build0566-FORTINET
    "3b843a585fce7f0e34cbd1fbae92f7d4eb4ad24c5634665e4196a864a2774a89": "dd52f130c8ca25a109236aab5e8f081e4e2135be0d7771c1468a3fbd51d25975 0c90827000347dc667f9116b5b3752d1",
    # FGT_VM64_IBM-v7.0.14.M-build0601-FORTINET
    "b8ff76df1ade5a0cb344fffbcfd94e2188f6ada7b5e28d7378c30b642519f7b5": "d13e628c88ee1fa4f96af03257eea6bb2cec218b855610a758a6456b2c4bd176 c5ed5651b993b77731e866ddd2e12c2e",
    # FGT_VM64_IBM-v7.4.1.F-build2463-FORTINET
    "f4ff1e81eb7293e3b5abf228c15f96233ee51a9241edb124f0fde664641cf7ce": "e5d2ffaf5f9274d96ef7131b3f70b674a2356757a2b450b30ca3ad3db689b534",
    # FGT_VM64_IBM-v7.4.2.F-build2571-FORTINET
    "c65be5c5380c3cf5393a556b5a0a38790e480aaeb496832f1b4920f38eb65b8b": "b6a99b440f17fd76958111e08efad9f19f27258f1d3c93d209666d3545efc4d3",
    # FGT_VM64_IBM-v7.4.3.F-build2573-FORTINET
    "a3f3de98f208ff20047029068bec8712e70da257b70212bb1f1b13a24e61777f": "38c2d0c81af5f96c5a92fc8b1853f38c0d677f761a48f14c757a2b1739598133",
    # FGT_VM64_KVM-v7.0.13.M-build0566-FORTINET
    "96404e366ac402a1abd895ad2ff9bb7520fdf50bda8678a7b80b6c87bf547932": "e9f117b3930abdf36eea7f0419c4df72b30570285c91009e62a8515266b9a5eb 1c13717cef7e461f862db077618cd7c1",
    # FGT_VM64_KVM-v7.0.14.M-build0601-FORTINET
    "dbcdb3a7bcec47ab6c91ab4764c9cab010b785b8dfaa5a5c84f882fab350159b": "afaca7a2bb226cb5084679faa69eb785ed9bd4f10027c9efe870acdbb1bfcbce c4d6a1f3dc2034979a6d958881db63a8",
    # FGT_VM64_KVM-v7.4.1.F-build2463-FORTINET
    "26af699026a09a72be0c243f55b933f4151aa39437a7f697e018e725e2a1110b": "811af728288a99ae490366de131ac4997abcc75d9b0ab5440ca832fdd5c5f6a2",
    # FGT_VM64_KVM-v7.4.2.F-build2571-FORTINET
    "d0b1f4e81b755156bda15852f06555f1ae48d809472246f50dd7cecf5ec766d0": "5dbb868fda6e5f3c9cf6cba5236cfdb09fb96a8495729f07f1f1480f05f37b60",
    # FGT_VM64_KVM-v7.4.3.F-build2573-FORTINET
    "03fe6b59525a8d4b0e1dd789bbd44c95c288255a87d78255f1c774a04e2609aa": "64693c17f02c68ac537b30796080f9819c01ae89a4d5258c4f9485404847a025",
    # FGT_VM64_OPC-v7.0.13.M-build0566-FORTINET
    "e91ba1c7f125066ed7a3b57855892592af9a9c2b7a3860dc04d269adb6a09088": "d037361be71ce10f4af05d33caca77077d17de1c7dbff2e604ce8a1aaa5fb628 5e5b847936c9567fc34108a995391a29",
    # FGT_VM64_OPC-v7.0.14.M-build0601-FORTINET
    "27871cdc6581e0e9d5665fc968874c0b365bd68e00b2ff7a8584d258a1de77d8": "7e13f006c6991fb89289f68d6d67cf1a9471fb7589389c224208855ab7dce2d3 9d1f54792b28cf77265843fcd7a91935",
    # FGT_VM64_OPC-v7.4.1.F-build2463-FORTINET
    "030ab163586fa24f86712a7d2f2df7c2f9395049fabdb8abbfa078ebab20469c": "3a62d003e0f61ff73490dac0400cfa5f7543c23800cef99e00a207bceefa0182",
    # FGT_VM64_OPC-v7.4.2.F-build2571-FORTINET
    "72614a6d2ddcfe5b0729ab8fb00eb082aeadfa333a19cf21ee9641c6c53bf56b": "331f309ddee50673f624bc4f10acb1e0b31b067d0600ee2a30fc77f38964a332",
    # FGT_VM64_OPC-v7.4.3.F-build2573-FORTINET
    "c1d656b60c1e200b846656c84779c740d5f73bd13c631b70f143b2af0ff9d5f7": "7cde9af207208d0483a13eebe85a6af3c857616e71ff269d8bac0b7915c8d507",
    # FGT_VM64_RAXONDEMAND-v7.0.13.M-build0566-FORTINET
    "277cf57bcf11003a4f50df85f2cb9fcb44716144588052d4f26f8881d4ec8afc": "c296c98c3f4ae9dc4853f57245dd2ba64dba97c12980474b31206facdb4201b1 047ebf84858974abdd159346243f0116",
    # FGT_VM64_RAXONDEMAND-v7.0.14.M-build0601-FORTINET
    "a2217497d60ab1a570eb0e3ee070da43b336e2fe02ab3c674c85eff24349fdd6": "c9a26db8e492f583ba5a0e7720baf5ae46cd5374361d240ca452719857368a12 850584a9ebbdcdf573eb40a4f2f0e69c",
    # FGT_VM64_RAXONDEMAND-v7.4.1.F-build2463-FORTINET
    "b412991fdf45604b60e1640a9eaa11453027eca4928e4b6edf996dad9350ce96": "caa7b0a76a8b6271c7fa2b2cbbd869c87bb66536adaecf20c6ce033c2f25ae28",
    # FGT_VM64_RAXONDEMAND-v7.4.2.F-build2571-FORTINET
    "1a7053c99fa69d7363d79d93b26b92a65c76f806d26b759c396777e355850b36": "15ce132217ec3570d9f51088abf9acf927903498d0cb8c75534c6b8cf869c79b",
    # FGT_VM64_RAXONDEMAND-v7.4.3.F-build2573-FORTINET
    "c57fbf31e70d8584823f96af1dabdf5178aa5e10703bbe446590b4505054de77": "c29c99ae52259613e8f647a6ee3ce082d321c8a6a7f37c8cdd0acecb8f44e017",
    # FGT_VM64_SVM-v7.0.13.M-build0566-FORTINET
    "c504304a600969ff47da1150a65a9e709c54defa099f1f3a90f13b383f43031a": "c875b60a71414b0d0a3c043cafa34a65a52c3d24bb9f87ff0397fc52865e6640 9e7ad15f4183538658e324650f07f678",
    # FGT_VM64_SVM-v7.0.14.M-build0601-FORTINET
    "a4eef267ee44040fae15b83dbecccc341248cbd4ce96600a775983bd4d3b86f3": "99bc1047b51c629aec881ec9825f1918a688658c00d74cd322b5ffda79d61012 7cb403c0decd77c8165239d0f90864ca",
    # FGT_VM64_VMX-v7.0.13.M-build0566-FORTINET
    "5459644455c356b823371cc20a0140ff840e9b489fd71419da3467323fc9deac": "6924444d45dd76329a2c0670241e9e3dbbf1d6049ae17854fa17a397196282fa e5718d29a2b653c9b1a4a18a462c43e9",
    # FGT_VM64_VMX-v7.0.14.M-build0601-FORTINET
    "20fd5b9fb7387c056d18a6aa51d6cd2121c45c827077dcc22f546591619c6e44": "56e807db49fbcadb19cc719e9a8cd1eafb2f04aa800992089920ed75a6a7e2c7 ad912f6f408fd649dec096d6dd5ca79f",
    # FGT_VM64_XEN-v7.0.13.M-build0566-FORTINET
    "a5261d354a6076c91fd434f929f53313b6507bd242911943efc7cb17511b01df": "3bafc3503fd83f94c4ca07dd4a5fc6d93beb5c6fa96b9285529dc718801ba1bc 5933960d17ca7ffd8709a8e46cfc66cf",
    # FGT_VM64_XEN-v7.0.14.M-build0601-FORTINET
    "93fc705cd98ae6317a2e57f097b8cb654b49b8168345a7041a65a045b7aed70b": "5cde745df08b28e12fdbc1ff35d0f194c92936f406c1251b635b13238cf216c0 476e7fc9407e47dce2397aede506e3ed",
    # FGT_VM64_XEN-v7.4.1.F-build2463-FORTINET
    "567d01ca73f65bfc02141845692464bf08885963f7ec923bbca2c9aae662193a": "2639a131fd458299af4be42a691bcb123bade8b314422d9e6084bb410b39315a",
    # FGT_VM64_XEN-v7.4.2.F-build2571-FORTINET
    "d0bbaa36723c36f7c763d869c7a6e946854ac5bc4c6c44ea03d1b5843cd42a89": "14c6607c1b675b7ec6d4c1a437e51dee2e742158b782f56c72d8fc5aae72f296",
    # FGT_VM64_XEN-v7.4.3.F-build2573-FORTINET
    "8951cb7b09bc3db2b8046d0b07fcda9ca83896e2fede2823ed72f4650398de48": "9cf653a43614cd0ec349b6f1589c9911badd5dd9181b29eb2c511e6362279506",
    # FOS_VM64-v7.0.13.M-build0566-FORTINET
    "d0c78b38525ddd20d098f813d26ddde80ab7ddbeba764fb85d25d79c423cc54d": "f6bdb0078ff41b1579cd1a93d390206346da620ebaec5a17dba9b0f120259b8d 438639432ee6c3fd2a2d6db6989bb4b5",
    # FOS_VM64-v7.0.14.M-build0601-FORTINET
    "94e189c43d130b45eb86043ffbd1b9afd7d14c37ce1481be3149a2f8ed198476": "438917b1623268c8a634f530892d1aab9b005d9efbdd85448aa78650a326bcd5 fb8a865efc8d12357a98d09c7f4eda81",
    # FOS_VM64_HV-v7.0.13.M-build0566-FORTINET
    "d63111b1c6920149b5b1b3879e7520ab4bc7af8935f30eafe30d27ba1459a2f4": "74b5cdb5e9bb544e8f6fd8393428c4cae010d08c7c5dc0bd3acebcbeafae6e4e 7e3b61ea6d78671c48d8aa242b611f83",
    # FOS_VM64_HV-v7.0.14.M-build0601-FORTINET
    "33cb5cd4012736351afd26790e17ed71049bc8161abbab251fe2decbddbb86a4": "8babb640582ccc0f74908da64a4ab61d29ed3e5cf1c80edc461a36bfd82329b5 fb744f0048e4523aaa8b885616be4796",
    # FOS_VM64_KVM-v7.0.13.M-build0566-FORTINET
    "ea073d4d7ff0e75dbc3421aadb1eca897b62fcfb1d56553fec267f4657f00f7c": "1fe82df074f717e934ad85b48c33dba80266be8b99c5276d0100ec50fef2e19d 03bbee6cc9479d5d5a8713ff87cf20d8",
    # FOS_VM64_KVM-v7.0.14.M-build0601-FORTINET
    "4db1709d293ef46e29b4c13042ffb22012c9ff616667548e807aba874dfed7e6": "4e5a7c8c5bf1f945050c51e9e3782ee97fd595a29d56208f2aa8e748071e38d3 a499258f33160c205eef50812e4ab7d0",
    # FOS_VM64_XEN-v7.0.13.M-build0566-FORTINET
    "9311c7baeea78e59f076aa60dbcebc2e66715e631ed66ecfabf7fe3462f80d20": "9742d94d5fedaf05ac767f98ee956b13426158fbff2480bbe121ea3f6740ded3 4483a4e993b948f9c73b227c3ba8fbd3",
    # FOS_VM64_XEN-v7.0.14.M-build0601-FORTINET
    "64bdd9463e1be4d01e307a6e3f8578be2714e064a829224a9e3c9bc6b0a38e45": "a825debf4bad44b9b57a3788fa5c16d2ac0c0a8e44bee2a93b2b1b5ae2252085 9aef31acb73af4b8ce74727a3edf2ec5",
    # FWF_40F-v7.0.13.M-build0566-FORTINET
    "5118227e08cb201714724f33bcc10b2bc970f3dd742335f329ec16269d114196": "6c4c0be41385247f7a8c480f16a466dfcba89c2c2f8e2c15f4c98d28d658aaa0 d19f4f860cdd25163ac52a31fd5d3794",
    # FWF_40F-v7.0.14.M-build0601-FORTINET
    "a84dfeeb19619ad45bc261b37d78490e0294cfa69ae9f22010babb423e310d1c": "700ff38f82c5963f126d8c57035783a7c3cacdc64824d32b32c5691f8e360010 dc4a7e2a52cc8e0fb0a15fc7a79f94dc",
    # FWF_40F-v7.4.1.F-build2463-FORTINET
    "1a1bafb78192ec9c56242fae30d58d402b9b4615ee9fd694ad55138ae25312d0": "33feab7920bb0e94445d814b5cd1c3c7ad623c0218673c7527d0578c391c077b",
    # FWF_40F-v7.4.2.F-build2571-FORTINET
    "b74e6808c9e6540c2892e7c62e24b4f85755bb3497432f8b89e2e4e8386846bb": "87e9221eb376e13dbc3ee4b09407b28a3215f101b917602fa35fdfa0a7367cb5",
    # FWF_40F-v7.4.3.F-build2573-FORTINET
    "f4f22eb0cf8c45c4c7781676c0f43524653fced4cdc24bcb104270bc987da425": "30690d3b35387ff1f817a35a00fa6187840fef6a0d84ef3f0144aca47edc319e",
    # FWF_40F_3G4G-v7.0.13.M-build0566-FORTINET
    "306752ab7a4ba8c94c8de9c3524c22f1c5fafaa9cbf1c65b7a65cd295ad46c87": "8168872e5f5217cff85ca81c8d3379341c4a0c47554e161871ba5663226c7589 4854d7df285ba6551712c3674a8106f0",
    # FWF_40F_3G4G-v7.0.14.M-build0601-FORTINET
    "d14adc8cdb24f586c343ef3c843b97d563bd44eede19ca5292eb0b1cacda2cf2": "49357b7979e89ecbce904533753ff9547cb2fb719404cea1e2b42e2703e445e9 a5f6fe8ced97be77598e44113e5bd577",
    # FWF_40F_3G4G-v7.4.1.F-build2463-FORTINET
    "d6780265afab2535ba48eb1e5adf8fa643282f8ffad06eea500b09e78b21b1fb": "49f75204a9c11b9b87ce8a32aa1023ba882d771ed39cefe7c5cd218bd7d9801a",
    # FWF_40F_3G4G-v7.4.2.F-build2571-FORTINET
    "f258c027bac0b9c7bf746d04f97e41c387ddd43e3f8b5e8f4899388a3eb0ab4d": "031c37f376b30acc63a0cad67b324e40eed3c8a16df08a29a8075f6559630398",
    # FWF_40F_3G4G-v7.4.3.F-build2573-FORTINET
    "c5e78caf91976def879382c858fb19ef55b7d042b369f6cc8fe79226994c2841": "49c2cf5158dc8cdd04ffab1abf6f9280da9fa9ab68eead124af958a03f032ecd",
    # FWF_60E-v7.0.13.M-build0566-FORTINET
    "7d4b8ab9895409bb9aa2df1b3af75e45cce5d29762b01659ec5b294ff9be13ba": "a7404b93e0d3fc1c211f135599a5f651e9fe2dedd5d9e37d3ef939acc37ad629 3934a524d7f2dfe2a8b0ff02ecd4739f",
    # FWF_60E-v7.0.14.M-build0601-FORTINET
    "5a84a1f473e99dcc9e8930c0ac44d1664490590a3b9f863a5c4681ee07dceed6": "bbd7a52bc09f90eb651acb19a4e3337a82bcee1573261d0f70da515ad8aba9d2 9888961208a3ac5bc36b08dd7c6d6911",
    # FWF_60E-v7.4.1.F-build2463-FORTINET
    "21fde5b8c698eefcb9e9f43e7a4eca403c039b3a5598060b75aef2353dd6454c": "bf3e11babe4751b888784c47363a2a199dca08b7e459d014786638f0f6b11db4",
    # FWF_60E-v7.4.2.F-build2571-FORTINET
    "09c3c9c070fdbcd00095962c5284524de6257893c8598515eb0504cd3c62a533": "8640e29714d03cd3019c1b3e23b50124f5aa35cf610628777f6d894cf4f11d89",
    # FWF_60E-v7.4.3.F-build2573-FORTINET
    "31f3773c79f50f8bf6b87cdc4b5fab93b47fc39a98317566f7d3fdbad03b078c": "5ef0a3a9bf70902e53d3b763ac073a7a5008e5a4962f6538ac7829e1089342c1",
    # FWF_60E_DSL-v7.0.13.M-build0566-FORTINET
    "e20e73a1c133c55d717d6dc97b95aa88decea6e241415891c3564cccd5199cdf": "0307d336e257e57b97ee8e3fb7b76a438e181314b595630dd04000cc9437fd58 46dd291a40fd2f86d165f88268fd5912",
    # FWF_60E_DSL-v7.0.14.M-build0601-FORTINET
    "3f3e6bd69d083e5e33eb04a67f1eca0ce34233e63f80e151c74ce5719b43fd33": "28f0826a28fd0b8eb15b8f158471f63419e3a89961842af8a78d638149889d06 614524c6d28f888881a4d1f16bcdde42",
    # FWF_60E_DSL-v7.4.1.F-build2463-FORTINET
    "df59de5847053209abce36c940d533556200715ae4a88701f9041c844fd51b36": "c6f4a0ae98c6b35e135704ed017c6f09f81503fb2c92dcbf2a266d8791bf1a1b",
    # FWF_60E_DSL-v7.4.2.F-build2571-FORTINET
    "ceba9d64a9caf714b16059ed4962067c25d50bb14dbdb98a3148af6e8a1c75d6": "d16b12146ef53ef41833b784eeca07b31ce2e80a1d8a1b3695d8cbc6f1158b79",
    # FWF_60E_DSL-v7.4.3.F-build2573-FORTINET
    "b01ccd2a345f5e4e26a617326b6ed102a08d2528c552548c4e68a26f5d392345": "1059b71f798d20dae998130690b1c5407336e39ae3ef6d5ee5be222f7879e7f2",
    # FWF_60E_DSLJ-v7.0.13.M-build0566-FORTINET
    "29433d147bc102b7dfb802569eae9686744b8d17db6fb2045de0b98eaee7ad62": "89956b19012081265d3a668d9838bfd869f4c363fcb5c45a07c405631a68b732 bc0e07adc3379711caa860921e31ad4b",
    # FWF_60E_DSLJ-v7.0.14.M-build0601-FORTINET
    "fc67d3ae2d106ead5d07f4e89ce81e520f5808815a389076b4cea71885eaaa82": "d83963b5f7f0d8674d6237c65e5d27a53248189bf61e6e1d7591cd6e8c22a02b 454ee8a69ddffa93fd0fe00afaf1013c",
    # FWF_60E_DSLJ-v7.4.1.F-build2463-FORTINET
    "5878a52a3ab83ed5c9c04dc7335fe6dd3576321734448359007f1fcd68d39789": "ee971994fb34755ff45a932a18de1d6352808ea5ab126e18830f8b410c800791",
    # FWF_60E_DSLJ-v7.4.2.F-build2571-FORTINET
    "50aeff4e538845cd5dc01e8ef818c2ea92fd0de2690bdc66fcd91f248f7d6b48": "b364657221ac797bccd4dc177901842eff198d89e8424a3184de90daf9c32f56",
    # FWF_60E_DSLJ-v7.4.3.F-build2573-FORTINET
    "e26e828e3129f10650a7b5d040f44b29d664718f58fffa56eb74abe837f3b869": "48cf7fcc44177e8649c3b9425f3afb4e628a5ba5f7179d0c8839e0865fff7572",
    # FWF_60F-v7.0.13.M-build0566-FORTINET
    "a7d1aa6e332393d775cb679e5363252f1ae3417636f9b4b0997b7f175f3c7fb0": "97a5e989988603360a63d41a14a6a96c33705836b514e6830438d1404e279ca7 e3f91c9af5ec9d723967d6e6a5771ba1",
    # FWF_60F-v7.0.14.M-build0601-FORTINET
    "cec44ac8f650456d8ccba1de1df767125909f540fd0edeec8d92971fadda8a8f": "eeeb0e66b3c40e17e81df07d27f9a69d7e8520cf9904caf396d430b5f55827d9 0c0355473256a34f7e220d232b6752db",
    # FWF_60F-v7.4.1.F-build2463-FORTINET
    "96efdd36eaaf0778601faf73b4afc27a09380512c5955d307c399aa711ac4f48": "f0088862942aa248ef8fb17fdf24c4ab47fc40e9de245da613781f7ba28ea97b",
    # FWF_60F-v7.4.2.F-build2571-FORTINET
    "c9f6940b3baeb2825fb4d9241c952bb9a3805c0af35a9b4d36b69f1e6a4d4a3d": "df70dd5112677e7e780ecd87299cd2cf73ae0b44038f3f7f3ca130fce78e2b85",
    # FWF_60F-v7.4.3.F-build2573-FORTINET
    "7ad838c2a1d02da37c76ea5f0edc0ec208471ecb01de3f9b32eba08a23ad3599": "f1a7527041b162c2f792085b5aa69982284af851e36676fbe7528c06bb2ce313",
    # FWF_61E-v7.0.13.M-build0566-FORTINET
    "ada2ce4d14e30292beb27ec02007ca7107adee3d555a36df80c089ff3e0f4a0b": "fb14b50bdf88c209e076419ab597b865331f4e325124d3a72da8cdfbbc131dce ac5f21e5926c201e44ad440a06084660",
    # FWF_61E-v7.0.14.M-build0601-FORTINET
    "19faf39de5c16bd5e4869ad2de19c2b064d2736c404f79b914d58e04dac1a499": "02557e65ae9e4ce0c09917dd223f6aab83544f13c0d15ec3e74a900305734058 930958bfd759bd27ba24b2f9395cd084",
    # FWF_61E-v7.4.1.F-build2463-FORTINET
    "5127b8bb64a06a189a686739c9ac2ef82304299192007683dc0aea4a19970617": "3c2ede28d15ffe3bc92026c0d34532d070327a090ad60c73a81328f21d242faa",
    # FWF_61E-v7.4.2.F-build2571-FORTINET
    "b02f629ba836274ce7dad7e1f8172cf4015f0c1222d60f98362d809ea047a790": "007fa3a4205ddcbb91d021bb647375573dc0e7b56802deba2fb71de3f6329bd9",
    # FWF_61E-v7.4.3.F-build2573-FORTINET
    "be4d2903c4bb2ee9d5b2c5c0d124557f792b58f222952e8ad02d55092a2ee48f": "1e907f45969521939c85aec9d2af39c18d9ac2069b32b53b9f80d49f1cb10fe1",
    # FWF_61F-v7.0.13.M-build0566-FORTINET
    "068a74274af6417a91bcb86bec10a25cce321e4e1e2524b0eaaf75e88d95fc7e": "82d66c74612154ff1728d60cdfbf08d56ae2e7233cc13d368640fa1f996ce116 b922fe8b5a44e4d0475a7d09baa0ab09",
    # FWF_61F-v7.0.14.M-build0601-FORTINET
    "f87598c20675a3ad0db72e4ff1d092a81fda20e8ee62e90a044bcfe0bcf9c6e1": "bc46b89a59008ff182e75ad7c1a6831fcd7ce0696e4d2b7e48dd24c8acb879f3 32b5ca9cd3a2e393ab4fb7c73b963090",
    # FWF_61F-v7.4.1.F-build2463-FORTINET
    "bc0d484b65d89c91d47a77fa8e2554eda4affb940788d3f248b36e539e77afe3": "8f199ff76c08b85db86bfeaa86e6cacb904d2a4d83a4aa16a67d5db15165b1d2",
    # FWF_61F-v7.4.2.F-build2571-FORTINET
    "40960250e57687de2ffd2acc077fed0298a7eec0ff702a7487e4e4c6197128e4": "0d8a802e0bb63db38a54040e083cf81108f5cbb3c0d34258caa97ebcb5a72661",
    # FWF_61F-v7.4.3.F-build2573-FORTINET
    "837d8c07f5f51dae250e0ea63dd2b390ca2880c1bbaaab056044869b59bfd1a4": "342957358102b52a760987b70c842feb6fde1339833a44dabd11a777369ab4d8",
    # FWF_80F_2R-v7.0.13.M-build0566-FORTINET
    "aabed28bb01c70f08dbbcd942ff7b4c387de3ae3ac4db75205c357b11c409cdd": "501519616bf615238e7d776075bb39a6c50c1748c207973a56ea65234cd06c07 2851f9359ea241bd71cc200e30fe7fd9",
    # FWF_80F_2R-v7.0.14.M-build0601-FORTINET
    "6759483f0ae25ceec250ee2585ab28955850532ac6f5a968470f08dcb860c0da": "e4d11ea233adf84f32254ef5eb0ba1d4d8021738a4304264e5d984d4c11b6ffa c276e972ef942978c2c19ba0b4b4e645",
    # FWF_80F_2R-v7.4.1.F-build2463-FORTINET
    "102c5d81d7f8f3dec96f48501b630275c492cff73733631299494cbc8d9b5d74": "3f0eabc3a1941bdfe83dd57903b5710b9fb4e2366d0bef6b4911dbda843cbc6f",
    # FWF_80F_2R-v7.4.2.F-build2571-FORTINET
    "71f8f725734807a334b422f2fd3ccef472e15b50f84ecd916a3e0c34255dc42a": "248658ffb7219aaadc9dc166d5b36299a210faff955a01a411a95f5ce5abedb7",
    # FWF_80F_2R-v7.4.3.F-build2573-FORTINET
    "f04841c636a6f7c1cd678f6b1a66a3c3375904d72d8a8f50a06f41bce33418a7": "da0e926c0867302003b6918b324c58e424ec3a171d3c5c7040a0a95e295e0c69",
    # FWF_80F_2R_3G4G_DSL-v7.0.13.M-build6913-FORTINET
    "380a47aab4cf26e5c97aff3c6a7c9dc7537c92700273c7c83f35d35ad6549d36": "44665877ceaad076806bfbe617b4b8ca640743b4b27984a488a2581e6ef4c1a0 d361b4d1159f96e3dbef7910032470ee",
    # FWF_80F_2R_3G4G_DSL-v7.0.14.M-build7173-FORTINET
    "d647a9dbc4d7320453f0f84684267b24fc90d549f3babde46f18bdd31cbdb454": "cd9819492b4e534fb61d5f08b77ccdde3b7a64737bf458c0b5cc6d5187394da3 bd11935d843af46ca5aaeae7f022b278",
    # FWF_81F_2R-v7.0.13.M-build0566-FORTINET
    "075c91613dd20e85c55b089e6efeb0e581de28018539be63585043d082153849": "4127936245f6096dcf973733e8072d51c92f99f1d0b658e9f989601f4924f1a8 0300fef3b16b934b7ffafece635e750d",
    # FWF_81F_2R-v7.0.14.M-build0601-FORTINET
    "c38b535eac88d607b2a10ca37562af924317f03abcce0a973fb886ad1feacc49": "9ac58aa6784287989ab1d7ab4729130333d5503829ab567bfbb4d0b5992d1fc7 f76148a2cb062371dd8b4548c9d08f0a",
    # FWF_81F_2R-v7.4.1.F-build2463-FORTINET
    "38af187eb44f4dd0168d8f8b9c81abe006a8860bbde65749ff7800c1b7d74565": "7f39826fadbb7e952f3201f2aee1379d7cd6200140a088e09aeef2709d154192",
    # FWF_81F_2R-v7.4.2.F-build2571-FORTINET
    "e06c2cf6431d668065a7473dd63ae5d8f5c9cdd229dea4d4745416a8e3727a14": "1123d1a11488630418e5dc571e7fce35ae1e42771ef43b82b38cb73fe609e5c4",
    # FWF_81F_2R-v7.4.3.F-build2573-FORTINET
    "83d4e6bea7c3667d05072a7d4b7f301322d69164d5b7be0b242a8a7dc04511bc": "1a5b92a1a2fe3bc688e78c5d6296a997264b3395f78ffae42f94343ea219a46b",
    # FWF_81F_2R_3G4G_DSL-v7.0.13.M-build6913-FORTINET
    "1a8e28b07188612e30c1be6fefb00fd330d09d3750cb6151200302181fa99f00": "3fef0f82540050deb98b02bb7f1d0bedc343bfeb597031a30e93a5e173f727fb 249d803e45f638911a95bc4228183c7e",
    # FWF_81F_2R_3G4G_DSL-v7.0.14.M-build7173-FORTINET
    "03a818f6989cfb0a0f25982f93f427e1609346368b7d3d247b3d1408b34f8204": "568a65173c1caef70c55dc7a9b514a059c0ffe59f53443c8616d069b9faec32d ef10a41b5e122adc3bd4e8072948fc14",
    # FWF_81F_2R_3G4G_POE-v7.0.13.M-build0566-FORTINET
    "e932f01b5e6202b98b0bd8764dc30c1291155b57bba515ff17da2b8c0a6f7eb9": "5e43f99a8b0ed7572b7de8682b79ef8bde6a8039dd01cbb318cb914f6c29d144 084f9f0e83109e6c607c9678bae260f4",
    # FWF_81F_2R_3G4G_POE-v7.0.14.M-build0601-FORTINET
    "a82a4679af6b0bb106e3d52f27349dcdadbb1d80e329c93a73df47a5afd29835": "ba9175b885dd7538a3a7391bfa46ddac3567f73981bbf2a81ae73563505bb0fe 38b8595d17091ff4217ed3715267fafb",
    # FWF_81F_2R_3G4G_POE-v7.4.1.F-build2463-FORTINET
    "42ab26aedde4fec68b62e4b593924d5bea927bc6466ae6c7c3a5356725185323": "c6b491a11cd564cb0c48a3f97333ed9c653f6ec939c2023ba7c4f64d88c5cfbd",
    # FWF_81F_2R_3G4G_POE-v7.4.2.F-build2571-FORTINET
    "42aec8606a6210e0b34675ebff5a5c084f637722c70157e4d72af8fd5a84b1d0": "d8ea12f10b1cb804e20193f065f44aadde8e588d77b4e0f594481916aa5ee966",
    # FWF_81F_2R_3G4G_POE-v7.4.3.F-build2573-FORTINET
    "170786f39d54196144bb34b2bed561a4035018521637756d7ae39d680d8dfcb5": "1593383972801dd60ed435668b1b8cb40e503224ddd43848732dd427c59e3071",
    # FWF_81F_2R_POE-v7.0.13.M-build0566-FORTINET
    "d3aa5a52ad06be3df86672784e3f76697a58725f8a87b7fc86a8674ad2fe9be0": "8b1cd9aab318e9d72bfc0670ddcf5a21bc881bcc86b42a4777fcc6abd38b39a9 36d5895a981f092a2b001b10a4a467ee",
    # FWF_81F_2R_POE-v7.0.14.M-build0601-FORTINET
    "73ee31d8b793a1d6272d4f9a511faa75ba4b0fff8900fb1b4398299443835c16": "5bc9b95ca71d87c0079955c7ff4465efc4c8088f45ef9dff5e6436428ce5a4ce 3ae7b03f91d28d40fcaec822bf5f7d94",
    # FWF_81F_2R_POE-v7.4.1.F-build2463-FORTINET
    "29279f4a168a7cb29f726962bf97af3bec26cb932e36d4dfa988ec9230a4b30d": "39252fe3cec846b2dbb3b5f0070b099089d3f0cf7f5cc616904027262bd6e267",
    # FWF_81F_2R_POE-v7.4.2.F-build2571-FORTINET
    "9898a78aa07a09ac0192ced7bcc422bb765b90ea16789329348c2b35000d94f7": "990074286787440b2c46307f3321f0ae500db6f9b1841b9866c438b6cc90fdb7",
    # FWF_81F_2R_POE-v7.4.3.F-build2573-FORTINET
    "29882e3f5945fe05459f8e890f092947575331919ec3efc8687fe1c8dd36de11": "580e131453a2f4c38cd1b6a36707d73155bebc4aa7d95e866cf5faa63a87616b",
}
