#!/bin/bash
# PaprWall Setup Script for Ubuntu/Debian
# This script installs all required dependencies for PaprWall
# EOL: LF enforced

set -e

# Colors for output
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m' # No Color

# Function to print colored output
print_info() {
    echo -e "${BLUE}[INFO]${NC} $1"
}

print_success() {
    echo -e "${GREEN}[SUCCESS]${NC} $1"
}

print_warning() {
    echo -e "${YELLOW}[WARNING]${NC} $1"
}

print_error() {
    echo -e "${RED}[ERROR]${NC} $1"
}

# Function to check if command exists
command_exists() {
    command -v "$1" >/dev/null 2>&1
}

# Print header
echo ""
echo "======================================================================"
echo "  PaprWall Setup Script for Ubuntu/Debian"
echo "  This will install all required dependencies"
echo "======================================================================"
echo