"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const wordpress_1 = require("./wordpress");
const app = new cdk.App();
const env = {
    region: process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
const stack = new cdk.Stack(app, 'demo-wordpress', { env });
new wordpress_1.WordPress(stack, 'WP', {
    auroraServerless: true,
    spot: true,
    enableExecuteCommand: true,
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcud29yZHByZXNzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2ludGVnLndvcmRwcmVzcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHFDQUFxQztBQUNyQywyQ0FBd0M7QUFHeEMsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFFMUIsTUFBTSxHQUFHLEdBQUc7SUFDVixNQUFNLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxrQkFBa0I7SUFDdEMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUJBQW1CO0NBQ3pDLENBQUM7QUFFRixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLGdCQUFnQixFQUFFLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztBQUU1RCxJQUFJLHFCQUFTLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRTtJQUN6QixnQkFBZ0IsRUFBRSxJQUFJO0lBQ3RCLElBQUksRUFBRSxJQUFJO0lBQ1Ysb0JBQW9CLEVBQUUsSUFBSTtDQUMzQixDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBXb3JkUHJlc3MgfSBmcm9tICcuL3dvcmRwcmVzcyc7XG5cblxuY29uc3QgYXBwID0gbmV3IGNkay5BcHAoKTtcblxuY29uc3QgZW52ID0ge1xuICByZWdpb246IHByb2Nlc3MuZW52LkNES19ERUZBVUxUX1JFR0lPTixcbiAgYWNjb3VudDogcHJvY2Vzcy5lbnYuQ0RLX0RFRkFVTFRfQUNDT1VOVCxcbn07XG5cbmNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjayhhcHAsICdkZW1vLXdvcmRwcmVzcycsIHsgZW52IH0pO1xuXG5uZXcgV29yZFByZXNzKHN0YWNrLCAnV1AnLCB7XG4gIGF1cm9yYVNlcnZlcmxlc3M6IHRydWUsXG4gIHNwb3Q6IHRydWUsXG4gIGVuYWJsZUV4ZWN1dGVDb21tYW5kOiB0cnVlLFxufSk7XG5cbiJdfQ==