import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SchemaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Display name for the schema.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/schema#display_name Schema#display_name}
    */
    readonly displayName?: string;
    /**
    * The schema's name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/schema#schema_name Schema#schema_name}
    */
    readonly schemaName: string;
    /**
    * fields block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/schema#fields Schema#fields}
    */
    readonly fields: SchemaFields[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/schema#timeouts Schema#timeouts}
    */
    readonly timeouts?: SchemaTimeouts;
}
export interface SchemaFieldsNumericIndexingSpec {
    /**
    * Maximum value of this field. This is meant to be indicative rather than enforced. Values outside this range will still be indexed, but search may not be as performant.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/schema#max_value Schema#max_value}
    */
    readonly maxValue?: number;
    /**
    * Minimum value of this field. This is meant to be indicative rather than enforced. Values outside this range will still be indexed, but search may not be as performant.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/schema#min_value Schema#min_value}
    */
    readonly minValue?: number;
}
export declare function schemaFieldsNumericIndexingSpecToTerraform(struct?: SchemaFieldsNumericIndexingSpecOutputReference | SchemaFieldsNumericIndexingSpec): any;
export declare class SchemaFieldsNumericIndexingSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SchemaFieldsNumericIndexingSpec | undefined;
    set internalValue(value: SchemaFieldsNumericIndexingSpec | undefined);
    private _maxValue?;
    get maxValue(): number;
    set maxValue(value: number);
    resetMaxValue(): void;
    get maxValueInput(): number | undefined;
    private _minValue?;
    get minValue(): number;
    set minValue(value: number);
    resetMinValue(): void;
    get minValueInput(): number | undefined;
}
export interface SchemaFields {
    /**
    * Display Name of the field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/schema#display_name Schema#display_name}
    */
    readonly displayName?: string;
    /**
    * The name of the field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/schema#field_name Schema#field_name}
    */
    readonly fieldName: string;
    /**
    * The type of the field. Acceptable values are:
      - `BOOL`
      - `DATE`
      - `DOUBLE`
      - `EMAIL`
      - `INT64`
      - `PHONE`
      - `STRING`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/schema#field_type Schema#field_type}
    */
    readonly fieldType: string;
    /**
    * Defaults to `true`. Boolean specifying whether the field is indexed or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/schema#indexed Schema#indexed}
    */
    readonly indexed?: boolean | cdktf.IResolvable;
    /**
    * Defaults to `false`. A boolean specifying whether this is a multi-valued field or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/schema#multi_valued Schema#multi_valued}
    */
    readonly multiValued?: boolean | cdktf.IResolvable;
    /**
    * Defaults to `ALL_DOMAIN_USERS`. Specifies who can view values of this field. See Retrieve users as a non-administrator for more information. Acceptable values are:
      - `ADMINS_AND_SELF`
      - `ALL_DOMAIN_USERS`
      Note: It may take up to 24 hours for changes to this field to be reflected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/schema#read_access_type Schema#read_access_type}
    */
    readonly readAccessType?: string;
    /**
    * numeric_indexing_spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/schema#numeric_indexing_spec Schema#numeric_indexing_spec}
    */
    readonly numericIndexingSpec?: SchemaFieldsNumericIndexingSpec;
}
export declare function schemaFieldsToTerraform(struct?: SchemaFields | cdktf.IResolvable): any;
export declare class SchemaFieldsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaFields | cdktf.IResolvable | undefined;
    set internalValue(value: SchemaFields | cdktf.IResolvable | undefined);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get etag(): string;
    get fieldId(): string;
    private _fieldName?;
    get fieldName(): string;
    set fieldName(value: string);
    get fieldNameInput(): string | undefined;
    private _fieldType?;
    get fieldType(): string;
    set fieldType(value: string);
    get fieldTypeInput(): string | undefined;
    private _indexed?;
    get indexed(): boolean | cdktf.IResolvable;
    set indexed(value: boolean | cdktf.IResolvable);
    resetIndexed(): void;
    get indexedInput(): boolean | cdktf.IResolvable | undefined;
    private _multiValued?;
    get multiValued(): boolean | cdktf.IResolvable;
    set multiValued(value: boolean | cdktf.IResolvable);
    resetMultiValued(): void;
    get multiValuedInput(): boolean | cdktf.IResolvable | undefined;
    private _readAccessType?;
    get readAccessType(): string;
    set readAccessType(value: string);
    resetReadAccessType(): void;
    get readAccessTypeInput(): string | undefined;
    private _numericIndexingSpec;
    get numericIndexingSpec(): SchemaFieldsNumericIndexingSpecOutputReference;
    putNumericIndexingSpec(value: SchemaFieldsNumericIndexingSpec): void;
    resetNumericIndexingSpec(): void;
    get numericIndexingSpecInput(): SchemaFieldsNumericIndexingSpec | undefined;
}
export declare class SchemaFieldsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SchemaFields[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaFieldsOutputReference;
}
export interface SchemaTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/schema#create Schema#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/schema#delete Schema#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/schema#update Schema#update}
    */
    readonly update?: string;
}
export declare function schemaTimeoutsToTerraform(struct?: SchemaTimeoutsOutputReference | SchemaTimeouts | cdktf.IResolvable): any;
export declare class SchemaTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SchemaTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SchemaTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/googleworkspace/r/schema googleworkspace_schema}
*/
export declare class Schema extends cdktf.TerraformResource {
    static readonly tfResourceType = "googleworkspace_schema";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/googleworkspace/r/schema googleworkspace_schema} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SchemaConfig
    */
    constructor(scope: Construct, id: string, config: SchemaConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get etag(): string;
    get id(): string;
    get schemaId(): string;
    private _schemaName?;
    get schemaName(): string;
    set schemaName(value: string);
    get schemaNameInput(): string | undefined;
    private _fields;
    get fields(): SchemaFieldsList;
    putFields(value: SchemaFields[] | cdktf.IResolvable): void;
    get fieldsInput(): cdktf.IResolvable | SchemaFields[] | undefined;
    private _timeouts;
    get timeouts(): SchemaTimeoutsOutputReference;
    putTimeouts(value: SchemaTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SchemaTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
