"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttributeGroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const validation_1 = require("./private/validation");
const servicecatalogappregistry_generated_1 = require("./servicecatalogappregistry.generated");
class AttributeGroupBase extends cdk.Resource {
}
/**
 * (experimental) A Service Catalog AppRegistry Attribute Group.
 *
 * @experimental
 */
class AttributeGroup extends AttributeGroupBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.validateAttributeGroupProps(props);
        const attributeGroup = new servicecatalogappregistry_generated_1.CfnAttributeGroup(this, 'Resource', {
            name: props.attributeGroupName,
            description: props.description,
            attributes: props.attributes,
        });
        this.attributeGroupArn = attributeGroup.attrArn;
        this.attributeGroupId = attributeGroup.attrId;
    }
    /**
     * (experimental) Imports an attribute group construct that represents an external attribute group.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attributeGroupArn the Amazon Resource Name of the existing AppRegistry attribute group.
     * @experimental
     */
    static fromAttributeGroupArn(scope, id, attributeGroupArn) {
        const arn = cdk.Stack.of(scope).splitArn(attributeGroupArn, cdk.ArnFormat.SLASH_RESOURCE_SLASH_RESOURCE_NAME);
        const attributeGroupId = arn.resourceName;
        if (!attributeGroupId) {
            throw new Error('Missing required Attribute Group ID from Attribute Group ARN: ' + attributeGroupArn);
        }
        class Import extends AttributeGroupBase {
            constructor() {
                super(...arguments);
                this.attributeGroupArn = attributeGroupArn;
                this.attributeGroupId = attributeGroupId;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: attributeGroupArn,
        });
    }
    validateAttributeGroupProps(props) {
        validation_1.InputValidator.validateLength(this.node.path, 'attribute group name', 1, 256, props.attributeGroupName);
        validation_1.InputValidator.validateRegex(this.node.path, 'attribute group name', /^[a-zA-Z0-9-_]+$/, props.attributeGroupName);
        validation_1.InputValidator.validateLength(this.node.path, 'attribute group description', 0, 1024, props.description);
    }
}
exports.AttributeGroup = AttributeGroup;
_a = JSII_RTTI_SYMBOL_1;
AttributeGroup[_a] = { fqn: "@aws-cdk/aws-servicecatalogappregistry.AttributeGroup", version: "1.126.0" };
//# sourceMappingURL=data:application/json;base64,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