# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from opera.api.openapi.models.base_model_ import Model
from opera.api.openapi import util


class DiffRequest(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, service_template=None, inputs=None, template_only=None, new_service_template_contents=None):  # noqa: E501
        """DiffRequest - a model defined in OpenAPI

        :param service_template: The service_template of this DiffRequest.  # noqa: E501
        :type service_template: str
        :param inputs: The inputs of this DiffRequest.  # noqa: E501
        :type inputs: object
        :param template_only: The template_only of this DiffRequest.  # noqa: E501
        :type template_only: bool
        :param new_service_template_contents: The new_service_template_contents of this DiffRequest.  # noqa: E501
        :type new_service_template_contents: str
        """
        self.openapi_types = {
            'service_template': str,
            'inputs': object,
            'template_only': bool,
            'new_service_template_contents': str
        }

        self.attribute_map = {
            'service_template': 'serviceTemplate',
            'inputs': 'inputs',
            'template_only': 'templateOnly',
            'new_service_template_contents': 'newServiceTemplateContents'
        }

        self._service_template = service_template
        self._inputs = inputs
        self._template_only = template_only
        self._new_service_template_contents = new_service_template_contents

    @classmethod
    def from_dict(cls, dikt) -> 'DiffRequest':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The DiffRequest of this DiffRequest.  # noqa: E501
        :rtype: DiffRequest
        """
        return util.deserialize_model(dikt, cls)

    @property
    def service_template(self):
        """Gets the service_template of this DiffRequest.

        The filename of the base service template.  # noqa: E501

        :return: The service_template of this DiffRequest.
        :rtype: str
        """
        return self._service_template

    @service_template.setter
    def service_template(self, service_template):
        """Sets the service_template of this DiffRequest.

        The filename of the base service template.  # noqa: E501

        :param service_template: The service_template of this DiffRequest.
        :type service_template: str
        """
        if service_template is None:
            raise ValueError("Invalid value for `service_template`, must not be `None`")  # noqa: E501

        self._service_template = service_template

    @property
    def inputs(self):
        """Gets the inputs of this DiffRequest.


        :return: The inputs of this DiffRequest.
        :rtype: object
        """
        return self._inputs

    @inputs.setter
    def inputs(self, inputs):
        """Sets the inputs of this DiffRequest.


        :param inputs: The inputs of this DiffRequest.
        :type inputs: object
        """
        if inputs is None:
            raise ValueError("Invalid value for `inputs`, must not be `None`")  # noqa: E501

        self._inputs = inputs

    @property
    def template_only(self):
        """Gets the template_only of this DiffRequest.


        :return: The template_only of this DiffRequest.
        :rtype: bool
        """
        return self._template_only

    @template_only.setter
    def template_only(self, template_only):
        """Sets the template_only of this DiffRequest.


        :param template_only: The template_only of this DiffRequest.
        :type template_only: bool
        """
        if template_only is None:
            raise ValueError("Invalid value for `template_only`, must not be `None`")  # noqa: E501

        self._template_only = template_only

    @property
    def new_service_template_contents(self):
        """Gets the new_service_template_contents of this DiffRequest.

        The contents of the new service template.  # noqa: E501

        :return: The new_service_template_contents of this DiffRequest.
        :rtype: str
        """
        return self._new_service_template_contents

    @new_service_template_contents.setter
    def new_service_template_contents(self, new_service_template_contents):
        """Sets the new_service_template_contents of this DiffRequest.

        The contents of the new service template.  # noqa: E501

        :param new_service_template_contents: The new_service_template_contents of this DiffRequest.
        :type new_service_template_contents: str
        """
        if new_service_template_contents is None:
            raise ValueError("Invalid value for `new_service_template_contents`, must not be `None`")  # noqa: E501

        self._new_service_template_contents = new_service_template_contents
