# AUTOGENERATED! DO NOT EDIT! File to edit: 50_cli.ipynb (unless otherwise specified).

__all__ = ['upload_dataset', 'download_dataset']

# Cell
from .core import *
from fastcore.script import *

# Cell
@call_parse
def upload_dataset(storage_name:Param('Section name in config',str),
                   dataset_name:Param('Dataset name',str),
                   config_name:Param('Path to config',str)='secrets/settings.ini',
                   dataset_version:Param('Dataset version',str)='patch'):
    "Create a new dataset archive and upload it to remote storage"
    r=new_storage_client(storage_name,config_name).upload_dataset(dataset_name,dataset_version)
    print('Dataset uploaded to',r)

# Cell
@call_parse
def download_dataset(storage_name:Param('Section name in config',str),
                     dataset_name:Param('Dataset name',str),
                     config_name:Param('Path to config',str)='secrets/settings.ini',
                     dataset_version:Param('Dataset version',str)='latest',
                     overwrite:Param('If True, delete the dataset and re-download',bool)=False):
    "Download a dataset archive from remote storage"
    r=new_storage_client(storage_name,config_name).download_dataset(dataset_name,dataset_version,overwrite)
    print('Dataset downloaded to',r)