from typing import Dict, Iterator, Tuple

class LevelDBException(Exception):
    """
    The exception thrown for all leveldb related errors.
    """
    pass


class LevelDB:
    def __init__(self, path: str, create_if_missing: bool = False): ...
    def close(self, compact: bool = True): ...
    def get(self, key: bytes) -> bytes: ...
    def put(self, key: bytes, val: bytes): ...
    def putBatch(self, data: Dict[bytes, bytes]): ...
    def delete(self, key: bytes): ...
    def iterate(self, start: bytes = None, end: bytes = None) -> Iterator[Tuple[bytes, bytes]]: ...
    def keys(self) -> Iterator[bytes]: ...
    def items(self) -> Iterator[Tuple[bytes, bytes]]: ...
    def __contains__(self, key: bytes): ...
    def __getitem__(self, key: bytes) -> bytes: ...
    def __setitem__(self, key: bytes, value: bytes): ...
    def __delitem__(self, key: bytes): ...
    def __iter__(self) -> Iterator[bytes]: ...
