import "core-js/modules/es.array.iterator";
import "core-js/modules/es.promise";
import "core-js/modules/es.regexp.constructor";
import "core-js/modules/es.regexp.to-string";
import "core-js/modules/es.string.match";
import "core-js/modules/web.dom-collections.iterator";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/* eslint camelcase: off */
import { DOMWidgetModel } from '@jupyter-widgets/base';
import Vue from 'vue';
import httpVueLoader from './httpVueLoader';
import { TemplateModel } from './Template';
export class VueComponentModel extends DOMWidgetModel {
  defaults() {
    return _objectSpread({}, super.defaults(), {}, {
      _model_name: 'VueComponentModel',
      _model_module: 'jupyter-vue',
      _model_module_version: '^0.0.3',
      name: null,
      component: null
    });
  }

  constructor(...args) {
    super(...args);
    const [, {
      widget_manager
    }] = args;
    const name = this.get('name');
    Vue.component(name, httpVueLoader(this.get('component')));
    this.on('change:component', () => {
      Vue.component(name, httpVueLoader(this.get('component')));

      (async () => {
        const models = await Promise.all(Object.values(widget_manager._models));
        const componentModels = models.filter(model => model instanceof VueComponentModel);
        const affectedComponents = [];

        function re(searchName) {
          return new RegExp("\\<".concat(searchName, "[ />\n]"), 'g');
        }

        function find_usage(searchName) {
          affectedComponents.push(searchName);
          componentModels.filter(model => model.get('component').match(re(searchName))).forEach(model => {
            const cname = model.get('name');

            if (!affectedComponents.includes(cname)) {
              find_usage(cname);
            }
          });
        }

        find_usage(name);
        const affectedTemplateModels = models.filter(model => model instanceof TemplateModel && affectedComponents.some(cname => model.get('template').match(re(cname))));
        affectedTemplateModels.forEach(model => model.trigger('change:template'));
      })();
    });
  }

}
VueComponentModel.serializers = _objectSpread({}, DOMWidgetModel.serializers);