# Generated by Django 2.2.3 on 2021-06-16 09:23

import data_apps.direct.models
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='TlmsWmsCtnDetail',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ent_direct_id', models.CharField(help_text='订单号', max_length=50, verbose_name='订单号')),
                ('quantity', models.IntegerField(default=0, help_text='数量', verbose_name='数量')),
                ('gross_weight', models.DecimalField(decimal_places=5, default=0, help_text='箱毛重', max_digits=10, verbose_name='箱毛重')),
                ('net_weight', models.DecimalField(decimal_places=5, default=0, max_digits=10, verbose_name='净量')),
                ('volume', models.DecimalField(decimal_places=5, default=0, max_digits=10, verbose_name='体积')),
            ],
            options={
                'verbose_name': '箱子-货物-关系表',
                'verbose_name_plural': '箱子-货物-关系表',
                'db_table': 'tlms_wms_ctn_cargo',
            },
        ),
        migrations.CreateModel(
            name='TlmsWmsEntCtn',
            fields=[
                ('id', data_apps.direct.models.TlmsWmsEntCtnIdField(auto_created=True, editable=False, max_length=18, primary_key=True, serialize=False)),
                ('ctnno', models.CharField(help_text='箱号', max_length=30, verbose_name='箱号')),
                ('seal_no', models.CharField(blank=True, help_text='铅封号', max_length=30, null=True, verbose_name='铅封号')),
                ('gross_weight', models.DecimalField(decimal_places=5, default=0, help_text='箱毛重', max_digits=19, verbose_name='箱毛重')),
                ('remark', models.CharField(blank=True, help_text='备注', max_length=200, null=True, verbose_name='备注')),
            ],
            options={
                'verbose_name': '委托业务箱子明细',
                'verbose_name_plural': '委托业务箱子明细',
                'db_table': 'ent_direct_ctn',
            },
        ),
        migrations.CreateModel(
            name='TlmsWmsEntDetails',
            fields=[
                ('id', data_apps.direct.models.TlmsWmsEntDetailIdField(auto_created=True, editable=False, max_length=17, primary_key=True, serialize=False)),
                ('wms_ent_plan', models.CharField(blank=True, help_text='wms入库计划号/出库时必填', max_length=30, null=True, verbose_name='wms入库计划号')),
                ('bill_detail_seqno', models.CharField(blank=True, help_text='出入库单明细序号', max_length=64, null=True, verbose_name='出入库单明细序号')),
                ('entry_gds_seqno', models.CharField(blank=True, help_text='关联报关单（备案清单、简易申报单）商品序号', max_length=64, null=True, verbose_name='关联报关单（备案清单、简易申报单）商品序号')),
                ('qty', models.DecimalField(decimal_places=5, default=0, max_digits=19, verbose_name='申报数量')),
                ('qty_1', models.DecimalField(decimal_places=5, default=0, max_digits=19, verbose_name='法定数量')),
                ('qty_2', models.DecimalField(decimal_places=5, default=0, max_digits=19, verbose_name='法定第二数量')),
                ('unit_price', models.DecimalField(decimal_places=5, default=0, max_digits=19, verbose_name='单价')),
                ('total_price', models.DecimalField(decimal_places=5, default=0, max_digits=19, verbose_name='总价')),
                ('trade_curr', models.CharField(blank=True, help_text='币值', max_length=10, null=True, verbose_name='币值')),
                ('net_wt', models.DecimalField(decimal_places=5, default=0, max_digits=19, verbose_name='实际净重')),
                ('gross_wt', models.DecimalField(decimal_places=5, default=0, max_digits=19, verbose_name='实际毛重')),
                ('volume', models.DecimalField(decimal_places=5, default=0, max_digits=19, verbose_name='实际体积')),
                ('amount', models.IntegerField(default=0, verbose_name='实际数量')),
                ('pellet_amount', models.IntegerField(default=0, verbose_name='实际托盘数量')),
                ('lastupdatedt', models.DateField(auto_now=True, help_text='数据最后更新时间', verbose_name='数据最后更新时间')),
                ('mark', models.CharField(max_length=20, verbose_name='批次/唛头')),
                ('factory_no', models.CharField(blank=True, help_text='工厂编号', max_length=30, null=True, verbose_name='工厂编号')),
                ('plan_amount', models.IntegerField(default=0, verbose_name='计划数量')),
                ('plan_net_wt', models.DecimalField(decimal_places=5, default=0, max_digits=19, verbose_name='计划净重')),
                ('plan_gross_wt', models.DecimalField(decimal_places=5, default=0, max_digits=19, verbose_name='计划毛重')),
                ('plan_volume', models.DecimalField(decimal_places=5, default=0, max_digits=10, verbose_name='计划体积')),
                ('plan_pellet_amount', models.IntegerField(blank=True, default=0, null=True, verbose_name='计划托盘数量')),
                ('produced_date', models.DateField(blank=True, help_text='生产日期', null=True, verbose_name='生产日期')),
                ('ed', models.DateField(blank=True, help_text='有效日期', null=True, verbose_name='有效日期')),
                ('remark', models.CharField(blank=True, max_length=255, null=True, verbose_name='备注')),
            ],
            options={
                'verbose_name': '入库计划明细',
                'verbose_name_plural': '入库计划明细',
                'db_table': 'ent_direct_detail',
            },
        ),
        migrations.CreateModel(
            name='TlmsWmsEntDirect',
            fields=[
                ('id', data_apps.direct.models.TlmsWmsEntDirectField(auto_created=True, default=data_apps.direct.models.tlms_wms_ent_direct_id, editable=False, max_length=26, primary_key=True, serialize=False)),
                ('tlms_plan', models.CharField(blank=True, help_text='tlms计划号', max_length=30, null=True, verbose_name='tlms计划号')),
                ('wms_ent_plan', models.CharField(blank=True, help_text='wms入库计划号', max_length=30, null=True, verbose_name='wms入库计划号')),
                ('wms_out_plan', models.CharField(blank=True, help_text='wms出库计划号', max_length=30, null=True, verbose_name='wms出库计划号')),
                ('plan_status', models.SmallIntegerField(choices=[(1, '已下发 | 未接受'), (2, '已接收 | 已接受'), (3, '已完成 | 已完成')], default=0, help_text='计划状态', verbose_name='计划状态')),
                ('stock_bill_type', models.SmallIntegerField(choices=[(1, '进库'), (2, '出库')], default=1, help_text='进出类型', verbose_name='进出类型')),
                ('bill_type', models.SmallIntegerField(choices=[(1, '一线'), (2, '二线'), (3, '区内'), (4, '区间')], default=1, help_text='出入库类型', verbose_name='出入库类型')),
                ('stock_type', models.SmallIntegerField(choices=[(1, '保税'), (2, '非保税')], default=1, help_text='库存类型', verbose_name='库存类型')),
                ('b_l_no', models.CharField(blank=True, help_text='提单号', max_length=30, null=True, verbose_name='提单号')),
                ('total_quantity', models.IntegerField(default=0, help_text='总数量（件数）', verbose_name='总数量（件数）')),
                ('total_gross_weight', models.DecimalField(decimal_places=2, default=0, max_digits=10, verbose_name='毛重')),
                ('total_net_weight', models.DecimalField(decimal_places=2, default=0, max_digits=10, verbose_name='净重')),
                ('business_type', models.SmallIntegerField(choices=[(1, '自用设备'), (2, '简单加工'), (3, '保税加工'), (4, '保税仓储'), (5, '转口贸易'), (6, '跨境电商'), (7, '汽车平行进口'), (8, '融资租赁'), (9, '期货保税交割'), (10, '保税维修'), (11, '进口汽车保税存储'), (12, '保税研发'), (13, '委托加工'), (14, '大宗商品现货保税交易')], default=14, help_text='业务类别', verbose_name='业务类别')),
                ('classify_type', models.CharField(choices=[('I', '料件'), ('E', '成品')], default='E', help_text='料件成品标志', max_length=1, verbose_name='料件成品标志')),
                ('supv_mode', models.CharField(blank=True, help_text='监管方式', max_length=30, null=True, verbose_name='监管方式')),
                ('traf_mode', models.CharField(blank=True, help_text='运输方式', max_length=30, null=True, verbose_name='运输方式')),
                ('i_e_port', models.CharField(blank=True, help_text='进出境关别', max_length=30, null=True, verbose_name='进出境关别')),
                ('custome_code', models.CharField(blank=True, help_text='主管海关', max_length=30, null=True, verbose_name='主管海关')),
                ('dclcus_flag', models.SmallIntegerField(choices=[(1, '报关'), (2, '非报关')], default=1, help_text='报关标志', verbose_name='报关标志')),
                ('customs_dec_no', models.CharField(blank=True, help_text='报关单号', max_length=30, null=True, verbose_name='报关单号')),
                ('destination_code', models.CharField(blank=True, help_text='最终目的国代码（地区）', max_length=30, null=True, verbose_name='最终目的国代码（地区）')),
                ('stship_trsarv_code', models.CharField(blank=True, help_text='启运国/运抵国代码（地区）', max_length=30, null=True, verbose_name='启运国/运抵国代码（地区）')),
                ('district_code', models.CharField(blank=True, help_text='境内目的地/货源地代码', max_length=30, null=True, verbose_name='境内目的地/货源地代码')),
                ('trade_country_code', models.CharField(blank=True, help_text='贸易国代码（地区）', max_length=30, null=True, verbose_name='贸易国代码（地区）')),
                ('rlt_entry_no', models.CharField(blank=True, help_text='关联报关单（备案清单、简易申报单）编号', max_length=64, null=True, verbose_name='关联报关单（备案清单、简易申报单）编号')),
                ('rlt_invt_no', models.CharField(blank=True, help_text='关联保税核注清单编号', max_length=64, null=True, verbose_name='关联保税核注清单编号')),
                ('owner_name', models.CharField(blank=True, help_text='货主名称', max_length=256, null=True, verbose_name='货主名称')),
                ('stock_date', models.DateField(auto_now_add=True, help_text='创建时间', verbose_name='创建时间')),
                ('lastupdatedt', models.DateField(auto_now=True, help_text='数据最后更新时间', verbose_name='数据最后更新时间')),
                ('pass_time', models.DateField(blank=True, help_text='放行时间', null=True, verbose_name='放行时间')),
                ('transit_time', models.DateField(blank=True, help_text='核放时间', null=True, verbose_name='核放时间')),
                ('contract_no', models.CharField(help_text='合同号/订单号', max_length=30, verbose_name='合同号/订单号')),
                ('dec_method', models.CharField(blank=True, help_text='申报方式', max_length=30, null=True, verbose_name='申报方式')),
                ('work_route', models.CharField(blank=True, help_text='作业路线', max_length=30, null=True, verbose_name='作业路线')),
                ('js_no', models.CharField(blank=True, help_text='js备案号', max_length=30, null=True, verbose_name='js备案号')),
                ('source_port', models.CharField(blank=True, help_text='起运港', max_length=50, null=True, verbose_name='起运港')),
                ('vessel', models.CharField(blank=True, help_text='船名', max_length=30, null=True, verbose_name='船名')),
                ('voyage', models.CharField(blank=True, help_text='航次', max_length=30, null=True, verbose_name='航次')),
                ('aim_port', models.CharField(blank=True, help_text='目的港', max_length=30, null=True, verbose_name='目的港')),
                ('inspection_no', models.CharField(blank=True, help_text='报检号', max_length=30, null=True, verbose_name='报检号')),
                ('trade_mode', models.CharField(blank=True, help_text='贸易方式', max_length=50, null=True, verbose_name='贸易方式')),
                ('package_type', models.CharField(blank=True, help_text='包装种类', max_length=50, null=True, verbose_name='包装种类')),
                ('transaction_mode', models.CharField(blank=True, help_text='成交方式', max_length=50, null=True, verbose_name='成交方式')),
                ('est_arrival_time', models.DateField(blank=True, help_text='预计到港日期', null=True, verbose_name='预计到港日期')),
                ('arrival_time', models.DateField(blank=True, help_text='到港日期', null=True, verbose_name='到港日期')),
                ('remark', models.CharField(blank=True, help_text='备注', max_length=200, null=True, verbose_name='备注')),
                ('plan_ent_date', models.DateTimeField(verbose_name='出入库时间')),
                ('if_buckle_cargo', models.BooleanField(default=False, verbose_name='是否海关扣货')),
            ],
            options={
                'verbose_name': '委托入库指令',
                'verbose_name_plural': '委托入库指令',
                'db_table': 'tlms_wms_ent_direct',
            },
        ),
    ]
