# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['django_filters_groups', 'django_filters_groups.templatetags']

package_data = \
{'': ['*'],
 'django_filters_groups': ['static/django_filters_groups/*',
                           'templates/django_filters_groups/*']}

install_requires = \
['Django>=2', 'django-filter>=2.4.0']

setup_kwargs = {
    'name': 'django-filter-groups',
    'version': '0.3.0',
    'description': '',
    'long_description': '# django filter groups\n\nThis package groups filters generated by django-filter\nThe main reason to use it - don\'t show all filters (show only selected filters)\n\n## how to use\n```\npip install django-filter-groups\n```\nadd to your `INSTALLED_APPS` after `django-filter`\n```python\nINSTALLED_APPS = [\n  ...\n  "django_filters",\n  "django_filters_groups",\n  ...\n]\n```\n\nuse it in your template `{% filters_by_groups %}` \\\nadd `{{ select_filter_form.media }}` after adding template tag\n\nIf FilterSet name is not \'filter\' -> add filterset \\\n`{% filters_by_groups my_custom_filterset %}`\nor filterset name\n`{% filters_by_groups "my_custom_filterset" %}`\n',
    'author': 'pnoryk',
    'author_email': 'pnoryk@mail.ru',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/PNoryk/django-filter-groups',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
