/*
 *  gttk_Symbols.cpp
 * ------------------------
 *
 * This file is part of the gttk package, a ttk based theme that uses
 * Gtk/GNOME for drawing.
 *
 * Copyright (C) 2004-2012 by:
 * Georgios Petasis, petasis@iit.demokritos.gr,
 * Software and Knowledge Engineering Laboratory,
 * Institute of Informatics and Telecommunications,
 * National Centre for Scientific Research (NCSR) "Demokritos",
 * Aghia Paraskevi, 153 10, Athens, Greece.
 */
/* THIS FILE IS AUTOMATICALLY GENERATED - DO NOT EDIT! */
#include "gttk_Symbols.h"
#ifdef    GTTK_LOAD_GTK_DYNAMICALLY
#if (TCL_MAJOR_VERSION >= 8) && (TCL_MINOR_VERSION >= 6)
#define LOAD_SYMBOLS_WITH_TCL
#endif

#ifndef LOAD_SYMBOLS_WITH_TCL
#include <gmodule.h>
#endif

Ptr_g_free gttk_g_free = 0;
Ptr_g_hash_table_get_keys gttk_g_hash_table_get_keys = 0;
Ptr_g_malloc gttk_g_malloc = 0;
Ptr_g_malloc0 gttk_g_malloc0 = 0;
Ptr_g_object_get gttk_g_object_get = 0;
Ptr_g_object_unref gttk_g_object_unref = 0;
Ptr_g_option_context_add_main_entries gttk_g_option_context_add_main_entries = 0;
Ptr_g_option_context_new gttk_g_option_context_new = 0;
Ptr_g_strfreev gttk_g_strfreev = 0;
Ptr_gdk_color_to_string gttk_gdk_color_to_string = 0;
Ptr_gdk_display_get_default gttk_gdk_display_get_default = 0;
Ptr_gdk_display_get_screen gttk_gdk_display_get_screen = 0;
Ptr_gdk_drawable_set_colormap gttk_gdk_drawable_set_colormap = 0;
Ptr_gdk_gc_new gttk_gdk_gc_new = 0;
Ptr_gdk_pixbuf_get_from_drawable gttk_gdk_pixbuf_get_from_drawable = 0;
Ptr_gdk_pixbuf_new gttk_gdk_pixbuf_new = 0;
Ptr_gdk_pixbuf_unref gttk_gdk_pixbuf_unref = 0;
Ptr_gdk_pixbuf_xlib_render_to_drawable gttk_gdk_pixbuf_xlib_render_to_drawable = 0;
Ptr_gdk_pixmap_foreign_new_for_screen gttk_gdk_pixmap_foreign_new_for_screen = 0;
Ptr_gdk_pixmap_new gttk_gdk_pixmap_new = 0;
Ptr_gdk_x11_colormap_foreign_new gttk_gdk_x11_colormap_foreign_new = 0;
Ptr_gdk_x11_lookup_xdisplay gttk_gdk_x11_lookup_xdisplay = 0;
Ptr_gdk_x11_screen_lookup_visual gttk_gdk_x11_screen_lookup_visual = 0;
Ptr_gtk_adjustment_new gttk_gtk_adjustment_new = 0;
Ptr_gtk_adjustment_set_value gttk_gtk_adjustment_set_value = 0;
Ptr_gtk_arrow_new gttk_gtk_arrow_new = 0;
Ptr_gtk_border_free gttk_gtk_border_free = 0;
Ptr_gtk_button_get_relief gttk_gtk_button_get_relief = 0;
Ptr_gtk_button_new gttk_gtk_button_new = 0;
Ptr_gtk_button_set_relief gttk_gtk_button_set_relief = 0;
Ptr_gtk_check_button_new gttk_gtk_check_button_new = 0;
Ptr_gtk_combo_box_entry_new gttk_gtk_combo_box_entry_new = 0;
Ptr_gtk_combo_box_new gttk_gtk_combo_box_new = 0;
Ptr_gtk_container_add gttk_gtk_container_add = 0;
Ptr_gtk_disable_setlocale gttk_gtk_disable_setlocale = 0;
Ptr_gtk_entry_new gttk_gtk_entry_new = 0;
Ptr_gtk_fixed_new gttk_gtk_fixed_new = 0;
Ptr_gtk_frame_new gttk_gtk_frame_new = 0;
Ptr_gtk_hpaned_new gttk_gtk_hpaned_new = 0;
Ptr_gtk_hscale_new_with_range gttk_gtk_hscale_new_with_range = 0;
Ptr_gtk_hscrollbar_new gttk_gtk_hscrollbar_new = 0;
Ptr_gtk_init_check gttk_gtk_init_check = 0;
Ptr_gtk_notebook_new gttk_gtk_notebook_new = 0;
Ptr_gtk_object_get gttk_gtk_object_get = 0;
Ptr_gtk_paint_arrow gttk_gtk_paint_arrow = 0;
Ptr_gtk_paint_box gttk_gtk_paint_box = 0;
Ptr_gtk_paint_box_gap gttk_gtk_paint_box_gap = 0;
Ptr_gtk_paint_check gttk_gtk_paint_check = 0;
Ptr_gtk_paint_extension gttk_gtk_paint_extension = 0;
Ptr_gtk_paint_flat_box gttk_gtk_paint_flat_box = 0;
Ptr_gtk_paint_focus gttk_gtk_paint_focus = 0;
Ptr_gtk_paint_handle gttk_gtk_paint_handle = 0;
Ptr_gtk_paint_option gttk_gtk_paint_option = 0;
Ptr_gtk_paint_resize_grip gttk_gtk_paint_resize_grip = 0;
Ptr_gtk_paint_shadow gttk_gtk_paint_shadow = 0;
Ptr_gtk_paint_slider gttk_gtk_paint_slider = 0;
Ptr_gtk_progress_bar_new gttk_gtk_progress_bar_new = 0;
Ptr_gtk_progress_bar_set_bar_style gttk_gtk_progress_bar_set_bar_style = 0;
Ptr_gtk_progress_bar_set_fraction gttk_gtk_progress_bar_set_fraction = 0;
Ptr_gtk_progress_bar_set_orientation gttk_gtk_progress_bar_set_orientation = 0;
Ptr_gtk_range_get_adjustment gttk_gtk_range_get_adjustment = 0;
Ptr_gtk_rc_get_default_files gttk_gtk_rc_get_default_files = 0;
Ptr_gtk_rc_get_style gttk_gtk_rc_get_style = 0;
Ptr_gtk_rc_get_theme_dir gttk_gtk_rc_get_theme_dir = 0;
Ptr_gtk_rc_reparse_all_for_settings gttk_gtk_rc_reparse_all_for_settings = 0;
Ptr_gtk_rc_reset_styles gttk_gtk_rc_reset_styles = 0;
Ptr_gtk_rc_set_default_files gttk_gtk_rc_set_default_files = 0;
Ptr_gtk_settings_get_default gttk_gtk_settings_get_default = 0;
Ptr_gtk_statusbar_new gttk_gtk_statusbar_new = 0;
Ptr_gtk_style_apply_default_background gttk_gtk_style_apply_default_background = 0;
Ptr_gtk_style_attach gttk_gtk_style_attach = 0;
Ptr_gtk_style_lookup_color gttk_gtk_style_lookup_color = 0;
Ptr_gtk_toolbar_new gttk_gtk_toolbar_new = 0;
Ptr_gtk_vpaned_new gttk_gtk_vpaned_new = 0;
Ptr_gtk_vscale_new_with_range gttk_gtk_vscale_new_with_range = 0;
Ptr_gtk_vscrollbar_new gttk_gtk_vscrollbar_new = 0;
Ptr_gtk_widget_destroy gttk_gtk_widget_destroy = 0;
Ptr_gtk_widget_realize gttk_gtk_widget_realize = 0;
Ptr_gtk_widget_set_size_request gttk_gtk_widget_set_size_request = 0;
Ptr_gtk_widget_size_request gttk_gtk_widget_size_request = 0;
Ptr_gtk_widget_style_get gttk_gtk_widget_style_get = 0;
Ptr_gtk_window_new gttk_gtk_window_new = 0;
Ptr_xlib_rgb_init gttk_xlib_rgb_init = 0;

int gttk_InitialiseSymbols_gdk(Tcl_Interp *interp, Tcl_Obj *file_name) {
#ifdef LOAD_SYMBOLS_WITH_TCL
  Tcl_LoadHandle loadHandle;
  int status;
  status = Tcl_LoadFile(interp, file_name, NULL, 0, NULL, &loadHandle);
  if (status != TCL_OK) return status;
  gttk_gdk_color_to_string = (Ptr_gdk_color_to_string) Tcl_FindSymbol(interp, loadHandle, "gdk_color_to_string");
  if (gttk_gdk_color_to_string == NULL) return TCL_ERROR;
  gttk_gdk_display_get_default = (Ptr_gdk_display_get_default) Tcl_FindSymbol(interp, loadHandle, "gdk_display_get_default");
  if (gttk_gdk_display_get_default == NULL) return TCL_ERROR;
  gttk_gdk_display_get_screen = (Ptr_gdk_display_get_screen) Tcl_FindSymbol(interp, loadHandle, "gdk_display_get_screen");
  if (gttk_gdk_display_get_screen == NULL) return TCL_ERROR;
  gttk_gdk_drawable_set_colormap = (Ptr_gdk_drawable_set_colormap) Tcl_FindSymbol(interp, loadHandle, "gdk_drawable_set_colormap");
  if (gttk_gdk_drawable_set_colormap == NULL) return TCL_ERROR;
  gttk_gdk_gc_new = (Ptr_gdk_gc_new) Tcl_FindSymbol(interp, loadHandle, "gdk_gc_new");
  if (gttk_gdk_gc_new == NULL) return TCL_ERROR;
  gttk_gdk_pixbuf_get_from_drawable = (Ptr_gdk_pixbuf_get_from_drawable) Tcl_FindSymbol(interp, loadHandle, "gdk_pixbuf_get_from_drawable");
  if (gttk_gdk_pixbuf_get_from_drawable == NULL) return TCL_ERROR;
  gttk_gdk_pixmap_foreign_new_for_screen = (Ptr_gdk_pixmap_foreign_new_for_screen) Tcl_FindSymbol(interp, loadHandle, "gdk_pixmap_foreign_new_for_screen");
  if (gttk_gdk_pixmap_foreign_new_for_screen == NULL) return TCL_ERROR;
  gttk_gdk_pixmap_new = (Ptr_gdk_pixmap_new) Tcl_FindSymbol(interp, loadHandle, "gdk_pixmap_new");
  if (gttk_gdk_pixmap_new == NULL) return TCL_ERROR;
  gttk_gdk_x11_colormap_foreign_new = (Ptr_gdk_x11_colormap_foreign_new) Tcl_FindSymbol(interp, loadHandle, "gdk_x11_colormap_foreign_new");
  if (gttk_gdk_x11_colormap_foreign_new == NULL) return TCL_ERROR;
  gttk_gdk_x11_lookup_xdisplay = (Ptr_gdk_x11_lookup_xdisplay) Tcl_FindSymbol(interp, loadHandle, "gdk_x11_lookup_xdisplay");
  if (gttk_gdk_x11_lookup_xdisplay == NULL) return TCL_ERROR;
  gttk_gdk_x11_screen_lookup_visual = (Ptr_gdk_x11_screen_lookup_visual) Tcl_FindSymbol(interp, loadHandle, "gdk_x11_screen_lookup_visual");
  if (gttk_gdk_x11_screen_lookup_visual == NULL) return TCL_ERROR;
#else
  const char *fname = Tcl_GetString(file_name);
  GModule *m = g_module_open(fname, G_MODULE_BIND_LAZY);
  if (!m) {
    Tcl_SetResult(interp, (char *) "cannot open module: ", TCL_STATIC);
    Tcl_AppendResult(interp, fname, (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gdk_color_to_string", (gpointer *) &gttk_gdk_color_to_string)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gdk_color_to_string", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gdk_display_get_default", (gpointer *) &gttk_gdk_display_get_default)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gdk_display_get_default", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gdk_display_get_screen", (gpointer *) &gttk_gdk_display_get_screen)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gdk_display_get_screen", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gdk_drawable_set_colormap", (gpointer *) &gttk_gdk_drawable_set_colormap)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gdk_drawable_set_colormap", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gdk_gc_new", (gpointer *) &gttk_gdk_gc_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gdk_gc_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gdk_pixbuf_get_from_drawable", (gpointer *) &gttk_gdk_pixbuf_get_from_drawable)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gdk_pixbuf_get_from_drawable", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gdk_pixmap_foreign_new_for_screen", (gpointer *) &gttk_gdk_pixmap_foreign_new_for_screen)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gdk_pixmap_foreign_new_for_screen", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gdk_pixmap_new", (gpointer *) &gttk_gdk_pixmap_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gdk_pixmap_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gdk_x11_colormap_foreign_new", (gpointer *) &gttk_gdk_x11_colormap_foreign_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gdk_x11_colormap_foreign_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gdk_x11_lookup_xdisplay", (gpointer *) &gttk_gdk_x11_lookup_xdisplay)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gdk_x11_lookup_xdisplay", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gdk_x11_screen_lookup_visual", (gpointer *) &gttk_gdk_x11_screen_lookup_visual)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gdk_x11_screen_lookup_visual", (char *) NULL);
    return TCL_ERROR;
  }
#endif
  return TCL_OK;
}; /* gttk_InitialiseSymbols_gdk */


int gttk_InitialiseSymbols_gdk_pixbuf(Tcl_Interp *interp, Tcl_Obj *file_name) {
#ifdef LOAD_SYMBOLS_WITH_TCL
  Tcl_LoadHandle loadHandle;
  int status;
  status = Tcl_LoadFile(interp, file_name, NULL, 0, NULL, &loadHandle);
  if (status != TCL_OK) return status;
  gttk_gdk_pixbuf_new = (Ptr_gdk_pixbuf_new) Tcl_FindSymbol(interp, loadHandle, "gdk_pixbuf_new");
  if (gttk_gdk_pixbuf_new == NULL) return TCL_ERROR;
  gttk_gdk_pixbuf_unref = (Ptr_gdk_pixbuf_unref) Tcl_FindSymbol(interp, loadHandle, "gdk_pixbuf_unref");
  if (gttk_gdk_pixbuf_unref == NULL) return TCL_ERROR;
#else
  const char *fname = Tcl_GetString(file_name);
  GModule *m = g_module_open(fname, G_MODULE_BIND_LAZY);
  if (!m) {
    Tcl_SetResult(interp, (char *) "cannot open module: ", TCL_STATIC);
    Tcl_AppendResult(interp, fname, (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gdk_pixbuf_new", (gpointer *) &gttk_gdk_pixbuf_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gdk_pixbuf_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gdk_pixbuf_unref", (gpointer *) &gttk_gdk_pixbuf_unref)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gdk_pixbuf_unref", (char *) NULL);
    return TCL_ERROR;
  }
#endif
  return TCL_OK;
}; /* gttk_InitialiseSymbols_gdk_pixbuf */


int gttk_InitialiseSymbols_gdk_pixbuf_xlib(Tcl_Interp *interp, Tcl_Obj *file_name) {
#ifdef LOAD_SYMBOLS_WITH_TCL
  Tcl_LoadHandle loadHandle;
  int status;
  status = Tcl_LoadFile(interp, file_name, NULL, 0, NULL, &loadHandle);
  if (status != TCL_OK) return status;
  gttk_gdk_pixbuf_xlib_render_to_drawable = (Ptr_gdk_pixbuf_xlib_render_to_drawable) Tcl_FindSymbol(interp, loadHandle, "gdk_pixbuf_xlib_render_to_drawable");
  if (gttk_gdk_pixbuf_xlib_render_to_drawable == NULL) return TCL_ERROR;
  gttk_xlib_rgb_init = (Ptr_xlib_rgb_init) Tcl_FindSymbol(interp, loadHandle, "xlib_rgb_init");
  if (gttk_xlib_rgb_init == NULL) return TCL_ERROR;
#else
  const char *fname = Tcl_GetString(file_name);
  GModule *m = g_module_open(fname, G_MODULE_BIND_LAZY);
  if (!m) {
    Tcl_SetResult(interp, (char *) "cannot open module: ", TCL_STATIC);
    Tcl_AppendResult(interp, fname, (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gdk_pixbuf_xlib_render_to_drawable", (gpointer *) &gttk_gdk_pixbuf_xlib_render_to_drawable)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gdk_pixbuf_xlib_render_to_drawable", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "xlib_rgb_init", (gpointer *) &gttk_xlib_rgb_init)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "xlib_rgb_init", (char *) NULL);
    return TCL_ERROR;
  }
#endif
  return TCL_OK;
}; /* gttk_InitialiseSymbols_gdk_pixbuf_xlib */


int gttk_InitialiseSymbols_glib(Tcl_Interp *interp, Tcl_Obj *file_name) {
#ifdef LOAD_SYMBOLS_WITH_TCL
  Tcl_LoadHandle loadHandle;
  int status;
  status = Tcl_LoadFile(interp, file_name, NULL, 0, NULL, &loadHandle);
  if (status != TCL_OK) return status;
  gttk_g_free = (Ptr_g_free) Tcl_FindSymbol(interp, loadHandle, "g_free");
  if (gttk_g_free == NULL) return TCL_ERROR;
  gttk_g_hash_table_get_keys = (Ptr_g_hash_table_get_keys) Tcl_FindSymbol(interp, loadHandle, "g_hash_table_get_keys");
  if (gttk_g_hash_table_get_keys == NULL) return TCL_ERROR;
  gttk_g_malloc = (Ptr_g_malloc) Tcl_FindSymbol(interp, loadHandle, "g_malloc");
  if (gttk_g_malloc == NULL) return TCL_ERROR;
  gttk_g_malloc0 = (Ptr_g_malloc0) Tcl_FindSymbol(interp, loadHandle, "g_malloc0");
  if (gttk_g_malloc0 == NULL) return TCL_ERROR;
  gttk_g_option_context_add_main_entries = (Ptr_g_option_context_add_main_entries) Tcl_FindSymbol(interp, loadHandle, "g_option_context_add_main_entries");
  if (gttk_g_option_context_add_main_entries == NULL) return TCL_ERROR;
  gttk_g_option_context_new = (Ptr_g_option_context_new) Tcl_FindSymbol(interp, loadHandle, "g_option_context_new");
  if (gttk_g_option_context_new == NULL) return TCL_ERROR;
  gttk_g_strfreev = (Ptr_g_strfreev) Tcl_FindSymbol(interp, loadHandle, "g_strfreev");
  if (gttk_g_strfreev == NULL) return TCL_ERROR;
#else
  const char *fname = Tcl_GetString(file_name);
  GModule *m = g_module_open(fname, G_MODULE_BIND_LAZY);
  if (!m) {
    Tcl_SetResult(interp, (char *) "cannot open module: ", TCL_STATIC);
    Tcl_AppendResult(interp, fname, (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "g_free", (gpointer *) &gttk_g_free)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "g_free", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "g_hash_table_get_keys", (gpointer *) &gttk_g_hash_table_get_keys)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "g_hash_table_get_keys", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "g_malloc", (gpointer *) &gttk_g_malloc)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "g_malloc", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "g_malloc0", (gpointer *) &gttk_g_malloc0)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "g_malloc0", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "g_option_context_add_main_entries", (gpointer *) &gttk_g_option_context_add_main_entries)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "g_option_context_add_main_entries", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "g_option_context_new", (gpointer *) &gttk_g_option_context_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "g_option_context_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "g_strfreev", (gpointer *) &gttk_g_strfreev)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "g_strfreev", (char *) NULL);
    return TCL_ERROR;
  }
#endif
  return TCL_OK;
}; /* gttk_InitialiseSymbols_glib */


int gttk_InitialiseSymbols_gobject(Tcl_Interp *interp, Tcl_Obj *file_name) {
#ifdef LOAD_SYMBOLS_WITH_TCL
  Tcl_LoadHandle loadHandle;
  int status;
  status = Tcl_LoadFile(interp, file_name, NULL, 0, NULL, &loadHandle);
  if (status != TCL_OK) return status;
  gttk_g_object_get = (Ptr_g_object_get) Tcl_FindSymbol(interp, loadHandle, "g_object_get");
  if (gttk_g_object_get == NULL) return TCL_ERROR;
  gttk_g_object_unref = (Ptr_g_object_unref) Tcl_FindSymbol(interp, loadHandle, "g_object_unref");
  if (gttk_g_object_unref == NULL) return TCL_ERROR;
#else
  const char *fname = Tcl_GetString(file_name);
  GModule *m = g_module_open(fname, G_MODULE_BIND_LAZY);
  if (!m) {
    Tcl_SetResult(interp, (char *) "cannot open module: ", TCL_STATIC);
    Tcl_AppendResult(interp, fname, (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "g_object_get", (gpointer *) &gttk_g_object_get)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "g_object_get", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "g_object_unref", (gpointer *) &gttk_g_object_unref)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "g_object_unref", (char *) NULL);
    return TCL_ERROR;
  }
#endif
  return TCL_OK;
}; /* gttk_InitialiseSymbols_gobject */


int gttk_InitialiseSymbols_gtk(Tcl_Interp *interp, Tcl_Obj *file_name) {
#ifdef LOAD_SYMBOLS_WITH_TCL
  Tcl_LoadHandle loadHandle;
  int status;
  status = Tcl_LoadFile(interp, file_name, NULL, 0, NULL, &loadHandle);
  if (status != TCL_OK) return status;
  gttk_gtk_adjustment_new = (Ptr_gtk_adjustment_new) Tcl_FindSymbol(interp, loadHandle, "gtk_adjustment_new");
  if (gttk_gtk_adjustment_new == NULL) return TCL_ERROR;
  gttk_gtk_adjustment_set_value = (Ptr_gtk_adjustment_set_value) Tcl_FindSymbol(interp, loadHandle, "gtk_adjustment_set_value");
  if (gttk_gtk_adjustment_set_value == NULL) return TCL_ERROR;
  gttk_gtk_arrow_new = (Ptr_gtk_arrow_new) Tcl_FindSymbol(interp, loadHandle, "gtk_arrow_new");
  if (gttk_gtk_arrow_new == NULL) return TCL_ERROR;
  gttk_gtk_border_free = (Ptr_gtk_border_free) Tcl_FindSymbol(interp, loadHandle, "gtk_border_free");
  if (gttk_gtk_border_free == NULL) return TCL_ERROR;
  gttk_gtk_button_get_relief = (Ptr_gtk_button_get_relief) Tcl_FindSymbol(interp, loadHandle, "gtk_button_get_relief");
  if (gttk_gtk_button_get_relief == NULL) return TCL_ERROR;
  gttk_gtk_button_new = (Ptr_gtk_button_new) Tcl_FindSymbol(interp, loadHandle, "gtk_button_new");
  if (gttk_gtk_button_new == NULL) return TCL_ERROR;
  gttk_gtk_button_set_relief = (Ptr_gtk_button_set_relief) Tcl_FindSymbol(interp, loadHandle, "gtk_button_set_relief");
  if (gttk_gtk_button_set_relief == NULL) return TCL_ERROR;
  gttk_gtk_check_button_new = (Ptr_gtk_check_button_new) Tcl_FindSymbol(interp, loadHandle, "gtk_check_button_new");
  if (gttk_gtk_check_button_new == NULL) return TCL_ERROR;
  gttk_gtk_combo_box_entry_new = (Ptr_gtk_combo_box_entry_new) Tcl_FindSymbol(interp, loadHandle, "gtk_combo_box_entry_new");
  if (gttk_gtk_combo_box_entry_new == NULL) return TCL_ERROR;
  gttk_gtk_combo_box_new = (Ptr_gtk_combo_box_new) Tcl_FindSymbol(interp, loadHandle, "gtk_combo_box_new");
  if (gttk_gtk_combo_box_new == NULL) return TCL_ERROR;
  gttk_gtk_container_add = (Ptr_gtk_container_add) Tcl_FindSymbol(interp, loadHandle, "gtk_container_add");
  if (gttk_gtk_container_add == NULL) return TCL_ERROR;
  gttk_gtk_disable_setlocale = (Ptr_gtk_disable_setlocale) Tcl_FindSymbol(interp, loadHandle, "gtk_disable_setlocale");
  if (gttk_gtk_disable_setlocale == NULL) return TCL_ERROR;
  gttk_gtk_entry_new = (Ptr_gtk_entry_new) Tcl_FindSymbol(interp, loadHandle, "gtk_entry_new");
  if (gttk_gtk_entry_new == NULL) return TCL_ERROR;
  gttk_gtk_fixed_new = (Ptr_gtk_fixed_new) Tcl_FindSymbol(interp, loadHandle, "gtk_fixed_new");
  if (gttk_gtk_fixed_new == NULL) return TCL_ERROR;
  gttk_gtk_frame_new = (Ptr_gtk_frame_new) Tcl_FindSymbol(interp, loadHandle, "gtk_frame_new");
  if (gttk_gtk_frame_new == NULL) return TCL_ERROR;
  gttk_gtk_hpaned_new = (Ptr_gtk_hpaned_new) Tcl_FindSymbol(interp, loadHandle, "gtk_hpaned_new");
  if (gttk_gtk_hpaned_new == NULL) return TCL_ERROR;
  gttk_gtk_hscale_new_with_range = (Ptr_gtk_hscale_new_with_range) Tcl_FindSymbol(interp, loadHandle, "gtk_hscale_new_with_range");
  if (gttk_gtk_hscale_new_with_range == NULL) return TCL_ERROR;
  gttk_gtk_hscrollbar_new = (Ptr_gtk_hscrollbar_new) Tcl_FindSymbol(interp, loadHandle, "gtk_hscrollbar_new");
  if (gttk_gtk_hscrollbar_new == NULL) return TCL_ERROR;
  gttk_gtk_init_check = (Ptr_gtk_init_check) Tcl_FindSymbol(interp, loadHandle, "gtk_init_check");
  if (gttk_gtk_init_check == NULL) return TCL_ERROR;
  gttk_gtk_notebook_new = (Ptr_gtk_notebook_new) Tcl_FindSymbol(interp, loadHandle, "gtk_notebook_new");
  if (gttk_gtk_notebook_new == NULL) return TCL_ERROR;
  gttk_gtk_object_get = (Ptr_gtk_object_get) Tcl_FindSymbol(interp, loadHandle, "gtk_object_get");
  if (gttk_gtk_object_get == NULL) return TCL_ERROR;
  gttk_gtk_paint_arrow = (Ptr_gtk_paint_arrow) Tcl_FindSymbol(interp, loadHandle, "gtk_paint_arrow");
  if (gttk_gtk_paint_arrow == NULL) return TCL_ERROR;
  gttk_gtk_paint_box = (Ptr_gtk_paint_box) Tcl_FindSymbol(interp, loadHandle, "gtk_paint_box");
  if (gttk_gtk_paint_box == NULL) return TCL_ERROR;
  gttk_gtk_paint_box_gap = (Ptr_gtk_paint_box_gap) Tcl_FindSymbol(interp, loadHandle, "gtk_paint_box_gap");
  if (gttk_gtk_paint_box_gap == NULL) return TCL_ERROR;
  gttk_gtk_paint_check = (Ptr_gtk_paint_check) Tcl_FindSymbol(interp, loadHandle, "gtk_paint_check");
  if (gttk_gtk_paint_check == NULL) return TCL_ERROR;
  gttk_gtk_paint_extension = (Ptr_gtk_paint_extension) Tcl_FindSymbol(interp, loadHandle, "gtk_paint_extension");
  if (gttk_gtk_paint_extension == NULL) return TCL_ERROR;
  gttk_gtk_paint_flat_box = (Ptr_gtk_paint_flat_box) Tcl_FindSymbol(interp, loadHandle, "gtk_paint_flat_box");
  if (gttk_gtk_paint_flat_box == NULL) return TCL_ERROR;
  gttk_gtk_paint_focus = (Ptr_gtk_paint_focus) Tcl_FindSymbol(interp, loadHandle, "gtk_paint_focus");
  if (gttk_gtk_paint_focus == NULL) return TCL_ERROR;
  gttk_gtk_paint_handle = (Ptr_gtk_paint_handle) Tcl_FindSymbol(interp, loadHandle, "gtk_paint_handle");
  if (gttk_gtk_paint_handle == NULL) return TCL_ERROR;
  gttk_gtk_paint_option = (Ptr_gtk_paint_option) Tcl_FindSymbol(interp, loadHandle, "gtk_paint_option");
  if (gttk_gtk_paint_option == NULL) return TCL_ERROR;
  gttk_gtk_paint_resize_grip = (Ptr_gtk_paint_resize_grip) Tcl_FindSymbol(interp, loadHandle, "gtk_paint_resize_grip");
  if (gttk_gtk_paint_resize_grip == NULL) return TCL_ERROR;
  gttk_gtk_paint_shadow = (Ptr_gtk_paint_shadow) Tcl_FindSymbol(interp, loadHandle, "gtk_paint_shadow");
  if (gttk_gtk_paint_shadow == NULL) return TCL_ERROR;
  gttk_gtk_paint_slider = (Ptr_gtk_paint_slider) Tcl_FindSymbol(interp, loadHandle, "gtk_paint_slider");
  if (gttk_gtk_paint_slider == NULL) return TCL_ERROR;
  gttk_gtk_progress_bar_new = (Ptr_gtk_progress_bar_new) Tcl_FindSymbol(interp, loadHandle, "gtk_progress_bar_new");
  if (gttk_gtk_progress_bar_new == NULL) return TCL_ERROR;
  gttk_gtk_progress_bar_set_bar_style = (Ptr_gtk_progress_bar_set_bar_style) Tcl_FindSymbol(interp, loadHandle, "gtk_progress_bar_set_bar_style");
  if (gttk_gtk_progress_bar_set_bar_style == NULL) return TCL_ERROR;
  gttk_gtk_progress_bar_set_fraction = (Ptr_gtk_progress_bar_set_fraction) Tcl_FindSymbol(interp, loadHandle, "gtk_progress_bar_set_fraction");
  if (gttk_gtk_progress_bar_set_fraction == NULL) return TCL_ERROR;
  gttk_gtk_progress_bar_set_orientation = (Ptr_gtk_progress_bar_set_orientation) Tcl_FindSymbol(interp, loadHandle, "gtk_progress_bar_set_orientation");
  if (gttk_gtk_progress_bar_set_orientation == NULL) return TCL_ERROR;
  gttk_gtk_range_get_adjustment = (Ptr_gtk_range_get_adjustment) Tcl_FindSymbol(interp, loadHandle, "gtk_range_get_adjustment");
  if (gttk_gtk_range_get_adjustment == NULL) return TCL_ERROR;
  gttk_gtk_rc_get_default_files = (Ptr_gtk_rc_get_default_files) Tcl_FindSymbol(interp, loadHandle, "gtk_rc_get_default_files");
  if (gttk_gtk_rc_get_default_files == NULL) return TCL_ERROR;
  gttk_gtk_rc_get_style = (Ptr_gtk_rc_get_style) Tcl_FindSymbol(interp, loadHandle, "gtk_rc_get_style");
  if (gttk_gtk_rc_get_style == NULL) return TCL_ERROR;
  gttk_gtk_rc_get_theme_dir = (Ptr_gtk_rc_get_theme_dir) Tcl_FindSymbol(interp, loadHandle, "gtk_rc_get_theme_dir");
  if (gttk_gtk_rc_get_theme_dir == NULL) return TCL_ERROR;
  gttk_gtk_rc_reparse_all_for_settings = (Ptr_gtk_rc_reparse_all_for_settings) Tcl_FindSymbol(interp, loadHandle, "gtk_rc_reparse_all_for_settings");
  if (gttk_gtk_rc_reparse_all_for_settings == NULL) return TCL_ERROR;
  gttk_gtk_rc_reset_styles = (Ptr_gtk_rc_reset_styles) Tcl_FindSymbol(interp, loadHandle, "gtk_rc_reset_styles");
  if (gttk_gtk_rc_reset_styles == NULL) return TCL_ERROR;
  gttk_gtk_rc_set_default_files = (Ptr_gtk_rc_set_default_files) Tcl_FindSymbol(interp, loadHandle, "gtk_rc_set_default_files");
  if (gttk_gtk_rc_set_default_files == NULL) return TCL_ERROR;
  gttk_gtk_settings_get_default = (Ptr_gtk_settings_get_default) Tcl_FindSymbol(interp, loadHandle, "gtk_settings_get_default");
  if (gttk_gtk_settings_get_default == NULL) return TCL_ERROR;
  gttk_gtk_statusbar_new = (Ptr_gtk_statusbar_new) Tcl_FindSymbol(interp, loadHandle, "gtk_statusbar_new");
  if (gttk_gtk_statusbar_new == NULL) return TCL_ERROR;
  gttk_gtk_style_apply_default_background = (Ptr_gtk_style_apply_default_background) Tcl_FindSymbol(interp, loadHandle, "gtk_style_apply_default_background");
  if (gttk_gtk_style_apply_default_background == NULL) return TCL_ERROR;
  gttk_gtk_style_attach = (Ptr_gtk_style_attach) Tcl_FindSymbol(interp, loadHandle, "gtk_style_attach");
  if (gttk_gtk_style_attach == NULL) return TCL_ERROR;
  gttk_gtk_style_lookup_color = (Ptr_gtk_style_lookup_color) Tcl_FindSymbol(interp, loadHandle, "gtk_style_lookup_color");
  if (gttk_gtk_style_lookup_color == NULL) return TCL_ERROR;
  gttk_gtk_toolbar_new = (Ptr_gtk_toolbar_new) Tcl_FindSymbol(interp, loadHandle, "gtk_toolbar_new");
  if (gttk_gtk_toolbar_new == NULL) return TCL_ERROR;
  gttk_gtk_vpaned_new = (Ptr_gtk_vpaned_new) Tcl_FindSymbol(interp, loadHandle, "gtk_vpaned_new");
  if (gttk_gtk_vpaned_new == NULL) return TCL_ERROR;
  gttk_gtk_vscale_new_with_range = (Ptr_gtk_vscale_new_with_range) Tcl_FindSymbol(interp, loadHandle, "gtk_vscale_new_with_range");
  if (gttk_gtk_vscale_new_with_range == NULL) return TCL_ERROR;
  gttk_gtk_vscrollbar_new = (Ptr_gtk_vscrollbar_new) Tcl_FindSymbol(interp, loadHandle, "gtk_vscrollbar_new");
  if (gttk_gtk_vscrollbar_new == NULL) return TCL_ERROR;
  gttk_gtk_widget_destroy = (Ptr_gtk_widget_destroy) Tcl_FindSymbol(interp, loadHandle, "gtk_widget_destroy");
  if (gttk_gtk_widget_destroy == NULL) return TCL_ERROR;
  gttk_gtk_widget_realize = (Ptr_gtk_widget_realize) Tcl_FindSymbol(interp, loadHandle, "gtk_widget_realize");
  if (gttk_gtk_widget_realize == NULL) return TCL_ERROR;
  gttk_gtk_widget_set_size_request = (Ptr_gtk_widget_set_size_request) Tcl_FindSymbol(interp, loadHandle, "gtk_widget_set_size_request");
  if (gttk_gtk_widget_set_size_request == NULL) return TCL_ERROR;
  gttk_gtk_widget_size_request = (Ptr_gtk_widget_size_request) Tcl_FindSymbol(interp, loadHandle, "gtk_widget_size_request");
  if (gttk_gtk_widget_size_request == NULL) return TCL_ERROR;
  gttk_gtk_widget_style_get = (Ptr_gtk_widget_style_get) Tcl_FindSymbol(interp, loadHandle, "gtk_widget_style_get");
  if (gttk_gtk_widget_style_get == NULL) return TCL_ERROR;
  gttk_gtk_window_new = (Ptr_gtk_window_new) Tcl_FindSymbol(interp, loadHandle, "gtk_window_new");
  if (gttk_gtk_window_new == NULL) return TCL_ERROR;
#else
  const char *fname = Tcl_GetString(file_name);
  GModule *m = g_module_open(fname, G_MODULE_BIND_LAZY);
  if (!m) {
    Tcl_SetResult(interp, (char *) "cannot open module: ", TCL_STATIC);
    Tcl_AppendResult(interp, fname, (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_adjustment_new", (gpointer *) &gttk_gtk_adjustment_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_adjustment_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_adjustment_set_value", (gpointer *) &gttk_gtk_adjustment_set_value)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_adjustment_set_value", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_arrow_new", (gpointer *) &gttk_gtk_arrow_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_arrow_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_border_free", (gpointer *) &gttk_gtk_border_free)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_border_free", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_button_get_relief", (gpointer *) &gttk_gtk_button_get_relief)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_button_get_relief", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_button_new", (gpointer *) &gttk_gtk_button_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_button_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_button_set_relief", (gpointer *) &gttk_gtk_button_set_relief)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_button_set_relief", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_check_button_new", (gpointer *) &gttk_gtk_check_button_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_check_button_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_combo_box_entry_new", (gpointer *) &gttk_gtk_combo_box_entry_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_combo_box_entry_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_combo_box_new", (gpointer *) &gttk_gtk_combo_box_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_combo_box_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_container_add", (gpointer *) &gttk_gtk_container_add)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_container_add", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_disable_setlocale", (gpointer *) &gttk_gtk_disable_setlocale)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_disable_setlocale", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_entry_new", (gpointer *) &gttk_gtk_entry_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_entry_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_fixed_new", (gpointer *) &gttk_gtk_fixed_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_fixed_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_frame_new", (gpointer *) &gttk_gtk_frame_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_frame_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_hpaned_new", (gpointer *) &gttk_gtk_hpaned_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_hpaned_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_hscale_new_with_range", (gpointer *) &gttk_gtk_hscale_new_with_range)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_hscale_new_with_range", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_hscrollbar_new", (gpointer *) &gttk_gtk_hscrollbar_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_hscrollbar_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_init_check", (gpointer *) &gttk_gtk_init_check)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_init_check", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_notebook_new", (gpointer *) &gttk_gtk_notebook_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_notebook_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_object_get", (gpointer *) &gttk_gtk_object_get)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_object_get", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_paint_arrow", (gpointer *) &gttk_gtk_paint_arrow)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_paint_arrow", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_paint_box", (gpointer *) &gttk_gtk_paint_box)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_paint_box", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_paint_box_gap", (gpointer *) &gttk_gtk_paint_box_gap)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_paint_box_gap", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_paint_check", (gpointer *) &gttk_gtk_paint_check)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_paint_check", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_paint_extension", (gpointer *) &gttk_gtk_paint_extension)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_paint_extension", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_paint_flat_box", (gpointer *) &gttk_gtk_paint_flat_box)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_paint_flat_box", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_paint_focus", (gpointer *) &gttk_gtk_paint_focus)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_paint_focus", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_paint_handle", (gpointer *) &gttk_gtk_paint_handle)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_paint_handle", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_paint_option", (gpointer *) &gttk_gtk_paint_option)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_paint_option", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_paint_resize_grip", (gpointer *) &gttk_gtk_paint_resize_grip)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_paint_resize_grip", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_paint_shadow", (gpointer *) &gttk_gtk_paint_shadow)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_paint_shadow", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_paint_slider", (gpointer *) &gttk_gtk_paint_slider)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_paint_slider", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_progress_bar_new", (gpointer *) &gttk_gtk_progress_bar_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_progress_bar_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_progress_bar_set_bar_style", (gpointer *) &gttk_gtk_progress_bar_set_bar_style)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_progress_bar_set_bar_style", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_progress_bar_set_fraction", (gpointer *) &gttk_gtk_progress_bar_set_fraction)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_progress_bar_set_fraction", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_progress_bar_set_orientation", (gpointer *) &gttk_gtk_progress_bar_set_orientation)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_progress_bar_set_orientation", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_range_get_adjustment", (gpointer *) &gttk_gtk_range_get_adjustment)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_range_get_adjustment", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_rc_get_default_files", (gpointer *) &gttk_gtk_rc_get_default_files)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_rc_get_default_files", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_rc_get_style", (gpointer *) &gttk_gtk_rc_get_style)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_rc_get_style", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_rc_get_theme_dir", (gpointer *) &gttk_gtk_rc_get_theme_dir)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_rc_get_theme_dir", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_rc_reparse_all_for_settings", (gpointer *) &gttk_gtk_rc_reparse_all_for_settings)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_rc_reparse_all_for_settings", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_rc_reset_styles", (gpointer *) &gttk_gtk_rc_reset_styles)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_rc_reset_styles", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_rc_set_default_files", (gpointer *) &gttk_gtk_rc_set_default_files)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_rc_set_default_files", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_settings_get_default", (gpointer *) &gttk_gtk_settings_get_default)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_settings_get_default", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_statusbar_new", (gpointer *) &gttk_gtk_statusbar_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_statusbar_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_style_apply_default_background", (gpointer *) &gttk_gtk_style_apply_default_background)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_style_apply_default_background", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_style_attach", (gpointer *) &gttk_gtk_style_attach)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_style_attach", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_style_lookup_color", (gpointer *) &gttk_gtk_style_lookup_color)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_style_lookup_color", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_toolbar_new", (gpointer *) &gttk_gtk_toolbar_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_toolbar_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_vpaned_new", (gpointer *) &gttk_gtk_vpaned_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_vpaned_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_vscale_new_with_range", (gpointer *) &gttk_gtk_vscale_new_with_range)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_vscale_new_with_range", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_vscrollbar_new", (gpointer *) &gttk_gtk_vscrollbar_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_vscrollbar_new", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_widget_destroy", (gpointer *) &gttk_gtk_widget_destroy)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_widget_destroy", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_widget_realize", (gpointer *) &gttk_gtk_widget_realize)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_widget_realize", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_widget_set_size_request", (gpointer *) &gttk_gtk_widget_set_size_request)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_widget_set_size_request", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_widget_size_request", (gpointer *) &gttk_gtk_widget_size_request)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_widget_size_request", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_widget_style_get", (gpointer *) &gttk_gtk_widget_style_get)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_widget_style_get", (char *) NULL);
    return TCL_ERROR;
  }
  if (!g_module_symbol(m, "gtk_window_new", (gpointer *) &gttk_gtk_window_new)) {
    Tcl_SetResult(interp, (char *) "cannot find symbol: ", TCL_STATIC);
    Tcl_AppendResult(interp, (char *) "gtk_window_new", (char *) NULL);
    return TCL_ERROR;
  }
#endif
  return TCL_OK;
}; /* gttk_InitialiseSymbols_gtk */

#endif /* GTTK_LOAD_GTK_DYNAMICALLY */
