# PrimeLunch: Amazon Transaction Updater

<div align="center">
    <p float="center">
        <img src=https://upload.wikimedia.org/wikipedia/commons/d/de/Amazon_icon.png
            width="35%" alt="lunchable">
        <img src=https://i.imgur.com/FyKDsG3.png
            width="60%" alt="lunchable">
    </p>
</div>

--------

`PrimeLunch` is a command line tool that supports updating Amazon transaction notes with the items from
Amazon itself. This tool uses CSVs generated by the
[Amazon Order History Reporter](https://chrome.google.com/webstore/detail/amazon-order-history-repo/mgkilgclilajckgnedgjgnfdokkgnibi)
plugin on Chrome. Once you've gathered your transactions, export them as a CSV and scan them with the tool.
You'll be asked which transactions you'd like to update.

<div>
    <img src=https://i.imgur.com/C5IcOQl.png>
</div>

--------

The plugin uses the dollar amounts on the CSV export to match Amazon transactions in LunchMoney.
When a matching dollar amount is found, `PrimeLunch` compares the date window between the transactions
to determine if they're really a match.

We're using
the [Amazon Order History Reporter](https://chrome.google.com/webstore/detail/amazon-order-history-repo/mgkilgclilajckgnedgjgnfdokkgnibi)
plugin because it gives us some functionality that Amazon doesn't: exporting Amazon transactions as they're
grouped on actual credit card transactions.

## Run via the [Lunchable CLI](cli.md#lunchable-cli)

You can install lunchable with [pip](https://pypi.org/project/lunchable/) or
[pipx](https://pypa.github.io/pipx/):

```shell
pipx install "lunchable[primelunch]"
```

```shell
pip install "lunchable[primelunch]"
```

The below command runs the `PrimeLunch` update tool:

```shell
lunchable plugins primelunch run -f ~/Downloads/amazon_order_history.csv
```

The below command runs the `PrimeLunch` update tool using a date window of three days
instead of 5 days:

```shell
lunchable plugins primelunch run \
   --file ~/Downloads/amazon_order_history.csv \
   --window 3
```

Update all transactions without going through the confirmation prompt for each one:

```shell
lunchable plugins primelunch run \
   --file ~/Downloads/amazon_order_history.csv \
   --all
```

Provide a LunchMoney API access token manually (`PrimeLunch` defaults to inheriting from the `LUNCHMONEY_ACCESS_TOKEN`
environment variable):

```shell
lunchable plugins primelunch run \
   --file ~/Downloads/amazon_order_history.csv \
   --token ABCDEFGHIJKLMNOP
```

## References

This lunchable plugin was inspired by the original Lunchable Amazon importer
at [samwelnella/amazon-transactions-to-lunchmoney](https://github.com/samwelnella/amazon-transactions-to-lunchmoney).
