%define prefix /opt/LHCbSoft

%global __os_install_post /usr/lib/rpm/check-buildroot

Name: LbEnv
Version: 0.1.5
Release: 1
Vendor: LHCb
Summary: Entry scripts for LHCb login environment
License: GPLv3
URL:     https://gitlab.cern.ch/lhcb-core/%{name}
Source0: https://gitlab.cern.ch/lhcb-core/%{name}/-/archive/%{version}/%{name}-%{version}.tar.gz

Group: LHCb

BuildArch: noarch
AutoReqProv: no
Prefix: %{prefix}
Provides: /bin/sh
Provides: /bin/bash

%description
Entry scripts for LHCb login environment

%prep
%setup -q

%build

%install
mkdir -p ${RPM_BUILD_ROOT}%{prefix}/bin
install -m 0755 '{{cookiecutter.dest_dir}}/bin/host_os' ${RPM_BUILD_ROOT}/%{prefix}/bin

for flavour in prod dev ; do
  for suff in '' .sh .csh ; do
    tgt=${RPM_BUILD_ROOT}/%{prefix}/LbEnv-${flavour}${suff}
    install -m 0644 "{{cookiecutter.dest_dir}}/LbEnv-{{cookiecutter.scripts_flavour}}${suff}" "${tgt}"
    sed -i "s/{{cookiecutter.scripts_flavour}}/${flavour}/g" "${tgt}"
  done
done
for suff in '' .sh .csh ; do
  ln -s LbEnv-prod${suff} ${RPM_BUILD_ROOT}/%{prefix}/LbEnv${suff}
done

%clean

%post -p /bin/bash
for flavour in prod dev ; do
  for suff in '' .sh .csh ; do
    tgt=${RPM_INSTALL_PREFIX}/LbEnv-${flavour}${suff}
    sed -i "s#{{cookiecutter.\(target_dir\|siteroot\)}}#${RPM_INSTALL_PREFIX}#g;s#{{cookiecutter.lbenv_root}}#${RPM_INSTALL_PREFIX}/var/lib/LbEnv/${flavour}#g" "${tgt}"
  done
done

%postun -p /bin/bash

%files
%defattr(-,root,root)
%{prefix}/bin/host_os
%{prefix}/LbEnv
%{prefix}/LbEnv.sh
%{prefix}/LbEnv.csh
%{prefix}/LbEnv-prod
%{prefix}/LbEnv-prod.sh
%{prefix}/LbEnv-prod.csh
%{prefix}/LbEnv-dev
%{prefix}/LbEnv-dev.sh
%{prefix}/LbEnv-dev.csh


%changelog
* Mon Oct 22 2018 Marco Clemencic <marco.clemencic@cern.ch>
- first rpm package
