# Generated by Django 3.1.3 on 2021-01-11 20:38

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion

class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sender_id', models.PositiveIntegerField(null=True)),
                ('context', models.JSONField(default=dict)),
                ('name', models.CharField(max_length=100)),
                ('subject', models.CharField(max_length=255)),
                ('text', models.TextField(blank=True, null=True)),
                ('html', models.TextField(blank=True, null=True)),
                ('link', models.CharField(blank=True, max_length=255, null=True)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_sent', models.DateTimeField(blank=True, null=True)),
                ('date_digested', models.DateTimeField(blank=True, null=True)),
                ('recipients', models.JSONField(blank=True, null=True)),
                ('sender_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='notification_sender_types', to='contenttypes.contenttype')),
            ],
        ),
        migrations.CreateModel(
            name='Subscription',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sender_id', models.PositiveIntegerField(null=True)),
                ('notification_name', models.CharField(max_length=100)),
                ('is_active', models.BooleanField(default=True)),
                ('digest', models.BooleanField(default=False)),
                ('sender_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='notification_subscription_sender_types', to='contenttypes.contenttype')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('user', 'notification_name', 'sender_type', 'sender_id', 'digest')},
            },
        ),
    ]
