[![PyPI](https://img.shields.io/pypi/v/prisma-sase.svg)](https://pypi.org/project/prisma-sase/)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/prisma-sase.svg)](https://pypi.org/project/prisma-sase/)
[![Downloads](https://pepy.tech/badge/prisma-sase)](https://pepy.tech/project/prisma-sase)
[![PyPI - License](https://img.shields.io/pypi/l/prisma-sase.svg?color=brightgreen)](https://pypi.org/project/prisma-sase/)
[![GitHub issues](https://img.shields.io/github/issues/PaloAltoNetworks/prisma-sase-sdk-python.svg)](https://github.com/PaloAltoNetworks/prisma-sase-sdk-python/issues)

# Palo Alto Networks Prisma SASE Python SDK v6.3.2b1
Python3 SDK for the Prisma SASE AppFabric

#### Synopsis
Intended to be a small, lightweight SDK wrapper around the Prisma SASE API for easy use. 
Initial version requires knowledge of JSON/Dict objects for POST/PUT/PATCH operations.

#### Requirements
* Active Prisma SASE Account
* Python >= 3.7
* Python modules:
    * Requests - <http://docs.python-requests.org/en/master/>
    * Websockets >= 8.1 - <https://websockets.readthedocs.io/en/stable/index.html>
    * urllib3 >= 2.0.0 - <https://urllib3.readthedocs.io/en/stable/>

#### Code Example
Comes with `example.py` that shows usage to get a JSON list of sites.

Super-simplified example code (rewrite of example.py in ~4 lines of code):
```python
# Import the Prisma SASE SDK API constructor and JSON response pretty printer
from prisma_sase import API, jd

# Instantiate the Prisma SASEx API constructor
sdk = API()

# Call Prisma SASE API login using the Interactive helpers (Handle SAML2.0 login and MSP functions too!).
sdk.interactive.login_secret(client_id='api_user1@1111111111.iam.panserviceaccount.com', 
                             client_secret='xxxxxx', 
                             tsg_id=1111111111)

# Print a dump of the list of sites for your selected account
jd(sdk.get.sites())
```

#### License
MIT

#### Version
| Version   | Build | Changes                                       |
|-----------| ----- |-----------------------------------------------|
| **6.3.2** | **b1** | Support for February 2023 Controller release. |
| **6.3.1** | **b1** | Support for November 2023 Controller release. |
| **6.2.3** | **b1** | Support for August 2023 Controller release.   |
| **6.2.2** | **b1** | Support for June 2023 Controller release.     |
| **6.2.1** | **b1** | Support for April 2023 Controller release.    |
| **6.1.2** | **b1** | Support for January 2023 Controller release.  |
| **6.1.1** | **b1** | Support for November 2022 Controller release. |
| **6.0.1** | **b1** | Support for May 2022 Controller release.      |

## For more info
 * Get help and additional Prisma SASE Documentation at <https://pan.dev/sase/docs>
 * View the autogenerated documentation in the `docs/` directory, or at <https://github.com/PaloAltoNetworks/prisma-sase-sdk-python/>.
 * View in-python help using `help()` functions. (example: `help(sdk.get.login)`)
