# Generated by Django 2.2.20 on 2021-08-25 08:12

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("djangocms_faq", "0002_auto_20210531_1650"),
    ]

    def update_all_uuids_by_random_ones(apps, schema_editor):
        from collections import defaultdict
        import random
        import uuid

        from djangocms_faq.models import (
            FaqPluginModel,
            RelationSearchFaq,
            SearchFaqPluginModel,
        )

        print("\nUpdating faqs...")

        print("Listing all same uuids...")
        # get a list of lists of faqs sorted by same uuid
        # ex:
        # [
        #   ['aaaa-aaaa',
        #    'aaaa-aaaa',
        #    'aaaa-aaaa',
        #   ],
        #   ['bbbb-bbbb',
        #    'bbbb-bbbb',
        #   ]
        #   ...
        # ]
        faqs = FaqPluginModel.objects.order_by("uuid")
        faqs_dict = defaultdict(list)
        for faq in faqs:
            faqs_dict[faq.uuid].append(faq)
        faqs_sorted = list(faqs_dict.values())

        for faqs in faqs_sorted:
            # each group of faq with same uuid
            for faq in faqs:
                # reinit uuid for faq
                rd = random.Random()
                new_uuid = uuid.UUID(int=rd.getrandbits(128))
                faq.uuid = new_uuid
                faq.save()

        print("Done!\nUpdating searches & relations...")

        # same thing but for searches this time
        searches = SearchFaqPluginModel.objects.order_by("uuid")
        searches_dict = defaultdict(list)
        for search in searches:
            searches_dict[search.uuid].append(search)
        searches_sorted = list(searches_dict.values())

        for searches in searches_sorted:
            for search in searches:
                rd = random.Random()
                new_uuid = uuid.UUID(int=rd.getrandbits(128))
                search.uuid = new_uuid
                search.save()

                for faq in search.search_in.all():
                    # create relations between faqs and searchs
                    if not RelationSearchFaq.objects.filter(
                        search=search.uuid, faq=faq.uuid
                    ):
                        new_relation = RelationSearchFaq()
                        new_relation.faq = search.uuid
                        new_relation.search = faq.uuid
                        new_relation.save()

        print("Done!")

    operations = [
        migrations.RemoveField(
            model_name="faqpluginmodel",
            name="show_title",
        ),
        migrations.AddField(
            model_name="faqpluginmodel",
            name="name",
            field=models.CharField(
                default="No name",
                help_text="Required. Will not be displayed on the website. Used to distinguish between several faqs.<br />",
                max_length=300,
                verbose_name="Nom",
            ),
        ),
        migrations.AlterField(
            model_name="faqpluginmodel",
            name="title",
            field=models.CharField(
                blank=True,
                help_text="Optional. Title that will be displayed on top of the FAQ. If not specified, nothing will be displayed.",
                max_length=300,
                verbose_name="Titre",
            ),
        ),
        migrations.AlterField(
            model_name="questionfaqpluginmodel",
            name="slug",
            field=models.SlugField(
                blank=True,
                default="",
                help_text="Unique slug for this question. Keep empty to let it be auto-generated. <br /><i>Warning: There is no control that the slug is unique, so you have to update it yourself if there is another question on the same page with the same slug.</i>",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="searchfaqpluginmodel",
            name="search_in",
            field=models.ManyToManyField(
                help_text="Format: name (source page name).<br />",
                limit_choices_to={"placeholder__page__publisher_is_draft": True},
                to="djangocms_faq.FaqPluginModel",
                verbose_name="Rechercher",
            ),
        ),
        migrations.RunPython(code=update_all_uuids_by_random_ones),
    ]
