"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsTopicAction = exports.SnsActionMessageFormat = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const role_1 = require("./private/role");
/**
 * SNS topic action message format options.
 */
var SnsActionMessageFormat;
(function (SnsActionMessageFormat) {
    /**
     * RAW message format.
     */
    SnsActionMessageFormat["RAW"] = "RAW";
    /**
     * JSON message format.
     */
    SnsActionMessageFormat["JSON"] = "JSON";
})(SnsActionMessageFormat = exports.SnsActionMessageFormat || (exports.SnsActionMessageFormat = {}));
/**
 * The action to write the data from an MQTT message to an Amazon SNS topic.
 *
 * @see https://docs.aws.amazon.com/iot/latest/developerguide/sns-rule-action.html
 */
class SnsTopicAction {
    /**
     * @param topic The Amazon SNS topic to publish data on. Must not be a FIFO topic.
     * @param props Properties to configure the action.
     */
    constructor(topic, props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_SnsTopicActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SnsTopicAction);
            }
            throw error;
        }
        if (topic.fifo) {
            throw Error('IoT Rule actions cannot be used with FIFO SNS Topics, please pass a non-FIFO Topic instead');
        }
        this.topic = topic;
        this.role = props.role;
        this.messageFormat = props.messageFormat;
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? role_1.singletonActionRole(rule);
        this.topic.grantPublish(role);
        return {
            configuration: {
                sns: {
                    targetArn: this.topic.topicArn,
                    roleArn: role.roleArn,
                    messageFormat: this.messageFormat,
                },
            },
        };
    }
}
exports.SnsTopicAction = SnsTopicAction;
_a = JSII_RTTI_SYMBOL_1;
SnsTopicAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.SnsTopicAction", version: "2.45.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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