# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['mudkip']

package_data = \
{'': ['*']}

install_requires = \
['click>=7.0,<8.0',
 'jupyter_nbextensions_configurator>=0.4.1,<0.5.0',
 'livereload>=2.6,<3.0',
 'nbsphinx>=0.7.1,<0.8.0',
 'notebook>=6.0.3,<7.0.0',
 'recommonmark>=0.6.0,<0.7.0',
 'sphinx-autodoc-typehints>=1.11.0,<2.0.0',
 'sphinx>=3.1.1,<4.0.0',
 'sphinx_rtd_theme>=0.5.0,<0.6.0',
 'tomlkit>=0.6.0,<0.7.0',
 'watchdog>=0.10.2,<0.11.0']

entry_points = \
{'console_scripts': ['mudkip = mudkip.cli:main']}

setup_kwargs = {
    'name': 'mudkip',
    'version': '0.3.6',
    'description': 'A friendly Sphinx wrapper',
    'long_description': '# 📘 mudkip\n\n[![PyPI](https://img.shields.io/pypi/v/mudkip.svg)](https://pypi.org/project/mudkip/)\n[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mudkip.svg)](https://pypi.org/project/mudkip/)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)\n\n> A friendly [Sphinx](https://sphinx-doc.org) wrapper.\n\n**🚧 Work in progress 🚧**\n\nMudkip is a small wrapper around [Sphinx](https://sphinx-doc.org) that bundles essential tools and extensions, providing everything needed for documenting your projects.\n\n```bash\n$ mudkip --help\nUsage: mudkip [OPTIONS] COMMAND [ARGS]...\n\n  A friendly Sphinx wrapper.\n\nOptions:\n  --version  Show the version and exit.\n  --help     Show this message and exit.\n\nCommands:\n  build    Build documentation.\n  clean    Remove output directory.\n  develop  Start development server.\n  init     Initialize documentation.\n  test     Test documentation.\n```\n\n## Features\n\nMudkip intends to provide an out-of-the-box solution for small to medium projects. The command-line utility lets you build and check your documentation, launch a development server with live reloading, run doctests and more!\n\nMudkip enables the following Sphinx extensions:\n\n- [`sphinx.ext.autodoc`](http://www.sphinx-doc.org/en/master/usage/extensions/autodoc.html) for generating documentation from docstrings\n- [`sphinx.ext.napoleon`](https://www.sphinx-doc.org/en/master/usage/extensions/napoleon.html) for Google-style and NumPy-style docstrings support\n- [`sphinx_autodoc_typehints`](https://github.com/agronholm/sphinx-autodoc-typehints) for pulling type information from Python 3 annotations\n- [`sphinx.ext.doctest`](https://www.sphinx-doc.org/en/master/usage/extensions/doctest.html) for doctest support\n- [`sphinx.ext.autosectionlabel`](https://www.sphinx-doc.org/en/master/usage/extensions/autosectionlabel.html) for referencing sections with their title\n- [`recommonmark`](https://recommonmark.readthedocs.io/en/latest/) for markdown support and [`AutoStructify`](https://recommonmark.readthedocs.io/en/latest/auto_structify.html)\n- [`nbsphinx`](https://nbsphinx.readthedocs.io) for Jupyter notebook support\n\nAdditional features are provided through an internal extension.\n\n- `mdinclude` directive\n\n  The built-in `include` directive doesn\'t handle markdown so mudkip provides an `mdinclude` directive to include markdown files.\n\n  ```reStructuredText\n  .. mdinclude:: ../README.md\n  ```\n\n  It\'s also possible to only include a specific section of the file with the `start-line` and `end-line` options.\n\n  ```reStructuredText\n  .. mdinclude:: ../README.md\n    :start-line: 7\n    :end-line: -3\n  ```\n\n## Installation\n\nThe package can be installed with `pip`.\n\n```bash\n$ pip install mudkip\n```\n\n## Getting started\n\nAfter installing the package, no need to run `sphinx-quickstart` or to configure anything, you can immediatly run the `develop` command and start writing docs.\n\n```bash\n$ mudkip develop\nWatching "docs"...\nServer running on http://localhost:5500\n```\n\nThe command will create the "docs" directory if it doesn\'t already exist and launch a development server with live reloading. If you create an `index.rst` file and open the link in your browser, you\'ll see that mudkip uses the [Read the Docs](https://github.com/rtfd/sphinx_rtd_theme) theme by default.\n\n> Note that mudkip enables the [`recommonmark`](https://recommonmark.readthedocs.io/en/latest/) extension, allowing you to use both reStructuredText and markdown files. You can totally create an `index.md` file instead if you prefer markdown over reStructuredText.\n\nPress `Ctrl+C` at any time to exit.\n\n### Building and checking documentation\n\nThe `build` command invokes the [`dirhtml`](https://www.sphinx-doc.org/en/master/usage/builders/index.html#sphinx.builders.dirhtml.DirectoryHTMLBuilder) builder and builds your documentation. By default, the generated files are in "docs/dist".\n\n```bash\n$ mudkip build\n```\n\nRunning the command with the `--check` or `-c` flag will exit with code `1` if Sphinx reports any error or warning.\n\n```bash\n$ mudkip build --check\n```\n\nThe `--check` flag also makes sure that there are no broken links by running the [`linkcheck`](https://www.sphinx-doc.org/en/master/usage/builders/index.html#sphinx.builders.linkcheck.CheckExternalLinksBuilder) builder on your documentation.\n\n### Running doctests\n\nMudkip enables the [`sphinx.ext.doctest`](https://www.sphinx-doc.org/en/master/usage/extensions/doctest.html) extension, making it possible to test interactive code examples. Try to add the following snippet to your `index` document:\n\n```py\n>>> import this\nThe Zen of Python, by Tim Peters\n<BLANKLINE>\nBeautiful is better than ugly.\n...\n```\n\nThe `test` command will run the code example and make sure that the output matches the documentation.\n\n```bash\n$ mudkip test\nTesting "docs"...\n\nDocument: index\n---------------\n1 items passed all tests:\n   1 tests in default\n1 tests in 1 items.\n1 passed and 0 failed.\nTest passed.\n\nDoctest summary\n===============\n    1 test\n    0 failures in tests\n    0 failures in setup code\n    0 failures in cleanup code\n\nPassed.\n```\n\n### Using Jupyter notebooks\n\nThe [`nbsphinx`](https://nbsphinx.readthedocs.io) extension provides support for Jupyter notebooks. This means that in addition to `.rst` and `.md` files, Sphinx will also generate pages for `.ipynb` files.\n\nThe `develop` command can launch the jupyter notebook in the "docs" directory and open it in your browser with the `--notebook` or `-n` flag.\n\n```bash\n$ mudkip develop --notebook\nWatching "docs"...\nServer running on http://localhost:5500\nNotebook running on http://localhost:8888/?token=5e64df6...\n```\n\nWith the `build` command, Notebooks are executed as part of the build process. The `--check` flag will make sure that there are no uncaught exceptions in any cell.\n\n### Integration with npm and yarn\n\nMudkip can help you go further than regular Sphinx themes by running npm scripts for you if you\'re building your own front-end. If your docs contain a `package.json` file, Mudkip will invoke the appropriate npm script after running Sphinx using your preferred npm client.\n\n```bash\n$ mudkip build\n```\n\nHere, Mudkip would try to run either `npm run build` or `yarn build` before exiting the command. Similarly, `mudkip clean` would try to run either `npm run clean` or `yarn clean`.\n\n```bash\n$ mudkip develop\n```\n\nThe `develop` command will try to run one of the following scripts: `develop`, `dev`, `start` or `serve`. If you don\'t have a dedicated script to run your project in development mode, Mudkip will simply execute the `build` script after running Sphinx each time you make a modification.\n\n### Configuration\n\nMudkip doesn\'t require any configuration. You can however overwrite some of the default settings with command-line options or a configuration file.\n\nFor instance, when running a command, you can use the `--preset` or `-p` option to overwrite the default preset with `alabaster` if you want to use the [Alabaster](https://alabaster.readthedocs.io/en/latest/) theme instead of the default [Read the Docs](https://github.com/rtfd/sphinx_rtd_theme) theme.\n\n```\n$ mudkip build --preset alabaster\n```\n\nIt\'s also possible to change the default source and output directories with the `--source-dir` and `--output-dir` options respectively.\n\n```\n$ mudkip build --source-dir path/to/docs --output-dir path/to/output\n```\n\nPassing these options to every single command can become tedious so you can use a configuration file to save your custom settings.\n\nRunning the `init` command will either add a `[tool.mudkip]` section to your `pyproject.toml` or create a `mudkip.toml` file with some basic configuration.\n\n```bash\n$ mudkip init\n```\n\nHere is the list of all the options that can be overwritten in the config file:\n\n- `preset`\n\n  default: `"rtd"`\n\n  Presets configure mudkip and Sphinx to enable specific features. The `rtd` and `alabaster` presets enable the development server and configure Sphinx to use the `dirhtml` builder. The `rtd` preset also changes the html theme to the Read the Docs theme.\n\n- `source_dir`\n\n  default: `"docs"`\n\n  This is the directory containing the source files for your documentation. Sphinx is configured to use it as its source directory and when the development server is enabled, mudkip will watch the directory for changes to rebuild your documentation.\n\n- `output_dir`\n\n  default: `"docs/dist"`\n\n  The output directory is where Sphinx will output the generated files. This is also the directory served by the development server.\n\n- `verbose`\n\n  default: `false`\n\n  This option can also be enabled on the command-line with the `--verbose` flag. Setting it to `true` will tell mudkip to display the entire Sphinx output as well as the Jupyter output when running the `develop` command with the `--notebook` flag.\n\n- `project_name`\n\n  default: The name of the project you\'re documenting in `pyproject.toml`\n\n  If you\'re not using [poetry](https://poetry.eustace.io/), you will need to set it manually.\n\n- `project_dir`\n\n  default: The value of the `project_name` option\n\n  Mudkip will watch the python files in your project directory when using the development server. This enables live reloading even when you\'re editing docstrings.\n\n- `title`\n\n  default: The value of the `project_name` option\n\n  The project title used by Sphinx when building the documentation.\n\n- `copyright`\n\n  default: The current year followed by the value of the `author` option\n\n  The copyright notice used by Sphinx when building the documentation.\n\n- `author`\n\n  default: The concatenated list of authors in `pyproject.toml`\n\n  If you\'re not using [poetry](https://poetry.eustace.io/), you will need to set it manually.\n\n- `version`\n\n  default: The first two numbers of the `release` option\n\n  The version used by Sphinx when building the documentation.\n\n- `release`\n\n  default: The project version in `pyproject.toml`\n\n  If you\'re not using [poetry](https://poetry.eustace.io/), you will need to set it manually.\n\n## Contributing\n\nContributions are welcome. This project uses [poetry](https://poetry.eustace.io/).\n\n```bash\n$ poetry install\n```\n\nThe code follows the [black](https://github.com/ambv/black) code style.\n\n```bash\n$ poetry run black mudkip\n```\n\n---\n\nLicense - [MIT](https://github.com/vberlier/mudkip/blob/master/LICENSE)\n',
    'author': 'Valentin Berlier',
    'author_email': 'berlier.v@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/vberlier/mudkip',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
