"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProviderAttribute = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An attribute available from a third party identity provider.
 *
 * @stability stable
 */
class ProviderAttribute {
    constructor(attributeName) {
        this.attributeName = attributeName;
    }
    /**
     * Use this to specify an attribute from the identity provider that is not pre-defined in the CDK.
     *
     * @param attributeName the attribute value string as recognized by the provider.
     * @stability stable
     */
    static other(attributeName) {
        return new ProviderAttribute(attributeName);
    }
}
exports.ProviderAttribute = ProviderAttribute;
_a = JSII_RTTI_SYMBOL_1;
ProviderAttribute[_a] = { fqn: "@aws-cdk/aws-cognito.ProviderAttribute", version: "1.140.0" };
/**
 * The email attribute provided by Apple.
 *
 * @stability stable
 */
ProviderAttribute.APPLE_EMAIL = new ProviderAttribute('email');
/**
 * The name attribute provided by Apple.
 *
 * @stability stable
 */
ProviderAttribute.APPLE_NAME = new ProviderAttribute('name');
/**
 * The first name attribute provided by Apple.
 *
 * @stability stable
 */
ProviderAttribute.APPLE_FIRST_NAME = new ProviderAttribute('firstName');
/**
 * The last name attribute provided by Apple.
 *
 * @stability stable
 */
ProviderAttribute.APPLE_LAST_NAME = new ProviderAttribute('lastName');
/**
 * The user id attribute provided by Amazon.
 *
 * @stability stable
 */
ProviderAttribute.AMAZON_USER_ID = new ProviderAttribute('user_id');
/**
 * The email attribute provided by Amazon.
 *
 * @stability stable
 */
ProviderAttribute.AMAZON_EMAIL = new ProviderAttribute('email');
/**
 * The name attribute provided by Amazon.
 *
 * @stability stable
 */
ProviderAttribute.AMAZON_NAME = new ProviderAttribute('name');
/**
 * The postal code attribute provided by Amazon.
 *
 * @stability stable
 */
ProviderAttribute.AMAZON_POSTAL_CODE = new ProviderAttribute('postal_code');
/**
 * The user id attribute provided by Facebook.
 *
 * @stability stable
 */
ProviderAttribute.FACEBOOK_ID = new ProviderAttribute('id');
/**
 * The birthday attribute provided by Facebook.
 *
 * @stability stable
 */
ProviderAttribute.FACEBOOK_BIRTHDAY = new ProviderAttribute('birthday');
/**
 * The email attribute provided by Facebook.
 *
 * @stability stable
 */
ProviderAttribute.FACEBOOK_EMAIL = new ProviderAttribute('email');
/**
 * The name attribute provided by Facebook.
 *
 * @stability stable
 */
ProviderAttribute.FACEBOOK_NAME = new ProviderAttribute('name');
/**
 * The first name attribute provided by Facebook.
 *
 * @stability stable
 */
ProviderAttribute.FACEBOOK_FIRST_NAME = new ProviderAttribute('first_name');
/**
 * The last name attribute provided by Facebook.
 *
 * @stability stable
 */
ProviderAttribute.FACEBOOK_LAST_NAME = new ProviderAttribute('last_name');
/**
 * The middle name attribute provided by Facebook.
 *
 * @stability stable
 */
ProviderAttribute.FACEBOOK_MIDDLE_NAME = new ProviderAttribute('middle_name');
/**
 * The gender attribute provided by Facebook.
 *
 * @stability stable
 */
ProviderAttribute.FACEBOOK_GENDER = new ProviderAttribute('gender');
/**
 * The locale attribute provided by Facebook.
 *
 * @stability stable
 */
ProviderAttribute.FACEBOOK_LOCALE = new ProviderAttribute('locale');
/**
 * The name attribute provided by Google.
 *
 * @stability stable
 */
ProviderAttribute.GOOGLE_NAMES = new ProviderAttribute('names');
/**
 * The gender attribute provided by Google.
 *
 * @stability stable
 */
ProviderAttribute.GOOGLE_GENDER = new ProviderAttribute('gender');
/**
 * The birthday attribute provided by Google.
 *
 * @stability stable
 */
ProviderAttribute.GOOGLE_BIRTHDAYS = new ProviderAttribute('birthdays');
/**
 * The phone number attribute provided by Google.
 *
 * @stability stable
 */
ProviderAttribute.GOOGLE_PHONE_NUMBERS = new ProviderAttribute('phoneNumbers');
/**
 * The email attribute provided by Google.
 *
 * @stability stable
 */
ProviderAttribute.GOOGLE_EMAIL = new ProviderAttribute('email');
/**
 * The name attribute provided by Google.
 *
 * @stability stable
 */
ProviderAttribute.GOOGLE_NAME = new ProviderAttribute('name');
/**
 * The picture attribute provided by Google.
 *
 * @stability stable
 */
ProviderAttribute.GOOGLE_PICTURE = new ProviderAttribute('picture');
/**
 * The given name attribute provided by Google.
 *
 * @stability stable
 */
ProviderAttribute.GOOGLE_GIVEN_NAME = new ProviderAttribute('given_name');
/**
 * The family name attribute provided by Google.
 *
 * @stability stable
 */
ProviderAttribute.GOOGLE_FAMILY_NAME = new ProviderAttribute('family_name');
//# sourceMappingURL=data:application/json;base64,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