#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['yaqd_microchip']

package_data = \
{'': ['*']}

install_requires = \
['yaqd-core>=2021.3.0', 'smbus2']

extras_require = \
{'dev': ['black', 'pre-commit']}

entry_points = \
{'console_scripts': ['yaqd-mcp3428 = yaqd_microchip._mcp3428:MCP3428.main',
                     'yaqd-mcp9600 = yaqd_microchip._mcp9600:MCP9600.main']}

setup(name='yaqd-microchip',
      version='2021.3.0',
      description='yaq daemons for interfacing with Microchip integrated circuits',
      author='Blaise Thompson',
      author_email='blaise@untzag.com',
      url='https://yaq.fyi/',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.7',
     )
