import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/helpers-internal';
/**
 * Properties for defining a `CfnPlaybackConfiguration`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html
 */
export interface CfnPlaybackConfigurationProps {
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.AdDecisionServerUrl`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-addecisionserverurl
     */
    readonly adDecisionServerUrl: string;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.Name`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-name
     */
    readonly name: string;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.VideoContentSourceUrl`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-videocontentsourceurl
     */
    readonly videoContentSourceUrl: string;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.AvailSuppression`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-availsuppression
     */
    readonly availSuppression?: CfnPlaybackConfiguration.AvailSuppressionProperty | cdk.IResolvable;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.Bumper`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-bumper
     */
    readonly bumper?: CfnPlaybackConfiguration.BumperProperty | cdk.IResolvable;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.CdnConfiguration`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-cdnconfiguration
     */
    readonly cdnConfiguration?: CfnPlaybackConfiguration.CdnConfigurationProperty | cdk.IResolvable;
    /**
     * The player parameters and aliases used as dynamic variables during session initialization. For more information, see [Domain Variables](https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domain.html) .
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-configurationaliases
     */
    readonly configurationAliases?: {
        [key: string]: (any | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.DashConfiguration`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-dashconfiguration
     */
    readonly dashConfiguration?: CfnPlaybackConfiguration.DashConfigurationProperty | cdk.IResolvable;
    /**
     * The configuration for HLS content.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-hlsconfiguration
     */
    readonly hlsConfiguration?: CfnPlaybackConfiguration.HlsConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.LivePreRollConfiguration`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-liveprerollconfiguration
     */
    readonly livePreRollConfiguration?: CfnPlaybackConfiguration.LivePreRollConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.ManifestProcessingRules`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-manifestprocessingrules
     */
    readonly manifestProcessingRules?: CfnPlaybackConfiguration.ManifestProcessingRulesProperty | cdk.IResolvable;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.PersonalizationThresholdSeconds`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-personalizationthresholdseconds
     */
    readonly personalizationThresholdSeconds?: number;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.SlateAdUrl`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-slateadurl
     */
    readonly slateAdUrl?: string;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.TranscodeProfileName`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-transcodeprofilename
     */
    readonly transcodeProfileName?: string;
}
/**
 * A CloudFormation `AWS::MediaTailor::PlaybackConfiguration`
 *
 * Adds a new playback configuration to AWS Elemental MediaTailor .
 *
 * @cloudformationResource AWS::MediaTailor::PlaybackConfiguration
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html
 */
export declare class CfnPlaybackConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaTailor::PlaybackConfiguration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPlaybackConfiguration;
    /**
     * The URL generated by MediaTailor to initiate a playback session. The session uses server-side reporting. This setting is ignored in PUT operations.
     * @cloudformationAttribute DashConfiguration.ManifestEndpointPrefix
     */
    readonly attrDashConfigurationManifestEndpointPrefix: string;
    /**
     * The URL that is used to initiate a playback session for devices that support Apple HLS. The session uses server-side reporting.
     * @cloudformationAttribute HlsConfiguration.ManifestEndpointPrefix
     */
    readonly attrHlsConfigurationManifestEndpointPrefix: string;
    /**
     * The Amazon Resource Name (ARN) for the playback configuration.
     * @cloudformationAttribute PlaybackConfigurationArn
     */
    readonly attrPlaybackConfigurationArn: string;
    /**
     * The URL that the player accesses to get a manifest from MediaTailor . This session will use server-side reporting.
     * @cloudformationAttribute PlaybackEndpointPrefix
     */
    readonly attrPlaybackEndpointPrefix: string;
    /**
     * The URL that the player uses to initialize a session that uses client-side reporting.
     * @cloudformationAttribute SessionInitializationEndpointPrefix
     */
    readonly attrSessionInitializationEndpointPrefix: string;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.AdDecisionServerUrl`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-addecisionserverurl
     */
    adDecisionServerUrl: string;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.Name`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-name
     */
    name: string;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.VideoContentSourceUrl`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-videocontentsourceurl
     */
    videoContentSourceUrl: string;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.AvailSuppression`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-availsuppression
     */
    availSuppression: CfnPlaybackConfiguration.AvailSuppressionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.Bumper`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-bumper
     */
    bumper: CfnPlaybackConfiguration.BumperProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.CdnConfiguration`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-cdnconfiguration
     */
    cdnConfiguration: CfnPlaybackConfiguration.CdnConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * The player parameters and aliases used as dynamic variables during session initialization. For more information, see [Domain Variables](https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domain.html) .
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-configurationaliases
     */
    configurationAliases: {
        [key: string]: (any | cdk.IResolvable);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.DashConfiguration`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-dashconfiguration
     */
    dashConfiguration: CfnPlaybackConfiguration.DashConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * The configuration for HLS content.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-hlsconfiguration
     */
    hlsConfiguration: CfnPlaybackConfiguration.HlsConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.LivePreRollConfiguration`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-liveprerollconfiguration
     */
    livePreRollConfiguration: CfnPlaybackConfiguration.LivePreRollConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.ManifestProcessingRules`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-manifestprocessingrules
     */
    manifestProcessingRules: CfnPlaybackConfiguration.ManifestProcessingRulesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.PersonalizationThresholdSeconds`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-personalizationthresholdseconds
     */
    personalizationThresholdSeconds: number | undefined;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.SlateAdUrl`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-slateadurl
     */
    slateAdUrl: string | undefined;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::MediaTailor::PlaybackConfiguration.TranscodeProfileName`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-transcodeprofilename
     */
    transcodeProfileName: string | undefined;
    /**
     * Create a new `AWS::MediaTailor::PlaybackConfiguration`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPlaybackConfigurationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnPlaybackConfiguration {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-admarkerpassthrough.html
     */
    interface AdMarkerPassthroughProperty {
        /**
         * `CfnPlaybackConfiguration.AdMarkerPassthroughProperty.Enabled`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-admarkerpassthrough.html#cfn-mediatailor-playbackconfiguration-admarkerpassthrough-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnPlaybackConfiguration {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-availsuppression.html
     */
    interface AvailSuppressionProperty {
        /**
         * `CfnPlaybackConfiguration.AvailSuppressionProperty.Mode`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-availsuppression.html#cfn-mediatailor-playbackconfiguration-availsuppression-mode
         */
        readonly mode?: string;
        /**
         * `CfnPlaybackConfiguration.AvailSuppressionProperty.Value`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-availsuppression.html#cfn-mediatailor-playbackconfiguration-availsuppression-value
         */
        readonly value?: string;
    }
}
export declare namespace CfnPlaybackConfiguration {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-bumper.html
     */
    interface BumperProperty {
        /**
         * `CfnPlaybackConfiguration.BumperProperty.EndUrl`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-bumper.html#cfn-mediatailor-playbackconfiguration-bumper-endurl
         */
        readonly endUrl?: string;
        /**
         * `CfnPlaybackConfiguration.BumperProperty.StartUrl`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-bumper.html#cfn-mediatailor-playbackconfiguration-bumper-starturl
         */
        readonly startUrl?: string;
    }
}
export declare namespace CfnPlaybackConfiguration {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-cdnconfiguration.html
     */
    interface CdnConfigurationProperty {
        /**
         * `CfnPlaybackConfiguration.CdnConfigurationProperty.AdSegmentUrlPrefix`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-cdnconfiguration.html#cfn-mediatailor-playbackconfiguration-cdnconfiguration-adsegmenturlprefix
         */
        readonly adSegmentUrlPrefix?: string;
        /**
         * `CfnPlaybackConfiguration.CdnConfigurationProperty.ContentSegmentUrlPrefix`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-cdnconfiguration.html#cfn-mediatailor-playbackconfiguration-cdnconfiguration-contentsegmenturlprefix
         */
        readonly contentSegmentUrlPrefix?: string;
    }
}
export declare namespace CfnPlaybackConfiguration {
    /**
     * The configuration for DASH content.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-dashconfiguration.html
     */
    interface DashConfigurationProperty {
        /**
         * The URL generated by MediaTailor to initiate a playback session. The session uses server-side reporting. This setting is ignored in PUT operations.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-dashconfiguration.html#cfn-mediatailor-playbackconfiguration-dashconfiguration-manifestendpointprefix
         */
        readonly manifestEndpointPrefix?: string;
        /**
         * The setting that controls whether MediaTailor includes the Location tag in DASH manifests. MediaTailor populates the Location tag with the URL for manifest update requests, to be used by players that don't support sticky redirects. Disable this if you have CDN routing rules set up for accessing MediaTailor manifests, and you are either using client-side reporting or your players support sticky HTTP redirects. Valid values are `DISABLED` and `EMT_DEFAULT` . The `EMT_DEFAULT` setting enables the inclusion of the tag and is the default value.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-dashconfiguration.html#cfn-mediatailor-playbackconfiguration-dashconfiguration-mpdlocation
         */
        readonly mpdLocation?: string;
        /**
         * The setting that controls whether MediaTailor handles manifests from the origin server as multi-period manifests or single-period manifests. If your origin server produces single-period manifests, set this to `SINGLE_PERIOD` . The default setting is `MULTI_PERIOD` . For multi-period manifests, omit this setting or set it to `MULTI_PERIOD` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-dashconfiguration.html#cfn-mediatailor-playbackconfiguration-dashconfiguration-originmanifesttype
         */
        readonly originManifestType?: string;
    }
}
export declare namespace CfnPlaybackConfiguration {
    /**
     * The configuration for HLS content.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-hlsconfiguration.html
     */
    interface HlsConfigurationProperty {
        /**
         * The URL that is used to initiate a playback session for devices that support Apple HLS. The session uses server-side reporting.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-hlsconfiguration.html#cfn-mediatailor-playbackconfiguration-hlsconfiguration-manifestendpointprefix
         */
        readonly manifestEndpointPrefix?: string;
    }
}
export declare namespace CfnPlaybackConfiguration {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-liveprerollconfiguration.html
     */
    interface LivePreRollConfigurationProperty {
        /**
         * `CfnPlaybackConfiguration.LivePreRollConfigurationProperty.AdDecisionServerUrl`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-liveprerollconfiguration.html#cfn-mediatailor-playbackconfiguration-liveprerollconfiguration-addecisionserverurl
         */
        readonly adDecisionServerUrl?: string;
        /**
         * `CfnPlaybackConfiguration.LivePreRollConfigurationProperty.MaxDurationSeconds`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-liveprerollconfiguration.html#cfn-mediatailor-playbackconfiguration-liveprerollconfiguration-maxdurationseconds
         */
        readonly maxDurationSeconds?: number;
    }
}
export declare namespace CfnPlaybackConfiguration {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-manifestprocessingrules.html
     */
    interface ManifestProcessingRulesProperty {
        /**
         * `CfnPlaybackConfiguration.ManifestProcessingRulesProperty.AdMarkerPassthrough`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-manifestprocessingrules.html#cfn-mediatailor-playbackconfiguration-manifestprocessingrules-admarkerpassthrough
         */
        readonly adMarkerPassthrough?: CfnPlaybackConfiguration.AdMarkerPassthroughProperty | cdk.IResolvable;
    }
}
