"use strict";
// Copyright 2012-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaTailorMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class MediaTailorMetrics {
    static adDecisionServerAdsSum(dimensions) {
        return {
            namespace: 'AWS/MediaTailor',
            metricName: 'AdDecisionServer.Ads',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static adDecisionServerDurationAverage(dimensions) {
        return {
            namespace: 'AWS/MediaTailor',
            metricName: 'AdDecisionServer.Duration',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static adDecisionServerErrorsSum(dimensions) {
        return {
            namespace: 'AWS/MediaTailor',
            metricName: 'AdDecisionServer.Errors',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static adDecisionServerFillRateSum(dimensions) {
        return {
            namespace: 'AWS/MediaTailor',
            metricName: 'AdDecisionServer.FillRate',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static adDecisionServerLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/MediaTailor',
            metricName: 'AdDecisionServer.Latency',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static adNotReadySum(dimensions) {
        return {
            namespace: 'AWS/MediaTailor',
            metricName: 'AdNotReady',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static availDurationSum(dimensions) {
        return {
            namespace: 'AWS/MediaTailor',
            metricName: 'Avail.Duration',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static availFillRateSum(dimensions) {
        return {
            namespace: 'AWS/MediaTailor',
            metricName: 'Avail.FillRate',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static availFilledDurationAverage(dimensions) {
        return {
            namespace: 'AWS/MediaTailor',
            metricName: 'Avail.FilledDuration',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static getManifestErrorsSum(dimensions) {
        return {
            namespace: 'AWS/MediaTailor',
            metricName: 'GetManifest.Errors',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static getManifestLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/MediaTailor',
            metricName: 'GetManifest.Latency',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static originErrorsSum(dimensions) {
        return {
            namespace: 'AWS/MediaTailor',
            metricName: 'Origin.Errors',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static originLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/MediaTailor',
            metricName: 'Origin.Latency',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
}
exports.MediaTailorMetrics = MediaTailorMetrics;
//# sourceMappingURL=data:application/json;base64,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