# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class WsWorkflowExecution(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'business_state': 'str',
        'content_exception': 'str',
        'current_item_display_name': 'str',
        'end_date': 'datetime',
        'id': 'str',
        'input_parameters': 'list[WsParameter]',
        'name': 'str',
        'output_parameters': 'list[WsParameter]',
        'relations': 'Relations',
        'start_date': 'datetime',
        'started_by': 'str',
        'state': 'ExecutionState'
    }

    attribute_map = {
        'business_state': 'businessState',
        'content_exception': 'contentException',
        'current_item_display_name': 'currentItemDisplayName',
        'end_date': 'endDate',
        'id': 'id',
        'input_parameters': 'inputParameters',
        'name': 'name',
        'output_parameters': 'outputParameters',
        'relations': 'relations',
        'start_date': 'startDate',
        'started_by': 'startedBy',
        'state': 'state'
    }

    def __init__(self, business_state=None, content_exception=None, current_item_display_name=None, end_date=None, id=None, input_parameters=None, name=None, output_parameters=None, relations=None, start_date=None, started_by=None, state=None):
        """
        WsWorkflowExecution - a model defined in Swagger
        """

        self._business_state = None
        self._content_exception = None
        self._current_item_display_name = None
        self._end_date = None
        self._id = None
        self._input_parameters = None
        self._name = None
        self._output_parameters = None
        self._relations = None
        self._start_date = None
        self._started_by = None
        self._state = None

        if business_state is not None:
          self.business_state = business_state
        if content_exception is not None:
          self.content_exception = content_exception
        if current_item_display_name is not None:
          self.current_item_display_name = current_item_display_name
        if end_date is not None:
          self.end_date = end_date
        if id is not None:
          self.id = id
        if input_parameters is not None:
          self.input_parameters = input_parameters
        if name is not None:
          self.name = name
        if output_parameters is not None:
          self.output_parameters = output_parameters
        if relations is not None:
          self.relations = relations
        if start_date is not None:
          self.start_date = start_date
        if started_by is not None:
          self.started_by = started_by
        if state is not None:
          self.state = state

    @property
    def business_state(self):
        """
        Gets the business_state of this WsWorkflowExecution.

        :return: The business_state of this WsWorkflowExecution.
        :rtype: str
        """
        return self._business_state

    @business_state.setter
    def business_state(self, business_state):
        """
        Sets the business_state of this WsWorkflowExecution.

        :param business_state: The business_state of this WsWorkflowExecution.
        :type: str
        """

        self._business_state = business_state

    @property
    def content_exception(self):
        """
        Gets the content_exception of this WsWorkflowExecution.

        :return: The content_exception of this WsWorkflowExecution.
        :rtype: str
        """
        return self._content_exception

    @content_exception.setter
    def content_exception(self, content_exception):
        """
        Sets the content_exception of this WsWorkflowExecution.

        :param content_exception: The content_exception of this WsWorkflowExecution.
        :type: str
        """

        self._content_exception = content_exception

    @property
    def current_item_display_name(self):
        """
        Gets the current_item_display_name of this WsWorkflowExecution.

        :return: The current_item_display_name of this WsWorkflowExecution.
        :rtype: str
        """
        return self._current_item_display_name

    @current_item_display_name.setter
    def current_item_display_name(self, current_item_display_name):
        """
        Sets the current_item_display_name of this WsWorkflowExecution.

        :param current_item_display_name: The current_item_display_name of this WsWorkflowExecution.
        :type: str
        """

        self._current_item_display_name = current_item_display_name

    @property
    def end_date(self):
        """
        Gets the end_date of this WsWorkflowExecution.

        :return: The end_date of this WsWorkflowExecution.
        :rtype: datetime
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """
        Sets the end_date of this WsWorkflowExecution.

        :param end_date: The end_date of this WsWorkflowExecution.
        :type: datetime
        """

        self._end_date = end_date

    @property
    def id(self):
        """
        Gets the id of this WsWorkflowExecution.

        :return: The id of this WsWorkflowExecution.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this WsWorkflowExecution.

        :param id: The id of this WsWorkflowExecution.
        :type: str
        """

        self._id = id

    @property
    def input_parameters(self):
        """
        Gets the input_parameters of this WsWorkflowExecution.

        :return: The input_parameters of this WsWorkflowExecution.
        :rtype: list[WsParameter]
        """
        return self._input_parameters

    @input_parameters.setter
    def input_parameters(self, input_parameters):
        """
        Sets the input_parameters of this WsWorkflowExecution.

        :param input_parameters: The input_parameters of this WsWorkflowExecution.
        :type: list[WsParameter]
        """

        self._input_parameters = input_parameters

    @property
    def name(self):
        """
        Gets the name of this WsWorkflowExecution.

        :return: The name of this WsWorkflowExecution.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this WsWorkflowExecution.

        :param name: The name of this WsWorkflowExecution.
        :type: str
        """

        self._name = name

    @property
    def output_parameters(self):
        """
        Gets the output_parameters of this WsWorkflowExecution.

        :return: The output_parameters of this WsWorkflowExecution.
        :rtype: list[WsParameter]
        """
        return self._output_parameters

    @output_parameters.setter
    def output_parameters(self, output_parameters):
        """
        Sets the output_parameters of this WsWorkflowExecution.

        :param output_parameters: The output_parameters of this WsWorkflowExecution.
        :type: list[WsParameter]
        """

        self._output_parameters = output_parameters

    @property
    def relations(self):
        """
        Gets the relations of this WsWorkflowExecution.

        :return: The relations of this WsWorkflowExecution.
        :rtype: Relations
        """
        return self._relations

    @relations.setter
    def relations(self, relations):
        """
        Sets the relations of this WsWorkflowExecution.

        :param relations: The relations of this WsWorkflowExecution.
        :type: Relations
        """

        self._relations = relations

    @property
    def start_date(self):
        """
        Gets the start_date of this WsWorkflowExecution.

        :return: The start_date of this WsWorkflowExecution.
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """
        Sets the start_date of this WsWorkflowExecution.

        :param start_date: The start_date of this WsWorkflowExecution.
        :type: datetime
        """

        self._start_date = start_date

    @property
    def started_by(self):
        """
        Gets the started_by of this WsWorkflowExecution.

        :return: The started_by of this WsWorkflowExecution.
        :rtype: str
        """
        return self._started_by

    @started_by.setter
    def started_by(self, started_by):
        """
        Sets the started_by of this WsWorkflowExecution.

        :param started_by: The started_by of this WsWorkflowExecution.
        :type: str
        """

        self._started_by = started_by

    @property
    def state(self):
        """
        Gets the state of this WsWorkflowExecution.

        :return: The state of this WsWorkflowExecution.
        :rtype: ExecutionState
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this WsWorkflowExecution.

        :param state: The state of this WsWorkflowExecution.
        :type: ExecutionState
        """

        self._state = state

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, WsWorkflowExecution):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
