# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class VmCriteriaRule(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'attribute_type': 'str',
        'attribute_value': 'str',
        'operator': 'str'
    }

    attribute_map = {
        'attribute_type': 'attributeType',
        'attribute_value': 'attributeValue',
        'operator': 'operator'
    }

    def __init__(self, attribute_type=None, attribute_value=None, operator=None):
        """
        VmCriteriaRule - a model defined in Swagger
        """

        self._attribute_type = None
        self._attribute_value = None
        self._operator = None

        self.attribute_type = attribute_type
        self.attribute_value = attribute_value
        self.operator = operator

    @property
    def attribute_type(self):
        """
        Gets the attribute_type of this VmCriteriaRule.
        The attribute type of a VM used for VM matching.  Below are supported types: <ul> <li> VM_TAG - Match the VM based on the tags associated with that VM. <li> VM_NAME - Match the VM based on the name of the VM. Only CONTAINS and STARTS_WITH operators are supported for this type. </ul> 

        :return: The attribute_type of this VmCriteriaRule.
        :rtype: str
        """
        return self._attribute_type

    @attribute_type.setter
    def attribute_type(self, attribute_type):
        """
        Sets the attribute_type of this VmCriteriaRule.
        The attribute type of a VM used for VM matching.  Below are supported types: <ul> <li> VM_TAG - Match the VM based on the tags associated with that VM. <li> VM_NAME - Match the VM based on the name of the VM. Only CONTAINS and STARTS_WITH operators are supported for this type. </ul> 

        :param attribute_type: The attribute_type of this VmCriteriaRule.
        :type: str
        """
        if attribute_type is None:
            raise ValueError("Invalid value for `attribute_type`, must not be `None`")

        self._attribute_type = attribute_type

    @property
    def attribute_value(self):
        """
        Gets the attribute_value of this VmCriteriaRule.
        The attribute value that is used to determine if a VM's attribute value matches the rule. Example: if the attribute type is VM_NAME, user should set this value to the name of the VM to match with. 

        :return: The attribute_value of this VmCriteriaRule.
        :rtype: str
        """
        return self._attribute_value

    @attribute_value.setter
    def attribute_value(self, attribute_value):
        """
        Sets the attribute_value of this VmCriteriaRule.
        The attribute value that is used to determine if a VM's attribute value matches the rule. Example: if the attribute type is VM_NAME, user should set this value to the name of the VM to match with. 

        :param attribute_value: The attribute_value of this VmCriteriaRule.
        :type: str
        """
        if attribute_value is None:
            raise ValueError("Invalid value for `attribute_value`, must not be `None`")

        self._attribute_value = attribute_value

    @property
    def operator(self):
        """
        Gets the operator of this VmCriteriaRule.
        The operator to perform to determine whether the rule's attribute value matches a VM's attribute value.  Example: if the attribute type is VM_NAME, user can set this operator to determine whether a VM's name must be an exact match or starts with that name. Below are supported types: <ul> <li> EQUALS - Match occurs if the VM's attribute value is exactly the same as the rule's attribute value. <li> CONTAINS - Match occurs if the VM's attribute value is contains the rule's attribute value. <li> STARTS_WITH - Match occurs if the VM's attribute value starts with the rule's attribute value. <li> ENDS_WITH - Match occurs if the VM's attribute value ends with the rule's attribute value. </ul> 

        :return: The operator of this VmCriteriaRule.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator):
        """
        Sets the operator of this VmCriteriaRule.
        The operator to perform to determine whether the rule's attribute value matches a VM's attribute value.  Example: if the attribute type is VM_NAME, user can set this operator to determine whether a VM's name must be an exact match or starts with that name. Below are supported types: <ul> <li> EQUALS - Match occurs if the VM's attribute value is exactly the same as the rule's attribute value. <li> CONTAINS - Match occurs if the VM's attribute value is contains the rule's attribute value. <li> STARTS_WITH - Match occurs if the VM's attribute value starts with the rule's attribute value. <li> ENDS_WITH - Match occurs if the VM's attribute value ends with the rule's attribute value. </ul> 

        :param operator: The operator of this VmCriteriaRule.
        :type: str
        """
        if operator is None:
            raise ValueError("Invalid value for `operator`, must not be `None`")

        self._operator = operator

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, VmCriteriaRule):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
