# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class VdcComputePolicy2(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'description': 'str',
        'policy_type': 'str',
        'name': 'str',
        'pvdc_compute_policy': 'EntityReference',
        'compatible_vdc_types': 'list[str]',
        'is_sizing_only': 'bool',
        'pvdc_id': 'str',
        'is_auto_generated': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'description': 'description',
        'policy_type': 'policyType',
        'name': 'name',
        'pvdc_compute_policy': 'pvdcComputePolicy',
        'compatible_vdc_types': 'compatibleVdcTypes',
        'is_sizing_only': 'isSizingOnly',
        'pvdc_id': 'pvdcId',
        'is_auto_generated': 'isAutoGenerated'
    }

    def __init__(self, id=None, description='A vDC compute policy.', policy_type=None, name=None, pvdc_compute_policy=None, compatible_vdc_types=None, is_sizing_only=None, pvdc_id=None, is_auto_generated=None):
        """
        VdcComputePolicy2 - a model defined in Swagger
        """

        self._id = None
        self._description = None
        self._policy_type = None
        self._name = None
        self._pvdc_compute_policy = None
        self._compatible_vdc_types = None
        self._is_sizing_only = None
        self._pvdc_id = None
        self._is_auto_generated = None

        if id is not None:
          self.id = id
        if description is not None:
          self.description = description
        self.policy_type = policy_type
        self.name = name
        if pvdc_compute_policy is not None:
          self.pvdc_compute_policy = pvdc_compute_policy
        if compatible_vdc_types is not None:
          self.compatible_vdc_types = compatible_vdc_types
        if is_sizing_only is not None:
          self.is_sizing_only = is_sizing_only
        if pvdc_id is not None:
          self.pvdc_id = pvdc_id
        if is_auto_generated is not None:
          self.is_auto_generated = is_auto_generated

    @property
    def id(self):
        """
        Gets the id of this VdcComputePolicy2.
        UUID for vDC compute policy. This is immutable. 

        :return: The id of this VdcComputePolicy2.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this VdcComputePolicy2.
        UUID for vDC compute policy. This is immutable. 

        :param id: The id of this VdcComputePolicy2.
        :type: str
        """

        self._id = id

    @property
    def description(self):
        """
        Gets the description of this VdcComputePolicy2.

        :return: The description of this VdcComputePolicy2.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this VdcComputePolicy2.

        :param description: The description of this VdcComputePolicy2.
        :type: str
        """
        if description is not None and len(description) > 256:
            raise ValueError("Invalid value for `description`, length must be less than or equal to `256`")
        if description is not None and len(description) < 1:
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `1`")

        self._description = description

    @property
    def policy_type(self):
        """
        Gets the policy_type of this VdcComputePolicy2.
        The discriminator type is used to differentiate among various sub policy types. 

        :return: The policy_type of this VdcComputePolicy2.
        :rtype: str
        """
        return self._policy_type

    @policy_type.setter
    def policy_type(self, policy_type):
        """
        Sets the policy_type of this VdcComputePolicy2.
        The discriminator type is used to differentiate among various sub policy types. 

        :param policy_type: The policy_type of this VdcComputePolicy2.
        :type: str
        """
        if policy_type is None:
            raise ValueError("Invalid value for `policy_type`, must not be `None`")

        self._policy_type = policy_type

    @property
    def name(self):
        """
        Gets the name of this VdcComputePolicy2.
        Display name. 

        :return: The name of this VdcComputePolicy2.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this VdcComputePolicy2.
        Display name. 

        :param name: The name of this VdcComputePolicy2.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        if name is not None and len(name) > 128:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `128`")
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")

        self._name = name

    @property
    def pvdc_compute_policy(self):
        """
        Gets the pvdc_compute_policy of this VdcComputePolicy2.
        This field cannot be updated and is a read-only field in the client after creation. 

        :return: The pvdc_compute_policy of this VdcComputePolicy2.
        :rtype: EntityReference
        """
        return self._pvdc_compute_policy

    @pvdc_compute_policy.setter
    def pvdc_compute_policy(self, pvdc_compute_policy):
        """
        Sets the pvdc_compute_policy of this VdcComputePolicy2.
        This field cannot be updated and is a read-only field in the client after creation. 

        :param pvdc_compute_policy: The pvdc_compute_policy of this VdcComputePolicy2.
        :type: EntityReference
        """

        self._pvdc_compute_policy = pvdc_compute_policy

    @property
    def compatible_vdc_types(self):
        """
        Gets the compatible_vdc_types of this VdcComputePolicy2.
        A list of read-only compatible vDC types for this policy.

        :return: The compatible_vdc_types of this VdcComputePolicy2.
        :rtype: list[str]
        """
        return self._compatible_vdc_types

    @compatible_vdc_types.setter
    def compatible_vdc_types(self, compatible_vdc_types):
        """
        Sets the compatible_vdc_types of this VdcComputePolicy2.
        A list of read-only compatible vDC types for this policy.

        :param compatible_vdc_types: The compatible_vdc_types of this VdcComputePolicy2.
        :type: list[str]
        """

        self._compatible_vdc_types = compatible_vdc_types

    @property
    def is_sizing_only(self):
        """
        Gets the is_sizing_only of this VdcComputePolicy2.
        This field cannot be updated and is a read-only field in the client after creation. It defines whether the policy is SIZING_ONLY or if it also contains affinity information. 

        :return: The is_sizing_only of this VdcComputePolicy2.
        :rtype: bool
        """
        return self._is_sizing_only

    @is_sizing_only.setter
    def is_sizing_only(self, is_sizing_only):
        """
        Sets the is_sizing_only of this VdcComputePolicy2.
        This field cannot be updated and is a read-only field in the client after creation. It defines whether the policy is SIZING_ONLY or if it also contains affinity information. 

        :param is_sizing_only: The is_sizing_only of this VdcComputePolicy2.
        :type: bool
        """

        self._is_sizing_only = is_sizing_only

    @property
    def pvdc_id(self):
        """
        Gets the pvdc_id of this VdcComputePolicy2.
        URN for Provider vDC. 

        :return: The pvdc_id of this VdcComputePolicy2.
        :rtype: str
        """
        return self._pvdc_id

    @pvdc_id.setter
    def pvdc_id(self, pvdc_id):
        """
        Sets the pvdc_id of this VdcComputePolicy2.
        URN for Provider vDC. 

        :param pvdc_id: The pvdc_id of this VdcComputePolicy2.
        :type: str
        """

        self._pvdc_id = pvdc_id

    @property
    def is_auto_generated(self):
        """
        Gets the is_auto_generated of this VdcComputePolicy2.
        It is a read-only field. It indicates whether the policy is auto-generated. 

        :return: The is_auto_generated of this VdcComputePolicy2.
        :rtype: bool
        """
        return self._is_auto_generated

    @is_auto_generated.setter
    def is_auto_generated(self, is_auto_generated):
        """
        Sets the is_auto_generated of this VdcComputePolicy2.
        It is a read-only field. It indicates whether the policy is auto-generated. 

        :param is_auto_generated: The is_auto_generated of this VdcComputePolicy2.
        :type: bool
        """

        self._is_auto_generated = is_auto_generated

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, VdcComputePolicy2):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
