# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class VCenterServerMetrics(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'vc_id': 'str',
        'clusters_count': 'int',
        'total_vm_count': 'int',
        'powered_on_vm_count': 'int',
        'total_mem_mb': 'int',
        'reserved_mem_mb': 'int',
        'demanded_mem_mb': 'int',
        'total_cpu_mhz': 'int',
        'reserved_cpu_mhz': 'int',
        'demanded_cpu_mhz': 'int',
        'total_storage_mb': 'int',
        'free_storage_mb': 'int',
        'uncommitted_storage_mb': 'int'
    }

    attribute_map = {
        'vc_id': 'vcId',
        'clusters_count': 'clustersCount',
        'total_vm_count': 'totalVmCount',
        'powered_on_vm_count': 'poweredOnVmCount',
        'total_mem_mb': 'totalMemMb',
        'reserved_mem_mb': 'reservedMemMb',
        'demanded_mem_mb': 'demandedMemMb',
        'total_cpu_mhz': 'totalCpuMhz',
        'reserved_cpu_mhz': 'reservedCpuMhz',
        'demanded_cpu_mhz': 'demandedCpuMhz',
        'total_storage_mb': 'totalStorageMb',
        'free_storage_mb': 'freeStorageMb',
        'uncommitted_storage_mb': 'uncommittedStorageMb'
    }

    def __init__(self, vc_id=None, clusters_count=None, total_vm_count=None, powered_on_vm_count=None, total_mem_mb=None, reserved_mem_mb=None, demanded_mem_mb=None, total_cpu_mhz=None, reserved_cpu_mhz=None, demanded_cpu_mhz=None, total_storage_mb=None, free_storage_mb=None, uncommitted_storage_mb=None):
        """
        VCenterServerMetrics - a model defined in Swagger
        """

        self._vc_id = None
        self._clusters_count = None
        self._total_vm_count = None
        self._powered_on_vm_count = None
        self._total_mem_mb = None
        self._reserved_mem_mb = None
        self._demanded_mem_mb = None
        self._total_cpu_mhz = None
        self._reserved_cpu_mhz = None
        self._demanded_cpu_mhz = None
        self._total_storage_mb = None
        self._free_storage_mb = None
        self._uncommitted_storage_mb = None

        if vc_id is not None:
          self.vc_id = vc_id
        if clusters_count is not None:
          self.clusters_count = clusters_count
        if total_vm_count is not None:
          self.total_vm_count = total_vm_count
        if powered_on_vm_count is not None:
          self.powered_on_vm_count = powered_on_vm_count
        if total_mem_mb is not None:
          self.total_mem_mb = total_mem_mb
        if reserved_mem_mb is not None:
          self.reserved_mem_mb = reserved_mem_mb
        if demanded_mem_mb is not None:
          self.demanded_mem_mb = demanded_mem_mb
        if total_cpu_mhz is not None:
          self.total_cpu_mhz = total_cpu_mhz
        if reserved_cpu_mhz is not None:
          self.reserved_cpu_mhz = reserved_cpu_mhz
        if demanded_cpu_mhz is not None:
          self.demanded_cpu_mhz = demanded_cpu_mhz
        if total_storage_mb is not None:
          self.total_storage_mb = total_storage_mb
        if free_storage_mb is not None:
          self.free_storage_mb = free_storage_mb
        if uncommitted_storage_mb is not None:
          self.uncommitted_storage_mb = uncommitted_storage_mb

    @property
    def vc_id(self):
        """
        Gets the vc_id of this VCenterServerMetrics.
        URN of the associated vCenter server.

        :return: The vc_id of this VCenterServerMetrics.
        :rtype: str
        """
        return self._vc_id

    @vc_id.setter
    def vc_id(self, vc_id):
        """
        Sets the vc_id of this VCenterServerMetrics.
        URN of the associated vCenter server.

        :param vc_id: The vc_id of this VCenterServerMetrics.
        :type: str
        """

        self._vc_id = vc_id

    @property
    def clusters_count(self):
        """
        Gets the clusters_count of this VCenterServerMetrics.
        The number of clusters in this vCenter server.

        :return: The clusters_count of this VCenterServerMetrics.
        :rtype: int
        """
        return self._clusters_count

    @clusters_count.setter
    def clusters_count(self, clusters_count):
        """
        Sets the clusters_count of this VCenterServerMetrics.
        The number of clusters in this vCenter server.

        :param clusters_count: The clusters_count of this VCenterServerMetrics.
        :type: int
        """

        self._clusters_count = clusters_count

    @property
    def total_vm_count(self):
        """
        Gets the total_vm_count of this VCenterServerMetrics.
        The number of VMs in this vCenter server.

        :return: The total_vm_count of this VCenterServerMetrics.
        :rtype: int
        """
        return self._total_vm_count

    @total_vm_count.setter
    def total_vm_count(self, total_vm_count):
        """
        Sets the total_vm_count of this VCenterServerMetrics.
        The number of VMs in this vCenter server.

        :param total_vm_count: The total_vm_count of this VCenterServerMetrics.
        :type: int
        """

        self._total_vm_count = total_vm_count

    @property
    def powered_on_vm_count(self):
        """
        Gets the powered_on_vm_count of this VCenterServerMetrics.
        The number of powered-on VMs in this vCenter server.

        :return: The powered_on_vm_count of this VCenterServerMetrics.
        :rtype: int
        """
        return self._powered_on_vm_count

    @powered_on_vm_count.setter
    def powered_on_vm_count(self, powered_on_vm_count):
        """
        Sets the powered_on_vm_count of this VCenterServerMetrics.
        The number of powered-on VMs in this vCenter server.

        :param powered_on_vm_count: The powered_on_vm_count of this VCenterServerMetrics.
        :type: int
        """

        self._powered_on_vm_count = powered_on_vm_count

    @property
    def total_mem_mb(self):
        """
        Gets the total_mem_mb of this VCenterServerMetrics.
        The total memory (in MB) in this vCenter server.

        :return: The total_mem_mb of this VCenterServerMetrics.
        :rtype: int
        """
        return self._total_mem_mb

    @total_mem_mb.setter
    def total_mem_mb(self, total_mem_mb):
        """
        Sets the total_mem_mb of this VCenterServerMetrics.
        The total memory (in MB) in this vCenter server.

        :param total_mem_mb: The total_mem_mb of this VCenterServerMetrics.
        :type: int
        """

        self._total_mem_mb = total_mem_mb

    @property
    def reserved_mem_mb(self):
        """
        Gets the reserved_mem_mb of this VCenterServerMetrics.
        The reserved memory (in MB) in this vCenter server.

        :return: The reserved_mem_mb of this VCenterServerMetrics.
        :rtype: int
        """
        return self._reserved_mem_mb

    @reserved_mem_mb.setter
    def reserved_mem_mb(self, reserved_mem_mb):
        """
        Sets the reserved_mem_mb of this VCenterServerMetrics.
        The reserved memory (in MB) in this vCenter server.

        :param reserved_mem_mb: The reserved_mem_mb of this VCenterServerMetrics.
        :type: int
        """

        self._reserved_mem_mb = reserved_mem_mb

    @property
    def demanded_mem_mb(self):
        """
        Gets the demanded_mem_mb of this VCenterServerMetrics.
        The demanded memory (in MB) in this vCenter server.

        :return: The demanded_mem_mb of this VCenterServerMetrics.
        :rtype: int
        """
        return self._demanded_mem_mb

    @demanded_mem_mb.setter
    def demanded_mem_mb(self, demanded_mem_mb):
        """
        Sets the demanded_mem_mb of this VCenterServerMetrics.
        The demanded memory (in MB) in this vCenter server.

        :param demanded_mem_mb: The demanded_mem_mb of this VCenterServerMetrics.
        :type: int
        """

        self._demanded_mem_mb = demanded_mem_mb

    @property
    def total_cpu_mhz(self):
        """
        Gets the total_cpu_mhz of this VCenterServerMetrics.
        The total CPU (in MHz) in this vCenter server.

        :return: The total_cpu_mhz of this VCenterServerMetrics.
        :rtype: int
        """
        return self._total_cpu_mhz

    @total_cpu_mhz.setter
    def total_cpu_mhz(self, total_cpu_mhz):
        """
        Sets the total_cpu_mhz of this VCenterServerMetrics.
        The total CPU (in MHz) in this vCenter server.

        :param total_cpu_mhz: The total_cpu_mhz of this VCenterServerMetrics.
        :type: int
        """

        self._total_cpu_mhz = total_cpu_mhz

    @property
    def reserved_cpu_mhz(self):
        """
        Gets the reserved_cpu_mhz of this VCenterServerMetrics.
        The reserved CPU (in MHz) in this vCenter server.

        :return: The reserved_cpu_mhz of this VCenterServerMetrics.
        :rtype: int
        """
        return self._reserved_cpu_mhz

    @reserved_cpu_mhz.setter
    def reserved_cpu_mhz(self, reserved_cpu_mhz):
        """
        Sets the reserved_cpu_mhz of this VCenterServerMetrics.
        The reserved CPU (in MHz) in this vCenter server.

        :param reserved_cpu_mhz: The reserved_cpu_mhz of this VCenterServerMetrics.
        :type: int
        """

        self._reserved_cpu_mhz = reserved_cpu_mhz

    @property
    def demanded_cpu_mhz(self):
        """
        Gets the demanded_cpu_mhz of this VCenterServerMetrics.
        The demanded CPU (in MHz) in this vCenter server.

        :return: The demanded_cpu_mhz of this VCenterServerMetrics.
        :rtype: int
        """
        return self._demanded_cpu_mhz

    @demanded_cpu_mhz.setter
    def demanded_cpu_mhz(self, demanded_cpu_mhz):
        """
        Sets the demanded_cpu_mhz of this VCenterServerMetrics.
        The demanded CPU (in MHz) in this vCenter server.

        :param demanded_cpu_mhz: The demanded_cpu_mhz of this VCenterServerMetrics.
        :type: int
        """

        self._demanded_cpu_mhz = demanded_cpu_mhz

    @property
    def total_storage_mb(self):
        """
        Gets the total_storage_mb of this VCenterServerMetrics.
        The size (in MB) of all datastores in this vCenter server.

        :return: The total_storage_mb of this VCenterServerMetrics.
        :rtype: int
        """
        return self._total_storage_mb

    @total_storage_mb.setter
    def total_storage_mb(self, total_storage_mb):
        """
        Sets the total_storage_mb of this VCenterServerMetrics.
        The size (in MB) of all datastores in this vCenter server.

        :param total_storage_mb: The total_storage_mb of this VCenterServerMetrics.
        :type: int
        """

        self._total_storage_mb = total_storage_mb

    @property
    def free_storage_mb(self):
        """
        Gets the free_storage_mb of this VCenterServerMetrics.
        The size of free storage (in MB) of all datastores in this vCenter server.

        :return: The free_storage_mb of this VCenterServerMetrics.
        :rtype: int
        """
        return self._free_storage_mb

    @free_storage_mb.setter
    def free_storage_mb(self, free_storage_mb):
        """
        Sets the free_storage_mb of this VCenterServerMetrics.
        The size of free storage (in MB) of all datastores in this vCenter server.

        :param free_storage_mb: The free_storage_mb of this VCenterServerMetrics.
        :type: int
        """

        self._free_storage_mb = free_storage_mb

    @property
    def uncommitted_storage_mb(self):
        """
        Gets the uncommitted_storage_mb of this VCenterServerMetrics.
        The size of uncommitted storage (in MB) of all datastores in this vCenter server.

        :return: The uncommitted_storage_mb of this VCenterServerMetrics.
        :rtype: int
        """
        return self._uncommitted_storage_mb

    @uncommitted_storage_mb.setter
    def uncommitted_storage_mb(self, uncommitted_storage_mb):
        """
        Sets the uncommitted_storage_mb of this VCenterServerMetrics.
        The size of uncommitted storage (in MB) of all datastores in this vCenter server.

        :param uncommitted_storage_mb: The uncommitted_storage_mb of this VCenterServerMetrics.
        :type: int
        """

        self._uncommitted_storage_mb = uncommitted_storage_mb

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, VCenterServerMetrics):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
