# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class TunnelConfig(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'perfect_forward_secrecy_enabled': 'bool',
        'df_policy': 'DfPolicyType',
        'dh_groups': 'list[DhGroupType]',
        'digest_algorithms': 'list[TunnelDigestAlgorithmType]',
        'encryption_algorithms': 'list[TunnelEncryptionAlgorithmType]',
        'sa_life_time': 'int'
    }

    attribute_map = {
        'perfect_forward_secrecy_enabled': 'perfectForwardSecrecyEnabled',
        'df_policy': 'dfPolicy',
        'dh_groups': 'dhGroups',
        'digest_algorithms': 'digestAlgorithms',
        'encryption_algorithms': 'encryptionAlgorithms',
        'sa_life_time': 'saLifeTime'
    }

    def __init__(self, perfect_forward_secrecy_enabled=True, df_policy=None, dh_groups=None, digest_algorithms=None, encryption_algorithms=None, sa_life_time=None):
        """
        TunnelConfig - a model defined in Swagger
        """

        self._perfect_forward_secrecy_enabled = None
        self._df_policy = None
        self._dh_groups = None
        self._digest_algorithms = None
        self._encryption_algorithms = None
        self._sa_life_time = None

        if perfect_forward_secrecy_enabled is not None:
          self.perfect_forward_secrecy_enabled = perfect_forward_secrecy_enabled
        if df_policy is not None:
          self.df_policy = df_policy
        self.dh_groups = dh_groups
        if digest_algorithms is not None:
          self.digest_algorithms = digest_algorithms
        self.encryption_algorithms = encryption_algorithms
        if sa_life_time is not None:
          self.sa_life_time = sa_life_time

    @property
    def perfect_forward_secrecy_enabled(self):
        """
        Gets the perfect_forward_secrecy_enabled of this TunnelConfig.
        If true, perfect forward secrecy is enabled. The default value is true.

        :return: The perfect_forward_secrecy_enabled of this TunnelConfig.
        :rtype: bool
        """
        return self._perfect_forward_secrecy_enabled

    @perfect_forward_secrecy_enabled.setter
    def perfect_forward_secrecy_enabled(self, perfect_forward_secrecy_enabled):
        """
        Sets the perfect_forward_secrecy_enabled of this TunnelConfig.
        If true, perfect forward secrecy is enabled. The default value is true.

        :param perfect_forward_secrecy_enabled: The perfect_forward_secrecy_enabled of this TunnelConfig.
        :type: bool
        """

        self._perfect_forward_secrecy_enabled = perfect_forward_secrecy_enabled

    @property
    def df_policy(self):
        """
        Gets the df_policy of this TunnelConfig.
        Policy for handling degragmentation bit. The default is COPY.

        :return: The df_policy of this TunnelConfig.
        :rtype: DfPolicyType
        """
        return self._df_policy

    @df_policy.setter
    def df_policy(self, df_policy):
        """
        Sets the df_policy of this TunnelConfig.
        Policy for handling degragmentation bit. The default is COPY.

        :param df_policy: The df_policy of this TunnelConfig.
        :type: DfPolicyType
        """

        self._df_policy = df_policy

    @property
    def dh_groups(self):
        """
        Gets the dh_groups of this TunnelConfig.
        The list of Diffie-Helman groups to be used is PFS is enabled. Default is GROUP14.

        :return: The dh_groups of this TunnelConfig.
        :rtype: list[DhGroupType]
        """
        return self._dh_groups

    @dh_groups.setter
    def dh_groups(self, dh_groups):
        """
        Sets the dh_groups of this TunnelConfig.
        The list of Diffie-Helman groups to be used is PFS is enabled. Default is GROUP14.

        :param dh_groups: The dh_groups of this TunnelConfig.
        :type: list[DhGroupType]
        """
        if dh_groups is None:
            raise ValueError("Invalid value for `dh_groups`, must not be `None`")

        self._dh_groups = dh_groups

    @property
    def digest_algorithms(self):
        """
        Gets the digest_algorithms of this TunnelConfig.
        The list of Digest algorithms to be used for message digest. The default digest algorithm is implictly covered by default encrpyption algorithm AES_GCM_128. 

        :return: The digest_algorithms of this TunnelConfig.
        :rtype: list[TunnelDigestAlgorithmType]
        """
        return self._digest_algorithms

    @digest_algorithms.setter
    def digest_algorithms(self, digest_algorithms):
        """
        Sets the digest_algorithms of this TunnelConfig.
        The list of Digest algorithms to be used for message digest. The default digest algorithm is implictly covered by default encrpyption algorithm AES_GCM_128. 

        :param digest_algorithms: The digest_algorithms of this TunnelConfig.
        :type: list[TunnelDigestAlgorithmType]
        """

        self._digest_algorithms = digest_algorithms

    @property
    def encryption_algorithms(self):
        """
        Gets the encryption_algorithms of this TunnelConfig.
        The list of Encryption algorithms to use in IPSec tunnel establishment. Default is AES_GCM_128. NO_ENCRYPTION_AUTH_AES_GMAC_* enables authentication on input data without encryption. If one of these options is used, digest algorithm should be empty. 

        :return: The encryption_algorithms of this TunnelConfig.
        :rtype: list[TunnelEncryptionAlgorithmType]
        """
        return self._encryption_algorithms

    @encryption_algorithms.setter
    def encryption_algorithms(self, encryption_algorithms):
        """
        Sets the encryption_algorithms of this TunnelConfig.
        The list of Encryption algorithms to use in IPSec tunnel establishment. Default is AES_GCM_128. NO_ENCRYPTION_AUTH_AES_GMAC_* enables authentication on input data without encryption. If one of these options is used, digest algorithm should be empty. 

        :param encryption_algorithms: The encryption_algorithms of this TunnelConfig.
        :type: list[TunnelEncryptionAlgorithmType]
        """
        if encryption_algorithms is None:
            raise ValueError("Invalid value for `encryption_algorithms`, must not be `None`")

        self._encryption_algorithms = encryption_algorithms

    @property
    def sa_life_time(self):
        """
        Gets the sa_life_time of this TunnelConfig.
        The Security Association life time in seconds. Default is 3600 seconds.

        :return: The sa_life_time of this TunnelConfig.
        :rtype: int
        """
        return self._sa_life_time

    @sa_life_time.setter
    def sa_life_time(self, sa_life_time):
        """
        Sets the sa_life_time of this TunnelConfig.
        The Security Association life time in seconds. Default is 3600 seconds.

        :param sa_life_time: The sa_life_time of this TunnelConfig.
        :type: int
        """
        if sa_life_time is not None and sa_life_time > 31536000:
            raise ValueError("Invalid value for `sa_life_time`, must be a value less than or equal to `31536000`")
        if sa_life_time is not None and sa_life_time < 900:
            raise ValueError("Invalid value for `sa_life_time`, must be a value greater than or equal to `900`")

        self._sa_life_time = sa_life_time

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, TunnelConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
