# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Token(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'token': 'str',
        'expiration_time_utc': 'datetime',
        'owner': 'EntityReference',
        'username': 'str',
        'user_id': 'str',
        'org_name': 'str',
        'org': 'EntityReference',
        'type': 'str'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'token': 'token',
        'expiration_time_utc': 'expirationTimeUtc',
        'owner': 'owner',
        'username': 'username',
        'user_id': 'userId',
        'org_name': 'orgName',
        'org': 'org',
        'type': 'type'
    }

    def __init__(self, id=None, name=None, token=None, expiration_time_utc=None, owner=None, username=None, user_id=None, org_name=None, org=None, type=None):
        """
        Token - a model defined in Swagger
        """

        self._id = None
        self._name = None
        self._token = None
        self._expiration_time_utc = None
        self._owner = None
        self._username = None
        self._user_id = None
        self._org_name = None
        self._org = None
        self._type = None

        self.id = id
        self.name = name
        if token is not None:
          self.token = token
        if expiration_time_utc is not None:
          self.expiration_time_utc = expiration_time_utc
        if owner is not None:
          self.owner = owner
        if username is not None:
          self.username = username
        if user_id is not None:
          self.user_id = user_id
        if org_name is not None:
          self.org_name = org_name
        if org is not None:
          self.org = org
        if type is not None:
          self.type = type

    @property
    def id(self):
        """
        Gets the id of this Token.
        ID of this token. Sorting on this field is not supported.

        :return: The id of this Token.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Token.
        ID of this token. Sorting on this field is not supported.

        :param id: The id of this Token.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Token.
        Name of the token

        :return: The name of this Token.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Token.
        Name of the token

        :param name: The name of this Token.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def token(self):
        """
        Gets the token of this Token.
        User specific token that can be used to access proxies. Sorting on this field is not supported.

        :return: The token of this Token.
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """
        Sets the token of this Token.
        User specific token that can be used to access proxies. Sorting on this field is not supported.

        :param token: The token of this Token.
        :type: str
        """

        self._token = token

    @property
    def expiration_time_utc(self):
        """
        Gets the expiration_time_utc of this Token.
        Time stamp representing when the token will expire (in UTC).

        :return: The expiration_time_utc of this Token.
        :rtype: datetime
        """
        return self._expiration_time_utc

    @expiration_time_utc.setter
    def expiration_time_utc(self, expiration_time_utc):
        """
        Sets the expiration_time_utc of this Token.
        Time stamp representing when the token will expire (in UTC).

        :param expiration_time_utc: The expiration_time_utc of this Token.
        :type: datetime
        """

        self._expiration_time_utc = expiration_time_utc

    @property
    def owner(self):
        """
        Gets the owner of this Token.
        Owner of the token. Either a user or an extension

        :return: The owner of this Token.
        :rtype: EntityReference
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """
        Sets the owner of this Token.
        Owner of the token. Either a user or an extension

        :param owner: The owner of this Token.
        :type: EntityReference
        """

        self._owner = owner

    @property
    def username(self):
        """
        Gets the username of this Token.
        Name of the user that this token is assigned to.

        :return: The username of this Token.
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """
        Sets the username of this Token.
        Name of the user that this token is assigned to.

        :param username: The username of this Token.
        :type: str
        """

        self._username = username

    @property
    def user_id(self):
        """
        Gets the user_id of this Token.
        ID of the user that this token is assigned to. Sorting on this field is not supported.  Can not be updated. 

        :return: The user_id of this Token.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this Token.
        ID of the user that this token is assigned to. Sorting on this field is not supported.  Can not be updated. 

        :param user_id: The user_id of this Token.
        :type: str
        """

        self._user_id = user_id

    @property
    def org_name(self):
        """
        Gets the org_name of this Token.
        Name of the organization that the assigned user belongs to. Sorting and filtering on this field is not supported.

        :return: The org_name of this Token.
        :rtype: str
        """
        return self._org_name

    @org_name.setter
    def org_name(self, org_name):
        """
        Sets the org_name of this Token.
        Name of the organization that the assigned user belongs to. Sorting and filtering on this field is not supported.

        :param org_name: The org_name of this Token.
        :type: str
        """

        self._org_name = org_name

    @property
    def org(self):
        """
        Gets the org of this Token.

        :return: The org of this Token.
        :rtype: EntityReference
        """
        return self._org

    @org.setter
    def org(self, org):
        """
        Sets the org of this Token.

        :param org: The org of this Token.
        :type: EntityReference
        """

        self._org = org

    @property
    def type(self):
        """
        Gets the type of this Token.
        Type of the token. Can be of type PROXY or EXTENSION

        :return: The type of this Token.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Token.
        Type of the token. Can be of type PROXY or EXTENSION

        :param type: The type of this Token.
        :type: str
        """

        self._type = type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Token):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
